/*
 * Copyright (c) 2001-2005 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/pim_xif.hh,v 1.28 2005/03/25 02:54:52 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_PIM_XIF_HH__
#define __XRL_INTERFACES_PIM_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifPim"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlPimV0p1Client {
public:
    XrlPimV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlPimV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableVifCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop a PIM vif interface.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to enable/disable/start/stop.
     *
     *  @param enable if true, then enable the vif, otherwise disable it.
     */
    bool send_enable_vif(
	const char*	target_name,
	const string&	vif_name,
	const bool&	enable,
	const EnableVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartVifCB;

    bool send_start_vif(
	const char*	target_name,
	const string&	vif_name,
	const StartVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopVifCB;

    bool send_stop_vif(
	const char*	target_name,
	const string&	vif_name,
	const StopVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableAllVifsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop all PIM vif interfaces.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the vifs, otherwise disable them.
     */
    bool send_enable_all_vifs(
	const char*	target_name,
	const bool&	enable,
	const EnableAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartAllVifsCB;

    bool send_start_all_vifs(
	const char*	target_name,
	const StartAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopAllVifsCB;

    bool send_stop_all_vifs(
	const char*	target_name,
	const StopAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnablePimCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the PIM protocol.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the PIM protocol, otherwise disable
     *  it.
     */
    bool send_enable_pim(
	const char*	target_name,
	const bool&	enable,
	const EnablePimCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartPimCB;

    bool send_start_pim(
	const char*	target_name,
	const StartPimCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopPimCB;

    bool send_stop_pim(
	const char*	target_name,
	const StopPimCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableCliCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the PIM CLI access.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the PIM CLI access, otherwise
     *  disable it.
     */
    bool send_enable_cli(
	const char*	target_name,
	const bool&	enable,
	const EnableCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartCliCB;

    bool send_start_cli(
	const char*	target_name,
	const StartCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopCliCB;

    bool send_stop_cli(
	const char*	target_name,
	const StopCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableBsrCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop BSR.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the BSR, otherwise disable it.
     */
    bool send_enable_bsr(
	const char*	target_name,
	const bool&	enable,
	const EnableBsrCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartBsrCB;

    bool send_start_bsr(
	const char*	target_name,
	const StartBsrCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopBsrCB;

    bool send_stop_bsr(
	const char*	target_name,
	const StopBsrCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigScopeZoneByVifName4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete scope zone.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param scope_zone_id the ID of the configured zone.
     *
     *  @param vif_name the name of the vif to use as a bondary of the scope
     *  zone.
     */
    bool send_add_config_scope_zone_by_vif_name4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name,
	const AddConfigScopeZoneByVifName4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigScopeZoneByVifName6CB;

    bool send_add_config_scope_zone_by_vif_name6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name,
	const AddConfigScopeZoneByVifName6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigScopeZoneByVifAddr4CB;

    bool send_add_config_scope_zone_by_vif_addr4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr,
	const AddConfigScopeZoneByVifAddr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigScopeZoneByVifAddr6CB;

    bool send_add_config_scope_zone_by_vif_addr6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr,
	const AddConfigScopeZoneByVifAddr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigScopeZoneByVifName4CB;

    bool send_delete_config_scope_zone_by_vif_name4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name,
	const DeleteConfigScopeZoneByVifName4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigScopeZoneByVifName6CB;

    bool send_delete_config_scope_zone_by_vif_name6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name,
	const DeleteConfigScopeZoneByVifName6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigScopeZoneByVifAddr4CB;

    bool send_delete_config_scope_zone_by_vif_addr4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr,
	const DeleteConfigScopeZoneByVifAddr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigScopeZoneByVifAddr6CB;

    bool send_delete_config_scope_zone_by_vif_addr6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr,
	const DeleteConfigScopeZoneByVifAddr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandBsrByVifName4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete candidate-BSR configuration.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param scope_zone_id the ID of the configured zone.
     *
     *  @param is_scope_zone true if configuring administratively scoped zone.
     *
     *  @param vif_name the name of the vif to use its address as a
     *  candidate-BSR.
     *
     *  @param bsr_priority the BSR priority (larger is better).
     *
     *  @param hash_mask_len the hash mask length.
     */
    bool send_add_config_cand_bsr_by_vif_name4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsrByVifName4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandBsrByVifName6CB;

    bool send_add_config_cand_bsr_by_vif_name6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsrByVifName6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandBsrByAddr4CB;

    bool send_add_config_cand_bsr_by_addr4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const IPv4&	cand_bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsrByAddr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandBsrByAddr6CB;

    bool send_add_config_cand_bsr_by_addr6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const IPv6&	cand_bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigCandBsrByAddr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandBsr4CB;

    bool send_delete_config_cand_bsr4(
	const char*	target_name,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const DeleteConfigCandBsr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandBsr6CB;

    bool send_delete_config_cand_bsr6(
	const char*	target_name,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const DeleteConfigCandBsr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandRpByVifName4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete Candidate-RP configuration.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param group_prefix the group prefix of the configured zone.
     *
     *  @param is_scope_zone true if configuring administratively scoped zone.
     *
     *  @param vif_name the name of the vif to use its address as a
     *  candidate-RP.
     *
     *  @param rp_priority the Cand-RP priority (smaller is better).
     *
     *  @param rp_holdtime the Cand-RP holdtime (in seconds).
     */
    bool send_add_config_cand_rp_by_vif_name4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRpByVifName4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandRpByVifName6CB;

    bool send_add_config_cand_rp_by_vif_name6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRpByVifName6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandRpByAddr4CB;

    bool send_add_config_cand_rp_by_addr4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv4&	cand_rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRpByAddr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigCandRpByAddr6CB;

    bool send_add_config_cand_rp_by_addr6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv6&	cand_rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddConfigCandRpByAddr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandRpByVifName4CB;

    bool send_delete_config_cand_rp_by_vif_name4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const DeleteConfigCandRpByVifName4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandRpByVifName6CB;

    bool send_delete_config_cand_rp_by_vif_name6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const DeleteConfigCandRpByVifName6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandRpByAddr4CB;

    bool send_delete_config_cand_rp_by_addr4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv4&	cand_rp_addr,
	const DeleteConfigCandRpByAddr4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigCandRpByAddr6CB;

    bool send_delete_config_cand_rp_by_addr6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv6&	cand_rp_addr,
	const DeleteConfigCandRpByAddr6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigStaticRp4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete/complete static RP configuration.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param group_prefix the group prefix for the RP.
     *
     *  @param rp_addr the RP address.
     *
     *  @param rp_priority the RP priority (smaller is better).
     *
     *  @param hash_mask_len the hash mask length used in computing an RP for a
     *  group. It should be same across all RPs. If set to zero, the default
     *  one will be used.
     */
    bool send_add_config_static_rp4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigStaticRp4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddConfigStaticRp6CB;

    bool send_add_config_static_rp6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len,
	const AddConfigStaticRp6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigStaticRp4CB;

    bool send_delete_config_static_rp4(
	const char*	target_name,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const DeleteConfigStaticRp4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigStaticRp6CB;

    bool send_delete_config_static_rp6(
	const char*	target_name,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const DeleteConfigStaticRp6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigAllStaticGroupPrefixesRp4CB;

    bool send_delete_config_all_static_group_prefixes_rp4(
	const char*	target_name,
	const IPv4&	rp_addr,
	const DeleteConfigAllStaticGroupPrefixesRp4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigAllStaticGroupPrefixesRp6CB;

    bool send_delete_config_all_static_group_prefixes_rp6(
	const char*	target_name,
	const IPv6&	rp_addr,
	const DeleteConfigAllStaticGroupPrefixesRp6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteConfigAllStaticRpsCB;

    bool send_delete_config_all_static_rps(
	const char*	target_name,
	const DeleteConfigAllStaticRpsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ConfigStaticRpDoneCB;

    bool send_config_static_rp_done(
	const char*	target_name,
	const ConfigStaticRpDoneCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifProtoVersionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Configure PIM Hello-related metrics. The 'set_foo' XRLs set the
     *  particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to configure.
     */
    bool send_get_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const GetVifProtoVersionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifProtoVersionCB;

    bool send_set_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	proto_version,
	const SetVifProtoVersionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifProtoVersionCB;

    bool send_reset_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifProtoVersionCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifHelloTriggeredDelayCB;

    bool send_get_vif_hello_triggered_delay(
	const char*	target_name,
	const string&	vif_name,
	const GetVifHelloTriggeredDelayCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifHelloTriggeredDelayCB;

    bool send_set_vif_hello_triggered_delay(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	hello_triggered_delay,
	const SetVifHelloTriggeredDelayCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifHelloTriggeredDelayCB;

    bool send_reset_vif_hello_triggered_delay(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifHelloTriggeredDelayCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifHelloPeriodCB;

    bool send_get_vif_hello_period(
	const char*	target_name,
	const string&	vif_name,
	const GetVifHelloPeriodCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifHelloPeriodCB;

    bool send_set_vif_hello_period(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	hello_period,
	const SetVifHelloPeriodCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifHelloPeriodCB;

    bool send_reset_vif_hello_period(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifHelloPeriodCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifHelloHoldtimeCB;

    bool send_get_vif_hello_holdtime(
	const char*	target_name,
	const string&	vif_name,
	const GetVifHelloHoldtimeCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifHelloHoldtimeCB;

    bool send_set_vif_hello_holdtime(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	hello_holdtime,
	const SetVifHelloHoldtimeCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifHelloHoldtimeCB;

    bool send_reset_vif_hello_holdtime(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifHelloHoldtimeCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifDrPriorityCB;

    bool send_get_vif_dr_priority(
	const char*	target_name,
	const string&	vif_name,
	const GetVifDrPriorityCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifDrPriorityCB;

    bool send_set_vif_dr_priority(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	dr_priority,
	const SetVifDrPriorityCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifDrPriorityCB;

    bool send_reset_vif_dr_priority(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifDrPriorityCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifLanDelayCB;

    bool send_get_vif_lan_delay(
	const char*	target_name,
	const string&	vif_name,
	const GetVifLanDelayCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifLanDelayCB;

    bool send_set_vif_lan_delay(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	lan_delay,
	const SetVifLanDelayCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifLanDelayCB;

    bool send_reset_vif_lan_delay(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifLanDelayCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifOverrideIntervalCB;

    bool send_get_vif_override_interval(
	const char*	target_name,
	const string&	vif_name,
	const GetVifOverrideIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifOverrideIntervalCB;

    bool send_set_vif_override_interval(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	override_interval,
	const SetVifOverrideIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifOverrideIntervalCB;

    bool send_reset_vif_override_interval(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifOverrideIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetVifIsTrackingSupportDisabledCB;

    bool send_get_vif_is_tracking_support_disabled(
	const char*	target_name,
	const string&	vif_name,
	const GetVifIsTrackingSupportDisabledCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifIsTrackingSupportDisabledCB;

    bool send_set_vif_is_tracking_support_disabled(
	const char*	target_name,
	const string&	vif_name,
	const bool&	is_tracking_support_disabled,
	const SetVifIsTrackingSupportDisabledCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifIsTrackingSupportDisabledCB;

    bool send_reset_vif_is_tracking_support_disabled(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifIsTrackingSupportDisabledCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetVifAcceptNohelloNeighborsCB;

    bool send_get_vif_accept_nohello_neighbors(
	const char*	target_name,
	const string&	vif_name,
	const GetVifAcceptNohelloNeighborsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifAcceptNohelloNeighborsCB;

    bool send_set_vif_accept_nohello_neighbors(
	const char*	target_name,
	const string&	vif_name,
	const bool&	accept_nohello_neighbors,
	const SetVifAcceptNohelloNeighborsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifAcceptNohelloNeighborsCB;

    bool send_reset_vif_accept_nohello_neighbors(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifAcceptNohelloNeighborsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifJoinPrunePeriodCB;
    /**
     *  Send Xrl intended to:
     *
     *  Configure PIM Join/Prune-related metrics. The 'set_foo' XRLs set the
     *  particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to configure.
     */
    bool send_get_vif_join_prune_period(
	const char*	target_name,
	const string&	vif_name,
	const GetVifJoinPrunePeriodCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifJoinPrunePeriodCB;

    bool send_set_vif_join_prune_period(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	join_prune_period,
	const SetVifJoinPrunePeriodCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifJoinPrunePeriodCB;

    bool send_reset_vif_join_prune_period(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifJoinPrunePeriodCB&	cb
    );

    typedef XorpCallback4<void, const XrlError&, const bool*, const uint32_t*, const uint32_t*>::RefPtr GetSwitchToSptThresholdCB;
    /**
     *  Send Xrl intended to:
     *
     *  Configure SPT-switch threshold. The 'set_foo' XRLs set the particular
     *  values. The 'reset_foo' XRLs reset the metrics to their default values.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_get_switch_to_spt_threshold(
	const char*	target_name,
	const GetSwitchToSptThresholdCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetSwitchToSptThresholdCB;

    bool send_set_switch_to_spt_threshold(
	const char*	target_name,
	const bool&	is_enabled,
	const uint32_t&	interval_sec,
	const uint32_t&	bytes,
	const SetSwitchToSptThresholdCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetSwitchToSptThresholdCB;

    bool send_reset_switch_to_spt_threshold(
	const char*	target_name,
	const ResetSwitchToSptThresholdCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddAlternativeSubnet4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add or delete an alternative subnet on a PIM vif. An alternative subnet
     *  is used to make incoming traffic with a non-local source address appear
     *  as it is coming from a local subnet. Note: add alternative subnets with
     *  extreme care, only if you know what you are really doing!
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to add or delete an alternative
     *  subnet.
     *
     *  @param subnet the subnet address to add or delete.
     */
    bool send_add_alternative_subnet4(
	const char*	target_name,
	const string&	vif_name,
	const IPv4Net&	subnet,
	const AddAlternativeSubnet4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddAlternativeSubnet6CB;

    bool send_add_alternative_subnet6(
	const char*	target_name,
	const string&	vif_name,
	const IPv6Net&	subnet,
	const AddAlternativeSubnet6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAlternativeSubnet4CB;

    bool send_delete_alternative_subnet4(
	const char*	target_name,
	const string&	vif_name,
	const IPv4Net&	subnet,
	const DeleteAlternativeSubnet4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAlternativeSubnet6CB;

    bool send_delete_alternative_subnet6(
	const char*	target_name,
	const string&	vif_name,
	const IPv6Net&	subnet,
	const DeleteAlternativeSubnet6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr RemoveAllAlternativeSubnetsCB;

    bool send_remove_all_alternative_subnets(
	const char*	target_name,
	const string&	vif_name,
	const RemoveAllAlternativeSubnetsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LogTraceAllCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable the PIM trace log for all operations.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    bool send_log_trace_all(
	const char*	target_name,
	const bool&	enable,
	const LogTraceAllCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestJpEntry4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test-related methods: add Join/Prune entries, and send them to a
     *  neighbor.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_add_test_jp_entry4(
	const char*	target_name,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	new_group_bool,
	const AddTestJpEntry4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestJpEntry6CB;

    bool send_add_test_jp_entry6(
	const char*	target_name,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	new_group_bool,
	const AddTestJpEntry6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestJpEntry4CB;

    bool send_send_test_jp_entry4(
	const char*	target_name,
	const IPv4&	nbr_addr,
	const SendTestJpEntry4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestJpEntry6CB;

    bool send_send_test_jp_entry6(
	const char*	target_name,
	const IPv6&	nbr_addr,
	const SendTestJpEntry6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestAssert4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test-related methods: send an Assert message on an interface.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to send the Assert on.
     *
     *  @param source_addr the source address inside the Assert message.
     *
     *  @param group_addr the group address inside the Assert message.
     *
     *  @param rpt_bit the RPT-bit inside the Assert message.
     *
     *  @param metric_preference the metric preference inside the Assert
     *  message.
     *
     *  @param metric the metric inside the Assert message.
     */
    bool send_send_test_assert4(
	const char*	target_name,
	const string&	vif_name,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric,
	const SendTestAssert4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestAssert6CB;

    bool send_send_test_assert6(
	const char*	target_name,
	const string&	vif_name,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric,
	const SendTestAssert6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrZone4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test-related methods: send Bootstrap and Cand-RP-Adv messages.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param zone_id_scope_zone_prefix the zone prefix of the zone ID.
     *
     *  @param zone_id_is_scope_zone true if the zone is scoped.
     *
     *  @param bsr_addr the address of the Bootstrap router.
     *
     *  @param bsr_priority the priority of the Bootstrap router.
     *
     *  @param hash_mask_len the hash mask length inside the Bootstrap
     *  messages.
     *
     *  @param fragment_tag the fragment tag inside the Bootstrap messages.
     */
    bool send_add_test_bsr_zone4(
	const char*	target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag,
	const AddTestBsrZone4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrZone6CB;

    bool send_add_test_bsr_zone6(
	const char*	target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag,
	const AddTestBsrZone6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrGroupPrefix4CB;

    bool send_add_test_bsr_group_prefix4(
	const char*	target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count,
	const AddTestBsrGroupPrefix4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrGroupPrefix6CB;

    bool send_add_test_bsr_group_prefix6(
	const char*	target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count,
	const AddTestBsrGroupPrefix6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrRp4CB;

    bool send_add_test_bsr_rp4(
	const char*	target_name,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddTestBsrRp4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddTestBsrRp6CB;

    bool send_add_test_bsr_rp6(
	const char*	target_name,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime,
	const AddTestBsrRp6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestBootstrapCB;

    bool send_send_test_bootstrap(
	const char*	target_name,
	const string&	vif_name,
	const SendTestBootstrapCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestBootstrapByDest4CB;

    bool send_send_test_bootstrap_by_dest4(
	const char*	target_name,
	const string&	vif_name,
	const IPv4&	dest_addr,
	const SendTestBootstrapByDest4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestBootstrapByDest6CB;

    bool send_send_test_bootstrap_by_dest6(
	const char*	target_name,
	const string&	vif_name,
	const IPv6&	dest_addr,
	const SendTestBootstrapByDest6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendTestCandRpAdvCB;

    bool send_send_test_cand_rp_adv(
	const char*	target_name,
	const SendTestCandRpAdvCB&	cb
    );

    typedef XorpCallback9<void, const XrlError&, const uint32_t*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*>::RefPtr PimstatNeighbors4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Retrieve information about all PIM neighbors.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_pimstat_neighbors4(
	const char*	target_name,
	const PimstatNeighbors4CB&	cb
    );

    typedef XorpCallback9<void, const XrlError&, const uint32_t*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*>::RefPtr PimstatNeighbors6CB;

    bool send_pimstat_neighbors6(
	const char*	target_name,
	const PimstatNeighbors6CB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const uint32_t*, const bool*, const uint32_t*, const IPv4*, const uint32_t*>::RefPtr PimstatInterface4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Retrieve information about PIM interfaces.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to retrieve information about.
     */
    bool send_pimstat_interface4(
	const char*	target_name,
	const string&	vif_name,
	const PimstatInterface4CB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const uint32_t*, const bool*, const uint32_t*, const IPv6*, const uint32_t*>::RefPtr PimstatInterface6CB;

    bool send_pimstat_interface6(
	const char*	target_name,
	const string&	vif_name,
	const PimstatInterface6CB&	cb
    );

    typedef XorpCallback8<void, const XrlError&, const uint32_t*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*>::RefPtr PimstatRps4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Retrieve information about the RP-Set.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_pimstat_rps4(
	const char*	target_name,
	const PimstatRps4CB&	cb
    );

    typedef XorpCallback8<void, const XrlError&, const uint32_t*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*, const XrlAtomList*>::RefPtr PimstatRps6CB;

    bool send_pimstat_rps6(
	const char*	target_name,
	const PimstatRps6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ClearPimStatisticsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Clear all statistics
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_clear_pim_statistics(
	const char*	target_name,
	const ClearPimStatisticsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ClearPimStatisticsPerVifCB;
    /**
     *  Send Xrl intended to:
     *
     *  Clear all statistics on a specific interface.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the interface to clear the statistics of.
     */
    bool send_clear_pim_statistics_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const ClearPimStatisticsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesReceivedCB;
    /**
     *  Send Xrl intended to:
     *
     *  Statistics-related counters and values
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_pimstat_hello_messages_received(
	const char*	target_name,
	const PimstatHelloMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesSentCB;

    bool send_pimstat_hello_messages_sent(
	const char*	target_name,
	const PimstatHelloMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesRxErrorsCB;

    bool send_pimstat_hello_messages_rx_errors(
	const char*	target_name,
	const PimstatHelloMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesReceivedCB;

    bool send_pimstat_register_messages_received(
	const char*	target_name,
	const PimstatRegisterMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesSentCB;

    bool send_pimstat_register_messages_sent(
	const char*	target_name,
	const PimstatRegisterMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesRxErrorsCB;

    bool send_pimstat_register_messages_rx_errors(
	const char*	target_name,
	const PimstatRegisterMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesReceivedCB;

    bool send_pimstat_register_stop_messages_received(
	const char*	target_name,
	const PimstatRegisterStopMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesSentCB;

    bool send_pimstat_register_stop_messages_sent(
	const char*	target_name,
	const PimstatRegisterStopMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesRxErrorsCB;

    bool send_pimstat_register_stop_messages_rx_errors(
	const char*	target_name,
	const PimstatRegisterStopMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesReceivedCB;

    bool send_pimstat_join_prune_messages_received(
	const char*	target_name,
	const PimstatJoinPruneMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesSentCB;

    bool send_pimstat_join_prune_messages_sent(
	const char*	target_name,
	const PimstatJoinPruneMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesRxErrorsCB;

    bool send_pimstat_join_prune_messages_rx_errors(
	const char*	target_name,
	const PimstatJoinPruneMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesReceivedCB;

    bool send_pimstat_bootstrap_messages_received(
	const char*	target_name,
	const PimstatBootstrapMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesSentCB;

    bool send_pimstat_bootstrap_messages_sent(
	const char*	target_name,
	const PimstatBootstrapMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesRxErrorsCB;

    bool send_pimstat_bootstrap_messages_rx_errors(
	const char*	target_name,
	const PimstatBootstrapMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesReceivedCB;

    bool send_pimstat_assert_messages_received(
	const char*	target_name,
	const PimstatAssertMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesSentCB;

    bool send_pimstat_assert_messages_sent(
	const char*	target_name,
	const PimstatAssertMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesRxErrorsCB;

    bool send_pimstat_assert_messages_rx_errors(
	const char*	target_name,
	const PimstatAssertMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesReceivedCB;

    bool send_pimstat_graft_messages_received(
	const char*	target_name,
	const PimstatGraftMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesSentCB;

    bool send_pimstat_graft_messages_sent(
	const char*	target_name,
	const PimstatGraftMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesRxErrorsCB;

    bool send_pimstat_graft_messages_rx_errors(
	const char*	target_name,
	const PimstatGraftMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesReceivedCB;

    bool send_pimstat_graft_ack_messages_received(
	const char*	target_name,
	const PimstatGraftAckMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesSentCB;

    bool send_pimstat_graft_ack_messages_sent(
	const char*	target_name,
	const PimstatGraftAckMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesRxErrorsCB;

    bool send_pimstat_graft_ack_messages_rx_errors(
	const char*	target_name,
	const PimstatGraftAckMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesReceivedCB;

    bool send_pimstat_candidate_rp_messages_received(
	const char*	target_name,
	const PimstatCandidateRpMessagesReceivedCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesSentCB;

    bool send_pimstat_candidate_rp_messages_sent(
	const char*	target_name,
	const PimstatCandidateRpMessagesSentCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesRxErrorsCB;

    bool send_pimstat_candidate_rp_messages_rx_errors(
	const char*	target_name,
	const PimstatCandidateRpMessagesRxErrorsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownTypeMessagesCB;

    bool send_pimstat_unknown_type_messages(
	const char*	target_name,
	const PimstatUnknownTypeMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownVersionMessagesCB;

    bool send_pimstat_unknown_version_messages(
	const char*	target_name,
	const PimstatUnknownVersionMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNeighborUnknownMessagesCB;

    bool send_pimstat_neighbor_unknown_messages(
	const char*	target_name,
	const PimstatNeighborUnknownMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadLengthMessagesCB;

    bool send_pimstat_bad_length_messages(
	const char*	target_name,
	const PimstatBadLengthMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadChecksumMessagesCB;

    bool send_pimstat_bad_checksum_messages(
	const char*	target_name,
	const PimstatBadChecksumMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadReceiveInterfaceMessagesCB;

    bool send_pimstat_bad_receive_interface_messages(
	const char*	target_name,
	const PimstatBadReceiveInterfaceMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxInterfaceDisabledMessagesCB;

    bool send_pimstat_rx_interface_disabled_messages(
	const char*	target_name,
	const PimstatRxInterfaceDisabledMessagesCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxRegisterNotRpCB;

    bool send_pimstat_rx_register_not_rp(
	const char*	target_name,
	const PimstatRxRegisterNotRpCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpFilteredSourceCB;

    bool send_pimstat_rp_filtered_source(
	const char*	target_name,
	const PimstatRpFilteredSourceCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownRegisterStopCB;

    bool send_pimstat_unknown_register_stop(
	const char*	target_name,
	const PimstatUnknownRegisterStopCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinPruneNoStateCB;

    bool send_pimstat_rx_join_prune_no_state(
	const char*	target_name,
	const PimstatRxJoinPruneNoStateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxGraftGraftAckNoStateCB;

    bool send_pimstat_rx_graft_graft_ack_no_state(
	const char*	target_name,
	const PimstatRxGraftGraftAckNoStateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxGraftOnUpstreamInterfaceCB;

    bool send_pimstat_rx_graft_on_upstream_interface(
	const char*	target_name,
	const PimstatRxGraftOnUpstreamInterfaceCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxCandidateRpNotBsrCB;

    bool send_pimstat_rx_candidate_rp_not_bsr(
	const char*	target_name,
	const PimstatRxCandidateRpNotBsrCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxBsrWhenBsrCB;

    bool send_pimstat_rx_bsr_when_bsr(
	const char*	target_name,
	const PimstatRxBsrWhenBsrCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxBsrNotRpfInterfaceCB;

    bool send_pimstat_rx_bsr_not_rpf_interface(
	const char*	target_name,
	const PimstatRxBsrNotRpfInterfaceCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxUnknownHelloOptionCB;

    bool send_pimstat_rx_unknown_hello_option(
	const char*	target_name,
	const PimstatRxUnknownHelloOptionCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxDataNoStateCB;

    bool send_pimstat_rx_data_no_state(
	const char*	target_name,
	const PimstatRxDataNoStateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxRpNoStateCB;

    bool send_pimstat_rx_rp_no_state(
	const char*	target_name,
	const PimstatRxRpNoStateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxAggregateCB;

    bool send_pimstat_rx_aggregate(
	const char*	target_name,
	const PimstatRxAggregateCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxMalformedPacketCB;

    bool send_pimstat_rx_malformed_packet(
	const char*	target_name,
	const PimstatRxMalformedPacketCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNoRpCB;

    bool send_pimstat_no_rp(
	const char*	target_name,
	const PimstatNoRpCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNoRouteUpstreamCB;

    bool send_pimstat_no_route_upstream(
	const char*	target_name,
	const PimstatNoRouteUpstreamCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpMismatchCB;

    bool send_pimstat_rp_mismatch(
	const char*	target_name,
	const PimstatRpMismatchCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpfNeighborUnknownCB;

    bool send_pimstat_rpf_neighbor_unknown(
	const char*	target_name,
	const PimstatRpfNeighborUnknownCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinRpCB;

    bool send_pimstat_rx_join_rp(
	const char*	target_name,
	const PimstatRxJoinRpCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneRpCB;

    bool send_pimstat_rx_prune_rp(
	const char*	target_name,
	const PimstatRxPruneRpCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinWcCB;

    bool send_pimstat_rx_join_wc(
	const char*	target_name,
	const PimstatRxJoinWcCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneWcCB;

    bool send_pimstat_rx_prune_wc(
	const char*	target_name,
	const PimstatRxPruneWcCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinSgCB;

    bool send_pimstat_rx_join_sg(
	const char*	target_name,
	const PimstatRxJoinSgCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneSgCB;

    bool send_pimstat_rx_prune_sg(
	const char*	target_name,
	const PimstatRxPruneSgCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinSgRptCB;

    bool send_pimstat_rx_join_sg_rpt(
	const char*	target_name,
	const PimstatRxJoinSgRptCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneSgRptCB;

    bool send_pimstat_rx_prune_sg_rpt(
	const char*	target_name,
	const PimstatRxPruneSgRptCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesReceivedPerVifCB;

    bool send_pimstat_hello_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatHelloMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesSentPerVifCB;

    bool send_pimstat_hello_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatHelloMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatHelloMessagesRxErrorsPerVifCB;

    bool send_pimstat_hello_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatHelloMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesReceivedPerVifCB;

    bool send_pimstat_register_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesSentPerVifCB;

    bool send_pimstat_register_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterMessagesRxErrorsPerVifCB;

    bool send_pimstat_register_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesReceivedPerVifCB;

    bool send_pimstat_register_stop_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesSentPerVifCB;

    bool send_pimstat_register_stop_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRegisterStopMessagesRxErrorsPerVifCB;

    bool send_pimstat_register_stop_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRegisterStopMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesReceivedPerVifCB;

    bool send_pimstat_join_prune_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesSentPerVifCB;

    bool send_pimstat_join_prune_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatJoinPruneMessagesRxErrorsPerVifCB;

    bool send_pimstat_join_prune_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatJoinPruneMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesReceivedPerVifCB;

    bool send_pimstat_bootstrap_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesSentPerVifCB;

    bool send_pimstat_bootstrap_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBootstrapMessagesRxErrorsPerVifCB;

    bool send_pimstat_bootstrap_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBootstrapMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesReceivedPerVifCB;

    bool send_pimstat_assert_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatAssertMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesSentPerVifCB;

    bool send_pimstat_assert_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatAssertMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatAssertMessagesRxErrorsPerVifCB;

    bool send_pimstat_assert_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatAssertMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesReceivedPerVifCB;

    bool send_pimstat_graft_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesSentPerVifCB;

    bool send_pimstat_graft_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftMessagesRxErrorsPerVifCB;

    bool send_pimstat_graft_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesReceivedPerVifCB;

    bool send_pimstat_graft_ack_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesSentPerVifCB;

    bool send_pimstat_graft_ack_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatGraftAckMessagesRxErrorsPerVifCB;

    bool send_pimstat_graft_ack_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatGraftAckMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesReceivedPerVifCB;

    bool send_pimstat_candidate_rp_messages_received_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesReceivedPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesSentPerVifCB;

    bool send_pimstat_candidate_rp_messages_sent_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesSentPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatCandidateRpMessagesRxErrorsPerVifCB;

    bool send_pimstat_candidate_rp_messages_rx_errors_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatCandidateRpMessagesRxErrorsPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownTypeMessagesPerVifCB;

    bool send_pimstat_unknown_type_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatUnknownTypeMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownVersionMessagesPerVifCB;

    bool send_pimstat_unknown_version_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatUnknownVersionMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNeighborUnknownMessagesPerVifCB;

    bool send_pimstat_neighbor_unknown_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatNeighborUnknownMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadLengthMessagesPerVifCB;

    bool send_pimstat_bad_length_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBadLengthMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadChecksumMessagesPerVifCB;

    bool send_pimstat_bad_checksum_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBadChecksumMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatBadReceiveInterfaceMessagesPerVifCB;

    bool send_pimstat_bad_receive_interface_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatBadReceiveInterfaceMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxInterfaceDisabledMessagesPerVifCB;

    bool send_pimstat_rx_interface_disabled_messages_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxInterfaceDisabledMessagesPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxRegisterNotRpPerVifCB;

    bool send_pimstat_rx_register_not_rp_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxRegisterNotRpPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpFilteredSourcePerVifCB;

    bool send_pimstat_rp_filtered_source_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRpFilteredSourcePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatUnknownRegisterStopPerVifCB;

    bool send_pimstat_unknown_register_stop_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatUnknownRegisterStopPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinPruneNoStatePerVifCB;

    bool send_pimstat_rx_join_prune_no_state_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxJoinPruneNoStatePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxGraftGraftAckNoStatePerVifCB;

    bool send_pimstat_rx_graft_graft_ack_no_state_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxGraftGraftAckNoStatePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxGraftOnUpstreamInterfacePerVifCB;

    bool send_pimstat_rx_graft_on_upstream_interface_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxGraftOnUpstreamInterfacePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxCandidateRpNotBsrPerVifCB;

    bool send_pimstat_rx_candidate_rp_not_bsr_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxCandidateRpNotBsrPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxBsrWhenBsrPerVifCB;

    bool send_pimstat_rx_bsr_when_bsr_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxBsrWhenBsrPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxBsrNotRpfInterfacePerVifCB;

    bool send_pimstat_rx_bsr_not_rpf_interface_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxBsrNotRpfInterfacePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxUnknownHelloOptionPerVifCB;

    bool send_pimstat_rx_unknown_hello_option_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxUnknownHelloOptionPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxDataNoStatePerVifCB;

    bool send_pimstat_rx_data_no_state_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxDataNoStatePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxRpNoStatePerVifCB;

    bool send_pimstat_rx_rp_no_state_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxRpNoStatePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxAggregatePerVifCB;

    bool send_pimstat_rx_aggregate_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxAggregatePerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxMalformedPacketPerVifCB;

    bool send_pimstat_rx_malformed_packet_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxMalformedPacketPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNoRpPerVifCB;

    bool send_pimstat_no_rp_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatNoRpPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatNoRouteUpstreamPerVifCB;

    bool send_pimstat_no_route_upstream_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatNoRouteUpstreamPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpMismatchPerVifCB;

    bool send_pimstat_rp_mismatch_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRpMismatchPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRpfNeighborUnknownPerVifCB;

    bool send_pimstat_rpf_neighbor_unknown_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRpfNeighborUnknownPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinRpPerVifCB;

    bool send_pimstat_rx_join_rp_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxJoinRpPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneRpPerVifCB;

    bool send_pimstat_rx_prune_rp_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxPruneRpPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinWcPerVifCB;

    bool send_pimstat_rx_join_wc_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxJoinWcPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneWcPerVifCB;

    bool send_pimstat_rx_prune_wc_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxPruneWcPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinSgPerVifCB;

    bool send_pimstat_rx_join_sg_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxJoinSgPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneSgPerVifCB;

    bool send_pimstat_rx_prune_sg_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxPruneSgPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxJoinSgRptPerVifCB;

    bool send_pimstat_rx_join_sg_rpt_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxJoinSgRptPerVifCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr PimstatRxPruneSgRptPerVifCB;

    bool send_pimstat_rx_prune_sg_rpt_per_vif(
	const char*	target_name,
	const string&	vif_name,
	const PimstatRxPruneSgRptPerVifCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_enable_vif(
	const XrlError&	e,
	XrlArgs*	a,
	EnableVifCB		cb
    );

    void unmarshall_start_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StartVifCB		cb
    );

    void unmarshall_stop_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StopVifCB		cb
    );

    void unmarshall_enable_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	EnableAllVifsCB		cb
    );

    void unmarshall_start_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StartAllVifsCB		cb
    );

    void unmarshall_stop_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StopAllVifsCB		cb
    );

    void unmarshall_enable_pim(
	const XrlError&	e,
	XrlArgs*	a,
	EnablePimCB		cb
    );

    void unmarshall_start_pim(
	const XrlError&	e,
	XrlArgs*	a,
	StartPimCB		cb
    );

    void unmarshall_stop_pim(
	const XrlError&	e,
	XrlArgs*	a,
	StopPimCB		cb
    );

    void unmarshall_enable_cli(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCliCB		cb
    );

    void unmarshall_start_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StartCliCB		cb
    );

    void unmarshall_stop_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StopCliCB		cb
    );

    void unmarshall_enable_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	EnableBsrCB		cb
    );

    void unmarshall_start_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	StartBsrCB		cb
    );

    void unmarshall_stop_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	StopBsrCB		cb
    );

    void unmarshall_add_config_scope_zone_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifName4CB		cb
    );

    void unmarshall_add_config_scope_zone_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifName6CB		cb
    );

    void unmarshall_add_config_scope_zone_by_vif_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifAddr4CB		cb
    );

    void unmarshall_add_config_scope_zone_by_vif_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigScopeZoneByVifAddr6CB		cb
    );

    void unmarshall_delete_config_scope_zone_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifName4CB		cb
    );

    void unmarshall_delete_config_scope_zone_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifName6CB		cb
    );

    void unmarshall_delete_config_scope_zone_by_vif_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifAddr4CB		cb
    );

    void unmarshall_delete_config_scope_zone_by_vif_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigScopeZoneByVifAddr6CB		cb
    );

    void unmarshall_add_config_cand_bsr_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsrByVifName4CB		cb
    );

    void unmarshall_add_config_cand_bsr_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsrByVifName6CB		cb
    );

    void unmarshall_add_config_cand_bsr_by_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsrByAddr4CB		cb
    );

    void unmarshall_add_config_cand_bsr_by_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandBsrByAddr6CB		cb
    );

    void unmarshall_delete_config_cand_bsr4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandBsr4CB		cb
    );

    void unmarshall_delete_config_cand_bsr6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandBsr6CB		cb
    );

    void unmarshall_add_config_cand_rp_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRpByVifName4CB		cb
    );

    void unmarshall_add_config_cand_rp_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRpByVifName6CB		cb
    );

    void unmarshall_add_config_cand_rp_by_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRpByAddr4CB		cb
    );

    void unmarshall_add_config_cand_rp_by_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigCandRpByAddr6CB		cb
    );

    void unmarshall_delete_config_cand_rp_by_vif_name4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRpByVifName4CB		cb
    );

    void unmarshall_delete_config_cand_rp_by_vif_name6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRpByVifName6CB		cb
    );

    void unmarshall_delete_config_cand_rp_by_addr4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRpByAddr4CB		cb
    );

    void unmarshall_delete_config_cand_rp_by_addr6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigCandRpByAddr6CB		cb
    );

    void unmarshall_add_config_static_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigStaticRp4CB		cb
    );

    void unmarshall_add_config_static_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	AddConfigStaticRp6CB		cb
    );

    void unmarshall_delete_config_static_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigStaticRp4CB		cb
    );

    void unmarshall_delete_config_static_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigStaticRp6CB		cb
    );

    void unmarshall_delete_config_all_static_group_prefixes_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticGroupPrefixesRp4CB		cb
    );

    void unmarshall_delete_config_all_static_group_prefixes_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticGroupPrefixesRp6CB		cb
    );

    void unmarshall_delete_config_all_static_rps(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteConfigAllStaticRpsCB		cb
    );

    void unmarshall_config_static_rp_done(
	const XrlError&	e,
	XrlArgs*	a,
	ConfigStaticRpDoneCB		cb
    );

    void unmarshall_get_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifProtoVersionCB		cb
    );

    void unmarshall_set_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifProtoVersionCB		cb
    );

    void unmarshall_reset_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifProtoVersionCB		cb
    );

    void unmarshall_get_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloTriggeredDelayCB		cb
    );

    void unmarshall_set_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloTriggeredDelayCB		cb
    );

    void unmarshall_reset_vif_hello_triggered_delay(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloTriggeredDelayCB		cb
    );

    void unmarshall_get_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloPeriodCB		cb
    );

    void unmarshall_set_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloPeriodCB		cb
    );

    void unmarshall_reset_vif_hello_period(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloPeriodCB		cb
    );

    void unmarshall_get_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifHelloHoldtimeCB		cb
    );

    void unmarshall_set_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifHelloHoldtimeCB		cb
    );

    void unmarshall_reset_vif_hello_holdtime(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifHelloHoldtimeCB		cb
    );

    void unmarshall_get_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifDrPriorityCB		cb
    );

    void unmarshall_set_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifDrPriorityCB		cb
    );

    void unmarshall_reset_vif_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifDrPriorityCB		cb
    );

    void unmarshall_get_vif_lan_delay(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifLanDelayCB		cb
    );

    void unmarshall_set_vif_lan_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifLanDelayCB		cb
    );

    void unmarshall_reset_vif_lan_delay(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifLanDelayCB		cb
    );

    void unmarshall_get_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifOverrideIntervalCB		cb
    );

    void unmarshall_set_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifOverrideIntervalCB		cb
    );

    void unmarshall_reset_vif_override_interval(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifOverrideIntervalCB		cb
    );

    void unmarshall_get_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifIsTrackingSupportDisabledCB		cb
    );

    void unmarshall_set_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifIsTrackingSupportDisabledCB		cb
    );

    void unmarshall_reset_vif_is_tracking_support_disabled(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifIsTrackingSupportDisabledCB		cb
    );

    void unmarshall_get_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifAcceptNohelloNeighborsCB		cb
    );

    void unmarshall_set_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifAcceptNohelloNeighborsCB		cb
    );

    void unmarshall_reset_vif_accept_nohello_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifAcceptNohelloNeighborsCB		cb
    );

    void unmarshall_get_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifJoinPrunePeriodCB		cb
    );

    void unmarshall_set_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifJoinPrunePeriodCB		cb
    );

    void unmarshall_reset_vif_join_prune_period(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifJoinPrunePeriodCB		cb
    );

    void unmarshall_get_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	GetSwitchToSptThresholdCB		cb
    );

    void unmarshall_set_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	SetSwitchToSptThresholdCB		cb
    );

    void unmarshall_reset_switch_to_spt_threshold(
	const XrlError&	e,
	XrlArgs*	a,
	ResetSwitchToSptThresholdCB		cb
    );

    void unmarshall_add_alternative_subnet4(
	const XrlError&	e,
	XrlArgs*	a,
	AddAlternativeSubnet4CB		cb
    );

    void unmarshall_add_alternative_subnet6(
	const XrlError&	e,
	XrlArgs*	a,
	AddAlternativeSubnet6CB		cb
    );

    void unmarshall_delete_alternative_subnet4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAlternativeSubnet4CB		cb
    );

    void unmarshall_delete_alternative_subnet6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAlternativeSubnet6CB		cb
    );

    void unmarshall_remove_all_alternative_subnets(
	const XrlError&	e,
	XrlArgs*	a,
	RemoveAllAlternativeSubnetsCB		cb
    );

    void unmarshall_log_trace_all(
	const XrlError&	e,
	XrlArgs*	a,
	LogTraceAllCB		cb
    );

    void unmarshall_add_test_jp_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestJpEntry4CB		cb
    );

    void unmarshall_add_test_jp_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestJpEntry6CB		cb
    );

    void unmarshall_send_test_jp_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestJpEntry4CB		cb
    );

    void unmarshall_send_test_jp_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestJpEntry6CB		cb
    );

    void unmarshall_send_test_assert4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestAssert4CB		cb
    );

    void unmarshall_send_test_assert6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestAssert6CB		cb
    );

    void unmarshall_add_test_bsr_zone4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrZone4CB		cb
    );

    void unmarshall_add_test_bsr_zone6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrZone6CB		cb
    );

    void unmarshall_add_test_bsr_group_prefix4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrGroupPrefix4CB		cb
    );

    void unmarshall_add_test_bsr_group_prefix6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrGroupPrefix6CB		cb
    );

    void unmarshall_add_test_bsr_rp4(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrRp4CB		cb
    );

    void unmarshall_add_test_bsr_rp6(
	const XrlError&	e,
	XrlArgs*	a,
	AddTestBsrRp6CB		cb
    );

    void unmarshall_send_test_bootstrap(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapCB		cb
    );

    void unmarshall_send_test_bootstrap_by_dest4(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapByDest4CB		cb
    );

    void unmarshall_send_test_bootstrap_by_dest6(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestBootstrapByDest6CB		cb
    );

    void unmarshall_send_test_cand_rp_adv(
	const XrlError&	e,
	XrlArgs*	a,
	SendTestCandRpAdvCB		cb
    );

    void unmarshall_pimstat_neighbors4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighbors4CB		cb
    );

    void unmarshall_pimstat_neighbors6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighbors6CB		cb
    );

    void unmarshall_pimstat_interface4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatInterface4CB		cb
    );

    void unmarshall_pimstat_interface6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatInterface6CB		cb
    );

    void unmarshall_pimstat_rps4(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRps4CB		cb
    );

    void unmarshall_pimstat_rps6(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRps6CB		cb
    );

    void unmarshall_clear_pim_statistics(
	const XrlError&	e,
	XrlArgs*	a,
	ClearPimStatisticsCB		cb
    );

    void unmarshall_clear_pim_statistics_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	ClearPimStatisticsPerVifCB		cb
    );

    void unmarshall_pimstat_hello_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_hello_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesSentCB		cb
    );

    void unmarshall_pimstat_hello_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_register_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_register_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesSentCB		cb
    );

    void unmarshall_pimstat_register_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesSentCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesSentCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesSentCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_assert_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_assert_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesSentCB		cb
    );

    void unmarshall_pimstat_assert_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_graft_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_graft_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesSentCB		cb
    );

    void unmarshall_pimstat_graft_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesSentCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_received(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesReceivedCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_sent(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesSentCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_rx_errors(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesRxErrorsCB		cb
    );

    void unmarshall_pimstat_unknown_type_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownTypeMessagesCB		cb
    );

    void unmarshall_pimstat_unknown_version_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownVersionMessagesCB		cb
    );

    void unmarshall_pimstat_neighbor_unknown_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighborUnknownMessagesCB		cb
    );

    void unmarshall_pimstat_bad_length_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadLengthMessagesCB		cb
    );

    void unmarshall_pimstat_bad_checksum_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadChecksumMessagesCB		cb
    );

    void unmarshall_pimstat_bad_receive_interface_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadReceiveInterfaceMessagesCB		cb
    );

    void unmarshall_pimstat_rx_interface_disabled_messages(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxInterfaceDisabledMessagesCB		cb
    );

    void unmarshall_pimstat_rx_register_not_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRegisterNotRpCB		cb
    );

    void unmarshall_pimstat_rp_filtered_source(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpFilteredSourceCB		cb
    );

    void unmarshall_pimstat_unknown_register_stop(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownRegisterStopCB		cb
    );

    void unmarshall_pimstat_rx_join_prune_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinPruneNoStateCB		cb
    );

    void unmarshall_pimstat_rx_graft_graft_ack_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftGraftAckNoStateCB		cb
    );

    void unmarshall_pimstat_rx_graft_on_upstream_interface(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftOnUpstreamInterfaceCB		cb
    );

    void unmarshall_pimstat_rx_candidate_rp_not_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxCandidateRpNotBsrCB		cb
    );

    void unmarshall_pimstat_rx_bsr_when_bsr(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrWhenBsrCB		cb
    );

    void unmarshall_pimstat_rx_bsr_not_rpf_interface(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrNotRpfInterfaceCB		cb
    );

    void unmarshall_pimstat_rx_unknown_hello_option(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxUnknownHelloOptionCB		cb
    );

    void unmarshall_pimstat_rx_data_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxDataNoStateCB		cb
    );

    void unmarshall_pimstat_rx_rp_no_state(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRpNoStateCB		cb
    );

    void unmarshall_pimstat_rx_aggregate(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxAggregateCB		cb
    );

    void unmarshall_pimstat_rx_malformed_packet(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxMalformedPacketCB		cb
    );

    void unmarshall_pimstat_no_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRpCB		cb
    );

    void unmarshall_pimstat_no_route_upstream(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRouteUpstreamCB		cb
    );

    void unmarshall_pimstat_rp_mismatch(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpMismatchCB		cb
    );

    void unmarshall_pimstat_rpf_neighbor_unknown(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpfNeighborUnknownCB		cb
    );

    void unmarshall_pimstat_rx_join_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinRpCB		cb
    );

    void unmarshall_pimstat_rx_prune_rp(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneRpCB		cb
    );

    void unmarshall_pimstat_rx_join_wc(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinWcCB		cb
    );

    void unmarshall_pimstat_rx_prune_wc(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneWcCB		cb
    );

    void unmarshall_pimstat_rx_join_sg(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgCB		cb
    );

    void unmarshall_pimstat_rx_prune_sg(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgCB		cb
    );

    void unmarshall_pimstat_rx_join_sg_rpt(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgRptCB		cb
    );

    void unmarshall_pimstat_rx_prune_sg_rpt(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgRptCB		cb
    );

    void unmarshall_pimstat_hello_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_hello_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_hello_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatHelloMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_register_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_register_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_register_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_register_stop_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRegisterStopMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_join_prune_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatJoinPruneMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_bootstrap_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBootstrapMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_assert_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_assert_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_assert_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatAssertMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_graft_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_graft_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_graft_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_graft_ack_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatGraftAckMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_received_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesReceivedPerVifCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_sent_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesSentPerVifCB		cb
    );

    void unmarshall_pimstat_candidate_rp_messages_rx_errors_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatCandidateRpMessagesRxErrorsPerVifCB		cb
    );

    void unmarshall_pimstat_unknown_type_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownTypeMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_unknown_version_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownVersionMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_neighbor_unknown_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNeighborUnknownMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_bad_length_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadLengthMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_bad_checksum_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadChecksumMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_bad_receive_interface_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatBadReceiveInterfaceMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_rx_interface_disabled_messages_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxInterfaceDisabledMessagesPerVifCB		cb
    );

    void unmarshall_pimstat_rx_register_not_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRegisterNotRpPerVifCB		cb
    );

    void unmarshall_pimstat_rp_filtered_source_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpFilteredSourcePerVifCB		cb
    );

    void unmarshall_pimstat_unknown_register_stop_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatUnknownRegisterStopPerVifCB		cb
    );

    void unmarshall_pimstat_rx_join_prune_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinPruneNoStatePerVifCB		cb
    );

    void unmarshall_pimstat_rx_graft_graft_ack_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftGraftAckNoStatePerVifCB		cb
    );

    void unmarshall_pimstat_rx_graft_on_upstream_interface_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxGraftOnUpstreamInterfacePerVifCB		cb
    );

    void unmarshall_pimstat_rx_candidate_rp_not_bsr_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxCandidateRpNotBsrPerVifCB		cb
    );

    void unmarshall_pimstat_rx_bsr_when_bsr_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrWhenBsrPerVifCB		cb
    );

    void unmarshall_pimstat_rx_bsr_not_rpf_interface_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxBsrNotRpfInterfacePerVifCB		cb
    );

    void unmarshall_pimstat_rx_unknown_hello_option_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxUnknownHelloOptionPerVifCB		cb
    );

    void unmarshall_pimstat_rx_data_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxDataNoStatePerVifCB		cb
    );

    void unmarshall_pimstat_rx_rp_no_state_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxRpNoStatePerVifCB		cb
    );

    void unmarshall_pimstat_rx_aggregate_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxAggregatePerVifCB		cb
    );

    void unmarshall_pimstat_rx_malformed_packet_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxMalformedPacketPerVifCB		cb
    );

    void unmarshall_pimstat_no_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRpPerVifCB		cb
    );

    void unmarshall_pimstat_no_route_upstream_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatNoRouteUpstreamPerVifCB		cb
    );

    void unmarshall_pimstat_rp_mismatch_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpMismatchPerVifCB		cb
    );

    void unmarshall_pimstat_rpf_neighbor_unknown_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRpfNeighborUnknownPerVifCB		cb
    );

    void unmarshall_pimstat_rx_join_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinRpPerVifCB		cb
    );

    void unmarshall_pimstat_rx_prune_rp_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneRpPerVifCB		cb
    );

    void unmarshall_pimstat_rx_join_wc_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinWcPerVifCB		cb
    );

    void unmarshall_pimstat_rx_prune_wc_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneWcPerVifCB		cb
    );

    void unmarshall_pimstat_rx_join_sg_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgPerVifCB		cb
    );

    void unmarshall_pimstat_rx_prune_sg_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgPerVifCB		cb
    );

    void unmarshall_pimstat_rx_join_sg_rpt_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxJoinSgRptPerVifCB		cb
    );

    void unmarshall_pimstat_rx_prune_sg_rpt_per_vif(
	const XrlError&	e,
	XrlArgs*	a,
	PimstatRxPruneSgRptPerVifCB		cb
    );

};

#endif /* __XRL_INTERFACES_PIM_XIF_HH__ */
