/*
 * Copyright (c) 2001-2005 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/mfea_xif.cc,v 1.19 2005/03/25 02:54:50 pavlin Exp $"

#include "mfea_xif.hh"

bool
XrlMfeaV0p1Client::send_have_multicast_routing4(
	const char*	the_tgt,
	const HaveMulticastRouting4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/have_multicast_routing4");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_have_multicast_routing4, cb));
}


/* Unmarshall have_multicast_routing4 */
void
XrlMfeaV0p1Client::unmarshall_have_multicast_routing4(
	const XrlError&	e,
	XrlArgs*	a,
	HaveMulticastRouting4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool result;
    try {
	a->get("result", result);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &result);
}

bool
XrlMfeaV0p1Client::send_have_multicast_routing6(
	const char*	the_tgt,
	const HaveMulticastRouting6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/have_multicast_routing6");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_have_multicast_routing6, cb));
}


/* Unmarshall have_multicast_routing6 */
void
XrlMfeaV0p1Client::unmarshall_have_multicast_routing6(
	const XrlError&	e,
	XrlArgs*	a,
	HaveMulticastRouting6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool result;
    try {
	a->get("result", result);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &result);
}

bool
XrlMfeaV0p1Client::send_add_protocol4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const AddProtocol4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_protocol4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_protocol4, cb));
}


/* Unmarshall add_protocol4 */
void
XrlMfeaV0p1Client::unmarshall_add_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_add_protocol6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const AddProtocol6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_protocol6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_protocol6, cb));
}


/* Unmarshall add_protocol6 */
void
XrlMfeaV0p1Client::unmarshall_add_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_protocol4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const DeleteProtocol4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_protocol4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_protocol4, cb));
}


/* Unmarshall delete_protocol4 */
void
XrlMfeaV0p1Client::unmarshall_delete_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_protocol6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const DeleteProtocol6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_protocol6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_protocol6, cb));
}


/* Unmarshall delete_protocol6 */
void
XrlMfeaV0p1Client::unmarshall_delete_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_protocol_vif4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StartProtocolVif4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_protocol_vif4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_protocol_vif4, cb));
}


/* Unmarshall start_protocol_vif4 */
void
XrlMfeaV0p1Client::unmarshall_start_protocol_vif4(
	const XrlError&	e,
	XrlArgs*	a,
	StartProtocolVif4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_protocol_vif6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StartProtocolVif6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_protocol_vif6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_protocol_vif6, cb));
}


/* Unmarshall start_protocol_vif6 */
void
XrlMfeaV0p1Client::unmarshall_start_protocol_vif6(
	const XrlError&	e,
	XrlArgs*	a,
	StartProtocolVif6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_protocol_vif4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StopProtocolVif4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_protocol_vif4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_protocol_vif4, cb));
}


/* Unmarshall stop_protocol_vif4 */
void
XrlMfeaV0p1Client::unmarshall_stop_protocol_vif4(
	const XrlError&	e,
	XrlArgs*	a,
	StopProtocolVif4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_protocol_vif6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StopProtocolVif6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_protocol_vif6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_protocol_vif6, cb));
}


/* Unmarshall stop_protocol_vif6 */
void
XrlMfeaV0p1Client::unmarshall_stop_protocol_vif6(
	const XrlError&	e,
	XrlArgs*	a,
	StopProtocolVif6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_allow_signal_messages(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const bool&	is_allow,
	const AllowSignalMessagesCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/allow_signal_messages");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("is_allow", is_allow);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_allow_signal_messages, cb));
}


/* Unmarshall allow_signal_messages */
void
XrlMfeaV0p1Client::unmarshall_allow_signal_messages(
	const XrlError&	e,
	XrlArgs*	a,
	AllowSignalMessagesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_join_multicast_group4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	group_address,
	const JoinMulticastGroup4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/join_multicast_group4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_join_multicast_group4, cb));
}


/* Unmarshall join_multicast_group4 */
void
XrlMfeaV0p1Client::unmarshall_join_multicast_group4(
	const XrlError&	e,
	XrlArgs*	a,
	JoinMulticastGroup4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_join_multicast_group6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	group_address,
	const JoinMulticastGroup6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/join_multicast_group6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_join_multicast_group6, cb));
}


/* Unmarshall join_multicast_group6 */
void
XrlMfeaV0p1Client::unmarshall_join_multicast_group6(
	const XrlError&	e,
	XrlArgs*	a,
	JoinMulticastGroup6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_leave_multicast_group4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	group_address,
	const LeaveMulticastGroup4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/leave_multicast_group4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_leave_multicast_group4, cb));
}


/* Unmarshall leave_multicast_group4 */
void
XrlMfeaV0p1Client::unmarshall_leave_multicast_group4(
	const XrlError&	e,
	XrlArgs*	a,
	LeaveMulticastGroup4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_leave_multicast_group6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	group_address,
	const LeaveMulticastGroup6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/leave_multicast_group6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_leave_multicast_group6, cb));
}


/* Unmarshall leave_multicast_group6 */
void
XrlMfeaV0p1Client::unmarshall_leave_multicast_group6(
	const XrlError&	e,
	XrlArgs*	a,
	LeaveMulticastGroup6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_add_mfc4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	iif_vif_index,
	const vector<uint8_t>&	oiflist,
	const vector<uint8_t>&	oiflist_disable_wrongvif,
	const uint32_t&	max_vifs_oiflist,
	const IPv4&	rp_address,
	const AddMfc4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_mfc4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("iif_vif_index", iif_vif_index);
    x.args().add("oiflist", oiflist);
    x.args().add("oiflist_disable_wrongvif", oiflist_disable_wrongvif);
    x.args().add("max_vifs_oiflist", max_vifs_oiflist);
    x.args().add("rp_address", rp_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_mfc4, cb));
}


/* Unmarshall add_mfc4 */
void
XrlMfeaV0p1Client::unmarshall_add_mfc4(
	const XrlError&	e,
	XrlArgs*	a,
	AddMfc4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_add_mfc6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	iif_vif_index,
	const vector<uint8_t>&	oiflist,
	const vector<uint8_t>&	oiflist_disable_wrongvif,
	const uint32_t&	max_vifs_oiflist,
	const IPv6&	rp_address,
	const AddMfc6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_mfc6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("iif_vif_index", iif_vif_index);
    x.args().add("oiflist", oiflist);
    x.args().add("oiflist_disable_wrongvif", oiflist_disable_wrongvif);
    x.args().add("max_vifs_oiflist", max_vifs_oiflist);
    x.args().add("rp_address", rp_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_mfc6, cb));
}


/* Unmarshall add_mfc6 */
void
XrlMfeaV0p1Client::unmarshall_add_mfc6(
	const XrlError&	e,
	XrlArgs*	a,
	AddMfc6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_mfc4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const DeleteMfc4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_mfc4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_mfc4, cb));
}


/* Unmarshall delete_mfc4 */
void
XrlMfeaV0p1Client::unmarshall_delete_mfc4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMfc4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_mfc6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const DeleteMfc6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_mfc6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_mfc6, cb));
}


/* Unmarshall delete_mfc6 */
void
XrlMfeaV0p1Client::unmarshall_delete_mfc6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMfc6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_send_protocol_message4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message,
	const SendProtocolMessage4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/send_protocol_message4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("source_address", source_address);
    x.args().add("dest_address", dest_address);
    x.args().add("ip_ttl", ip_ttl);
    x.args().add("ip_tos", ip_tos);
    x.args().add("is_router_alert", is_router_alert);
    x.args().add("protocol_message", protocol_message);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_send_protocol_message4, cb));
}


/* Unmarshall send_protocol_message4 */
void
XrlMfeaV0p1Client::unmarshall_send_protocol_message4(
	const XrlError&	e,
	XrlArgs*	a,
	SendProtocolMessage4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_send_protocol_message6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message,
	const SendProtocolMessage6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/send_protocol_message6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("protocol_name", protocol_name);
    x.args().add("protocol_id", protocol_id);
    x.args().add("vif_name", vif_name);
    x.args().add("vif_index", vif_index);
    x.args().add("source_address", source_address);
    x.args().add("dest_address", dest_address);
    x.args().add("ip_ttl", ip_ttl);
    x.args().add("ip_tos", ip_tos);
    x.args().add("is_router_alert", is_router_alert);
    x.args().add("protocol_message", protocol_message);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_send_protocol_message6, cb));
}


/* Unmarshall send_protocol_message6 */
void
XrlMfeaV0p1Client::unmarshall_send_protocol_message6(
	const XrlError&	e,
	XrlArgs*	a,
	SendProtocolMessage6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_add_dataflow_monitor4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const AddDataflowMonitor4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_dataflow_monitor4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("threshold_interval_sec", threshold_interval_sec);
    x.args().add("threshold_interval_usec", threshold_interval_usec);
    x.args().add("threshold_packets", threshold_packets);
    x.args().add("threshold_bytes", threshold_bytes);
    x.args().add("is_threshold_in_packets", is_threshold_in_packets);
    x.args().add("is_threshold_in_bytes", is_threshold_in_bytes);
    x.args().add("is_geq_upcall", is_geq_upcall);
    x.args().add("is_leq_upcall", is_leq_upcall);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_dataflow_monitor4, cb));
}


/* Unmarshall add_dataflow_monitor4 */
void
XrlMfeaV0p1Client::unmarshall_add_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	AddDataflowMonitor4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_add_dataflow_monitor6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const AddDataflowMonitor6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/add_dataflow_monitor6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("threshold_interval_sec", threshold_interval_sec);
    x.args().add("threshold_interval_usec", threshold_interval_usec);
    x.args().add("threshold_packets", threshold_packets);
    x.args().add("threshold_bytes", threshold_bytes);
    x.args().add("is_threshold_in_packets", is_threshold_in_packets);
    x.args().add("is_threshold_in_bytes", is_threshold_in_bytes);
    x.args().add("is_geq_upcall", is_geq_upcall);
    x.args().add("is_leq_upcall", is_leq_upcall);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_add_dataflow_monitor6, cb));
}


/* Unmarshall add_dataflow_monitor6 */
void
XrlMfeaV0p1Client::unmarshall_add_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	AddDataflowMonitor6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_dataflow_monitor4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const DeleteDataflowMonitor4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_dataflow_monitor4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("threshold_interval_sec", threshold_interval_sec);
    x.args().add("threshold_interval_usec", threshold_interval_usec);
    x.args().add("threshold_packets", threshold_packets);
    x.args().add("threshold_bytes", threshold_bytes);
    x.args().add("is_threshold_in_packets", is_threshold_in_packets);
    x.args().add("is_threshold_in_bytes", is_threshold_in_bytes);
    x.args().add("is_geq_upcall", is_geq_upcall);
    x.args().add("is_leq_upcall", is_leq_upcall);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_dataflow_monitor4, cb));
}


/* Unmarshall delete_dataflow_monitor4 */
void
XrlMfeaV0p1Client::unmarshall_delete_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteDataflowMonitor4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_dataflow_monitor6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const DeleteDataflowMonitor6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_dataflow_monitor6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    x.args().add("threshold_interval_sec", threshold_interval_sec);
    x.args().add("threshold_interval_usec", threshold_interval_usec);
    x.args().add("threshold_packets", threshold_packets);
    x.args().add("threshold_bytes", threshold_bytes);
    x.args().add("is_threshold_in_packets", is_threshold_in_packets);
    x.args().add("is_threshold_in_bytes", is_threshold_in_bytes);
    x.args().add("is_geq_upcall", is_geq_upcall);
    x.args().add("is_leq_upcall", is_leq_upcall);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_dataflow_monitor6, cb));
}


/* Unmarshall delete_dataflow_monitor6 */
void
XrlMfeaV0p1Client::unmarshall_delete_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteDataflowMonitor6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_all_dataflow_monitor4(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const DeleteAllDataflowMonitor4CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_all_dataflow_monitor4");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_all_dataflow_monitor4, cb));
}


/* Unmarshall delete_all_dataflow_monitor4 */
void
XrlMfeaV0p1Client::unmarshall_delete_all_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllDataflowMonitor4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_delete_all_dataflow_monitor6(
	const char*	the_tgt,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const DeleteAllDataflowMonitor6CB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/delete_all_dataflow_monitor6");
    x.args().add("xrl_sender_name", xrl_sender_name);
    x.args().add("source_address", source_address);
    x.args().add("group_address", group_address);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_delete_all_dataflow_monitor6, cb));
}


/* Unmarshall delete_all_dataflow_monitor6 */
void
XrlMfeaV0p1Client::unmarshall_delete_all_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllDataflowMonitor6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_enable_vif(
	const char*	the_tgt,
	const string&	vif_name,
	const bool&	enable,
	const EnableVifCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/enable_vif");
    x.args().add("vif_name", vif_name);
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_enable_vif, cb));
}


/* Unmarshall enable_vif */
void
XrlMfeaV0p1Client::unmarshall_enable_vif(
	const XrlError&	e,
	XrlArgs*	a,
	EnableVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_vif(
	const char*	the_tgt,
	const string&	vif_name,
	const StartVifCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_vif");
    x.args().add("vif_name", vif_name);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_vif, cb));
}


/* Unmarshall start_vif */
void
XrlMfeaV0p1Client::unmarshall_start_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StartVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_vif(
	const char*	the_tgt,
	const string&	vif_name,
	const StopVifCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_vif");
    x.args().add("vif_name", vif_name);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_vif, cb));
}


/* Unmarshall stop_vif */
void
XrlMfeaV0p1Client::unmarshall_stop_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StopVifCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_enable_all_vifs(
	const char*	the_tgt,
	const bool&	enable,
	const EnableAllVifsCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/enable_all_vifs");
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_enable_all_vifs, cb));
}


/* Unmarshall enable_all_vifs */
void
XrlMfeaV0p1Client::unmarshall_enable_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	EnableAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_all_vifs(
	const char*	the_tgt,
	const StartAllVifsCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_all_vifs");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_all_vifs, cb));
}


/* Unmarshall start_all_vifs */
void
XrlMfeaV0p1Client::unmarshall_start_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StartAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_all_vifs(
	const char*	the_tgt,
	const StopAllVifsCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_all_vifs");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_all_vifs, cb));
}


/* Unmarshall stop_all_vifs */
void
XrlMfeaV0p1Client::unmarshall_stop_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StopAllVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_enable_mfea(
	const char*	the_tgt,
	const bool&	enable,
	const EnableMfeaCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/enable_mfea");
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_enable_mfea, cb));
}


/* Unmarshall enable_mfea */
void
XrlMfeaV0p1Client::unmarshall_enable_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	EnableMfeaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_mfea(
	const char*	the_tgt,
	const StartMfeaCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_mfea");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_mfea, cb));
}


/* Unmarshall start_mfea */
void
XrlMfeaV0p1Client::unmarshall_start_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	StartMfeaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_mfea(
	const char*	the_tgt,
	const StopMfeaCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_mfea");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_mfea, cb));
}


/* Unmarshall stop_mfea */
void
XrlMfeaV0p1Client::unmarshall_stop_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	StopMfeaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_enable_cli(
	const char*	the_tgt,
	const bool&	enable,
	const EnableCliCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/enable_cli");
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_enable_cli, cb));
}


/* Unmarshall enable_cli */
void
XrlMfeaV0p1Client::unmarshall_enable_cli(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_start_cli(
	const char*	the_tgt,
	const StartCliCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/start_cli");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_start_cli, cb));
}


/* Unmarshall start_cli */
void
XrlMfeaV0p1Client::unmarshall_start_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StartCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_stop_cli(
	const char*	the_tgt,
	const StopCliCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/stop_cli");
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_stop_cli, cb));
}


/* Unmarshall stop_cli */
void
XrlMfeaV0p1Client::unmarshall_stop_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StopCliCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlMfeaV0p1Client::send_log_trace_all(
	const char*	the_tgt,
	const bool&	enable,
	const LogTraceAllCB&	cb
)
{
    Xrl x(the_tgt, "mfea/0.1/log_trace_all");
    x.args().add("enable", enable);
    return _sender->send(x, callback(this, &XrlMfeaV0p1Client::unmarshall_log_trace_all, cb));
}


/* Unmarshall log_trace_all */
void
XrlMfeaV0p1Client::unmarshall_log_trace_all(
	const XrlError&	e,
	XrlArgs*	a,
	LogTraceAllCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
