/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 *
 * $XORP: xorp/xrl/targets/ospf_base.hh,v 1.14 2004/06/10 22:42:13 hodson Exp $
 */


#ifndef __XRL_INTERFACES_OSPF_BASE_HH__
#define __XRL_INTERFACES_OSPF_BASE_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XrlOspfTarget"

#include "libxorp/xlog.h"
#include "libxipc/xrl_cmd_map.hh"

class XrlOspfTargetBase {
protected:
    XrlCmdMap* _cmds;

public:
    /**
     * Constructor.
     *
     * @param cmds an XrlCmdMap that the commands associated with the target
     *		   should be added to.  This is typically the XrlRouter
     *		   associated with the target.
     */
    XrlOspfTargetBase(XrlCmdMap* cmds = 0);

    /**
     * Destructor.
     *
     * Dissociates instance commands from command map.
     */
    virtual ~XrlOspfTargetBase();

    /**
     * Set command map.
     *
     * @param cmds pointer to command map to associate commands with.  This
     * argument is typically a pointer to the XrlRouter associated with the
     * target.
     *
     * @return true on success, false if cmds is null or a command map has
     * already been supplied.
     */
    bool set_command_map(XrlCmdMap* cmds);

    /**
     * Get Xrl instance name associated with command map.
     */
    inline const string& name() const { return _cmds->name(); }

    /**
     * Get version string of instance.
     */
    inline const char* version() const { return "ospf/0.0"; }

protected:

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get name of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_target_name(
	// Output values,
	string&	name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get version string from Xrl Target
     */
    virtual XrlCmdError common_0_1_get_version(
	// Output values,
	string&	version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get status of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t&	status,
	string&	reason) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Request clean shutdown of Xrl Target
     */
    virtual XrlCmdError common_0_1_shutdown() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set router id
     */
    virtual XrlCmdError ospf_0_1_set_router_id(
	// Input values,
	const uint32_t&	id) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get router id
     */
    virtual XrlCmdError ospf_0_1_get_router_id(
	// Output values,
	uint32_t&	id) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set maximum number of AS-external LSA's
     */
    virtual XrlCmdError ospf_0_1_set_lsdb_limit(
	// Input values,
	const int32_t&	limit) = 0;

    virtual XrlCmdError ospf_0_1_get_lsdb_limit(
	// Output values,
	int32_t&	limit) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable / disable MOSPF
     */
    virtual XrlCmdError ospf_0_1_set_mospf(
	// Input values,
	const bool&	enabled) = 0;

    virtual XrlCmdError ospf_0_1_get_mospf(
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable / Disable Inter-area multicast
     */
    virtual XrlCmdError ospf_0_1_set_interarea_mc(
	// Input values,
	const bool&	enabled) = 0;

    virtual XrlCmdError ospf_0_1_get_interarea_mc(
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set time to exit overflow state
     */
    virtual XrlCmdError ospf_0_1_set_overflow_interval(
	// Input values,
	const int32_t&	ovfl_int) = 0;

    virtual XrlCmdError ospf_0_1_get_overflow_interval(
	// Output values,
	int32_t&	ovfl_int) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set flood rate - self orig per second
     */
    virtual XrlCmdError ospf_0_1_set_flood_rate(
	// Input values,
	const int32_t&	rate) = 0;

    virtual XrlCmdError ospf_0_1_get_flood_rate(
	// Output values,
	int32_t&	rate) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set back-to-back retransmissions
     */
    virtual XrlCmdError ospf_0_1_set_max_rxmt_window(
	// Input values,
	const uint32_t&	window) = 0;

    virtual XrlCmdError ospf_0_1_get_max_rxmt_window(
	// Output values,
	uint32_t&	window) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set maximum simultaneous DB exchanges
     */
    virtual XrlCmdError ospf_0_1_set_max_dds(
	// Input values,
	const uint32_t&	max_dds) = 0;

    virtual XrlCmdError ospf_0_1_get_max_dds(
	// Output values,
	uint32_t&	max_dds) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set rate to refresh DoNotAge LSAs
     */
    virtual XrlCmdError ospf_0_1_set_lsa_refresh_rate(
	// Input values,
	const uint32_t&	rate) = 0;

    virtual XrlCmdError ospf_0_1_get_lsa_refresh_rate(
	// Output values,
	uint32_t&	rate) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the maximum number of point-to-point links that will become
     *  adjacent to a particular neighbor. If there is no limit then value is
     *  zero.
     */
    virtual XrlCmdError ospf_0_1_set_p2p_adj_limit(
	// Input values,
	const uint32_t&	max_adj) = 0;

    virtual XrlCmdError ospf_0_1_get_p2p_adj_limit(
	// Output values,
	uint32_t&	max_adj) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set randomized LSA refreshes
     */
    virtual XrlCmdError ospf_0_1_set_random_refresh(
	// Input values,
	const bool&	enabled) = 0;

    virtual XrlCmdError ospf_0_1_get_random_refresh(
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Create area
     */
    virtual XrlCmdError ospf_0_1_add_or_configure_area(
	// Input values,
	const uint32_t&	area_id,
	const bool&	is_stub,
	const uint32_t&	default_cost,
	const bool&	import_summary_routes) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete area
     */
    virtual XrlCmdError ospf_0_1_delete_area(
	// Input values,
	const uint32_t&	area_id) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Query area options
     */
    virtual XrlCmdError ospf_0_1_query_area(
	// Input values,
	const uint32_t&	area_id,
	// Output values,
	bool&	is_stub,
	uint32_t&	default_cost,
	bool&	import_summary_routes) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *
     *  @param area_ids list of value area_ids. Each id is a u32.
     */
    virtual XrlCmdError ospf_0_1_list_area_ids(
	// Output values,
	XrlAtomList&	area_ids) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add or configure aggregate.
     *
     *  @param area_id id of area aggregate belongs to.
     *
     *  @param network network identifier.
     *
     *  @param netmask netmask identifier.
     *
     *  @param suppress_advertisement of aggregate.
     */
    virtual XrlCmdError ospf_0_1_add_or_configure_aggregate(
	// Input values,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask,
	const bool&	suppress_advertisement) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete aggregate identified by area_id, network, and netmask
     */
    virtual XrlCmdError ospf_0_1_delete_aggregate(
	// Input values,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Query aggregate identified by area_id, network, and netmask
     */
    virtual XrlCmdError ospf_0_1_query_aggregate(
	// Input values,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask,
	// Output values,
	bool&	suppress_advertisement) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Return list of aggregate identifiers for area identified by area_id.
     *  Two lists are returned, the nth elements in each list comprise the
     *  tuple (network,netmask) that uniquely identifies the aggregate within
     *  the area.
     */
    virtual XrlCmdError ospf_0_1_list_aggregates(
	// Input values,
	const uint32_t&	area_id,
	// Output values,
	XrlAtomList&	networks,
	XrlAtomList&	netmasks) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add or configure host routes.
     *
     *  @param area_id host is to be advertised in.
     *
     *  @param cost metric associated with host (0-65535).
     */
    virtual XrlCmdError ospf_0_1_add_or_configure_host(
	// Input values,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id,
	const uint32_t&	cost) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete host identified by network and netmask
     */
    virtual XrlCmdError ospf_0_1_delete_host(
	// Input values,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Query host identified by network and netmask
     */
    virtual XrlCmdError ospf_0_1_query_host(
	// Input values,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id,
	// Output values,
	uint32_t&	cost) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Return list of host identifiers for area identified by area_id. Two
     *  lists are returned, the nth elements in each list comprise the tuple
     *  (network,netmask) that uniquely identifies the host within the area.
     */
    virtual XrlCmdError ospf_0_1_list_hosts(
	// Input values,
	const uint32_t&	area_id,
	// Output values,
	XrlAtomList&	networks,
	XrlAtomList&	netmasks) = 0;

    virtual XrlCmdError ospf_0_1_add_vlink(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id) = 0;

    virtual XrlCmdError ospf_0_1_delete_vlink(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id) = 0;

    virtual XrlCmdError ospf_0_1_vlink_set_transmit_delay(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	delay_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_get_transmit_delay(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	// Output values,
	uint32_t&	delay_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_set_retransmit_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_get_retransmit_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	// Output values,
	uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_set_hello_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_get_hello_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	// Output values,
	uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_set_router_dead_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_vlink_get_router_dead_interval(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	// Output values,
	uint32_t&	interval_secs) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *
     *  @param type is one of "none", "cleartext", "md5"
     */
    virtual XrlCmdError ospf_0_1_vlink_set_authentication(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const string&	type,
	const string&	key) = 0;

    virtual XrlCmdError ospf_0_1_vlink_get_authentication(
	// Input values,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	// Output values,
	string&	type,
	string&	key) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Return list of neighbour id's (unsigned 32 bit values)
     */
    virtual XrlCmdError ospf_0_1_list_vlinks(
	// Input values,
	const uint32_t&	transit_id,
	// Output values,
	XrlAtomList&	neighbor_ids) = 0;

    virtual XrlCmdError ospf_0_1_add_or_configure_external_route(
	// Input values,
	const IPv4Net&	network,
	const IPv4&	gateway,
	const uint32_t&	type,
	const uint32_t&	cost,
	const bool&	multicast,
	const uint32_t&	external_route_tag) = 0;

    virtual XrlCmdError ospf_0_1_delete_external_route(
	// Input values,
	const IPv4Net&	network,
	const IPv4&	gateway) = 0;

    virtual XrlCmdError ospf_0_1_query_external_route(
	// Input values,
	const IPv4Net&	network,
	const IPv4&	gateway,
	// Output values,
	uint32_t&	type,
	uint32_t&	cost,
	bool&	multicast,
	uint32_t&	external_route_tag) = 0;

    virtual XrlCmdError ospf_0_1_list_external_routes(
	// Input values,
	const IPv4Net&	network,
	// Output values,
	XrlAtomList&	gateways) = 0;

    virtual XrlCmdError ospf_0_1_add_interface(
	// Input values,
	const string&	identifier,
	const uint32_t&	if_index,
	const uint32_t&	area_id,
	const uint32_t&	cost,
	const uint32_t&	mtu,
	const string&	type,
	const bool&	on_demand,
	const bool&	passive) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_if_index(
	// Input values,
	const string&	identifier,
	const uint32_t&	index) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_if_index(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	index) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_area_id(
	// Input values,
	const string&	identifier,
	const uint32_t&	area_id) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_area_id(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	area_id) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_cost(
	// Input values,
	const string&	identifier,
	const uint32_t&	cost) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_cost(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	cost) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_mtu(
	// Input values,
	const string&	identifier,
	const uint32_t&	mtu) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_mtu(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	mtu) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_type(
	// Input values,
	const string&	identifier,
	const string&	type) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_type(
	// Input values,
	const string&	identifier,
	// Output values,
	string&	type) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_dr_priority(
	// Input values,
	const string&	identifier,
	const uint32_t&	dr_priority) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_dr_priority(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	dr_priority) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_transit_delay(
	// Input values,
	const string&	identifier,
	const uint32_t&	delay_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_transit_delay(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	delay_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_retransmit_interval(
	// Input values,
	const string&	identifier,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_retransmit_interval(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_router_dead_interval(
	// Input values,
	const string&	identifier,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_router_dead_interval(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_poll_interval(
	// Input values,
	const string&	identifier,
	const uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_poll_interval(
	// Input values,
	const string&	identifier,
	// Output values,
	uint32_t&	interval_secs) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_authentication(
	// Input values,
	const string&	identifier,
	const string&	type,
	const string&	key) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_authentication(
	// Input values,
	const string&	identifier,
	// Output values,
	string&	type,
	string&	key) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set state of multicast forwarding on interface.
     *
     *  @param type multicast type can be one of three values: "blocked"
     *  meaning not enabled, "multicast" meaning data-link multicast, or
     *  "unicast" meaning multicast packets should be unicast on data-link.
     */
    virtual XrlCmdError ospf_0_1_interface_set_multicast_forwarding(
	// Input values,
	const string&	identifier,
	const string&	type) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_multicast_forwarding(
	// Input values,
	const string&	identifier,
	// Output values,
	string&	type) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_on_demand(
	// Input values,
	const string&	identifier,
	const bool&	on_demand) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_on_demand(
	// Input values,
	const string&	identifier,
	// Output values,
	bool&	on_demand) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_passive(
	// Input values,
	const string&	identifier,
	const bool&	passive) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_passive(
	// Input values,
	const string&	identifier,
	// Output values,
	bool&	passive) = 0;

    virtual XrlCmdError ospf_0_1_interface_set_igmp(
	// Input values,
	const string&	identifier,
	const bool&	enabled) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_igmp(
	// Input values,
	const string&	identifier,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ospf_0_1_delete_interface(
	// Input values,
	const string&	identifier) = 0;

    virtual XrlCmdError ospf_0_1_list_interfaces(
	// Output values,
	XrlAtomList&	identifiers) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add md5 key to interface. The key may be used for both receiving and
     *  transmitting packets. Separate time periods are used to describe when
     *  the key is valid for receiving and transmitting. These periods are
     *  bound by times start_receive, stop_receive and start_transmit,
     *  stop_transmit. The expected date format is "%Y-%m-%d %H:%M:%S". This
     *  code uses strptime and strftime internally.
     *
     *  @param identifier interface key is to be used for.
     *
     *  @param key_id a value between 1-255 that identifies the key.
     */
    virtual XrlCmdError ospf_0_1_interface_add_md5_key(
	// Input values,
	const string&	identifier,
	const uint32_t&	key_id,
	const string&	md5key,
	const string&	start_receive,
	const string&	stop_receive,
	const string&	start_transmit,
	const string&	stop_transmit) = 0;

    virtual XrlCmdError ospf_0_1_interface_get_md5_key(
	// Input values,
	const string&	identifier,
	const uint32_t&	key_id,
	// Output values,
	string&	md5key,
	string&	start_receive,
	string&	stop_receive,
	string&	start_transmit,
	string&	stop_transmit) = 0;

    virtual XrlCmdError ospf_0_1_interface_delete_md5_key(
	// Input values,
	const string&	identifier,
	const uint32_t&	key_id) = 0;

    virtual XrlCmdError ospf_0_1_interface_list_md5_keys(
	// Input values,
	const string&	identifier,
	// Output values,
	XrlAtomList&	key_ids) = 0;

    virtual XrlCmdError ospf_0_1_add_neighbor(
	// Input values,
	const IPv4&	nbr_addr,
	const bool&	dr_eligible) = 0;

    virtual XrlCmdError ospf_0_1_get_neighbor(
	// Input values,
	const IPv4&	nbr_addr,
	// Output values,
	bool&	dr_eligible) = 0;

    virtual XrlCmdError ospf_0_1_delete_neighbor(
	// Input values,
	const IPv4&	nbr_addr) = 0;

    virtual XrlCmdError ospf_0_1_list_neighbors(
	// Output values,
	XrlAtomList&	nbr_addrs) = 0;

private:
    const XrlCmdError handle_common_0_1_get_target_name(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_status(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_shutdown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_router_id(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_router_id(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_lsdb_limit(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_lsdb_limit(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_mospf(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_mospf(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_interarea_mc(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_interarea_mc(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_overflow_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_overflow_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_flood_rate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_flood_rate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_max_rxmt_window(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_max_rxmt_window(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_max_dds(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_max_dds(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_lsa_refresh_rate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_lsa_refresh_rate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_p2p_adj_limit(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_p2p_adj_limit(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_set_random_refresh(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_random_refresh(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_or_configure_area(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_area(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_query_area(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_area_ids(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_or_configure_aggregate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_aggregate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_query_aggregate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_aggregates(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_or_configure_host(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_host(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_query_host(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_hosts(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_vlink(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_vlink(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_set_transmit_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_get_transmit_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_set_retransmit_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_get_retransmit_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_set_hello_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_get_hello_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_set_router_dead_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_get_router_dead_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_set_authentication(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_vlink_get_authentication(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_vlinks(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_or_configure_external_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_external_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_query_external_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_external_routes(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_if_index(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_if_index(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_area_id(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_area_id(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_cost(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_cost(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_mtu(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_mtu(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_type(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_type(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_dr_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_dr_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_transit_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_transit_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_retransmit_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_retransmit_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_router_dead_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_router_dead_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_poll_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_poll_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_authentication(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_authentication(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_multicast_forwarding(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_multicast_forwarding(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_on_demand(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_on_demand(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_passive(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_passive(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_set_igmp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_igmp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_interfaces(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_add_md5_key(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_get_md5_key(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_delete_md5_key(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_interface_list_md5_keys(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_add_neighbor(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_get_neighbor(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_delete_neighbor(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ospf_0_1_list_neighbors(const XrlArgs& in, XrlArgs* out);

    void add_handlers();
    void remove_handlers();
};

#endif /* __XRL_INTERFACES_OSPF_BASE_HH__ */
