/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/ospf_base.cc,v 1.12 2004/06/10 22:42:12 hodson Exp $"


#include "ospf_base.hh"


XrlOspfTargetBase::XrlOspfTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlOspfTargetBase::~XrlOspfTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlOspfTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlOspfTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_router_id(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_router_id");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_router_id(
	    xa_inputs.get_uint32("id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_router_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_router_id(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_router_id");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t id;
    try {
	XrlCmdError e = ospf_0_1_get_router_id(
	    id);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_router_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("id", id);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_lsdb_limit(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_lsdb_limit");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_lsdb_limit(
	    xa_inputs.get_int32("limit"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_lsdb_limit", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_lsdb_limit(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_lsdb_limit");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    int32_t limit;
    try {
	XrlCmdError e = ospf_0_1_get_lsdb_limit(
	    limit);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_lsdb_limit", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("limit", limit);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_mospf(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_mospf");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_mospf(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_mospf", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_mospf(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_mospf");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ospf_0_1_get_mospf(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_mospf", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_interarea_mc(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_interarea_mc");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_interarea_mc(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_interarea_mc", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_interarea_mc(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_interarea_mc");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ospf_0_1_get_interarea_mc(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_interarea_mc", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_overflow_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_overflow_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_overflow_interval(
	    xa_inputs.get_int32("ovfl_int"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_overflow_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_overflow_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_overflow_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    int32_t ovfl_int;
    try {
	XrlCmdError e = ospf_0_1_get_overflow_interval(
	    ovfl_int);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_overflow_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ovfl_int", ovfl_int);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_flood_rate(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_flood_rate");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_flood_rate(
	    xa_inputs.get_int32("rate"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_flood_rate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_flood_rate(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_flood_rate");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    int32_t rate;
    try {
	XrlCmdError e = ospf_0_1_get_flood_rate(
	    rate);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_flood_rate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("rate", rate);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_max_rxmt_window(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_max_rxmt_window");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_max_rxmt_window(
	    xa_inputs.get_uint32("window"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_max_rxmt_window", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_max_rxmt_window(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_max_rxmt_window");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t window;
    try {
	XrlCmdError e = ospf_0_1_get_max_rxmt_window(
	    window);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_max_rxmt_window", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("window", window);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_max_dds(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_max_dds");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_max_dds(
	    xa_inputs.get_uint32("max_dds"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_max_dds", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_max_dds(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_max_dds");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t max_dds;
    try {
	XrlCmdError e = ospf_0_1_get_max_dds(
	    max_dds);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_max_dds", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("max_dds", max_dds);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_lsa_refresh_rate(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_lsa_refresh_rate");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_lsa_refresh_rate(
	    xa_inputs.get_uint32("rate"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_lsa_refresh_rate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_lsa_refresh_rate(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_lsa_refresh_rate");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t rate;
    try {
	XrlCmdError e = ospf_0_1_get_lsa_refresh_rate(
	    rate);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_lsa_refresh_rate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("rate", rate);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_p2p_adj_limit(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_p2p_adj_limit");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_p2p_adj_limit(
	    xa_inputs.get_uint32("max_adj"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_p2p_adj_limit", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_p2p_adj_limit(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_p2p_adj_limit");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t max_adj;
    try {
	XrlCmdError e = ospf_0_1_get_p2p_adj_limit(
	    max_adj);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_p2p_adj_limit", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("max_adj", max_adj);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_set_random_refresh(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/set_random_refresh");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_set_random_refresh(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/set_random_refresh", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_random_refresh(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/get_random_refresh");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ospf_0_1_get_random_refresh(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_random_refresh", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_area(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ospf/0.1/add_or_configure_area");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_or_configure_area(
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_bool("is_stub"),
	    xa_inputs.get_uint32("default_cost"),
	    xa_inputs.get_bool("import_summary_routes"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_or_configure_area", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_area(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_area");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_area(
	    xa_inputs.get_uint32("area_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_area", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_query_area(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/query_area");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool is_stub;
    uint32_t default_cost;
    bool import_summary_routes;
    try {
	XrlCmdError e = ospf_0_1_query_area(
	    xa_inputs.get_uint32("area_id"),
	    is_stub,
	    default_cost,
	    import_summary_routes);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/query_area", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("is_stub", is_stub);
	pxa_outputs->add("default_cost", default_cost);
	pxa_outputs->add("import_summary_routes", import_summary_routes);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_area_ids(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/list_area_ids");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList area_ids;
    try {
	XrlCmdError e = ospf_0_1_list_area_ids(
	    area_ids);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_area_ids", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("area_ids", area_ids);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_aggregate(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ospf/0.1/add_or_configure_aggregate");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_or_configure_aggregate(
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"),
	    xa_inputs.get_bool("suppress_advertisement"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_or_configure_aggregate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_aggregate(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_aggregate");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_aggregate(
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_aggregate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_query_aggregate(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/query_aggregate");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool suppress_advertisement;
    try {
	XrlCmdError e = ospf_0_1_query_aggregate(
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"),
	    suppress_advertisement);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/query_aggregate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("suppress_advertisement", suppress_advertisement);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_aggregates(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/list_aggregates");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList networks;
    XrlAtomList netmasks;
    try {
	XrlCmdError e = ospf_0_1_list_aggregates(
	    xa_inputs.get_uint32("area_id"),
	    networks,
	    netmasks);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_aggregates", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("networks", networks);
	pxa_outputs->add("netmasks", netmasks);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_host(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ospf/0.1/add_or_configure_host");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_or_configure_host(
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"),
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_uint32("cost"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_or_configure_host", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_host(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_host");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_host(
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"),
	    xa_inputs.get_uint32("area_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_host", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_query_host(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/query_host");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t cost;
    try {
	XrlCmdError e = ospf_0_1_query_host(
	    xa_inputs.get_ipv4("network"),
	    xa_inputs.get_ipv4("netmask"),
	    xa_inputs.get_uint32("area_id"),
	    cost);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/query_host", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("cost", cost);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_hosts(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/list_hosts");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList networks;
    XrlAtomList netmasks;
    try {
	XrlCmdError e = ospf_0_1_list_hosts(
	    xa_inputs.get_uint32("area_id"),
	    networks,
	    netmasks);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_hosts", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("networks", networks);
	pxa_outputs->add("netmasks", netmasks);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_vlink(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/add_vlink");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_vlink(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_vlink", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_vlink(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_vlink");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_vlink(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_vlink", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_set_transmit_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_set_transmit_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_vlink_set_transmit_delay(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    xa_inputs.get_uint32("delay_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_set_transmit_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_get_transmit_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_get_transmit_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t delay_secs;
    try {
	XrlCmdError e = ospf_0_1_vlink_get_transmit_delay(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    delay_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_get_transmit_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("delay_secs", delay_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_set_retransmit_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_set_retransmit_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_vlink_set_retransmit_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_set_retransmit_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_get_retransmit_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_get_retransmit_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_vlink_get_retransmit_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_get_retransmit_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_set_hello_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_set_hello_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_vlink_set_hello_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_set_hello_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_get_hello_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_get_hello_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_vlink_get_hello_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_get_hello_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_set_router_dead_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_set_router_dead_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_vlink_set_router_dead_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_set_router_dead_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_get_router_dead_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_get_router_dead_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_vlink_get_router_dead_interval(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_get_router_dead_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_set_authentication(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_set_authentication");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_vlink_set_authentication(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    xa_inputs.get_string("type"),
	    xa_inputs.get_string("key"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_set_authentication", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_vlink_get_authentication(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/vlink_get_authentication");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string type;
    string key;
    try {
	XrlCmdError e = ospf_0_1_vlink_get_authentication(
	    xa_inputs.get_uint32("transit_area"),
	    xa_inputs.get_uint32("neighbor_id"),
	    type,
	    key);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/vlink_get_authentication", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("type", type);
	pxa_outputs->add("key", key);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_vlinks(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/list_vlinks");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList neighbor_ids;
    try {
	XrlCmdError e = ospf_0_1_list_vlinks(
	    xa_inputs.get_uint32("transit_id"),
	    neighbor_ids);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_vlinks", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("neighbor_ids", neighbor_ids);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_external_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            6, (uint32_t)xa_inputs.size(), "ospf/0.1/add_or_configure_external_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_or_configure_external_route(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("gateway"),
	    xa_inputs.get_uint32("type"),
	    xa_inputs.get_uint32("cost"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_uint32("external_route_tag"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_or_configure_external_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_external_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_external_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_external_route(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("gateway"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_external_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_query_external_route(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/query_external_route");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t type;
    uint32_t cost;
    bool multicast;
    uint32_t external_route_tag;
    try {
	XrlCmdError e = ospf_0_1_query_external_route(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_ipv4("gateway"),
	    type,
	    cost,
	    multicast,
	    external_route_tag);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/query_external_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("type", type);
	pxa_outputs->add("cost", cost);
	pxa_outputs->add("multicast", multicast);
	pxa_outputs->add("external_route_tag", external_route_tag);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_external_routes(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/list_external_routes");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList gateways;
    try {
	XrlCmdError e = ospf_0_1_list_external_routes(
	    xa_inputs.get_ipv4net("network"),
	    gateways);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_external_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("gateways", gateways);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            8, (uint32_t)xa_inputs.size(), "ospf/0.1/add_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_interface(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("if_index"),
	    xa_inputs.get_uint32("area_id"),
	    xa_inputs.get_uint32("cost"),
	    xa_inputs.get_uint32("mtu"),
	    xa_inputs.get_string("type"),
	    xa_inputs.get_bool("on_demand"),
	    xa_inputs.get_bool("passive"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_if_index(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_if_index");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_if_index(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_if_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_if_index(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_if_index");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t index;
    try {
	XrlCmdError e = ospf_0_1_interface_get_if_index(
	    xa_inputs.get_string("identifier"),
	    index);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_if_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("index", index);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_area_id(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_area_id");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_area_id(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("area_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_area_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_area_id(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_area_id");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t area_id;
    try {
	XrlCmdError e = ospf_0_1_interface_get_area_id(
	    xa_inputs.get_string("identifier"),
	    area_id);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_area_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("area_id", area_id);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_cost(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("cost"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_cost(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_cost");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t cost;
    try {
	XrlCmdError e = ospf_0_1_interface_get_cost(
	    xa_inputs.get_string("identifier"),
	    cost);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("cost", cost);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_mtu(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_mtu(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("mtu"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_mtu(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t mtu;
    try {
	XrlCmdError e = ospf_0_1_interface_get_mtu(
	    xa_inputs.get_string("identifier"),
	    mtu);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mtu", mtu);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_type(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_type");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_type(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_string("type"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_type", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_type(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_type");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string type;
    try {
	XrlCmdError e = ospf_0_1_interface_get_type(
	    xa_inputs.get_string("identifier"),
	    type);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_type", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("type", type);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_dr_priority(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_dr_priority");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_dr_priority(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("dr_priority"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_dr_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_dr_priority(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_dr_priority");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t dr_priority;
    try {
	XrlCmdError e = ospf_0_1_interface_get_dr_priority(
	    xa_inputs.get_string("identifier"),
	    dr_priority);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_dr_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("dr_priority", dr_priority);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_transit_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_transit_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_transit_delay(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("delay_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_transit_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_transit_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_transit_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t delay_secs;
    try {
	XrlCmdError e = ospf_0_1_interface_get_transit_delay(
	    xa_inputs.get_string("identifier"),
	    delay_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_transit_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("delay_secs", delay_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_retransmit_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_retransmit_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_retransmit_interval(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_retransmit_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_retransmit_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_retransmit_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_interface_get_retransmit_interval(
	    xa_inputs.get_string("identifier"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_retransmit_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_router_dead_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_router_dead_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_router_dead_interval(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_router_dead_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_router_dead_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_router_dead_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_interface_get_router_dead_interval(
	    xa_inputs.get_string("identifier"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_router_dead_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_poll_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_poll_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_poll_interval(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("interval_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_poll_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_poll_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_poll_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t interval_secs;
    try {
	XrlCmdError e = ospf_0_1_interface_get_poll_interval(
	    xa_inputs.get_string("identifier"),
	    interval_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_poll_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_authentication(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_authentication");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_authentication(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_string("type"),
	    xa_inputs.get_string("key"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_authentication", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_authentication(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_authentication");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string type;
    string key;
    try {
	XrlCmdError e = ospf_0_1_interface_get_authentication(
	    xa_inputs.get_string("identifier"),
	    type,
	    key);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_authentication", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("type", type);
	pxa_outputs->add("key", key);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_multicast_forwarding(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_multicast_forwarding");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_multicast_forwarding(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_string("type"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_multicast_forwarding", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_multicast_forwarding(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_multicast_forwarding");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string type;
    try {
	XrlCmdError e = ospf_0_1_interface_get_multicast_forwarding(
	    xa_inputs.get_string("identifier"),
	    type);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_multicast_forwarding", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("type", type);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_on_demand(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_on_demand");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_on_demand(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_bool("on_demand"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_on_demand", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_on_demand(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_on_demand");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool on_demand;
    try {
	XrlCmdError e = ospf_0_1_interface_get_on_demand(
	    xa_inputs.get_string("identifier"),
	    on_demand);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_on_demand", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("on_demand", on_demand);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_passive(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_passive");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_passive(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_bool("passive"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_passive", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_passive(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_passive");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool passive;
    try {
	XrlCmdError e = ospf_0_1_interface_get_passive(
	    xa_inputs.get_string("identifier"),
	    passive);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_passive", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("passive", passive);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_set_igmp(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_set_igmp");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_set_igmp(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_set_igmp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_igmp(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_igmp");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ospf_0_1_interface_get_igmp(
	    xa_inputs.get_string("identifier"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_igmp", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_interface(
	    xa_inputs.get_string("identifier"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_interfaces(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/list_interfaces");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList identifiers;
    try {
	XrlCmdError e = ospf_0_1_list_interfaces(
	    identifiers);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_interfaces", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("identifiers", identifiers);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_add_md5_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            7, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_add_md5_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_add_md5_key(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("key_id"),
	    xa_inputs.get_string("md5key"),
	    xa_inputs.get_string("start_receive"),
	    xa_inputs.get_string("stop_receive"),
	    xa_inputs.get_string("start_transmit"),
	    xa_inputs.get_string("stop_transmit"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_add_md5_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_get_md5_key(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_get_md5_key");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string md5key;
    string start_receive;
    string stop_receive;
    string start_transmit;
    string stop_transmit;
    try {
	XrlCmdError e = ospf_0_1_interface_get_md5_key(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("key_id"),
	    md5key,
	    start_receive,
	    stop_receive,
	    start_transmit,
	    stop_transmit);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_get_md5_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("md5key", md5key);
	pxa_outputs->add("start_receive", start_receive);
	pxa_outputs->add("stop_receive", stop_receive);
	pxa_outputs->add("start_transmit", start_transmit);
	pxa_outputs->add("stop_transmit", stop_transmit);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_delete_md5_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_delete_md5_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_interface_delete_md5_key(
	    xa_inputs.get_string("identifier"),
	    xa_inputs.get_uint32("key_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_delete_md5_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_interface_list_md5_keys(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/interface_list_md5_keys");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList key_ids;
    try {
	XrlCmdError e = ospf_0_1_interface_list_md5_keys(
	    xa_inputs.get_string("identifier"),
	    key_ids);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/interface_list_md5_keys", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("key_ids", key_ids);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_add_neighbor(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ospf/0.1/add_neighbor");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_add_neighbor(
	    xa_inputs.get_ipv4("nbr_addr"),
	    xa_inputs.get_bool("dr_eligible"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/add_neighbor", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_get_neighbor(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/get_neighbor");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool dr_eligible;
    try {
	XrlCmdError e = ospf_0_1_get_neighbor(
	    xa_inputs.get_ipv4("nbr_addr"),
	    dr_eligible);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/get_neighbor", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("dr_eligible", dr_eligible);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_delete_neighbor(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ospf/0.1/delete_neighbor");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospf_0_1_delete_neighbor(
	    xa_inputs.get_ipv4("nbr_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/delete_neighbor", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfTargetBase::handle_ospf_0_1_list_neighbors(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ospf/0.1/list_neighbors");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList nbr_addrs;
    try {
	XrlCmdError e = ospf_0_1_list_neighbors(
	    nbr_addrs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospf/0.1/list_neighbors", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("nbr_addrs", nbr_addrs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlOspfTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlOspfTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlOspfTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlOspfTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlOspfTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("ospf/0.1/set_router_id",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_router_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_router_id");
	}
	if (_cmds->add_handler("ospf/0.1/get_router_id",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_router_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_router_id");
	}
	if (_cmds->add_handler("ospf/0.1/set_lsdb_limit",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_lsdb_limit)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_lsdb_limit");
	}
	if (_cmds->add_handler("ospf/0.1/get_lsdb_limit",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_lsdb_limit)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_lsdb_limit");
	}
	if (_cmds->add_handler("ospf/0.1/set_mospf",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_mospf)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_mospf");
	}
	if (_cmds->add_handler("ospf/0.1/get_mospf",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_mospf)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_mospf");
	}
	if (_cmds->add_handler("ospf/0.1/set_interarea_mc",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_interarea_mc)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_interarea_mc");
	}
	if (_cmds->add_handler("ospf/0.1/get_interarea_mc",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_interarea_mc)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_interarea_mc");
	}
	if (_cmds->add_handler("ospf/0.1/set_overflow_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_overflow_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_overflow_interval");
	}
	if (_cmds->add_handler("ospf/0.1/get_overflow_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_overflow_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_overflow_interval");
	}
	if (_cmds->add_handler("ospf/0.1/set_flood_rate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_flood_rate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_flood_rate");
	}
	if (_cmds->add_handler("ospf/0.1/get_flood_rate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_flood_rate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_flood_rate");
	}
	if (_cmds->add_handler("ospf/0.1/set_max_rxmt_window",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_max_rxmt_window)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_max_rxmt_window");
	}
	if (_cmds->add_handler("ospf/0.1/get_max_rxmt_window",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_max_rxmt_window)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_max_rxmt_window");
	}
	if (_cmds->add_handler("ospf/0.1/set_max_dds",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_max_dds)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_max_dds");
	}
	if (_cmds->add_handler("ospf/0.1/get_max_dds",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_max_dds)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_max_dds");
	}
	if (_cmds->add_handler("ospf/0.1/set_lsa_refresh_rate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_lsa_refresh_rate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_lsa_refresh_rate");
	}
	if (_cmds->add_handler("ospf/0.1/get_lsa_refresh_rate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_lsa_refresh_rate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_lsa_refresh_rate");
	}
	if (_cmds->add_handler("ospf/0.1/set_p2p_adj_limit",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_p2p_adj_limit)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_p2p_adj_limit");
	}
	if (_cmds->add_handler("ospf/0.1/get_p2p_adj_limit",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_p2p_adj_limit)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_p2p_adj_limit");
	}
	if (_cmds->add_handler("ospf/0.1/set_random_refresh",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_set_random_refresh)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/set_random_refresh");
	}
	if (_cmds->add_handler("ospf/0.1/get_random_refresh",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_random_refresh)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_random_refresh");
	}
	if (_cmds->add_handler("ospf/0.1/add_or_configure_area",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_area)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_or_configure_area");
	}
	if (_cmds->add_handler("ospf/0.1/delete_area",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_area)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_area");
	}
	if (_cmds->add_handler("ospf/0.1/query_area",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_query_area)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/query_area");
	}
	if (_cmds->add_handler("ospf/0.1/list_area_ids",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_area_ids)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_area_ids");
	}
	if (_cmds->add_handler("ospf/0.1/add_or_configure_aggregate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_aggregate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_or_configure_aggregate");
	}
	if (_cmds->add_handler("ospf/0.1/delete_aggregate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_aggregate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_aggregate");
	}
	if (_cmds->add_handler("ospf/0.1/query_aggregate",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_query_aggregate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/query_aggregate");
	}
	if (_cmds->add_handler("ospf/0.1/list_aggregates",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_aggregates)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_aggregates");
	}
	if (_cmds->add_handler("ospf/0.1/add_or_configure_host",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_host)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_or_configure_host");
	}
	if (_cmds->add_handler("ospf/0.1/delete_host",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_host)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_host");
	}
	if (_cmds->add_handler("ospf/0.1/query_host",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_query_host)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/query_host");
	}
	if (_cmds->add_handler("ospf/0.1/list_hosts",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_hosts)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_hosts");
	}
	if (_cmds->add_handler("ospf/0.1/add_vlink",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_vlink)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_vlink");
	}
	if (_cmds->add_handler("ospf/0.1/delete_vlink",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_vlink)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_vlink");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_set_transmit_delay",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_set_transmit_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_set_transmit_delay");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_get_transmit_delay",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_get_transmit_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_get_transmit_delay");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_set_retransmit_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_set_retransmit_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_set_retransmit_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_get_retransmit_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_get_retransmit_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_get_retransmit_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_set_hello_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_set_hello_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_set_hello_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_get_hello_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_get_hello_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_get_hello_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_set_router_dead_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_set_router_dead_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_set_router_dead_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_get_router_dead_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_get_router_dead_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_get_router_dead_interval");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_set_authentication",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_set_authentication)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_set_authentication");
	}
	if (_cmds->add_handler("ospf/0.1/vlink_get_authentication",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_vlink_get_authentication)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/vlink_get_authentication");
	}
	if (_cmds->add_handler("ospf/0.1/list_vlinks",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_vlinks)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_vlinks");
	}
	if (_cmds->add_handler("ospf/0.1/add_or_configure_external_route",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_or_configure_external_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_or_configure_external_route");
	}
	if (_cmds->add_handler("ospf/0.1/delete_external_route",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_external_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_external_route");
	}
	if (_cmds->add_handler("ospf/0.1/query_external_route",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_query_external_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/query_external_route");
	}
	if (_cmds->add_handler("ospf/0.1/list_external_routes",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_external_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_external_routes");
	}
	if (_cmds->add_handler("ospf/0.1/add_interface",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_interface");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_if_index",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_if_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_if_index");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_if_index",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_if_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_if_index");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_area_id",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_area_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_area_id");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_area_id",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_area_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_area_id");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_cost",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_cost");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_cost",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_cost");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_mtu",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_mtu");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_mtu",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_mtu");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_type",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_type)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_type");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_type",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_type)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_type");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_dr_priority",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_dr_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_dr_priority");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_dr_priority",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_dr_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_dr_priority");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_transit_delay",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_transit_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_transit_delay");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_transit_delay",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_transit_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_transit_delay");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_retransmit_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_retransmit_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_retransmit_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_retransmit_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_retransmit_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_retransmit_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_router_dead_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_router_dead_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_router_dead_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_router_dead_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_router_dead_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_router_dead_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_poll_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_poll_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_poll_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_poll_interval",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_poll_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_poll_interval");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_authentication",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_authentication)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_authentication");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_authentication",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_authentication)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_authentication");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_multicast_forwarding",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_multicast_forwarding)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_multicast_forwarding");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_multicast_forwarding",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_multicast_forwarding)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_multicast_forwarding");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_on_demand",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_on_demand)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_on_demand");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_on_demand",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_on_demand)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_on_demand");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_passive",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_passive)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_passive");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_passive",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_passive)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_passive");
	}
	if (_cmds->add_handler("ospf/0.1/interface_set_igmp",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_set_igmp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_set_igmp");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_igmp",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_igmp)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_igmp");
	}
	if (_cmds->add_handler("ospf/0.1/delete_interface",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_interface");
	}
	if (_cmds->add_handler("ospf/0.1/list_interfaces",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_interfaces)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_interfaces");
	}
	if (_cmds->add_handler("ospf/0.1/interface_add_md5_key",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_add_md5_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_add_md5_key");
	}
	if (_cmds->add_handler("ospf/0.1/interface_get_md5_key",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_get_md5_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_get_md5_key");
	}
	if (_cmds->add_handler("ospf/0.1/interface_delete_md5_key",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_delete_md5_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_delete_md5_key");
	}
	if (_cmds->add_handler("ospf/0.1/interface_list_md5_keys",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_interface_list_md5_keys)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/interface_list_md5_keys");
	}
	if (_cmds->add_handler("ospf/0.1/add_neighbor",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_add_neighbor)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/add_neighbor");
	}
	if (_cmds->add_handler("ospf/0.1/get_neighbor",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_get_neighbor)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/get_neighbor");
	}
	if (_cmds->add_handler("ospf/0.1/delete_neighbor",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_delete_neighbor)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/delete_neighbor");
	}
	if (_cmds->add_handler("ospf/0.1/list_neighbors",
	    callback(this, &XrlOspfTargetBase::handle_ospf_0_1_list_neighbors)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospf", "ospf/0.1/list_neighbors");
	}
	_cmds->finalize();
}

void
XrlOspfTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("ospf/0.1/set_router_id");
	_cmds->remove_handler("ospf/0.1/get_router_id");
	_cmds->remove_handler("ospf/0.1/set_lsdb_limit");
	_cmds->remove_handler("ospf/0.1/get_lsdb_limit");
	_cmds->remove_handler("ospf/0.1/set_mospf");
	_cmds->remove_handler("ospf/0.1/get_mospf");
	_cmds->remove_handler("ospf/0.1/set_interarea_mc");
	_cmds->remove_handler("ospf/0.1/get_interarea_mc");
	_cmds->remove_handler("ospf/0.1/set_overflow_interval");
	_cmds->remove_handler("ospf/0.1/get_overflow_interval");
	_cmds->remove_handler("ospf/0.1/set_flood_rate");
	_cmds->remove_handler("ospf/0.1/get_flood_rate");
	_cmds->remove_handler("ospf/0.1/set_max_rxmt_window");
	_cmds->remove_handler("ospf/0.1/get_max_rxmt_window");
	_cmds->remove_handler("ospf/0.1/set_max_dds");
	_cmds->remove_handler("ospf/0.1/get_max_dds");
	_cmds->remove_handler("ospf/0.1/set_lsa_refresh_rate");
	_cmds->remove_handler("ospf/0.1/get_lsa_refresh_rate");
	_cmds->remove_handler("ospf/0.1/set_p2p_adj_limit");
	_cmds->remove_handler("ospf/0.1/get_p2p_adj_limit");
	_cmds->remove_handler("ospf/0.1/set_random_refresh");
	_cmds->remove_handler("ospf/0.1/get_random_refresh");
	_cmds->remove_handler("ospf/0.1/add_or_configure_area");
	_cmds->remove_handler("ospf/0.1/delete_area");
	_cmds->remove_handler("ospf/0.1/query_area");
	_cmds->remove_handler("ospf/0.1/list_area_ids");
	_cmds->remove_handler("ospf/0.1/add_or_configure_aggregate");
	_cmds->remove_handler("ospf/0.1/delete_aggregate");
	_cmds->remove_handler("ospf/0.1/query_aggregate");
	_cmds->remove_handler("ospf/0.1/list_aggregates");
	_cmds->remove_handler("ospf/0.1/add_or_configure_host");
	_cmds->remove_handler("ospf/0.1/delete_host");
	_cmds->remove_handler("ospf/0.1/query_host");
	_cmds->remove_handler("ospf/0.1/list_hosts");
	_cmds->remove_handler("ospf/0.1/add_vlink");
	_cmds->remove_handler("ospf/0.1/delete_vlink");
	_cmds->remove_handler("ospf/0.1/vlink_set_transmit_delay");
	_cmds->remove_handler("ospf/0.1/vlink_get_transmit_delay");
	_cmds->remove_handler("ospf/0.1/vlink_set_retransmit_interval");
	_cmds->remove_handler("ospf/0.1/vlink_get_retransmit_interval");
	_cmds->remove_handler("ospf/0.1/vlink_set_hello_interval");
	_cmds->remove_handler("ospf/0.1/vlink_get_hello_interval");
	_cmds->remove_handler("ospf/0.1/vlink_set_router_dead_interval");
	_cmds->remove_handler("ospf/0.1/vlink_get_router_dead_interval");
	_cmds->remove_handler("ospf/0.1/vlink_set_authentication");
	_cmds->remove_handler("ospf/0.1/vlink_get_authentication");
	_cmds->remove_handler("ospf/0.1/list_vlinks");
	_cmds->remove_handler("ospf/0.1/add_or_configure_external_route");
	_cmds->remove_handler("ospf/0.1/delete_external_route");
	_cmds->remove_handler("ospf/0.1/query_external_route");
	_cmds->remove_handler("ospf/0.1/list_external_routes");
	_cmds->remove_handler("ospf/0.1/add_interface");
	_cmds->remove_handler("ospf/0.1/interface_set_if_index");
	_cmds->remove_handler("ospf/0.1/interface_get_if_index");
	_cmds->remove_handler("ospf/0.1/interface_set_area_id");
	_cmds->remove_handler("ospf/0.1/interface_get_area_id");
	_cmds->remove_handler("ospf/0.1/interface_set_cost");
	_cmds->remove_handler("ospf/0.1/interface_get_cost");
	_cmds->remove_handler("ospf/0.1/interface_set_mtu");
	_cmds->remove_handler("ospf/0.1/interface_get_mtu");
	_cmds->remove_handler("ospf/0.1/interface_set_type");
	_cmds->remove_handler("ospf/0.1/interface_get_type");
	_cmds->remove_handler("ospf/0.1/interface_set_dr_priority");
	_cmds->remove_handler("ospf/0.1/interface_get_dr_priority");
	_cmds->remove_handler("ospf/0.1/interface_set_transit_delay");
	_cmds->remove_handler("ospf/0.1/interface_get_transit_delay");
	_cmds->remove_handler("ospf/0.1/interface_set_retransmit_interval");
	_cmds->remove_handler("ospf/0.1/interface_get_retransmit_interval");
	_cmds->remove_handler("ospf/0.1/interface_set_router_dead_interval");
	_cmds->remove_handler("ospf/0.1/interface_get_router_dead_interval");
	_cmds->remove_handler("ospf/0.1/interface_set_poll_interval");
	_cmds->remove_handler("ospf/0.1/interface_get_poll_interval");
	_cmds->remove_handler("ospf/0.1/interface_set_authentication");
	_cmds->remove_handler("ospf/0.1/interface_get_authentication");
	_cmds->remove_handler("ospf/0.1/interface_set_multicast_forwarding");
	_cmds->remove_handler("ospf/0.1/interface_get_multicast_forwarding");
	_cmds->remove_handler("ospf/0.1/interface_set_on_demand");
	_cmds->remove_handler("ospf/0.1/interface_get_on_demand");
	_cmds->remove_handler("ospf/0.1/interface_set_passive");
	_cmds->remove_handler("ospf/0.1/interface_get_passive");
	_cmds->remove_handler("ospf/0.1/interface_set_igmp");
	_cmds->remove_handler("ospf/0.1/interface_get_igmp");
	_cmds->remove_handler("ospf/0.1/delete_interface");
	_cmds->remove_handler("ospf/0.1/list_interfaces");
	_cmds->remove_handler("ospf/0.1/interface_add_md5_key");
	_cmds->remove_handler("ospf/0.1/interface_get_md5_key");
	_cmds->remove_handler("ospf/0.1/interface_delete_md5_key");
	_cmds->remove_handler("ospf/0.1/interface_list_md5_keys");
	_cmds->remove_handler("ospf/0.1/add_neighbor");
	_cmds->remove_handler("ospf/0.1/get_neighbor");
	_cmds->remove_handler("ospf/0.1/delete_neighbor");
	_cmds->remove_handler("ospf/0.1/list_neighbors");
}
