/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/fea_ifmgr_mirror_base.cc,v 1.9 2004/06/10 22:42:10 hodson Exp $"


#include "fea_ifmgr_mirror_base.hh"


XrlFeaIfmgrMirrorTargetBase::XrlFeaIfmgrMirrorTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlFeaIfmgrMirrorTargetBase::~XrlFeaIfmgrMirrorTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlFeaIfmgrMirrorTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_add(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_add");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_add(
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_add", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_remove(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_remove");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_remove(
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_remove", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_set_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_set_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_set_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_mtu(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_set_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_set_mtu(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_uint32("mtu_bytes"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_set_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_mac(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_set_mac");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_set_mac(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_mac("mac"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_set_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_pif_index(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/interface_set_pif_index");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_interface_set_pif_index(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_uint32("index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/interface_set_pif_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_add(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_add");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_add(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_add", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_remove(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_remove");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_remove(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_remove", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_multicast_capable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_multicast_capable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_multicast_capable(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("capable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_multicast_capable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_broadcast_capable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_broadcast_capable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_broadcast_capable(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("capable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_broadcast_capable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_p2p_capable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_p2p_capable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_p2p_capable(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("capable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_p2p_capable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_loopback(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_loopback");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_loopback(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_loopback", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_pif_index(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/vif_set_pif_index");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_vif_set_pif_index(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("index"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/vif_set_pif_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_add(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_add");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_add(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_add", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_remove(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_remove");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_remove(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_remove", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_prefix(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_prefix");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_prefix(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_prefix", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_multicast_capable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_multicast_capable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_multicast_capable(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("capable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_multicast_capable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_loopback(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_loopback");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_loopback(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_loopback", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_broadcast(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_broadcast");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_broadcast(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_ipv4("oaddr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_broadcast", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_endpoint(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv4_set_endpoint");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv4_set_endpoint(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_ipv4("oaddr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv4_set_endpoint", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_add(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_add");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_add(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_add", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_remove(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_remove");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_remove(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_remove", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_prefix(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_set_prefix");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_set_prefix(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_set_prefix", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_set_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_set_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_set_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_loopback(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_set_loopback");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_set_loopback(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_bool("loopback"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_set_loopback", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_multicast_capable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_set_multicast_capable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_set_multicast_capable(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_bool("capable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_set_multicast_capable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_endpoint(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/ipv6_set_endpoint");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_ipv6_set_endpoint(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_ipv6("oaddr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/ipv6_set_endpoint", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_hint_tree_complete(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/hint_tree_complete");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_hint_tree_complete();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/hint_tree_complete", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_hint_updates_made(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fea_ifmgr_mirror/0.1/hint_updates_made");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_ifmgr_mirror_0_1_hint_updates_made();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_ifmgr_mirror/0.1/hint_updates_made", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

void
XrlFeaIfmgrMirrorTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_add",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_add)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_add");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_remove",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_remove)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_remove");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_set_enabled",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_set_enabled");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_set_mtu",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_set_mtu");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_set_mac",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_set_mac");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/interface_set_pif_index",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_interface_set_pif_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/interface_set_pif_index");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_add",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_add)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_add");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_remove",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_remove)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_remove");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_enabled",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_enabled");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_multicast_capable",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_multicast_capable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_multicast_capable");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_broadcast_capable",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_broadcast_capable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_broadcast_capable");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_p2p_capable",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_p2p_capable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_p2p_capable");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_loopback",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_loopback)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_loopback");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/vif_set_pif_index",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_vif_set_pif_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/vif_set_pif_index");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_add",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_add)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_add");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_remove",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_remove)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_remove");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_prefix",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_prefix)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_prefix");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_enabled",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_enabled");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_multicast_capable",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_multicast_capable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_multicast_capable");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_loopback",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_loopback)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_loopback");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_broadcast",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_broadcast)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_broadcast");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv4_set_endpoint",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv4_set_endpoint)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv4_set_endpoint");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_add",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_add)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_add");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_remove",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_remove)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_remove");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_set_prefix",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_prefix)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_set_prefix");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_set_enabled",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_set_enabled");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_set_loopback",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_loopback)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_set_loopback");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_set_multicast_capable",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_multicast_capable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_set_multicast_capable");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/ipv6_set_endpoint",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_ipv6_set_endpoint)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/ipv6_set_endpoint");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/hint_tree_complete",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_hint_tree_complete)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/hint_tree_complete");
	}
	if (_cmds->add_handler("fea_ifmgr_mirror/0.1/hint_updates_made",
	    callback(this, &XrlFeaIfmgrMirrorTargetBase::handle_fea_ifmgr_mirror_0_1_hint_updates_made)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea_ifmgr_mirror", "fea_ifmgr_mirror/0.1/hint_updates_made");
	}
	_cmds->finalize();
}

void
XrlFeaIfmgrMirrorTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_add");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_remove");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_set_enabled");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_set_mtu");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_set_mac");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/interface_set_pif_index");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_add");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_remove");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_enabled");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_multicast_capable");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_broadcast_capable");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_p2p_capable");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_loopback");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/vif_set_pif_index");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_add");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_remove");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_prefix");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_enabled");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_multicast_capable");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_loopback");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_broadcast");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv4_set_endpoint");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_add");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_remove");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_set_prefix");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_set_enabled");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_set_loopback");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_set_multicast_capable");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/ipv6_set_endpoint");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/hint_tree_complete");
	_cmds->remove_handler("fea_ifmgr_mirror/0.1/hint_updates_made");
}
