/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 *
 * $XORP: xorp/xrl/targets/fea_base.hh,v 1.36 2004/06/10 22:42:10 hodson Exp $
 */


#ifndef __XRL_INTERFACES_FEA_BASE_HH__
#define __XRL_INTERFACES_FEA_BASE_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XrlFeaTarget"

#include "libxorp/xlog.h"
#include "libxipc/xrl_cmd_map.hh"

class XrlFeaTargetBase {
protected:
    XrlCmdMap* _cmds;

public:
    /**
     * Constructor.
     *
     * @param cmds an XrlCmdMap that the commands associated with the target
     *		   should be added to.  This is typically the XrlRouter
     *		   associated with the target.
     */
    XrlFeaTargetBase(XrlCmdMap* cmds = 0);

    /**
     * Destructor.
     *
     * Dissociates instance commands from command map.
     */
    virtual ~XrlFeaTargetBase();

    /**
     * Set command map.
     *
     * @param cmds pointer to command map to associate commands with.  This
     * argument is typically a pointer to the XrlRouter associated with the
     * target.
     *
     * @return true on success, false if cmds is null or a command map has
     * already been supplied.
     */
    bool set_command_map(XrlCmdMap* cmds);

    /**
     * Get Xrl instance name associated with command map.
     */
    inline const string& name() const { return _cmds->name(); }

    /**
     * Get version string of instance.
     */
    inline const char* version() const { return "fea/0.0"; }

protected:

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get name of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_target_name(
	// Output values,
	string&	name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get version string from Xrl Target
     */
    virtual XrlCmdError common_0_1_get_version(
	// Output values,
	string&	version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get status of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t&	status,
	string&	reason) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Request clean shutdown of Xrl Target
     */
    virtual XrlCmdError common_0_1_shutdown() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add a FIB client.
     *
     *  @param target_name the target name of the FIB client to add.
     */
    virtual XrlCmdError fea_fib_0_1_add_fib_client4(
	// Input values,
	const string&	target_name) = 0;

    virtual XrlCmdError fea_fib_0_1_add_fib_client6(
	// Input values,
	const string&	target_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete a FIB client.
     *
     *  @param target_name the target name of the FIB client to delete.
     */
    virtual XrlCmdError fea_fib_0_1_delete_fib_client4(
	// Input values,
	const string&	target_name) = 0;

    virtual XrlCmdError fea_fib_0_1_delete_fib_client6(
	// Input values,
	const string&	target_name) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_interface_names(
	// Output values,
	XrlAtomList&	ifnames) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_names(
	// Input values,
	const string&	ifname,
	// Output values,
	XrlAtomList&	vifs) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_flags(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	bool&	enabled,
	bool&	broadcast,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_pif_index(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	uint32_t&	pif_index) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_addresses4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	XrlAtomList&	addresses) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_addresses6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	XrlAtomList&	addresses) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_address_flags4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	bool&	enabled,
	bool&	broadcast,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_address_flags6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	bool&	enabled,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_interface_enabled(
	// Input values,
	const string&	ifname,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_mac(
	// Input values,
	const string&	ifname,
	// Output values,
	Mac&	mac) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_mtu(
	// Input values,
	const string&	ifname,
	// Output values,
	uint32_t&	mtu) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_vif_enabled(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_prefix4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_broadcast4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	IPv4&	broadcast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_endpoint4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	IPv4&	endpoint) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_prefix6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_endpoint6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	IPv6&	endpoint) = 0;

    virtual XrlCmdError ifmgr_0_1_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    virtual XrlCmdError ifmgr_0_1_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    virtual XrlCmdError ifmgr_0_1_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    virtual XrlCmdError ifmgr_0_1_create_interface(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname) = 0;

    virtual XrlCmdError ifmgr_0_1_delete_interface(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Implicitly configure an interface within the FEA by using information
     *  from the underlying system.
     *
     *  @param tid the transaction ID.
     *
     *  @param ifname the name of the interface to configure.
     */
    virtual XrlCmdError ifmgr_0_1_configure_interface_from_system(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname) = 0;

    virtual XrlCmdError ifmgr_0_1_set_interface_enabled(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_set_mac(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const Mac&	mac) = 0;

    virtual XrlCmdError ifmgr_0_1_set_mtu(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const uint32_t&	mtu) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Create a vif
     *
     *  @param ifname the name of the physical interface associated with the
     *  new vif.
     *
     *  @param vif name for new vif, must be unique across all the vifs in the
     *  system.
     */
    virtual XrlCmdError ifmgr_0_1_create_vif(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif) = 0;

    virtual XrlCmdError ifmgr_0_1_delete_vif(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif) = 0;

    virtual XrlCmdError ifmgr_0_1_set_vif_enabled(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_create_address4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address) = 0;

    virtual XrlCmdError ifmgr_0_1_delete_address4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address) = 0;

    virtual XrlCmdError ifmgr_0_1_set_address_enabled4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_address_enabled4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_set_prefix4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_set_broadcast4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	broadcast) = 0;

    virtual XrlCmdError ifmgr_0_1_set_endpoint4(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	const IPv4&	endpoint) = 0;

    virtual XrlCmdError ifmgr_0_1_create_address6(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address) = 0;

    virtual XrlCmdError ifmgr_0_1_delete_address6(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address) = 0;

    virtual XrlCmdError ifmgr_0_1_set_address_enabled6(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_configured_address_enabled6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_set_prefix6(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_set_endpoint6(
	// Input values,
	const uint32_t&	tid,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	const IPv6&	endpoint) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Register network interface observer for configured interfaces.
     *
     *  @param clientname name of xrl entity supporting fea_ifmgr_client.xif
     *  methods.
     */
    virtual XrlCmdError ifmgr_0_1_register_client(
	// Input values,
	const string&	clientname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Unregister network interface observer for configured interfaces. This
     *  method is not strictly necessary, the fea will remove the interface
     *  observer from its list of known observers if interface update XRLs
     *  fail.
     */
    virtual XrlCmdError ifmgr_0_1_unregister_client(
	// Input values,
	const string&	clientname) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_interface_names(
	// Output values,
	XrlAtomList&	ifnames) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_names(
	// Input values,
	const string&	ifname,
	// Output values,
	XrlAtomList&	vifs) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_flags(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	bool&	enabled,
	bool&	broadcast,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_pif_index(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	uint32_t&	pif_index) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_addresses4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	XrlAtomList&	addresses) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_address_flags4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	bool&	enabled,
	bool&	broadcast,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_addresses6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	XrlAtomList&	addresses) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_address_flags6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	bool&	enabled,
	bool&	loopback,
	bool&	point_to_point,
	bool&	multicast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_interface_enabled(
	// Input values,
	const string&	ifname,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_mac(
	// Input values,
	const string&	ifname,
	// Output values,
	Mac&	mac) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_mtu(
	// Input values,
	const string&	ifname,
	// Output values,
	uint32_t&	mtu) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_vif_enabled(
	// Input values,
	const string&	ifname,
	const string&	vif,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_prefix4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_broadcast4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	IPv4&	broadcast) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_endpoint4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	IPv4&	endpoint) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_prefix6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	uint32_t&	prefix_len) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_endpoint6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	IPv6&	endpoint) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_address_enabled4(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv4&	address,
	// Output values,
	bool&	enabled) = 0;

    virtual XrlCmdError ifmgr_0_1_get_system_address_enabled6(
	// Input values,
	const string&	ifname,
	const string&	vif,
	const IPv6&	address,
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Register network interface observer for all system interfaces.
     *
     *  @param clientname name of xrl entity supporting fea_ifmgr_client.xif
     *  methods.
     */
    virtual XrlCmdError ifmgr_0_1_register_system_interfaces_client(
	// Input values,
	const string&	clientname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Unregister network interface observer for all system interfaces. This
     *  method is not strictly necessary, the fea will remove the interface
     *  observer from its list of known observers if interface update XRLs
     *  fail.
     */
    virtual XrlCmdError ifmgr_0_1_unregister_system_interfaces_client(
	// Input values,
	const string&	clientname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Register remote mirror of interface state.
     */
    virtual XrlCmdError ifmgr_replicator_0_1_register_ifmgr_mirror(
	// Input values,
	const string&	clientname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Register remote mirror of interface state.
     */
    virtual XrlCmdError ifmgr_replicator_0_1_unregister_ifmgr_mirror(
	// Input values,
	const string&	clientname) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start transaction.
     *
     *  @param tid the transaction ID to use for this transaction.
     */
    virtual XrlCmdError fti_0_2_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Commit transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError fti_0_2_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Abort transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError fti_0_2_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_add_entry4(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_add_entry6(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     */
    virtual XrlCmdError fti_0_2_delete_entry4(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	dst) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     */
    virtual XrlCmdError fti_0_2_delete_entry6(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	dst) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete all routing entries for all address families.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError fti_0_2_delete_all_entries(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete all routing entries for the IPv4 address family.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError fti_0_2_delete_all_entries4(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete all routing entries for the IPv6 address family.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError fti_0_2_delete_all_entries6(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Lookup a route for a destination host address.
     *
     *  @param dst the destination host address to lookup.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_lookup_route4(
	// Input values,
	const IPv4&	dst,
	// Output values,
	IPv4Net&	netmask,
	IPv4&	gateway,
	string&	ifname,
	string&	vifname,
	uint32_t&	metric,
	uint32_t&	admin_distance,
	string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Lookup a route for a destination host address.
     *
     *  @param dst the destination host address to lookup.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_lookup_route6(
	// Input values,
	const IPv6&	dst,
	// Output values,
	IPv6Net&	netmask,
	IPv6&	gateway,
	string&	ifname,
	string&	vifname,
	uint32_t&	metric,
	uint32_t&	admin_distance,
	string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Lookup a route for a destination subnet address.
     *
     *  @param dst the destination subnet address to lookup.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_lookup_entry4(
	// Input values,
	const IPv4Net&	dst,
	// Output values,
	IPv4&	gateway,
	string&	ifname,
	string&	vifname,
	uint32_t&	metric,
	uint32_t&	admin_distance,
	string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Lookup a route for a destination subnet address.
     *
     *  @param dst the destination subnet address to lookup.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError fti_0_2_lookup_entry6(
	// Input values,
	const IPv6Net&	dst,
	// Output values,
	IPv6&	gateway,
	string&	ifname,
	string&	vifname,
	uint32_t&	metric,
	uint32_t&	admin_distance,
	string&	protocol_origin) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test if the underlying system supports IPv4.
     *
     *  @param result true if the underlying system supports IPv4, otherwise
     *  false.
     */
    virtual XrlCmdError fti_0_2_have_ipv4(
	// Output values,
	bool&	result) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test if the underlying system supports IPv6.
     *
     *  @param result true if the underlying system supports IPv4, otherwise
     *  false.
     */
    virtual XrlCmdError fti_0_2_have_ipv6(
	// Output values,
	bool&	result) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test whether the IPv4 unicast forwarding engine is enabled or disabled
     *  to forward packets.
     *
     *  @param enabled if true, then the IPv4 unicast forwarding is enabled,
     *  otherwise is disabled.
     */
    virtual XrlCmdError fti_0_2_get_unicast_forwarding_enabled4(
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test whether the IPv6 unicast forwarding engine is enabled or disabled
     *  to forward packets.
     *
     *  @param enabled if true, then the IPv6 unicast forwarding is enabled,
     *  otherwise is disabled.
     */
    virtual XrlCmdError fti_0_2_get_unicast_forwarding_enabled6(
	// Output values,
	bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the IPv4 unicast forwarding engine to enable or disable forwarding
     *  of packets.
     *
     *  @param enabled if true, then enable IPv4 unicast forwarding, otherwise
     *  disable it.
     */
    virtual XrlCmdError fti_0_2_set_unicast_forwarding_enabled4(
	// Input values,
	const bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set the IPv6 unicast forwarding engine to enable or disable forwarding
     *  of packets.
     *
     *  @param enabled if true, then enable IPv6 unicast forwarding, otherwise
     *  disable it.
     */
    virtual XrlCmdError fti_0_2_set_unicast_forwarding_enabled6(
	// Input values,
	const bool&	enabled) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start transaction.
     *
     *  @param tid the transaction ID to use for this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Commit transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Abort transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst destination network.
     *
     *  @param nh nexthop router address.
     *
     *  @param ifname interface name associated with nexthop.
     *
     *  @param vifname virtual interface name with nexthop.
     *
     *  @param metric origin routing protocol metric for route.
     *
     *  @param ad administrative distance of origin routing protocol.
     *
     *  @param cookie value set be requestor to identify redistribution source.
     *  Typical value is the originating protocol name.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError redist_transaction4_0_1_add_route(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	nh,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	ad,
	const string&	cookie,
	const string&	protocol_origin) = 0;

    virtual XrlCmdError redist_transaction4_0_1_delete_route(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	network,
	const string&	cookie) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start transaction.
     *
     *  @param tid the transaction ID to use for this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Commit transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Abort transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst destination network.
     *
     *  @param nh nexthop router address.
     *
     *  @param ifname interface name associated with nexthop.
     *
     *  @param vifname virtual interface name with nexthop.
     *
     *  @param metric origin routing protocol metric for route.
     *
     *  @param ad administrative distance of origin routing protocol.
     *
     *  @param cookie value set be requestor to identify redistribution source.
     *  Typical value is the originating protocol name.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError redist_transaction6_0_1_add_route(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	nh,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	ad,
	const string&	cookie,
	const string&	protocol_origin) = 0;

    virtual XrlCmdError redist_transaction6_0_1_delete_route(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	network,
	const string&	cookie) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Send a packet on a raw socket.
     */
    virtual XrlCmdError raw_packet_0_1_send4(
	// Input values,
	const IPv4&	src_address,
	const IPv4&	dst_address,
	const string&	vif_name,
	const uint32_t&	proto,
	const uint32_t&	ttl,
	const uint32_t&	tos,
	const vector<uint8_t>&	options,
	const vector<uint8_t>&	payload) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Send raw packet. Checksum is computed and applied before transmission.
     *  All the fields within the IPv4 header must be in network order.
     */
    virtual XrlCmdError raw_packet_0_1_send_raw4(
	// Input values,
	const string&	vif_name,
	const vector<uint8_t>&	packet) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Register to receive packets. The receiver is expected to support
     *  raw_socket_client/0.1 interface.
     */
    virtual XrlCmdError raw_packet_0_1_register_vif_receiver(
	// Input values,
	const string&	router_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	proto) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Unregister stop receiving packets.
     *
     *  @param proto Protocol number that the receiver is interested in.
     */
    virtual XrlCmdError raw_packet_0_1_unregister_vif_receiver(
	// Input values,
	const string&	router_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	proto) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Find suitable socket serving Xrl Target for a particular interface
     *  address.
     */
    virtual XrlCmdError socket4_locator_0_1_find_socket_server_for_addr(
	// Input values,
	const IPv4&	local_addr,
	// Output values,
	string&	xrl_target) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Find suitable socket serving Xrl Target for a particular interface
     *  address.
     */
    virtual XrlCmdError socket6_locator_0_1_find_socket_server_for_addr(
	// Input values,
	const IPv6&	local_addr,
	// Output values,
	string&	xrl_target) = 0;

private:
    const XrlCmdError handle_common_0_1_get_target_name(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_status(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_shutdown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fea_fib_0_1_add_fib_client4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fea_fib_0_1_add_fib_client6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fea_fib_0_1_delete_fib_client4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fea_fib_0_1_delete_fib_client6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_interface_names(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_names(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_flags(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_pif_index(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_addresses4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_addresses6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_address_flags4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_address_flags6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_interface_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_mac(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_mtu(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_vif_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_prefix4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_broadcast4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_endpoint4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_prefix6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_endpoint6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_create_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_delete_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_configure_interface_from_system(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_interface_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_mac(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_mtu(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_create_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_delete_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_vif_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_create_address4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_delete_address4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_address_enabled4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_address_enabled4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_prefix4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_broadcast4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_endpoint4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_create_address6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_delete_address6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_address_enabled6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_configured_address_enabled6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_prefix6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_set_endpoint6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_register_client(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_unregister_client(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_interface_names(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_names(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_flags(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_pif_index(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_addresses4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_address_flags4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_addresses6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_address_flags6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_interface_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_mac(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_mtu(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_vif_enabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_prefix4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_broadcast4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_endpoint4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_prefix6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_endpoint6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_address_enabled4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_get_system_address_enabled6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_register_system_interfaces_client(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_0_1_unregister_system_interfaces_client(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_replicator_0_1_register_ifmgr_mirror(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_add_entry4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_add_entry6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_delete_entry4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_delete_entry6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_delete_all_entries(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_delete_all_entries4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_delete_all_entries6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_lookup_route4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_lookup_route6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_lookup_entry4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_lookup_entry6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_have_ipv4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_have_ipv6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_get_unicast_forwarding_enabled4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_get_unicast_forwarding_enabled6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_set_unicast_forwarding_enabled4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_fti_0_2_set_unicast_forwarding_enabled6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_add_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_delete_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_add_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_delete_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_packet_0_1_send4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_packet_0_1_send_raw4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_packet_0_1_register_vif_receiver(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_raw_packet_0_1_unregister_vif_receiver(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_socket4_locator_0_1_find_socket_server_for_addr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_socket6_locator_0_1_find_socket_server_for_addr(const XrlArgs& in, XrlArgs* out);

    void add_handlers();
    void remove_handlers();
};

#endif /* __XRL_INTERFACES_FEA_BASE_HH__ */
