/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/fea_base.cc,v 1.34 2004/06/10 22:42:09 hodson Exp $"


#include "fea_base.hh"


XrlFeaTargetBase::XrlFeaTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlFeaTargetBase::~XrlFeaTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlFeaTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_fib/0.1/add_fib_client4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_add_fib_client4(
	    xa_inputs.get_string("target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/add_fib_client4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_fib/0.1/add_fib_client6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_add_fib_client6(
	    xa_inputs.get_string("target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/add_fib_client6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_fib/0.1/delete_fib_client4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_delete_fib_client4(
	    xa_inputs.get_string("target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/delete_fib_client4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fea_fib/0.1/delete_fib_client6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fea_fib_0_1_delete_fib_client6(
	    xa_inputs.get_string("target_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fea_fib/0.1/delete_fib_client6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_interface_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ifnames;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_names(
	    ifnames);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifnames", ifnames);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList vifs;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_names(
	    xa_inputs.get_string("ifname"),
	    vifs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("vifs", vifs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_flags(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_flags");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_flags(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_pif_index(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_pif_index");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t pif_index;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_pif_index(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    pif_index);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_pif_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("pif_index", pif_index);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_addresses4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_addresses4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_addresses4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_addresses6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_addresses6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_addresses6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_address_flags4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_flags4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_flags4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_address_flags6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_flags6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_flags6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_interface_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_interface_enabled(
	    xa_inputs.get_string("ifname"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_interface_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mac(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_mac");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    Mac mac;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_mac(
	    xa_inputs.get_string("ifname"),
	    mac);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mac", mac);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mtu(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t mtu;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_mtu(
	    xa_inputs.get_string("ifname"),
	    mtu);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mtu", mtu);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_vif_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_vif_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_vif_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_prefix4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_broadcast4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_broadcast4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 broadcast;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_broadcast4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    broadcast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_broadcast4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("broadcast", broadcast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_endpoint4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_endpoint4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_endpoint4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_prefix6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_endpoint6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_endpoint6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_endpoint6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ifmgr/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = ifmgr_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/create_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_interface(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_interface(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/delete_interface");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_interface(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_interface", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_configure_interface_from_system(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/configure_interface_from_system");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_configure_interface_from_system(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/configure_interface_from_system", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_interface_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_interface_enabled(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_interface_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_mac(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_mac");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_mac(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_mac("mac"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_mtu(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_mtu(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_uint32("mtu"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/create_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_vif(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/delete_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_vif(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_vif_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_vif_enabled(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_vif_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_address4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ifmgr/0.1/create_address4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_address4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_address4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_address4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ifmgr/0.1/delete_address4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_address4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_address4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_address_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_address_enabled4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_address_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_address_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_enabled4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_prefix4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_broadcast4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_broadcast4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_broadcast4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_ipv4("broadcast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_broadcast4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_endpoint4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_endpoint4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    xa_inputs.get_ipv4("endpoint"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_endpoint4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_create_address6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ifmgr/0.1/create_address6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_create_address6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/create_address6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_delete_address6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "ifmgr/0.1/delete_address6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_delete_address6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/delete_address6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_address_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_address_enabled6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_address_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_configured_address_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_configured_address_enabled6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_configured_address_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_prefix6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "ifmgr/0.1/set_endpoint6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_set_endpoint6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    xa_inputs.get_ipv6("endpoint"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/set_endpoint6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_register_client(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/register_client");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_register_client(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/register_client", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_unregister_client(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/unregister_client");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_unregister_client(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/unregister_client", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_interface_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_interface_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ifnames;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_interface_names(
	    ifnames);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_interface_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifnames", ifnames);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_names(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_names");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList vifs;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_names(
	    xa_inputs.get_string("ifname"),
	    vifs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_names", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("vifs", vifs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_flags(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_flags");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_flags(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_pif_index(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_pif_index");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t pif_index;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_pif_index(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    pif_index);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_pif_index", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("pif_index", pif_index);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_addresses4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_addresses4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_addresses4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_addresses4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_flags4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_address_flags4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool broadcast;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_address_flags4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled,
	    broadcast,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_address_flags4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("broadcast", broadcast);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_addresses6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_addresses6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList addresses;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_addresses6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    addresses);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_addresses6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("addresses", addresses);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_flags6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_address_flags6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    bool loopback;
    bool point_to_point;
    bool multicast;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_address_flags6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled,
	    loopback,
	    point_to_point,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_address_flags6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
	pxa_outputs->add("loopback", loopback);
	pxa_outputs->add("point_to_point", point_to_point);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_interface_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_interface_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_interface_enabled(
	    xa_inputs.get_string("ifname"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_interface_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_mac(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_mac");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    Mac mac;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_mac(
	    xa_inputs.get_string("ifname"),
	    mac);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_mac", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mac", mac);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_mtu(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_mtu");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t mtu;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_mtu(
	    xa_inputs.get_string("ifname"),
	    mtu);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_mtu", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("mtu", mtu);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_vif_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_vif_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_vif_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_prefix4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_prefix4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_prefix4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_prefix4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_broadcast4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_broadcast4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 broadcast;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_broadcast4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    broadcast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_broadcast4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("broadcast", broadcast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_endpoint4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_endpoint4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_endpoint4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_endpoint4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_prefix6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_prefix6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t prefix_len;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_prefix6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    prefix_len);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_prefix6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("prefix_len", prefix_len);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_endpoint6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_endpoint6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 endpoint;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_endpoint6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    endpoint);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_endpoint6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("endpoint", endpoint);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_enabled4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_address_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_address_enabled4(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv4("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_address_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_enabled6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "ifmgr/0.1/get_system_address_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = ifmgr_0_1_get_system_address_enabled6(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vif"),
	    xa_inputs.get_ipv6("address"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/get_system_address_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_register_system_interfaces_client(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/register_system_interfaces_client");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_register_system_interfaces_client(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/register_system_interfaces_client", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_0_1_unregister_system_interfaces_client(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr/0.1/unregister_system_interfaces_client");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_0_1_unregister_system_interfaces_client(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr/0.1/unregister_system_interfaces_client", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr_replicator/0.1/register_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_register_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/register_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_unregister_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/unregister_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fti/0.2/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = fti_0_2_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_add_entry4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            8, (uint32_t)xa_inputs.size(), "fti/0.2/add_entry4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_add_entry4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("gateway"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/add_entry4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_add_entry6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            8, (uint32_t)xa_inputs.size(), "fti/0.2/add_entry6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_add_entry6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("dst"),
	    xa_inputs.get_ipv6("gateway"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/add_entry6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_delete_entry4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fti/0.2/delete_entry4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_delete_entry4(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("dst"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/delete_entry4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_delete_entry6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "fti/0.2/delete_entry6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_delete_entry6(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("dst"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/delete_entry6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_delete_all_entries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/delete_all_entries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_delete_all_entries(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/delete_all_entries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_delete_all_entries4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/delete_all_entries4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_delete_all_entries4(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/delete_all_entries4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_delete_all_entries6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/delete_all_entries6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_delete_all_entries6(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/delete_all_entries6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/lookup_route4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4Net netmask;
    IPv4 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route4(
	    xa_inputs.get_ipv4("dst"),
	    netmask,
	    gateway,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("netmask", netmask);
	pxa_outputs->add("gateway", gateway);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_route6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/lookup_route6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6Net netmask;
    IPv6 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_route6(
	    xa_inputs.get_ipv6("dst"),
	    netmask,
	    gateway,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("netmask", netmask);
	pxa_outputs->add("gateway", gateway);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_entry4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/lookup_entry4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_entry4(
	    xa_inputs.get_ipv4net("dst"),
	    gateway,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_entry4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("gateway", gateway);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_lookup_entry6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/lookup_entry6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	XrlCmdError e = fti_0_2_lookup_entry6(
	    xa_inputs.get_ipv6net("dst"),
	    gateway,
	    ifname,
	    vifname,
	    metric,
	    admin_distance,
	    protocol_origin);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/lookup_entry6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("gateway", gateway);
	pxa_outputs->add("ifname", ifname);
	pxa_outputs->add("vifname", vifname);
	pxa_outputs->add("metric", metric);
	pxa_outputs->add("admin_distance", admin_distance);
	pxa_outputs->add("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_have_ipv4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fti/0.2/have_ipv4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = fti_0_2_have_ipv4(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/have_ipv4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_have_ipv6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fti/0.2/have_ipv6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = fti_0_2_have_ipv6(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/have_ipv6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fti/0.2/get_unicast_forwarding_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = fti_0_2_get_unicast_forwarding_enabled4(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/get_unicast_forwarding_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "fti/0.2/get_unicast_forwarding_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = fti_0_2_get_unicast_forwarding_enabled6(
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/get_unicast_forwarding_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/set_unicast_forwarding_enabled4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_enabled4(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_enabled4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "fti/0.2/set_unicast_forwarding_enabled6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = fti_0_2_set_unicast_forwarding_enabled6(
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "fti/0.2/set_unicast_forwarding_enabled6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "redist_transaction4/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction4_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "redist_transaction4/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "redist_transaction4/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            9, (uint32_t)xa_inputs.size(), "redist_transaction4/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_add_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("nh"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("ad"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "redist_transaction4/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction4_0_1_delete_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction4/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_start_transaction(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "redist_transaction6/0.1/start_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t tid;
    try {
	XrlCmdError e = redist_transaction6_0_1_start_transaction(
	    tid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/start_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("tid", tid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_commit_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "redist_transaction6/0.1/commit_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_commit_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/commit_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_abort_transaction(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "redist_transaction6/0.1/abort_transaction");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_abort_transaction(
	    xa_inputs.get_uint32("tid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/abort_transaction", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            9, (uint32_t)xa_inputs.size(), "redist_transaction6/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_add_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("dst"),
	    xa_inputs.get_ipv6("nh"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("ad"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "redist_transaction6/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist_transaction6_0_1_delete_route(
	    xa_inputs.get_uint32("tid"),
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist_transaction6/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet_0_1_send4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            8, (uint32_t)xa_inputs.size(), "raw_packet/0.1/send4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet_0_1_send4(
	    xa_inputs.get_ipv4("src_address"),
	    xa_inputs.get_ipv4("dst_address"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("proto"),
	    xa_inputs.get_uint32("ttl"),
	    xa_inputs.get_uint32("tos"),
	    xa_inputs.get_binary("options"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet/0.1/send4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet_0_1_send_raw4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "raw_packet/0.1/send_raw4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet_0_1_send_raw4(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_binary("packet"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet/0.1/send_raw4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet_0_1_register_vif_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "raw_packet/0.1/register_vif_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet_0_1_register_vif_receiver(
	    xa_inputs.get_string("router_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("proto"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet/0.1/register_vif_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_raw_packet_0_1_unregister_vif_receiver(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "raw_packet/0.1/unregister_vif_receiver");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet_0_1_unregister_vif_receiver(
	    xa_inputs.get_string("router_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("proto"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet/0.1/unregister_vif_receiver", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket4_locator_0_1_find_socket_server_for_addr(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "socket4_locator/0.1/find_socket_server_for_addr");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string xrl_target;
    try {
	XrlCmdError e = socket4_locator_0_1_find_socket_server_for_addr(
	    xa_inputs.get_ipv4("local_addr"),
	    xrl_target);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_locator/0.1/find_socket_server_for_addr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("xrl_target", xrl_target);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlFeaTargetBase::handle_socket6_locator_0_1_find_socket_server_for_addr(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "socket6_locator/0.1/find_socket_server_for_addr");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string xrl_target;
    try {
	XrlCmdError e = socket6_locator_0_1_find_socket_server_for_addr(
	    xa_inputs.get_ipv6("local_addr"),
	    xrl_target);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6_locator/0.1/find_socket_server_for_addr", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("xrl_target", xrl_target);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlFeaTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlFeaTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("fea_fib/0.1/add_fib_client4",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/add_fib_client4");
	}
	if (_cmds->add_handler("fea_fib/0.1/add_fib_client6",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_add_fib_client6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/add_fib_client6");
	}
	if (_cmds->add_handler("fea_fib/0.1/delete_fib_client4",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/delete_fib_client4");
	}
	if (_cmds->add_handler("fea_fib/0.1/delete_fib_client6",
	    callback(this, &XrlFeaTargetBase::handle_fea_fib_0_1_delete_fib_client6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fea_fib/0.1/delete_fib_client6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_flags",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_flags");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_pif_index",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_pif_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_pif_index");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_addresses4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_addresses4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_addresses6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_addresses6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_addresses6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_flags4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_flags4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_flags6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_flags6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_flags6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_interface_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_interface_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_interface_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_vif_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_vif_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_vif_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_prefix4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_prefix4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_broadcast4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_broadcast4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_broadcast4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_endpoint4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_endpoint4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_prefix6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_prefix6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_endpoint6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_endpoint6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_endpoint6");
	}
	if (_cmds->add_handler("ifmgr/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/start_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/commit_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/abort_transaction");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_interface",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_interface");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_interface",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_interface)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_interface");
	}
	if (_cmds->add_handler("ifmgr/0.1/configure_interface_from_system",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_configure_interface_from_system)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/configure_interface_from_system");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_interface_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_interface_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_interface_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_vif",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_vif");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_vif",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_vif");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_vif_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_vif_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_vif_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_address4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_address4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_address4");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_address4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_address4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_address4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_address_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_address_enabled4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_enabled4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_prefix4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_prefix4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_broadcast4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_broadcast4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_broadcast4");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_endpoint4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_endpoint4");
	}
	if (_cmds->add_handler("ifmgr/0.1/create_address6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_create_address6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/create_address6");
	}
	if (_cmds->add_handler("ifmgr/0.1/delete_address6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_delete_address6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/delete_address6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_address_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_address_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_address_enabled6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_configured_address_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_configured_address_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_configured_address_enabled6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_prefix6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_prefix6");
	}
	if (_cmds->add_handler("ifmgr/0.1/set_endpoint6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_set_endpoint6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/set_endpoint6");
	}
	if (_cmds->add_handler("ifmgr/0.1/register_client",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_register_client)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/register_client");
	}
	if (_cmds->add_handler("ifmgr/0.1/unregister_client",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_unregister_client)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/unregister_client");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_interface_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_interface_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_interface_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_names",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_names)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_names");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_flags",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_flags");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_pif_index",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_pif_index)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_pif_index");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_addresses4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_addresses4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_addresses4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_address_flags4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_flags4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_address_flags4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_addresses6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_addresses6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_addresses6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_address_flags6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_flags6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_address_flags6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_interface_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_interface_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_interface_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_mac",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_mac)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_mac");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_mtu",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_mtu)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_mtu");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_vif_enabled",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_vif_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_vif_enabled");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_prefix4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_prefix4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_prefix4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_broadcast4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_broadcast4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_broadcast4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_endpoint4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_endpoint4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_endpoint4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_prefix6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_prefix6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_prefix6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_endpoint6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_endpoint6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_endpoint6");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_address_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_address_enabled4");
	}
	if (_cmds->add_handler("ifmgr/0.1/get_system_address_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_get_system_address_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/get_system_address_enabled6");
	}
	if (_cmds->add_handler("ifmgr/0.1/register_system_interfaces_client",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_register_system_interfaces_client)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/register_system_interfaces_client");
	}
	if (_cmds->add_handler("ifmgr/0.1/unregister_system_interfaces_client",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_0_1_unregister_system_interfaces_client)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr/0.1/unregister_system_interfaces_client");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/register_ifmgr_mirror",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr_replicator/0.1/register_ifmgr_mirror");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror",
	    callback(this, &XrlFeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	}
	if (_cmds->add_handler("fti/0.2/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/start_transaction");
	}
	if (_cmds->add_handler("fti/0.2/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/commit_transaction");
	}
	if (_cmds->add_handler("fti/0.2/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/abort_transaction");
	}
	if (_cmds->add_handler("fti/0.2/add_entry4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_add_entry4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/add_entry4");
	}
	if (_cmds->add_handler("fti/0.2/add_entry6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_add_entry6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/add_entry6");
	}
	if (_cmds->add_handler("fti/0.2/delete_entry4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_delete_entry4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/delete_entry4");
	}
	if (_cmds->add_handler("fti/0.2/delete_entry6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_delete_entry6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/delete_entry6");
	}
	if (_cmds->add_handler("fti/0.2/delete_all_entries",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_delete_all_entries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/delete_all_entries");
	}
	if (_cmds->add_handler("fti/0.2/delete_all_entries4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_delete_all_entries4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/delete_all_entries4");
	}
	if (_cmds->add_handler("fti/0.2/delete_all_entries6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_delete_all_entries6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/delete_all_entries6");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route4");
	}
	if (_cmds->add_handler("fti/0.2/lookup_route6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_route6");
	}
	if (_cmds->add_handler("fti/0.2/lookup_entry4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_entry4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_entry4");
	}
	if (_cmds->add_handler("fti/0.2/lookup_entry6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_lookup_entry6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/lookup_entry6");
	}
	if (_cmds->add_handler("fti/0.2/have_ipv4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_have_ipv4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/have_ipv4");
	}
	if (_cmds->add_handler("fti/0.2/have_ipv6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_have_ipv6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/have_ipv6");
	}
	if (_cmds->add_handler("fti/0.2/get_unicast_forwarding_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/get_unicast_forwarding_enabled4");
	}
	if (_cmds->add_handler("fti/0.2/get_unicast_forwarding_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_get_unicast_forwarding_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/get_unicast_forwarding_enabled6");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_enabled4",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_enabled4");
	}
	if (_cmds->add_handler("fti/0.2/set_unicast_forwarding_enabled6",
	    callback(this, &XrlFeaTargetBase::handle_fti_0_2_set_unicast_forwarding_enabled6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "fti/0.2/set_unicast_forwarding_enabled6");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/add_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction4/0.1/delete_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction4_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction4/0.1/delete_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/start_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_start_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/start_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/commit_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_commit_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/commit_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/abort_transaction",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_abort_transaction)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/abort_transaction");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/add_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/add_route");
	}
	if (_cmds->add_handler("redist_transaction6/0.1/delete_route",
	    callback(this, &XrlFeaTargetBase::handle_redist_transaction6_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "redist_transaction6/0.1/delete_route");
	}
	if (_cmds->add_handler("raw_packet/0.1/send4",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet_0_1_send4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet/0.1/send4");
	}
	if (_cmds->add_handler("raw_packet/0.1/send_raw4",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet_0_1_send_raw4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet/0.1/send_raw4");
	}
	if (_cmds->add_handler("raw_packet/0.1/register_vif_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet_0_1_register_vif_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet/0.1/register_vif_receiver");
	}
	if (_cmds->add_handler("raw_packet/0.1/unregister_vif_receiver",
	    callback(this, &XrlFeaTargetBase::handle_raw_packet_0_1_unregister_vif_receiver)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "raw_packet/0.1/unregister_vif_receiver");
	}
	if (_cmds->add_handler("socket4_locator/0.1/find_socket_server_for_addr",
	    callback(this, &XrlFeaTargetBase::handle_socket4_locator_0_1_find_socket_server_for_addr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket4_locator/0.1/find_socket_server_for_addr");
	}
	if (_cmds->add_handler("socket6_locator/0.1/find_socket_server_for_addr",
	    callback(this, &XrlFeaTargetBase::handle_socket6_locator_0_1_find_socket_server_for_addr)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "fea", "socket6_locator/0.1/find_socket_server_for_addr");
	}
	_cmds->finalize();
}

void
XrlFeaTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("fea_fib/0.1/add_fib_client4");
	_cmds->remove_handler("fea_fib/0.1/add_fib_client6");
	_cmds->remove_handler("fea_fib/0.1/delete_fib_client4");
	_cmds->remove_handler("fea_fib/0.1/delete_fib_client6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_names");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_names");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_flags");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_pif_index");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_addresses4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_addresses6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_flags4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_flags6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_interface_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_configured_mac");
	_cmds->remove_handler("ifmgr/0.1/get_configured_mtu");
	_cmds->remove_handler("ifmgr/0.1/get_configured_vif_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_configured_prefix4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_broadcast4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_endpoint4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_prefix6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_endpoint6");
	_cmds->remove_handler("ifmgr/0.1/start_transaction");
	_cmds->remove_handler("ifmgr/0.1/commit_transaction");
	_cmds->remove_handler("ifmgr/0.1/abort_transaction");
	_cmds->remove_handler("ifmgr/0.1/create_interface");
	_cmds->remove_handler("ifmgr/0.1/delete_interface");
	_cmds->remove_handler("ifmgr/0.1/configure_interface_from_system");
	_cmds->remove_handler("ifmgr/0.1/set_interface_enabled");
	_cmds->remove_handler("ifmgr/0.1/set_mac");
	_cmds->remove_handler("ifmgr/0.1/set_mtu");
	_cmds->remove_handler("ifmgr/0.1/create_vif");
	_cmds->remove_handler("ifmgr/0.1/delete_vif");
	_cmds->remove_handler("ifmgr/0.1/set_vif_enabled");
	_cmds->remove_handler("ifmgr/0.1/create_address4");
	_cmds->remove_handler("ifmgr/0.1/delete_address4");
	_cmds->remove_handler("ifmgr/0.1/set_address_enabled4");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_enabled4");
	_cmds->remove_handler("ifmgr/0.1/set_prefix4");
	_cmds->remove_handler("ifmgr/0.1/set_broadcast4");
	_cmds->remove_handler("ifmgr/0.1/set_endpoint4");
	_cmds->remove_handler("ifmgr/0.1/create_address6");
	_cmds->remove_handler("ifmgr/0.1/delete_address6");
	_cmds->remove_handler("ifmgr/0.1/set_address_enabled6");
	_cmds->remove_handler("ifmgr/0.1/get_configured_address_enabled6");
	_cmds->remove_handler("ifmgr/0.1/set_prefix6");
	_cmds->remove_handler("ifmgr/0.1/set_endpoint6");
	_cmds->remove_handler("ifmgr/0.1/register_client");
	_cmds->remove_handler("ifmgr/0.1/unregister_client");
	_cmds->remove_handler("ifmgr/0.1/get_system_interface_names");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_names");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_flags");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_pif_index");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_addresses4");
	_cmds->remove_handler("ifmgr/0.1/get_system_address_flags4");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_addresses6");
	_cmds->remove_handler("ifmgr/0.1/get_system_address_flags6");
	_cmds->remove_handler("ifmgr/0.1/get_system_interface_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_system_mac");
	_cmds->remove_handler("ifmgr/0.1/get_system_mtu");
	_cmds->remove_handler("ifmgr/0.1/get_system_vif_enabled");
	_cmds->remove_handler("ifmgr/0.1/get_system_prefix4");
	_cmds->remove_handler("ifmgr/0.1/get_system_broadcast4");
	_cmds->remove_handler("ifmgr/0.1/get_system_endpoint4");
	_cmds->remove_handler("ifmgr/0.1/get_system_prefix6");
	_cmds->remove_handler("ifmgr/0.1/get_system_endpoint6");
	_cmds->remove_handler("ifmgr/0.1/get_system_address_enabled4");
	_cmds->remove_handler("ifmgr/0.1/get_system_address_enabled6");
	_cmds->remove_handler("ifmgr/0.1/register_system_interfaces_client");
	_cmds->remove_handler("ifmgr/0.1/unregister_system_interfaces_client");
	_cmds->remove_handler("ifmgr_replicator/0.1/register_ifmgr_mirror");
	_cmds->remove_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	_cmds->remove_handler("fti/0.2/start_transaction");
	_cmds->remove_handler("fti/0.2/commit_transaction");
	_cmds->remove_handler("fti/0.2/abort_transaction");
	_cmds->remove_handler("fti/0.2/add_entry4");
	_cmds->remove_handler("fti/0.2/add_entry6");
	_cmds->remove_handler("fti/0.2/delete_entry4");
	_cmds->remove_handler("fti/0.2/delete_entry6");
	_cmds->remove_handler("fti/0.2/delete_all_entries");
	_cmds->remove_handler("fti/0.2/delete_all_entries4");
	_cmds->remove_handler("fti/0.2/delete_all_entries6");
	_cmds->remove_handler("fti/0.2/lookup_route4");
	_cmds->remove_handler("fti/0.2/lookup_route6");
	_cmds->remove_handler("fti/0.2/lookup_entry4");
	_cmds->remove_handler("fti/0.2/lookup_entry6");
	_cmds->remove_handler("fti/0.2/have_ipv4");
	_cmds->remove_handler("fti/0.2/have_ipv6");
	_cmds->remove_handler("fti/0.2/get_unicast_forwarding_enabled4");
	_cmds->remove_handler("fti/0.2/get_unicast_forwarding_enabled6");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_enabled4");
	_cmds->remove_handler("fti/0.2/set_unicast_forwarding_enabled6");
	_cmds->remove_handler("redist_transaction4/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction4/0.1/add_route");
	_cmds->remove_handler("redist_transaction4/0.1/delete_route");
	_cmds->remove_handler("redist_transaction6/0.1/start_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/commit_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/abort_transaction");
	_cmds->remove_handler("redist_transaction6/0.1/add_route");
	_cmds->remove_handler("redist_transaction6/0.1/delete_route");
	_cmds->remove_handler("raw_packet/0.1/send4");
	_cmds->remove_handler("raw_packet/0.1/send_raw4");
	_cmds->remove_handler("raw_packet/0.1/register_vif_receiver");
	_cmds->remove_handler("raw_packet/0.1/unregister_vif_receiver");
	_cmds->remove_handler("socket4_locator/0.1/find_socket_server_for_addr");
	_cmds->remove_handler("socket6_locator/0.1/find_socket_server_for_addr");
}
