/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/mld6igmp_xif.hh,v 1.14 2004/06/10 22:42:02 hodson Exp $
 */

#ifndef __XRL_INTERFACES_MLD6IGMP_XIF_HH__
#define __XRL_INTERFACES_MLD6IGMP_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifMld6igmp"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlMld6igmpV0p1Client {
public:
    XrlMld6igmpV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlMld6igmpV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableVifCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop a MLD6IGMP vif interface.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to enable/disable/start/stop.
     *
     *  @param enable if true, then enable the vif, otherwise disable it.
     */
    bool send_enable_vif(
	const char*	target_name,
	const string&	vif_name,
	const bool&	enable,
	const EnableVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartVifCB;

    bool send_start_vif(
	const char*	target_name,
	const string&	vif_name,
	const StartVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopVifCB;

    bool send_stop_vif(
	const char*	target_name,
	const string&	vif_name,
	const StopVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableAllVifsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop all MLD6IGMP vif interfaces.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the vifs, otherwise disable them.
     */
    bool send_enable_all_vifs(
	const char*	target_name,
	const bool&	enable,
	const EnableAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartAllVifsCB;

    bool send_start_all_vifs(
	const char*	target_name,
	const StartAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopAllVifsCB;

    bool send_stop_all_vifs(
	const char*	target_name,
	const StopAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableMld6IgmpCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the MLD6IGMP protocol.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the MLD6IGMP protocol, otherwise
     *  disable it.
     */
    bool send_enable_mld6igmp(
	const char*	target_name,
	const bool&	enable,
	const EnableMld6IgmpCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartMld6IgmpCB;

    bool send_start_mld6igmp(
	const char*	target_name,
	const StartMld6IgmpCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopMld6IgmpCB;

    bool send_stop_mld6igmp(
	const char*	target_name,
	const StopMld6IgmpCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableCliCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the MLD6IGMP CLI access.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the MLD6IGMP CLI access, otherwise
     *  disable it.
     */
    bool send_enable_cli(
	const char*	target_name,
	const bool&	enable,
	const EnableCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartCliCB;

    bool send_start_cli(
	const char*	target_name,
	const StartCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopCliCB;

    bool send_stop_cli(
	const char*	target_name,
	const StopCliCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetVifProtoVersionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Configure MLD6IGMP interface-related metrics. The 'set_foo' XRLs set
     *  the particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to configure.
     */
    bool send_get_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const GetVifProtoVersionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetVifProtoVersionCB;

    bool send_set_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const uint32_t&	proto_version,
	const SetVifProtoVersionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetVifProtoVersionCB;

    bool send_reset_vif_proto_version(
	const char*	target_name,
	const string&	vif_name,
	const ResetVifProtoVersionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LogTraceAllCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable the MLD6IGMP trace log for all operations.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    bool send_log_trace_all(
	const char*	target_name,
	const bool&	enable,
	const LogTraceAllCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddProtocol4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete a client protocol in the MLD/IGMP protocol.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to add/delete.
     *
     *  @param protocol_id the ID of the protocol to add/delete (both sides
     *  must agree on the particular values).
     *
     *  @param vif_name the name of the vif the protocol add/delete to apply
     *  to.
     *
     *  @param vif_index the index of the vif the protocol add/delete to apply
     *  to. The added protocol will receive Join/Leave membership information
     *  about same-LAN members for the particular vif.
     */
    bool send_add_protocol4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const AddProtocol4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddProtocol6CB;

    bool send_add_protocol6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const AddProtocol6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteProtocol4CB;

    bool send_delete_protocol4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const DeleteProtocol4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteProtocol6CB;

    bool send_delete_protocol6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const DeleteProtocol6CB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_enable_vif(
	const XrlError&	e,
	XrlArgs*	a,
	EnableVifCB		cb
    );

    void unmarshall_start_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StartVifCB		cb
    );

    void unmarshall_stop_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StopVifCB		cb
    );

    void unmarshall_enable_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	EnableAllVifsCB		cb
    );

    void unmarshall_start_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StartAllVifsCB		cb
    );

    void unmarshall_stop_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StopAllVifsCB		cb
    );

    void unmarshall_enable_mld6igmp(
	const XrlError&	e,
	XrlArgs*	a,
	EnableMld6IgmpCB		cb
    );

    void unmarshall_start_mld6igmp(
	const XrlError&	e,
	XrlArgs*	a,
	StartMld6IgmpCB		cb
    );

    void unmarshall_stop_mld6igmp(
	const XrlError&	e,
	XrlArgs*	a,
	StopMld6IgmpCB		cb
    );

    void unmarshall_enable_cli(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCliCB		cb
    );

    void unmarshall_start_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StartCliCB		cb
    );

    void unmarshall_stop_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StopCliCB		cb
    );

    void unmarshall_get_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifProtoVersionCB		cb
    );

    void unmarshall_set_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	SetVifProtoVersionCB		cb
    );

    void unmarshall_reset_vif_proto_version(
	const XrlError&	e,
	XrlArgs*	a,
	ResetVifProtoVersionCB		cb
    );

    void unmarshall_log_trace_all(
	const XrlError&	e,
	XrlArgs*	a,
	LogTraceAllCB		cb
    );

    void unmarshall_add_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol4CB		cb
    );

    void unmarshall_add_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol6CB		cb
    );

    void unmarshall_delete_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol4CB		cb
    );

    void unmarshall_delete_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol6CB		cb
    );

};

#endif /* __XRL_INTERFACES_MLD6IGMP_XIF_HH__ */
