/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fti_xif.hh,v 1.8 2004/06/10 22:42:01 hodson Exp $
 */

#ifndef __XRL_INTERFACES_FTI_XIF_HH__
#define __XRL_INTERFACES_FTI_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFti"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlFtiV0p2Client {
public:
    XrlFtiV0p2Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlFtiV0p2Client() {}

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr StartTransactionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Start transaction.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_start_transaction(
	const char*	target_name,
	const StartTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CommitTransactionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Commit transaction.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     */
    bool send_commit_transaction(
	const char*	target_name,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AbortTransactionCB;
    /**
     *  Send Xrl intended to:
     *
     *  Abort transaction.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     */
    bool send_abort_transaction(
	const char*	target_name,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddEntry4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add a routing entry.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    bool send_add_entry4(
	const char*	target_name,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin,
	const AddEntry4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddEntry6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add a routing entry.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     *
     *  @param gateway the address of the next-hop router toward dst.
     *
     *  @param ifname the name of the physical interface toward dst.
     *
     *  @param vifname the name of the virtual interface toward dst.
     *
     *  @param metric the routing metric toward dst.
     *
     *  @param admin_distance the administratively defined distance toward dst.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    bool send_add_entry6(
	const char*	target_name,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin,
	const AddEntry6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteEntry4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete a routing entry.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     */
    bool send_delete_entry4(
	const char*	target_name,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const DeleteEntry4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteEntry6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete a routing entry.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst the destination subnet address of the entry.
     */
    bool send_delete_entry6(
	const char*	target_name,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const DeleteEntry6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAllEntriesCB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete all routing entries for all address families.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     */
    bool send_delete_all_entries(
	const char*	target_name,
	const uint32_t&	tid,
	const DeleteAllEntriesCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAllEntries4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete all routing entries for the IPv4 address family.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     */
    bool send_delete_all_entries4(
	const char*	target_name,
	const uint32_t&	tid,
	const DeleteAllEntries4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAllEntries6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete all routing entries for the IPv6 address family.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param tid the transaction ID of this transaction.
     */
    bool send_delete_all_entries6(
	const char*	target_name,
	const uint32_t&	tid,
	const DeleteAllEntries6CB&	cb
    );

    typedef XorpCallback8<void, const XrlError&, const IPv4Net*, const IPv4*, const string*, const string*, const uint32_t*, const uint32_t*, const string*>::RefPtr LookupRoute4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Lookup a route for a destination host address.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param dst the destination host address to lookup.
     */
    bool send_lookup_route4(
	const char*	target_name,
	const IPv4&	dst,
	const LookupRoute4CB&	cb
    );

    typedef XorpCallback8<void, const XrlError&, const IPv6Net*, const IPv6*, const string*, const string*, const uint32_t*, const uint32_t*, const string*>::RefPtr LookupRoute6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Lookup a route for a destination host address.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param dst the destination host address to lookup.
     */
    bool send_lookup_route6(
	const char*	target_name,
	const IPv6&	dst,
	const LookupRoute6CB&	cb
    );

    typedef XorpCallback7<void, const XrlError&, const IPv4*, const string*, const string*, const uint32_t*, const uint32_t*, const string*>::RefPtr LookupEntry4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Lookup a route for a destination subnet address.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param dst the destination subnet address to lookup.
     */
    bool send_lookup_entry4(
	const char*	target_name,
	const IPv4Net&	dst,
	const LookupEntry4CB&	cb
    );

    typedef XorpCallback7<void, const XrlError&, const IPv6*, const string*, const string*, const uint32_t*, const uint32_t*, const string*>::RefPtr LookupEntry6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Lookup a route for a destination subnet address.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param dst the destination subnet address to lookup.
     */
    bool send_lookup_entry6(
	const char*	target_name,
	const IPv6Net&	dst,
	const LookupEntry6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr HaveIpv4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test if the underlying system supports IPv4.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_have_ipv4(
	const char*	target_name,
	const HaveIpv4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr HaveIpv6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test if the underlying system supports IPv6.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_have_ipv6(
	const char*	target_name,
	const HaveIpv6CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetUnicastForwardingEnabled4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test whether the IPv4 unicast forwarding engine is enabled or disabled
     *  to forward packets.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_get_unicast_forwarding_enabled4(
	const char*	target_name,
	const GetUnicastForwardingEnabled4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetUnicastForwardingEnabled6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test whether the IPv6 unicast forwarding engine is enabled or disabled
     *  to forward packets.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_get_unicast_forwarding_enabled6(
	const char*	target_name,
	const GetUnicastForwardingEnabled6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetUnicastForwardingEnabled4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the IPv4 unicast forwarding engine to enable or disable forwarding
     *  of packets.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enabled if true, then enable IPv4 unicast forwarding, otherwise
     *  disable it.
     */
    bool send_set_unicast_forwarding_enabled4(
	const char*	target_name,
	const bool&	enabled,
	const SetUnicastForwardingEnabled4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetUnicastForwardingEnabled6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the IPv6 unicast forwarding engine to enable or disable forwarding
     *  of packets.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enabled if true, then enable IPv6 unicast forwarding, otherwise
     *  disable it.
     */
    bool send_set_unicast_forwarding_enabled6(
	const char*	target_name,
	const bool&	enabled,
	const SetUnicastForwardingEnabled6CB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
    );

    void unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
    );

    void unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
    );

    void unmarshall_add_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	AddEntry4CB		cb
    );

    void unmarshall_add_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	AddEntry6CB		cb
    );

    void unmarshall_delete_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEntry4CB		cb
    );

    void unmarshall_delete_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEntry6CB		cb
    );

    void unmarshall_delete_all_entries(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntriesCB		cb
    );

    void unmarshall_delete_all_entries4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntries4CB		cb
    );

    void unmarshall_delete_all_entries6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntries6CB		cb
    );

    void unmarshall_lookup_route4(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRoute4CB		cb
    );

    void unmarshall_lookup_route6(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRoute6CB		cb
    );

    void unmarshall_lookup_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	LookupEntry4CB		cb
    );

    void unmarshall_lookup_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	LookupEntry6CB		cb
    );

    void unmarshall_have_ipv4(
	const XrlError&	e,
	XrlArgs*	a,
	HaveIpv4CB		cb
    );

    void unmarshall_have_ipv6(
	const XrlError&	e,
	XrlArgs*	a,
	HaveIpv6CB		cb
    );

    void unmarshall_get_unicast_forwarding_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	GetUnicastForwardingEnabled4CB		cb
    );

    void unmarshall_get_unicast_forwarding_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	GetUnicastForwardingEnabled6CB		cb
    );

    void unmarshall_set_unicast_forwarding_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	SetUnicastForwardingEnabled4CB		cb
    );

    void unmarshall_set_unicast_forwarding_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	SetUnicastForwardingEnabled6CB		cb
    );

};

#endif /* __XRL_INTERFACES_FTI_XIF_HH__ */
