/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fea_rawpkt_xif.hh,v 1.10 2004/06/10 22:42:00 hodson Exp $
 */

#ifndef __XRL_INTERFACES_FEA_RAWPKT_XIF_HH__
#define __XRL_INTERFACES_FEA_RAWPKT_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFeaRawpkt"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlRawPacketV0p1Client {
public:
    XrlRawPacketV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlRawPacketV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr Send4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Send a packet on a raw socket.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_send4(
	const char*	target_name,
	const IPv4&	src_address,
	const IPv4&	dst_address,
	const string&	vif_name,
	const uint32_t&	proto,
	const uint32_t&	ttl,
	const uint32_t&	tos,
	const vector<uint8_t>&	options,
	const vector<uint8_t>&	payload,
	const Send4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendRaw4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Send raw packet. Checksum is computed and applied before transmission.
     *  All the fields within the IPv4 header must be in network order.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_send_raw4(
	const char*	target_name,
	const string&	vif_name,
	const vector<uint8_t>&	packet,
	const SendRaw4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr RegisterVifReceiverCB;
    /**
     *  Send Xrl intended to:
     *
     *  Register to receive packets. The receiver is expected to support
     *  raw_socket_client/0.1 interface.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_register_vif_receiver(
	const char*	target_name,
	const string&	router_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	proto,
	const RegisterVifReceiverCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UnregisterVifReceiverCB;
    /**
     *  Send Xrl intended to:
     *
     *  Unregister stop receiving packets.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param proto Protocol number that the receiver is interested in.
     */
    bool send_unregister_vif_receiver(
	const char*	target_name,
	const string&	router_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	proto,
	const UnregisterVifReceiverCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_send4(
	const XrlError&	e,
	XrlArgs*	a,
	Send4CB		cb
    );

    void unmarshall_send_raw4(
	const XrlError&	e,
	XrlArgs*	a,
	SendRaw4CB		cb
    );

    void unmarshall_register_vif_receiver(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterVifReceiverCB		cb
    );

    void unmarshall_unregister_vif_receiver(
	const XrlError&	e,
	XrlArgs*	a,
	UnregisterVifReceiverCB		cb
    );

};

#endif /* __XRL_INTERFACES_FEA_RAWPKT_XIF_HH__ */
