#ifndef XSHRLOADER_H
#define XSHRLOADER_H

#include "globals.h"
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include "../image/image.h"

//structure that describe resource
struct ResId
{
  char name[64];
  int  img_size;
  char *img_data;
  char *fname;
  ResId(char* iname,char* iimg_data=0,int iimg_size=0): img_size(iimg_size)
  {
    strncpy(name,iname,64);
    fname=0;
    img_data=iimg_data;
  };
};

//Working modes for loader
enum LoaderMode { SharedOverride, SharedWrite, SharedRead, NonShared };

//Class that implement XSharedLoader itself
class xsharedLoader
{
  int screen;
  Window root;
  Colormap defcmp;
  int (*prev_handler)(Display*, XErrorEvent*);
  LoaderMode mode;

  int    make_shared(Atom xa_prop, void* data,Atom xa_type, int quant);
  void*  get_shared_res_by_atom(Atom xa_res,Atom xa_type);
  void   ignore_xerror();
  void   restore_xerror();
  Pixmap real_load_pixmap(ResId res, int& l,int& h);
  int    make_shared_pixmap(ResId res,int x, int y,void* data);
  Pixmap get_shared_pixmap(ResId res,int& x, int& y);

public:
  xsharedLoader(LoaderMode m=SharedRead) { set_workmode(m);};
  void   init();
  Pixmap load_pixmap(ResId, int&l, int& h);
  void   free_pixmap(Pixmap);
  void   exit_now();
  LoaderMode set_workmode(LoaderMode m) { LoaderMode oldmode=mode;mode=m; return oldmode; };
};

extern xsharedLoader *default_loader;

#endif
