/* $Id: panel.h,v 1.1.1.1 2001/04/17 08:45:25 leo Exp $ */
#ifndef PANEL_H
#define PANEL_H
#include "base_cap.h"
#include "scroll.h"

extern int mystrcmp(char*,int,int,char*,int,int);

#define STL_SIZE_NCHAR   12
#define STL_ATTR_NCHAR    4
#define STL_TIME_NCHAR   17
#define STL_OWNER_NCHAR  16


#define STL_SIZE_PTR     stl_arr[0]
#define STL_ATTR_PTR     stl_arr[1]
#define STL_TIME_PTR     stl_arr[2]
#define STL_NAME_PTR     stl_arr[3]
#define STL_OWNER_PTR    stl_arr[4]

#define STL_MAX_MEM      5

//StatusLine height
#define STL_H            22

#define STL_SPACE        7
#define STL_SPACE2       (STL_SPACE/2)
struct StatusLinePos
{
    int x;    //Offset from start in horizontal
    int y;    //Offset from start in vetical
    int tx;   //Offset for text
    int ty;   //Offset for text
    int tlen; //Max length of text
    int len;  //Length of area in pixels
};





class Lister:public Gui,public BaseCaptain
{
 protected:
  GC wgcw,fgc;
  GC xpmgc;
  XRectangle rect,rect2;
 public:
  Lister *panel2;
  Cmdline *cmdl;
  int ty,tdl,bclk,lmx,lmy,flen,lowfl,brief,side,mouse;
  uint tl,pl;
  int prflg,lastn,fixl,fixh,fixy,fattr1;
  Time dbtime;
  Menu *subm;
  void (*viewfunc)(char*);
  void (*viewonlyfunc)(char*);
  void (*editorfunc)(char*);
  int attdx;
  ScrollBar *scr;
  StatusLinePos stl_arr[STL_MAX_MEM];

  Lister(int ix,int iy,int il,int ih,int icolumns=2):Gui(),BaseCaptain(icolumns)
   {
     x=ix;y=iy;l=il;h=ih;
     ty=tdl=bclk=lmx=lmy=mouse=0;
     guitype=GUI_LISTER;
     prflg=0;
     lastn=0;
     cmdl=NULL;
     lowfl=0;
     viewfunc=viewonlyfunc=NULL;
     editorfunc=NULL;
     side=0;
     subm=NULL;
   };
  void repanel(int);
  void delall_l(FList*);
  void cmdl_insert_name(char *name);
  void reconfigure(int ix,int iy,int il,int ih);
  void reconfigure_without_expose(int ix,int iy,int il,int ih);
  void setcmdl(Cmdline* cmd) {cmdl=cmd;};
  void funcs(int);
  void setpanel(Lister* pp) {panel2=pp;};
  void setviewer(void (*vw)(char*),void (*vow)(char*)) {viewfunc=vw;viewonlyfunc=vow;};
  void seteditor(void (*vw)(char*)) {editorfunc=vw;};
  void setsubmenu(Menu* sbm) {subm=sbm;};
  void activate();
  ~Lister() {XFreeGC(disp,gcw);XFreeGC(disp,fgc);XFreeGC(disp,wgcw);XFreeGC(disp,xpmgc);delall_l(&dl);delete maskchr;};
  virtual void init(Window);
  virtual void click();
  virtual void expose();
  virtual void show();
  virtual void scrollup(Gui*);
  virtual void scrolldown(Gui*);
  virtual void calc_statusbar_offsets();

  void view(int);
  void edit();
  void copy();
  void move();
  void copy(VFS*);
  void move(VFS*);
  void del();
  void remount();
  void mkdir();
  void attrib();
  void raise_terminal_if_need();
  void lpr();
  
  int  moved(char*);
  void fedit();
  void ext_exec(char*);
  void menu_exec(char*);
  void wide_exec();
  void ps_info();
  void send_dnd_message();
  void try_to_add_to_bookmark(int cy);
  void check_dnd_dir(unsigned mask);
  void check_dnd_dir_on_panel2(int,int,unsigned mask);
  void fast_find(XEvent*);
  void create_ftp_link();
  void bg_view(char *name);
  void bg_edit(char *name);
  virtual void header_blink();
  virtual void header_blink_other();
  void insert_right_dir();
  void insert_left_dir();
  virtual void redraw_statusbar();

  virtual int  am_i_visible();
  virtual void showdir();
  virtual void fserror(char*,FList*);
  virtual void total_expose();
  virtual void total_reread();
  virtual void flush_screen();
  virtual int  is_panel_vfs(VFS*);
  virtual void set_recycle_state(int);     // Visualization of recycle operation  
  virtual void create_infowin(char *head); // Create progress bar window
  virtual void del_infowin();              // Delete progress window
  virtual void to_infowin(char *str);      // Message to show in window
  virtual void infowin_set_coun(int);      // Set progress length
  virtual void infowin_update_coun(int);   // Update progress bar
  virtual void show_item(FList*);          // Show one item from list
  virtual void showfinfo(FList*);          // Show file info to status bar
  virtual void expose_panel();
  virtual BaseCaptain* other();            // Return other(second) panel pointer
  virtual VFS* other_vfs();                // Return other(second) panel current vfs
  virtual void showdirname();              // Show directory name in the header
  virtual void showitem(FList*,int);       // Show one file item
  virtual void showempty(int);             // Show one empty item
  virtual void show_ff_item(int,int);      // Show fast find item
  virtual void show_string_info(char*);    // Show given string in status bar
};

extern Lister *panel;


extern void   save_cfg(Lister *,Lister *);
extern void   load_cfg(Lister *,Lister *);
extern void   qview();
extern void   qv_update(FList*);
extern void   init_qview();
extern void   qv_signal();

extern void   toggle_inodewin();
extern void   show_inodeinfo(FList *o);

extern  int   hide_hidden;

extern int    symlink_as_is;  //Copy symlink as is (symlink as symlink, not a copy of file it points to) 
extern char*  panlist[];
extern char*  panlist2[];
extern int    psmax;
extern FList  otmp;
extern int    dont_update;
extern int    just_at_startup;

extern void   simple_flist_add(FList *base, FList* it);

#include "commonfuncs.h"

//////////////////////////////////////////////////End of file/////////////////////////////////////////////
#endif

