#ifndef GUI_H
#define GUI_H
#include <X11/cursorfont.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "types.h"
#include "history.h"
#include "geomfuncs.h"
#include "flist.h"
#include "guilocale.h"

//Notification types
#define MENU_HIDE        1
#define MENU_SHOW        2

//Gui types
#define        GUI_UNREG                0
#define        GUI_IGNORE               254

#define        GUI_KEY                  11
#define        GUI_SWITCH               12
#define        GUI_SWPANEL              13
#define        GUI_LISTER               44
#define        GUI_PANEL                17
#define        GUI_WIN                  1
#define        GUI_SEP                  2
#define        GUI_VIEWER               3
#define        GUI_EDITOR               4
#define        GUI_SPWIN                5
#define        GUI_CMDLINE              6
#define        GUI_INPUT                7
#define        GUI_TEXT                 8
#define        GUI_WTEXT                18
#define        GUI_MENUBAR              9
#define        GUI_MENU                 10
#define        GUI_BKEY                 14
#define        GUI_SCROLL               45
#define        GUI_EXWIN                46
#define        GUI_PAGER                47
#define        GUI_IMLOAD               48
#define        GUI_FBROWSE              16
#define        GUI_SWITCHER             49
#define        GUI_FVISUAL              50
#define        GUI_BOOKMARK             51

extern     int gui_options;
//Defines for 'gui_options' variable
#define        THICK_BORDER            1


class Gui
{
 public:
  int foc;
  Gui *next,*prev,*guiobj;
  Window w,parent;
  GC gcw;
  short int guitype;
  char in_name[20];
  char in_family[20];
  int x,y;
  uint l,h;
  Gui() {next=prev=NULL;foc=0;guiobj=NULL;in_name[0]=0;in_family[0]=0;guitype=GUI_UNREG;};
  virtual void expose() {};
  virtual void click()=0;
  virtual void show();
  virtual void hide();
  virtual void init(Window) {};
  virtual void link(Gui *o) {next=o;o->prev=this;};
  virtual void scrollup(Gui*) {};
  virtual void scrolldown(Gui*) {};
  virtual void scroll(Gui*) {};
  virtual void scrolling(Gui*) {};
  virtual void guifunc(Gui*,int,...) {};
  virtual void set_iname(char *iname) {strcpy(in_name, iname);};
  virtual void set_ifamily(char *iname) {strcpy(in_family, iname);};
  virtual int  geometry_by_iname();
};

extern Gui *focobj;

class KEY: public Gui
{
 protected:
  void (*func)();
 public:
  int prflg,tx,ty,hflg,dflg;
  uint tl;
  ulong col;
  char *name;
  void (*escfunc)();
  Sprite *skin;
  KEY(int ix,int iy,int il,int ih,char *iname,ulong icol,void (*ifunc)());
  ~KEY() {if(disp) XFreeGC(disp,gcw);hflg=0;dflg=0;};
  void set_escapefunc(void (*v)()) {escfunc=v;};
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void press();
};         

class ScrollBar;

class Panel: public Gui
{
 protected:
  int (*func)(int,char*);
 public:
  int prflg,tx,ty,hflg,max,base,cur,vh;
  uint tl;
  ulong col;
  char **names;
  void (*canfunc)();
  void (*keyfunc)(KeySym,Panel*);
  ScrollBar *scr;
  int dbtime;
  int lmx,lmy,bclk, every_move;
  Panel(int ix,int iy,int il,int ih,char **iname,int imax,ulong icol,int (*ifunc)(int,char*));
  ~Panel() {if(disp) XFreeGC(disp,gcw);hflg=0;};
  void setkeyfunc(void (*ik)(KeySym,Panel*)) {keyfunc=ik;}
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  virtual void scroll(Gui*);
  virtual void scrollup(Gui* o) {scroll(o);};
  virtual void scrolling(Gui* o) {scroll(o);};
  virtual void scrolldown(Gui* o) {scroll(o);};
  virtual void shownames();
  void reset_list();
  virtual void showcurs(int=1);
  void escfunc(void (*ecanfunc)()) {canfunc=ecanfunc;};
  void add_element(char*);
  void find_and_set(char*);
  void activate_function();
  int  get_current_index() { return base+cur;};
  void set_every_move_to(int i) {every_move=i;};
  void set_max_to(int i) { max=i;};
  void cursor_to(int i) { cur=i % vh; base=i-cur;};
};

class Sw_panel;

class Switch: public Gui
{
 protected:
  void (*func)();
 public:
  int prflg,tx,ty,hflg,sw,excl;
  uint tl;
  ulong col;
  char *name;
  Pixmap gl;
  Sw_panel *sp;
  int disable;
  void (*escfunc)();

  Switch(int ix,int iy,int il,char *iname,ulong icol,void (*ifunc)()=NULL);
  ~Switch() {if(disp){ XFreeGC(disp,gcw);XFreePixmap(disp,gl);hflg=0;};};
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void press();
  virtual void select();
  void setexcl() {excl=1;};
  void setpanel(Sw_panel* isp) {sp=isp;};
  void set_disable(int i) {disable=i;};
  void set_escapefunc(void (*esc)()) {escfunc=esc;};
};

struct MenuItem;

class Sw_panel: public Gui
{
 protected:
  int max;
  MenuItem *smn;
 public:
  Switch **ar;
  int ty,tx,shown,initfl,columns,columnl;
  char *head;
  
  Sw_panel(int ix,int iy,int il,char *ihead,MenuItem* mn,int imax, int icolumn=1);
  ~Sw_panel();
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  virtual void link(Gui*);
  void set(int n,int s);
  void excl();
  int get(int n) {return ar[n]->sw;};
  void reaction(Switch*);
  void set_escapefunc(void (*esc)());
};

struct List;

class Win:public Gui
{
 public:
  int ty,ffl;
  uint tl;
  int col,prflg,hflg;
  char *name;
  List *oldel;
  Gui *guiexpose;
  void (*escape_func)();
  Sprite *spr_con1;
  Sprite *spr_con2;
  Sprite *spr_con3;
  Sprite *spr_con4;
  RecArea *ra_tbl;
  Win(int ix,int iy,int il,int ih,char *iname,int icol,int hfl=0):Gui()
   {x=ix;y=iy;l=il;h=ih;col=icol;name=iname;hflg=hfl;guitype=GUI_WIN;
    guiexpose=NULL;escape_func=NULL;ra_tbl=NULL;};
  ~Win() {if(disp){XFreeGC(disp,gcw);XDestroyWindow(disp,w);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void nonresizable();
  void add_toexpose(Gui* ex) {guiexpose=ex;};
  void set_escapefunc(void (*v)()) {escape_func=v;hflg=1;};
};

class Separator:public Gui
{
  public:
   int vertical;
   Gui *win;
   Separator(int ix,int iy,int il,Gui *ww,int ivert=NO) : Gui() {x=ix;y=iy;l=il;win=ww;guitype=GUI_SEP;vertical=ivert;};
   virtual void init(Window) {w=win->w;gcw=win->gcw;};
   virtual void show() {}; 
   virtual void hide() {};
   virtual void click();
   virtual void expose();
};

enum RuState {KOI8,CP866,WIN1251};

class Viewer:public Gui
{
 public:
  GC gct;
  int ty,ffl,tx,cx,cy,row,highlight,unmap,totallines;
  uint tl;
  int col,prflg,hflg,base,vish,visl,cbase,sl,nn,n,hex,tab,stx,koi;
  char *name;
  char *buf;
  char findbuf[255];
  List *oldel;
  FList *node;
  ScrollBar *scr;
  void (*endfunc)(Viewer*);
  void (*swfunc)(Viewer*);
  void (*external_reconfigure)(Viewer*,int,int,int,int);
  RuState  rusconv_state;
  Viewer(int ix,int iy,int il,int ih,
         char *iname,int icol,void(*ff)(Viewer*)=NULL):Gui()
    {
      x=ix;y=iy;l=il;h=ih;col=icol;
      name=iname;unmap=0;hflg=0;
      buf=NULL;
      guitype=GUI_VIEWER;
      endfunc=ff;
      findbuf[0]=0;
      swfunc=NULL;
      external_reconfigure=NULL;
      rusconv_state=KOI8;
	};
  ~Viewer() {if(disp) {XFreeGC(disp,gcw);XFreeGC(disp,gct);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  virtual void scroll(Gui*);
  virtual void scrolling(Gui*);
  virtual void scrollup(Gui*);
  virtual void scrolldown(Gui*);
  void view(FList*);
  char* scanlines();
  void viewmem(FList*,char*);
  void showhexfile();
  void showasc();
  void back();
  void hexoff();
  void rusconvert();
  void reconfigure(int,int);
  void set_external_reconfigure(void (*reconf)(Viewer*,int,int,int,int)) {external_reconfigure=reconf;};
  void wrusconvert();
  void linenum();
  void showcurs(int=1);
  void setswfunc(void (*ff)(Viewer*)) {swfunc=ff;};
  int pagedown(int);
  void info();
  void insert(KeySym*);
  void line(int);
  void save();
  void func(int);
  void hex_asc();
  void find();
};

class Editor:public Gui
{
 public:
  GC gct;
  ScrollBar *scr;
  int ty,ffl,tx,cx,cy,row,dx,bw,ent,dos,koi,rmode;
  int *xl;
  int *chl;
  uint tl;
  int col,prflg,hflg,base,vish,visl,stx,maxr,mod,highe,highb,unmap;
  char *name;
  char **buf;
  char fname[255];
  char findbuf[255];
  List *oldel;
  FList *node;
  void (*endfunc)(Editor*);
  void (*swfunc)(Editor*);
  void (*external_reconfigure)(Editor*,int,int,int,int);
  void (*cfind_func)(char *);
  int enable_bracket;
  GuiLocale gl;

  Editor(int ix,int iy,int il,int ih,
         char *iname,int icol,void(*ff)(Editor*)=NULL):Gui()
   {
     x=ix;y=iy;l=il;h=ih;col=icol;
     name=iname;
     mod=unmap=0;
     hflg=0;guitype=GUI_EDITOR;
     endfunc=ff;
     findbuf[0]=0;
     swfunc=NULL;
     external_reconfigure=NULL;
     cfind_func=NULL;
     enable_bracket=0;
   };
  ~Editor() {if(disp){XFreeGC(disp,gcw);XFreeGC(disp,gct);XDestroyWindow(disp,w);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  virtual void scroll(Gui*);
  virtual void scrolling(Gui*);
  virtual void scrollup(Gui*);
  virtual void scrolldown(Gui*);
  char trans(int mode,char sym);
  void set_external_reconfigure(void (*reconf)(Editor*,int,int,int,int)) {external_reconfigure=reconf;};
  void setswfunc(void (*ff)(Editor*)) {swfunc=ff;};
  void set_cfind_func(void (*ff)(char*)) {cfind_func=ff;};
  void load(FList*);
  void newfile(FList*);
  void view();
  void showcurs(int=1);
  void showline(int);
  int  calclen(int,int);
  void do_convertion();
  void do_wconvertion();
  void pageup();
  void pagedown();
  void rusconvert();
  void reconfigure(int,int);
  void wrusconvert();
  void info();
  void xyinfo();
  void back();
  void backln();
  void delln(int);
  void insertln();
  void insert(char);
  void insspace();
  void insempty(int);
  void func(int);
  int  save();
  void find();
  void find_brackets();
  void reverse_find_bracket();
  void ssave();
  void sfind();
  void cfindfunc(int);
  void cfindwin();
  void cfindpromptwin();
  void set_straight_and_find(char *str);
  void copy();
  void paste();
  void cut();
  void del();
  void sgoto();
  void gotoln();
  void cut_cur_word(char *wordto);
  void exit_and_save();
  void enter_sym(XEvent*);
};

class SpecialWin:public Gui
{
 public:
  int ty,ffl;
  uint tl;
  int col,prflg,hflg,nn,al;
  char *name;
  Pixmap pm1;
  SpecialWin(int ix,int iy):Gui()
   {x=ix;y=iy;guitype=GUI_SPWIN;};
  ~SpecialWin() {if(disp) {XFreePixmap(disp,pm1);XFreeGC(disp,gcw);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void nextpiece();
  void initroute(FList *,int);
};

class Cmdline:public Gui
{
 public:
  int ty,bbp,bp;
  uint tl,tw,bl;
  int col,hflg,cp,ll,el,visl,base;
  char name[1024];
  char buf[1024];
  char bak[10][1024];
  char store[1024];
  char store_cp, store_base;
  GuiLocale gl;
  Cmdline(int ix,int iy,int il,int icol):Gui()
   {x=ix;y=iy;l=il;col=icol;name[0]=0;tl=0;cp=0;bl=0;buf[0]=0;
    el=1023;guitype=GUI_CMDLINE;visl=base=0;store[0]=0;};
  ~Cmdline() {if(disp) XFreeGC(disp,gcw);};
  void setpath(char*);
  void press(int);
  void showbuf();
  void flush();
  void insert(char);
  void reconfigure(int ix,int iy,int il,int ih);
  void backup();
  void look_for_cd();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void save_input();
  void restore_input();
};

class Input:public Gui
{
 protected:
  void (*func)();
  GuiLocale gl;
 public:
  char hist_id[8];
  int ty;
  uint dl,bl;
  int col,hflg,cp,ll,tl,el,firstfl;
  char *buf;
  void (*escfunc)();
  History *hist;
  int first_hist;
  int passwd;        //If == 1 then blind input.
  int bool_expand;
  Input(int ix,int iy,int il,int icol,void (*ifunc)()=NULL):Gui()
   {x=ix;y=iy;l=il;col=icol;tl=0;cp=0;bl=0;el=255;func=ifunc;escfunc=NULL;guitype=GUI_INPUT;strcpy(hist_id,"UNREG");
        hist=NULL;passwd=0;bool_expand=0;};
  ~Input() {if(disp) XFreeGC(disp,gcw);};
  void set_histid(char *id) {strcpy(hist_id,id);};
  virtual void press();
  virtual void showbuf();
  void flush();
  void insert(char);
  void set_escapefunc(void (*esc)()) {escfunc=esc;};
  void setbuf(char *ibuf,int nn) {buf=ibuf;el=nn;cp=0;bl=strlen(buf);dl=0;};
  virtual void init(Window);
  virtual void show();
  virtual void click();
  virtual void expose();
  void extract_path_part(char *buf, int pos, char *topath, char *part);
  int   do_tab_expansion(char *buf, int pos, int maxl);
  void partial_completion(char *compl, char *name, int *completed, int* bool_first);
};

class Text:public Gui
{
 public:
  uint tl;
  int col;
  char *name;
  Text(int ix,int iy,char *iname,int icol):Gui()
   {x=ix;y=iy;col=icol;name=iname;guitype=GUI_TEXT;};
  ~Text() {if(disp) XFreeGC(disp,gcw);};
  void recalc();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void clear_text_area(int);
};

class WText:public Gui
{
 public:
  int ty;
  uint tl,tx;
  int col,centered;
  char *name;
  WText(int ix,int iy,int il,char *iname,int icol):Gui()
   {x=ix;y=iy;col=icol;l=il;h=18;name=iname;guitype=GUI_WTEXT;centered=1;};
  ~WText() {if(disp) XFreeGC(disp,gcw);};
  void recalc();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
};

class Menu;
struct MenuItem
{
 char *name;
 ulong col;
 void (*func)();
 Menu *o;
};

class MenuBar:public Gui
{
 protected:
  int *dx;
  int *tl;
  int *dl;
  MenuItem *items;
  int max,ty,cur,prflg,enx,stx,deltal;
  Sprite *skin;
  Sprite *skinpr;
  Pixmap fillpix;
  unsigned int fill_l, fill_h;
  Sprite *pskin;
  int last_idx;
 public:
  
  int menuh;
  
  MenuBar(int ix,int iy,MenuItem *ii,int maxi):Gui() 
    {x=ix;y=iy;max=maxi;items=ii;dx=new int[max];tl=new int[max];dl=new int[max];
        guitype=GUI_MENUBAR;deltal=0;skin=NULL;skinpr=pskin=NULL;last_idx=-1;};
  virtual ~MenuBar() {delete dx;delete tl;delete dl;if(disp) XFreeGC(disp,gcw);};
  virtual void init(Window);
  virtual void expose();
  virtual void click();
  virtual int  geometry_by_iname();
  void showitem(int);
  void reconfigure(int ix,int iy,int pl,int ph);
  void pressitem(int);
  Menu* getmenu() {return items[cur].o;};
  void substract_from_l(int dd) {deltal=dd;};
  void notify(int code);
};

const unsigned mitemh=20;  
class Menu:public Gui
{
 protected:
  int *dx;
  int *tl;
  int *dl;
  MenuItem *items;
  Pixmap xpm;
  List *oldel;
 public:
  int max,ty,cur,prflg,shflg,actfl;
  int right_justified;
  MenuBar *menu_to_notify;
  
  Menu(MenuItem *ii,int maxi) :Gui()
    {max=maxi;h=max*mitemh+6;items=ii;shflg=0;tl=new int[max];guitype=GUI_MENU;
     for(int i=0;i<max;i++)
       tl[i]=strlen(items[i].name);
     right_justified=NO;
     menu_to_notify=NULL;
    };
  virtual ~Menu() {delete tl;};
  virtual void init(Window);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  virtual void showitem(int);
  virtual void select(int);
  void setpos(int ix,int iy) {x=ix;y=iy;};
  int is_shown() {return shflg;};
  int is_active() {return actfl;};
  void switches();
  void set(int i) {cur=i;switches();};
};


extern char   *getext(char* str);

extern int    str_casecmp(char*,char*);
extern int    str_ncasecmp(char*,char*,int);

extern Pixmap main_pixmap;
extern void   guiSetInputFocus(Display* disp, Window w, int revert_to, Time t);
extern void   prect(Window w, GC & gcw, int x, int y, int l, int h);
extern void   urect(Window w, GC & gcw, int x, int y, int l, int h);

extern void   delay(int usec);

extern int    shadow;

#endif
///////////////////////////////////////End of file///////////////////////////////////////////

