/****************************************************************************
*  Copyright (C) 2000 by Leo Khramov
*  email:     leo@xnc.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
 ****************************************************************************/
/* $Id: base_cap.cxx,v 1.1.1.1 2001/04/17 08:45:25 leo Exp $ */
#include "base_cap.h"
#include "ftpfs.h"
#include "ftpcfg.h"
#include "systemfuncs.h"

int    disable_reread = 0;        //If 1 reread disables in ****::expose;
int    dirdelay=1;                //Timeout in seconds for rereading directory contens
int    compare_by_size=YES;       //Use sizecompare for directory comparision
int    compare_by_time=NO;        //Use timecompare for directory comparision
 


//--------------------------------------------------------------------------
//Search entry in the file list by name and return index from start of list
//--------------------------------------------------------------------------
int    BaseCaptain::findentry(char *nme)
{
  FList *fo = dl.next;
  int    i = 0;
  while (fo != NULL)
    if (strcmp(fo->name, nme) == 0)
      break;
    else
    {
      fo = fo->next;
      i++;
    };
  if (fo != NULL)
    return i;
  return -1;
}

//--------------------------------------------------------------------------
//Adds subdirectory to path (curdir)
//example  was:/usr/local cont=bin will:/usr/local/bin
//--------------------------------------------------------------------------
void   BaseCaptain::addpathcontent(char *cont)
{
  if (curdir[strlen(curdir) - 1] != '/')
    strcat(curdir, "/");
  strcat(curdir, cont);
}

//--------------------------------------------------------------------------
//Make curdir show upper dir (cd ..)
//example was: /usr/local/bin will:/usr/local
//--------------------------------------------------------------------------
void   BaseCaptain::upperpath()
{
  char  *bb = strrchr(curdir, '/');
  *bb = 0;
  if (strlen(curdir) == 0)
    strcpy(curdir, "/");
}

//--------------------------------------------------------------------------
//sets cursor to position dd against current position *cr
//--------------------------------------------------------------------------
int    BaseCaptain::setcur(FList ** cr, int dd)
{
  FList *fo = *cr;
  if (dd > 0)
    while (fo->next != NULL && dd > 0)
    {
      fo = fo->next;
      dd--;
    }
  else
    while (fo->prev != &dl && dd < 0)
    {
      fo = fo->prev;
      dd++;
    }
  if (dd == 0)
  {
    *cr = fo;
    return 1;
  };
  return 0;
}


//--------------------------------------------------------------------------
// Read directory listing using current *vfs
// If vfs now in background mode then pop up previous one
//--------------------------------------------------------------------------
int    BaseCaptain::direc(char *dir_ch)
{
  FList *o,*o2;
  compare = comp;
  int    ret,coun;
  sort_order=rev_order ^ 1;
  ret = vfs->direc(dir_ch);
  if (ret)
  {
    if(vfs->bgbit)        //If VFS became BG then POP previous VFS
    {
      vfs=pop_vfs();
      vfs->ch_curdir();
      ret=vfs->direc(vfs->curdir);
      if(ret==0) 
	return ret;
    }
    /*      lar = vfs->lar;
	    larmax = vfs->larmax;
    */
    dl.next = vfs->dl.next;
    fl.next = vfs->fl.next;
      

    if (strcmp(dl.next->name, ".") == 0)
      dl.next = dl.next->next;
    dl.next->prev = &dl;
    cur = &dl;
    coun=0;
    while (cur->next != NULL)
    {
      cur = cur->next;
      coun++;
    }
    cur->next = fl.next;
    if (fl.next != NULL)
      fl.next->prev = cur;
    cur=fl.next;
    while(cur)
    {
      cur=cur->next;
      coun++;
    }
    base = cur = dl.next;
    lcurn = curn = 0;
    selfiles = selsize = 0;
    time(&lastscan);
    //    scr->setpages(coun/(th*col));
    //    scr->setrange(0, coun);
    //    scr->expose();
  }
  return ret;
}

//--------------------------------------------------------------------------
//Select given file for future packet operations
//--------------------------------------------------------------------------
void   BaseCaptain::selected(FList * fo)
{
  fo->options ^= S_SELECT;
  if (fo->options & S_SELECT)
  {
    selfiles++;
    selsize += fo->size;
  }
  else
  {
    selfiles--;
    selsize -= fo->size;
  }
}

//--------------------------------------------------------------------------
//Set attibutes to selected files
//--------------------------------------------------------------------------
void   BaseCaptain::setattrs(int scf,int atrib)
{
  FList *ko;
  ko = dl.next;
  vfs->ch_curdir();
  while (ko != NULL)
  {
    if (ko->options & S_SELECT)
    {
      if (scf)
	ko->mode |= atrib;
      else
	ko->mode &= atrib;
      if (vfs->chmod(ko->name, ko->mode) >= 0)
      {
	ko->options ^= S_SELECT;
	selfiles--;
	selsize -= ko->size;
      }
    };
    ko = ko->next;
  }
  vfs->ch_curdir();
}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//                            VFS stack operations
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


//--------------------------------------------------------------------------
//Pushes current VFS *v on top of stack
//--------------------------------------------------------------------------
void   BaseCaptain::push_vfs(VFS * v)
{
  VFS   *o;
  DFS   *df,*df2=(DFS*)v;
  FTP   *f;
  switch (v->fstype)
  {
  case DFS_TYPE:
    df = new DFS;
    memcpy(df, v, sizeof(DFS));
    df->curdir=new char[df2->dlen];
    strcpy(df->curdir,v->curdir);
    o=df;
    break;
  case AFS_TYPE:
    o = new AFS;
    memcpy(o, v, sizeof(AFS));
    o->set_dir_pointer(NULL,0);
    strcpy(o->curdir,v->curdir);
    break;
  case FTP_TYPE:
    o = new FTP;
    memcpy(o, v, sizeof(FTP));
    f=(FTP*)o;
    f->ftp_to_bg((FTP*)v);
    break;
  default:
    return;
  };
  o->next = vfstack;
  vfstack = o;
}

//--------------------------------------------------------------------------
// Pop up vfs from stack
//--------------------------------------------------------------------------
VFS*   BaseCaptain::pop_vfs()
{
  char   *dir;
  VFS   *o = vfstack;
  if (o == NULL)
    return &dfs;
  vfstack = o->next;
  o->need_reread = 1;
  switch (o->fstype)
  {
  case DFS_TYPE:
    dir=dfs.curdir;
    memcpy(&dfs, o, sizeof(DFS));
    dfs.curdir=dir;
    strcpy(dfs.curdir,o->curdir);
    delete o->curdir;
    delete o;
    return &dfs;
  case AFS_TYPE:
    dir=afs.curdir;
    memcpy(&afs, o, sizeof(AFS));
    afs.curdir=dir;
    if(dir==NULL)
      afs.set_dir_pointer(NULL,0);
    strcpy(afs.curdir,o->curdir);
    delete o->curdir;
    delete o;
    return &afs;
  case FTP_TYPE:
    if(is_this_ftp((FTP*)o)==0)
    {
      xncdprintf(("Lister::pop_vfs() FTP Object not in list\n"));
      return pop_vfs();
    }
    memcpy(&ftp, o, sizeof(FTP));
    ftp.ftp_to_bg((FTP*)o);
    delete o;
    return &ftp;
      
  };
  delete o;
  return &dfs;
}

//--------------------------------------------------------------------------
// Pop up previous vfs, reread and show directory
//--------------------------------------------------------------------------
void BaseCaptain::switch_to_prev_vfs()
{
  vfs->delete_vfs_list();
  vfs=pop_vfs();
  // *INDENT-OFF*        
  ::chdir(curdir);
  // *INDENT-ON*        
  vfs->ch_curdir();
  if (direc(curdir) == 0)
  {
    vfs_error("VFS", "Can't change to dir");
    show_vfs_error();
    vfs->chdir("..");
    vfs->getcwd(curdir, 1020);
    direc(curdir);
  }
  showdir();
}

//--------------------------------------------------------------------------
// Pop up vfses from stack, cleanup all stack, then switch
//--------------------------------------------------------------------------
void   BaseCaptain::switch_to_vfs(int vfs_type, char *dir)
{
  char  *name, *b;
  vfs->delete_vfs_list();
  if (vfs->fstype != DFS_TYPE)
    while (vfstack != NULL)
      pop_vfs();
  vfs = &dfs;
  switch (vfs_type)
  {
  case DFS_TYPE:
    vfs = &dfs;
    vfs->init_support(0);
    reset_cur();
    strcpy(curdir, dir);
    vfs->chdir(curdir);
    senddir(curdir);
    reread();
    expose_panel();
    break;
  case AFS_TYPE:
    vfs->delete_vfs_list();
    reset_cur();
    push_vfs(vfs);
    vfs = &afs;
    b = strrchr(dir, '/');
    *b = 0;
    // *INDENT-OFF*        
    if(*dir==0) 
      ::chdir("/");
    else 
      ::chdir(dir);
    // *INDENT-ON*        
    *b = '/';
    name = b + 1;
    if (afs.init_support(name) == 0)        //If error we return to prev VFS
    {
      show_vfs_error();
      vfs = pop_vfs();
    }
    // *INDENT-OFF*        
    ::chdir(curdir);
    // *INDENT-ON*        
    vfs->ch_curdir();
    direc(".");
    expose_panel();
    break;
  };
}

//--------------------------------------------------------------------------
//Push current VFS then switch to given FTP with its init.
//--------------------------------------------------------------------------
VFS* BaseCaptain::push_n_pop(FTP *p)
{
  vfs->delete_vfs_list();
  push_vfs(vfs);
  vfs = &ftp;
  ftp=*p;
  ftp.init_internals();
  vfs->ch_curdir();
  if (direc(curdir) == 0)
  {
    vfs_error("FTP", "Can't change to dir");
    show_vfs_error();
    vfs->chdir("..");
    vfs->getcwd(curdir, 1020);
    direc(curdir);
  }
  total_reread();
  return vfs;
}
  
//--------------------------------------------------------------------------
// Check current vfs and given one then if equal pop another one and show it
//--------------------------------------------------------------------------
void BaseCaptain::check_and_pop(VFS *vf)
{
  int res;
  switch(vf->fstype)
  {
  case DFS_TYPE:
    res=memcmp(vf,vfs,sizeof(DFS));
    break;
  case AFS_TYPE:
    res=memcmp(vf,vfs,sizeof(AFS));
    break;
  case FTP_TYPE:
    res=memcmp(vf,vfs,sizeof(FTP));
    break;
  default:
    res=1;
  }
  if(res==0)
    pop_and_show();
}

//--------------------------------------------------------------------------
//Pop vfs from vfs_stack and then show directory listing.
//--------------------------------------------------------------------------
void BaseCaptain::pop_and_show()
{
  vfs=pop_vfs();
  // *INDENT-OFF*        
  ::chdir(curdir);
  // *INDENT-ON*        
  vfs->ch_curdir();
  if (direc(curdir) == 0)
  {
    vfs_error(vfs->vfs_prefix, "Can't change to dir");
    show_vfs_error();
    vfs->chdir("..");
    vfs->getcwd(curdir, 1020);
    direc(curdir);
  }
  showdir();
}

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// Sorting functions
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

void   BaseCaptain::sortbyext()
{
  comp = extcmp;
  reread();
}

void   BaseCaptain::sortbysize()
{
  comp = sizecmp;
  reread();
}

void   BaseCaptain::sortbytime()
{
  comp = timecmp;
  reread();
}

void   BaseCaptain::sortbyname()
{
  comp = mystrcmp;
  reread();
}

void   BaseCaptain::sortbyunsort()
{
  comp = unsortcmp;
  reread();
}


//Clear fast find buffer
void   BaseCaptain::clear_ff()
{
  ff_buf[0] = '\0';
  last_ff = NULL;
}



//--------------------------------------------------------------------------
//Reread current directory, then calls virtual method for showing list of files
//--------------------------------------------------------------------------
void   BaseCaptain::reread()
{
  int    kn, kk, sel_fl = 0;
  if (selfiles)
  {
    sel_fl = 1;
    save_select();
  };
  if (cur)
    strcpy(refindchr, cur->name);
  else
    refindchr[0] = 0;
  if (vfs->ch_curdir() == -1)
    vfs->ch_to_rootdir();
  dl.next = fl.next = NULL;
  direc(curdir);
  if (refindchr[0] != 0)
  {
    if (!am_i_visible())
      curn = lcurn;
    kn = findentry(refindchr);
    if (kn != -1)
    {
      curn = kn % (th * col);
      kk = kn - curn;
      setcur(&base, kk);
      setcur(&cur, kn);
    }
  }
  if (sel_fl)
    restore_select();
  if (!am_i_visible())
  {
    lcurn = curn;
    curn = -1;
    if (lay == 0)
      showdir();
  }
  else
    showdir();
  xncdprintf(("Reread dir: %s\n",curdir));
}


//--------------------------------------------------------------------------
// Save selected files to special buffer
//--------------------------------------------------------------------------
void   BaseCaptain::save_select()
{
  FList *o=dl.next;
  int coun=0;
  xncdprintf(("BaseCaptain::save_select() %x->save_select1(%d)=%x\n",this, selfiles, asel));
  if(asel)
    delete asel;
  asel=NULL;
  if(selfiles==0)
    return;
  asel = new FList[selfiles];
  aselmax = 0;
  while(o)
  {
    if (o->options & S_SELECT)
      asel[aselmax++].init(o->name, o->mode, 0, 0, 0, 0);
    o=o->next;
    coun++;
  }
  xncdprintf(("BaseCaptain::save_select() %x->save_select2(%d/%d)=%x\n",this, selfiles, coun, asel));
}

//--------------------------------------------------------------------------
// Restore saved selections to current listing
//--------------------------------------------------------------------------
void   BaseCaptain::restore_select()
{
  FList *o;
  int coun=0;
  selsize = selfiles = 0;
  if(asel==NULL)
    return;
  for (int i = 0; i < aselmax; i++)
  {
    o=dl.next;
    while(o)
    {
      if (strcmp(o->name, asel[i].name) == 0)
      {
	o->options |= S_SELECT;
	selsize += o->size;
	selfiles++;
	break;
      }
      o=o->next;
      coun++;
    }
  }
  xncdprintf(("BaseCaptain::restore_select() %x->restore_select(%d/%d/%d)=%x...",this, selfiles, coun, aselmax, asel));
  delete asel;
  asel=NULL;
  xncdprintf(("...done\n"));
}

//--------------------------------------------------------------------------
// Find item in list by filename, sets it to current
//--------------------------------------------------------------------------
void   BaseCaptain::set_by_name(char *findchr)
{
  int    kn, kk;
  kn = findentry(findchr);
  if (kn != -1)
  {
    curn = kn % (th * col);
    kk = kn - curn;
    setcur(&base, kk);
    setcur(&cur, kn);
  }
}

//--------------------------------------------------------------------------
// Change current directory to newdir
//--------------------------------------------------------------------------
void   BaseCaptain::change_dir(char *newdir)
{
  char   findchr[250];
  int    findfl = 0, kn, kk;
  masks|=PANEL_CD_DONE;
  vfs->ch_curdir();
  if (vfs->chdir(newdir) == 0)
  {
    if (strcmp(newdir, "..") == 0)
    {
      findfl = 1;
      strcpy(findchr, strrchr(curdir, '/') + 1);
    };
    vfs->getcwd(curdir, 1020);
    dl.next = fl.next = NULL;
    direc(curdir);
    if (findfl != 0 && findchr[0] != 0)
    {
      kn = findentry(findchr);
      if (kn != -1)
      {
	curn = kn % (th * col);
	kk = kn - curn;
	setcur(&base, kk);
	setcur(&cur, kn);
      }
    }
    showdir();
  };
}

//--------------------------------------------------------------------------
// Select files from dir-list by mask
//--------------------------------------------------------------------------
void   BaseCaptain::select_by_mask(int sel)
{
  strcpy(maskchr, dbuf);
  FList *o = dl.next->next;
  int coun=0;
  char *fname=NULL;
  while (o != NULL)
  {
    if (is_filtered(o->name, maskchr))
    {
      if (sel)
      {
	if ((o->options & S_SELECT) == 0)
	{
	  o->options |= S_SELECT;
	  selfiles++;
	  coun++;
	  selsize += o->size;
	  if(!fname)
	    fname=o->name;
	};
      }
      else if (o->options & S_SELECT)
      {
	o->options ^= S_SELECT;
	selfiles--;
	coun++;
	selsize -= o->size;
      }
    }
    o = o->next;
  }
  if (selfiles < 0)
  {
    selfiles = 0;
    selsize = 0;
  }
  if(coun==0)
    simple_mes("Information","No files match given criteria.");
  else
  {
    showdir();
    if(fname)
      step_to_name(fname);
  }
}


//--------------------------------------------------------------------------
// Select given file
//--------------------------------------------------------------------------
void BaseCaptain::select_file(FList* o)
{
  o->options|=S_SELECT;
  selfiles++;
  selsize+=o->size;
}

//--------------------------------------------------------------------------
// Find file entry by name
//--------------------------------------------------------------------------
FList *BaseCaptain::find_file_entry(char *name)
{
  FList *o=dl.next;
  while(o)
  {
    if(strcmp(o->name,name)==0)
      return o;
    o=o->next;
  }
  return NULL;
}

//--------------------------------------------------------------------------
// Extract extension from file and set it to mask
//--------------------------------------------------------------------------
void   BaseCaptain::select_file_mask(int sel)
{
  char *name=cur->name;
  int l=strlen(name);
  if(name[l-1]=='.')
    return;
  char *b=strrchr(name,'.');
  if(b==NULL)
  {
    simple_mes("Sorry!", "Current FileName has no extension!");
    return;
  }
  sprintf(dbuf,"*%s",b);
  select_by_mask(sel);
}

//--------------------------------------------------------------------------
//Does name *s match filter *ff (1 - if it does, 0 - doesn't)
//--------------------------------------------------------------------------
int    BaseCaptain::is_filtered(char *s, char *ff)
{
  char  *f="";
  while (*s != 0)
  {
    f = ff;
    if (*f == '*')
    {
      f++;
      while (*f != 0 && *s != 0)
	if (*s == *f)
	  break;
	else
	  s++;
      if (*f == 0)
	return 1;
    }
    while (*s != 0 && *f != 0 && *f != '*')
      if (*f == '?')
      {
	f++;
	s++;
      }
      else if (*s != *f)
      {
	if (*ff == '*')
	  break;
	else
	  return 0;
      }
      else
      {
	s++;
	f++;
      };

    if (*f == '*')
      ff = f;
  }
  if (*f == 0 || *f == '*')
    return 1;
  return 0;
}

//--------------------------------------------------------------------------
//Search item in list by name and make it current
//--------------------------------------------------------------------------
void   BaseCaptain::step_to_name(char *name)
{
  FList *o = dl.next;
  int    kn = 0, kk=0;
  while (o)
    if (strcmp(o->name, name) == 0)
      break;
    else
    {
      o = o->next;
      kn++;
    };
  if (o != NULL)
  {
    base = dl.next;
    cur = o;
    lcurn = curn = kn % (th * col);
    kk = kn - curn;
    setcur(&base, kk);
    showfilelist();
    last_ff = o;
  }
}

//--------------------------------------------------------------------------
//
//               Global FS operations (copy/move/delete)...
//
//--------------------------------------------------------------------------


//--------------------------------------------------------------------------
// Delete file of selected files from current VFS, show progress bar
// and error messages if any
//--------------------------------------------------------------------------
void   BaseCaptain::fdelete()
{
  FList *pcur, *ko;
  VFS *pvfs=vfs;
  int    ferr = 0;
  disable_reread = 1;
  total_expose();
  set_recycle_state(0);
  if (vfs->is_del_supported() == 0)
  {
    simple_mes("Error", "Can't DELETE on this VFS");
    return;
  }
  create_infowin("Deleting...");
  if (selfiles == 0 || vfs->can_we_optimize_del())
  {
    if(selfiles)
      vfs->use_optimization();
    to_infowin(cur->name);
    if (vfs->remove(cur))
    {
      del_infowin();
      fserror("Delete File", cur);
    }
    else
      if(selfiles==0 && pvfs->bgbit==0) {
	if (cur->next)
	  cur->next->prev = cur->prev;
	cur->prev->next = cur->next;
	pcur = cur->next;
	ko = cur->prev;
	if (pcur)
	  cur = pcur;
	else
	{
	  cur = ko;
	  curn--;
	};
	del_infowin();
	showdir();
      };
    if(pvfs->bgbit)
      reread();
  }
  else
  {
    ko = dl.next;
    infowin_set_coun(selfiles);
    while (ko != NULL)
    {
      if (ko->options & S_SELECT)
      {
	to_infowin(ko->name);
	if (vfs->remove(ko))
	{
	  ko = ko->next;
	  ferr = 1;
	}
	else                // fserror("Delete Files");
	{
	  pcur = ko->next;
	  if (ko->next)
	    ko->next->prev = ko->prev;
	  ko->prev->next = ko->next;
	  selfiles--;
	  selsize -= ko->size;
	  ko = pcur;
	  infowin_update_coun(1);
	}
      }
      else
	ko = ko->next;
    }
    del_infowin();
    if (ferr)
    {
      ko = dl.next;
      while (ko != NULL)
	if (ko->options & S_SELECT)
	  break;
	else
	  ko = ko->next;
      fserror("Delete files", ko);
    }
    curn = 0;
    cur = base = dl.next;
    showdir();
  }
  disable_reread = 0;
}

//--------------------------------------------------------------------------
// Copy file of selected files from current VFS, show progress bar
// and error messages if any
//--------------------------------------------------------------------------
void   BaseCaptain::fcopy()
{
  FList *ko,*so;
  int    rcode = 0;
  VFS   *vfstmp,*pvfs;
  disable_reread = 1;
  total_expose();
  if (vfs->curdir[0] != '/')
    vfs->make_fullpath();
  if (selfiles != 0 && vfs->fstype == AFS_TYPE && vfs->is_full_extract_allowed())
  {
    if (vfs->check_for_full_extract(selfiles))
    {
      vfstmp = define_vfs(dbuf);
      afstmp_defined = 0;
      if (vfstmp == NULL)
      {
	show_vfs_error();
	return;
      }
      create_infowin("Copying...");
      to_infowin("Full Unpack");

      rcode = vfs->full_extract_to_vfs(vfstmp);

      del_infowin();
      if (!is_panel_vfs(vfstmp) && vfstmp->bgbit==0)
      {
	vfstmp->delete_vfs_list();
	vfstmp->close_fs();
      }
      if (rcode != 0 && ow_cancel == 0)
	show_vfs_error();
      else
      {
	selfiles = 0;
	selsize = 0;
      };
      flush_screen();
      disable_reread = 0;
      total_reread();
      vfs->ch_curdir();
      ow_all = 0;
      ow_cancel = ow_no = 0;
      return;
    }
  }

  vfstmp = define_vfs(dbuf);
  afstmp_defined = 0;
  if (vfstmp == NULL)
  {
    show_vfs_error();
    return;
  }
  if (vfstmp->is_copy_supported() == 0)
  {
    simple_mes("Error", "Can't COPY on this VFS");
    return;
  }
  create_infowin("Copying...");

  if (selfiles == 0 || vfs->can_we_optimize() ||
      (vfstmp->fstype == FTP_TYPE && vfstmp->can_we_optimize()) ||
      (vfstmp->fstype == AFS_TYPE && vfstmp->is_pocket_addition_allowed()))
  {
    if (selfiles == 0)
      to_infowin(cur->name);
    else
      to_infowin("Pocket operation");
    if (selfiles)
      vfs->use_optimization();
    pvfs=vfs;
    rcode = vfs->copy(cur, vfstmp);
    so=NULL;
    if(rcode==0 && pvfs->bgbit)        //Are we in background?
    {
      selfiles=selsize=0;                //Yes! So some cleanups.
    } else        
      if (selfiles)
      {
	ko = dl.next;
	selfiles = 0;
	selsize = 0;
	while (ko != NULL)
	{
	  if (ko->options & S_SELECT)
	  {
	    selfiles++;
	    selsize += ko->size;
	    so=ko;
	  }
	  ko = ko->next;
	}
      }
    del_infowin();
    if (!is_panel_vfs(vfstmp) && vfstmp->bgbit==0)
    {
      vfstmp->delete_vfs_list();
      vfstmp->close_fs();
    }
    if (rcode != 0 && ow_cancel == 0)
      fserror("Copy file", so ? so : cur);
    flush_screen();
  }
  else
  {
    ko = dl.next;
    infowin_set_coun(selsize);
    while (ko != NULL)
    {
      if (ko->options & S_SELECT)
      {
	to_infowin(ko->name);
	ow_no = 0;
	rcode = vfs->copy(ko, vfstmp) ? 1 : 0;
	if (rcode && ow_cancel)
	  break;
	if (rcode == 0 && ow_no == 0)
	{
	  ko->options ^= S_SELECT;
	  selfiles--;
	  selsize -= ko->size;
	  infowin_update_coun(ko->size);
	  show_item(ko);
	  flush_screen();
	}
	showfinfo(ko);
      };
      ko = ko->next;
    }
    del_infowin();
    if (rcode && ow_cancel == 0)
    {
      ko = dl.next;
      while (ko != NULL)
	if (ko->options & S_SELECT)
	  break;
	else
	  ko = ko->next;
      fserror("Copy files", ko);
    }
    if (!is_panel_vfs(vfstmp) && vfstmp->bgbit==0)
    {
      vfstmp->delete_vfs_list();
      vfstmp->close_fs();
    }
  }
  disable_reread = 0;
  total_reread();
  vfs->ch_curdir();
  ow_all = 0;
  ow_cancel = ow_no = 0;
}


//--------------------------------------------------------------------------
// Copy file of selected files from current VFS, show progress bar
// and error messages if any
//--------------------------------------------------------------------------
void   BaseCaptain::fmove()
{
  FList *ko;
  int    ferr = 0;
  int    rcode;
  VFS   *vfstmp;
  disable_reread = 1;
  total_expose();
  if (vfs->curdir[0] != '/')
    vfs->make_fullpath();
  create_infowin("Moving...");
  if (selfiles == 0)
  {
    to_infowin(cur->name);
    vfstmp = define_vfs(dbuf);
    afstmp_defined = 0;
    if (vfstmp == NULL)
    {
      del_infowin();
      show_vfs_error();
      return;
    }
    if ((vfstmp->is_move_supported()) == 0)
    {
      del_infowin();
      simple_mes("Error", "Can't MOVE on this VFS");
      return;
    }
    rcode = vfs->move(cur, vfstmp);
    if (!is_panel_vfs(vfstmp) && vfstmp->bgbit==0)
    {
      vfstmp->delete_vfs_list();
      vfstmp->close_fs();
    }
    if (rcode && ow_cancel == 0)
    {
      del_infowin();
      fserror("Move file", cur);
    }
    else
      del_infowin();
  }
  else
  {
    ko = dl.next;
    vfstmp = define_vfs(dbuf);
    afstmp_defined = 0;
    if (vfstmp == NULL)
    {
      del_infowin();
      show_vfs_error();
      return;
    }
    if ((vfstmp->is_move_supported()) == 0)
    {
      del_infowin();
      simple_mes("Error", "Can't MOVE on this VFS");
      return;
    }
    infowin_set_coun(selsize);
    while (ko != NULL)
    {
      if (ko->options & S_SELECT)
      {
	to_infowin(ko->name);
	ow_no = 0;
	ferr = vfs->move(ko, vfstmp) ? 1 : 0;
	if (ferr && ow_cancel)
	  break;
	if (ferr == 0 && ow_no == 0)
	{
	  ko->options ^= S_SELECT;
	  selfiles--;
	  selsize -= ko->size;
	  show_item(ko);
	  showfinfo(ko);
	  infowin_update_coun(ko->size);
	  flush_screen();
	};
      };
      ko = ko->next;
    }
    del_infowin();
    if (ferr && ow_cancel == 0)
    {
      ko = dl.next;
      while (ko != NULL)
	if (ko->options & S_SELECT)
	  break;
	else
	  ko = ko->next;
      fserror("Move files", ko);
    }
    if (!is_panel_vfs(vfstmp) && vfstmp->bgbit==0)
    {
      vfstmp->delete_vfs_list();
      vfstmp->close_fs();
    }
  }
  flush_screen();
  disable_reread = 0;
  total_reread();
  vfs->ch_curdir();
  ow_cancel = ow_no = ow_all = 0;

}

//--------------------------------------------------------------------------
// Making directory on current VFS
//--------------------------------------------------------------------------
void   BaseCaptain::fmkdir()
{
  VFS *pvfs=vfs;
  FList *o = new FList(dbuf, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
  if (vfs->mkdir(dbuf, o->mode) == 0)
  {
    if(pvfs->bgbit==0)
    {
      strcpy(cur->name, dbuf);
      vfs->need_reread=1;
      vfs->options|=REALREAD_BIT;
      disable_reread=0;
    }
    reread();
  }
  else
    fserror("Make directory", o);
  delete o;
}

//--------------------------------------------------------------------------
// Trying reread current directory and show listing
//--------------------------------------------------------------------------
void   BaseCaptain::try_reread_dir()
{
  time_t tt;
  if (disable_reread == 0)
  {
    if (scanfl)
    {
      if (vfs->ch_curdir() == -1)
	vfs->ch_to_rootdir();
      direc(curdir);
      scanfl = 0;
      if (!am_i_visible())
	curn = -1;
      showdir();
    }
    else
    {
      if(vfs->need_reread)
      {
	reread();
	if(lay == 0 && other_vfs()->need_reread)
	  other()->reread();
      } else
      {
	time(&tt);
	if (tt < lastscan + dirdelay)
	  showdir();
	else
	{
	  total_reread();
	}
      }
    }
  }
  else
    showdir();
}

//--------------------------------------------------------------------------
// Change owners on current or selected files
//--------------------------------------------------------------------------
void   BaseCaptain::chowns()
{
  int    i = 0;
  char  *gr = NULL;
  int    r=0, ui, gi;
  FList *o, *oo=NULL;
  while (dbuf[i] != 0 && dbuf[i] != '.')
    i++;
  if (dbuf[i] == '.')
  {
    dbuf[i] = 0;
    gr = dbuf + i + 1;
  };
  ui = finduserid_by_name(dbuf);
  if (gr != NULL)
    gi = findgroupid_by_name(gr);
  else
    gi = -1;
  if (selfiles == 0)
  {
    r = vfs->chown(cur->name, ui, gi);
    oo = cur;
  }
  else
  {
    o = dl.next;
    while (o != NULL)
    {
      if (o->options & S_SELECT)
      {
	if (vfs->chown(o->name, ui, gi) == -1)
	{
	  r |= -1;
	  oo = o;
	}
	else
	{
	  o->options ^= S_SELECT;
	  selfiles--;
	  selsize -= o->size;
	}
      }
      o = o->next;
    }
  }
  if (r == -1)
  {
    errno2mes();
    fserror("Change Owner", oo);
  }
}

//--------------------------------------------------------------------------
// Parse file though MAGIC database (man file :)
//--------------------------------------------------------------------------
void   BaseCaptain::do_quick_file()
{
  if(!cur)
    return;
  if(cur->magic[0]==0)
    vfs->magic_file_process(cur);
  if(cur->magic[0])
    show_string_info(cur->magic);
}


//--------------------------------------------------------------------------
// Show file listing
//--------------------------------------------------------------------------
void   BaseCaptain::showfilelist()
{
  FList *fo = base;
  int    i = 0, al = col * th;
  while (fo != NULL && i < al)
  {
    showitem(fo, i);
    fo = fo->next;
    i++;
  }
  while (i < al)
  {
    showempty(i);
    i++;
  };
}

//--------------------------------------------------------------------------
// Move cursor to one line down
//--------------------------------------------------------------------------
void   BaseCaptain::go_downline()
{
  clear_ff();
  if (cur->next)
  {
    curn++;
    cur = cur->next;
    if (curn >= col * th)
    {
      curn--;
      base = base->next;
      showfilelist();
    }
    else
    {
      showitem(cur->prev, curn - 1);
      showitem(cur, curn);
    }
  }
}

//--------------------------------------------------------------------------
// Move cursor to one line up
//--------------------------------------------------------------------------
void   BaseCaptain::go_upline()
{
  clear_ff();
  if (cur->prev != &dl)
  {
    curn--;
    cur = cur->prev;
    if (curn < 0)
    {
      curn = 0;
      base = base->prev;
      showfilelist();
    }
    else
    {
      showitem(cur->next, curn + 1);
      showitem(cur, curn);
    }
  }
}

//--------------------------------------------------------------------------
// Move cursor to home
//--------------------------------------------------------------------------
void   BaseCaptain::go_home()
{
  if(cur!=dl.next)
  {
    base = dl.next;
    cur = base;
    curn = 0;
    showdir();
  }
}

//--------------------------------------------------------------------------
// Move cursor to end
//--------------------------------------------------------------------------
void    BaseCaptain::go_end()
{
  FList *o=dl.next;
  int n=0;
  while(o->next)
  {
    o=o->next;
    n++;
  }
  if(cur==o)
    return;
  base=dl.next;
  cur=o;
  curn=n % (th*col);
  setcur(&base, n-curn);
  showdir();
}

//--------------------------------------------------------------------------
// Move cursor to left column
//--------------------------------------------------------------------------
void   BaseCaptain::left()
{
  int    i = 0;
  FList *pcur;
  pcur = cur;
  if (setcur(&cur, -th))
  {
    curn -= th;
    if (curn < 0)
    {
      curn += th;
      if (setcur(&base, -th) == 0)
      {
	base = dl.next;
	pcur = base;
	curn = 0;
	while (pcur != cur)
	{
	  pcur = pcur->next;
	  curn++;
	};
      };
      showdir();
    }
    else
    {
      showitem(pcur, curn + th);
      showitem(cur, curn);
    }
  }
  else if (cur != dl.next)
  {
    i = curn;
    curn = 0;
    showitem(pcur, i);
    if (base != dl.next)
    {
      base = cur = dl.next;
      showdir();
    }
    else
    {
      cur = dl.next;
      showitem(cur, curn);
    };
  }
}

//--------------------------------------------------------------------------
// Move cursor to right column
//--------------------------------------------------------------------------
void   BaseCaptain::right()
{
  FList *pcur, *ko;
  int    i = 0;
  pcur = cur;
  if (setcur(&cur, th))
  {
    curn += th;
    if (curn >= th * col)
    {
      curn -= th;
      setcur(&base, th);
      showfilelist();
    }
    else
    {
      showitem(pcur, curn - th);
      showitem(cur, curn);
    }
  }
  else
  {
    i = 0;
    ko = cur;
    while (cur->next != NULL)
    {
      i++;
      cur = cur->next;
    };
    if (i > 0)
    {
      curn += i;
      showitem(ko, curn - i);
      if (curn >= th * col)
      {
	curn -= th;
	setcur(&base, th);
	showdir();
      }
      else
	showitem(cur, curn);
    };
  };
}

//--------------------------------------------------------------------------
// Move cursor one page up
//--------------------------------------------------------------------------
void   BaseCaptain::page_up()
{
  int    i = 0;
  FList *pcur;
  pcur = cur;
  if (setcur(&cur, -th *col))
  {
    if (setcur(&base, -th*col) == 0)
    {
      base = dl.next;
      pcur = base;
      curn = 0;
      while (pcur != cur)
      {
	pcur = pcur->next;
	curn++;
      };
    };
    showdir();
  }
  else if (cur != dl.next)
  {
    i = curn;
    curn = 0;
    showitem(pcur, i);
    if (base != dl.next)
    {
      base = cur = dl.next;
      showdir();
    }
    else
    {
      cur = dl.next;
      showitem(cur, curn);
    };
  }
}

//--------------------------------------------------------------------------
// Move cursor one page down
//--------------------------------------------------------------------------
void  BaseCaptain::page_down()
{
  FList *pcur, *ko;
  int    i = 0;
  pcur = cur;
  if (setcur(&cur, th * col))
  {
    setcur(&base, th*col);
    showfilelist();
  }
  else
  {
    i = 0;
    ko = cur;
    while (cur->next != NULL)
    {
      i++;
      cur = cur->next;
    };
    if (i > 0)
    {
      curn += i;
      showitem(ko, curn - i);
      if (curn >= th * col)
      {
	curn -= th * col;
	setcur(&base, th * col);
	showdir();
      }
      else
	showitem(cur, curn);
    };
  };
}

//--------------------------------------------------------------------------
// Compare two panels and highlight difference
//--------------------------------------------------------------------------
void BaseCaptain::compare_panels()
{
  FList *o=dl.next->next, *oo;
  selfiles=selsize=0;
  while(o)
  {
    oo=other()->find_file_entry(o->name);
    if(oo==NULL)
      select_file(o);
    else
      if(compare_by_size && o->size!=oo->size)
	select_file(o);
      else
	if(compare_by_time && o->time!=oo->time)
	  select_file(o);
    o=o->next;
  }
  if(am_i_visible() || lay==0)
    showdir();
}

//--------------------------------------------------------------------------
// Set attributes to current file
//--------------------------------------------------------------------------
void   BaseCaptain::setattr()
{
  vfs->ch_curdir();
  if (vfs->chmod(cur->name, cur->mode) == -1)
  {
    errno2mes();
    fserror("Set attributes", cur);
  }
  total_reread();
}

//--------------------------------------------------------------------------
// Push current vfs and try to switch to new ftp
//--------------------------------------------------------------------------
void   BaseCaptain::do_ftp_link()
{
  vfs->delete_vfs_list();
  push_vfs(vfs);
  vfs = &ftp;
  if (ftp.init_support((char*)&ftprec) == 0)        //If error we return to panels DFS
  {
    show_vfs_error();
    vfs = pop_vfs();
  } else
    if(ftp.bgbit)
      vfs=pop_vfs();
  // *INDENT-OFF*        
  ::chdir(curdir);
  // *INDENT-ON*        


  vfs->ch_curdir();
  if (direc(curdir) == 0)
  {
    vfs_error(vfs->vfs_prefix, "Can't change to dir");
    show_vfs_error();
    vfs->chdir("..");
    vfs->getcwd(curdir, 1020);
    direc(curdir);
  }
  showdir();
}

//******************************** Virtual Methods ***********************************

BaseVirtual(void,showdir())
BaseVirtual(void,fserror(char*,FList*))
BaseVirtual(void,total_expose())
BaseVirtual(void,set_recycle_state(int))
BaseVirtual(void,create_infowin(char *head))
BaseVirtual(void,del_infowin())
BaseVirtual(void,to_infowin(char *str))
BaseVirtual(void,infowin_set_coun(int))
BaseVirtual(void,infowin_update_coun(int))
BaseVirtual(void,total_reread())
BaseVirtual(void,flush_screen())
BaseVirtual(void,show_item(FList*))
BaseVirtual(void,showfinfo(FList*))
BaseVirtual(void,expose_panel())
BaseVirtual(void,showdirname())
BaseVirtual(void,showitem(FList*,int))
BaseVirtual(void,showempty(int))
BaseVirtual(void,show_ff_item(int,int))
BaseVirtual(void,show_string_info(char*))

rBaseVirtual(int,am_i_visible(),0)
rBaseVirtual(int,is_panel_vfs(VFS*),0)
rBaseVirtual(BaseCaptain*,other(),0)
rBaseVirtual(VFS*,other_vfs(),0)



