/****************************************************************************
*  Copyright (C) 1996-97 by Leo Khramov
*  email:     leo@xnc.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/

#include "panel.h"
#include "xnc.icon"
#include "xncm.icon"
#include "bookmark.h"
#include "xncversion.h"
#include "tartest.h"
#include "geomfuncs.h"
#include "image/image.h"
#include "xnimlib.h"
#include "flist.h"
#include "pluginman.h"

char       home_files_dir[1024];

int        use_prompt=~0;        //By default activate all prompt windows.

//Additinal options for XNC at startup. Overwrites by xnc.cfg
int        option_bits=FILLED_CURSOR | IVES_EXIT_TOO |
                       STATUS_ATTR | STATUS_NAME | STATUS_TIME | STATUS_SIZE | STATUS_OWNER; 

int        xnc_ver=0,                //XNC version stored in config file
           xnc_orig_ver=0;          //Original XNC version
int        init_starts=0, xnc_starts=0;

int        wm_y_correction=21;      //Correction for Window manager title window


char       magic_file_location[256]="/usr/share/magic";

extern int detect_tar_output(char *path);

void init_inodewin_with_position(int x, int y);
int  get_inodewin_position(int *x, int *y);


void str2version(char *str,int *ver)
{
        int version=0,major=0,minor=0;
        sscanf(str,"%d.%d.%d",&version,&major,&minor);
        *ver=version*100+major*10+minor;
}

int create_file(char *path, char *fname, char *buf, int siz)
{
        char str[2048];
        int fp;
        sprintf(str,"%s/%s",path,fname);
        fp=open(str,O_WRONLY | O_CREAT,0600);
        if(fp==-1)
	  return 0;
        write(fp,buf,siz);
        close(fp);
        return 1;
}

int is_new_version()
{
  char tmp[1024];
  FILE *fp;
  if(getenv("HOME")==0)
    return 1;
  sprintf(tmp, "%s/.xnc/current-"XNCVERSION, getenv("HOME"));
  fp=fopen(tmp, "r");
  if(fp)
    {
      fclose(fp);
      return 0;
    }
  fp=fopen(tmp, "w");
  if(fp)
    {
      fputs(XNCVERSION, fp);
      fclose(fp);
    }
  return 1;
}

int auto_create_startup_files(char *path)
{
        int oldtar=detect_tar_output(path);
        if(create_file(path,"xnc.ini",xncini_chr,xncini_chr_size)==0) return 0;
        switch(oldtar)
        {
                case GNUTAR_1_11:
                        if(create_file(path,"xnc.afs",xncafs_chr,xncafs_chr_size)==0) return 0;
                        break;
                case GNUTAR_1_12:
                        if(create_file(path,"xnc.afs",xncafstar_chr,xncafstar_chr_size)==0) return 0;
                        break;
                case OPENTAR_1_11:
                        if(create_file(path,"xnc.afs",xncafsopenbsd_chr,xncafsopenbsd_chr_size)==0) return 0;
                        break;
                case AIXTAR_1:
                        if(create_file(path,"xnc.afs",xncafsaix_chr,xncafsaix_chr_size)==0) return 0;
                        break;
                default:
                        fprintf(stderr, "Detected unknown [%d] tar output! Use default...\n",oldtar);
                        if(create_file(path,"xnc.afs",xncafs_chr,xncafs_chr_size)==0) return 0;
                        break;
        }
        if(create_file(path,"xnc.ext",xncext_chr,xncext_chr_size)==0) return 0;
        if(create_file(path,"xnc.cfg",xnccfg_chr,xnccfg_chr_size)==0) return 0;
        if(create_file(path,"xnc.menu",xncmenu_chr,xncmenu_chr_size)==0) return 0;
        if(create_file(path,"xnc.keys",xnckeys_chr,xnckeys_chr_size)==0) return 0;
        return 1;
}

void   make_home_file_dir()
{
  char   str[1024];
  int    fp;
  if(getenv("HOME")==NULL)
  {
          perror("FATAL ERROR: can't resolve 'HOME' environment");
          exit(-1);
  }
  sprintf(str, "%s/.xnc/xnc.ini", getenv("HOME"));
  fp = open(str, O_RDONLY);
  if (fp == -1)
    {
      sprintf(str,"%s/.xnc",getenv("HOME"));
      mkdir(str,0700);
      if(auto_create_startup_files(str))
      {
          strcpy(home_files_dir, getenv("HOME"));
          strcat(home_files_dir, "/.xnc");
      } else
      {
      strcpy(home_files_dir, XNC_DIR);
      strcat(home_files_dir, "/xnc");
      }

      fprintf(stderr,"\n-------------------------------------------------------------\n");    
      fprintf(stderr, "WARNING: User configuration files not found - using system ones...\n");
      fprintf(stderr, "Please, run **' xncsetup '** for configuring your own settings for XNC.....\n");
      fprintf(stderr,"-------------------------------------------------------------\n\n");    
      sleep(2);
      sprintf(str, "%s/xnc.ini", home_files_dir);
      fp = open(str, O_RDONLY);
      if (fp == -1)
        fprintf(stderr, "\nWARNING: System default configuration files not found ...\n");
      else
        close(fp);
      return;
    }
  else
    close(fp);
  strcpy(home_files_dir, getenv("HOME"));
  strcat(home_files_dir, "/.xnc");
}



extern char build_chr[];
char   xncvt[100];
char   geom[100];
extern char host[];
extern int afs_disabled;
extern int ftp_cache_disabled;

int    margc;
int    centerx, centery;
char **margv;
int    ScreenL, ScreenH;
int    allow_t_raising = 1;

char **ext = NULL;
char **extcom;
char **menunames;
char **menucom;
KeySym *mkeys = NULL;
int    extmax = 0, menumax = 0;
int    term_sticky = 1;
int    hide_hidden = 0;

int    findmenukey(KeySym ks)
{
  for (int i = 0; i < menumax; i++)
    if (mkeys[i] == ks)
      return i;
  return -1;
}

int    fstring(FILE * fp, char *str)
{
  char  *s = str;
  while (!feof(fp))
    {
      *str = (char)fgetc(fp);
      if (*str == '\n')
        {
          *str = 0;
          return 1;
        };
      str++;
    };
  *str = 0;
  if (*s)
    return 1;
  return 0;
}

char  *strscan(char *src, char *dest)
{
  while (*src != 0 && *src != ':')
    *dest++ = *src++;
  *dest = 0;
  return ++src;
}

char  *strscan2(char *src, char *dest)
{
  while (*src == ' ')
    src++;
  while (*src != 0 && *src != ' ' && *src != 0xa)
    *dest++ = *src++;
  *dest = 0;
  return ++src;
}

void   del_ext()
{
  int    i;
  if (ext != NULL)
    {
      for (i = 0; i < extmax; i++)
        {
          delete ext[i];
          delete extcom[i];
        }
      delete ext;
      delete extcom;
      ext = NULL;
    }
}

void   del_menu()
{
  int    i;
  if (mkeys != NULL)
    {
      for (i = 0; i < menumax; i++)
        {
          if (menunames[i])
            delete menunames[i];
          if (menucom[i])
            delete menucom[i];
        }
      delete menunames;
      delete menucom;
      delete mkeys;
      mkeys = NULL;
    }
}

int    ext_find(char *name)
{
  int    l = strlen(name), i, nl, el, fl;
  for (i = 0; i < extmax; i++)
    {
      el = strlen(ext[i]);
      nl = l;
      fl = 1;
      while (el >= 0)
        if (name[nl] != ext[i][el])
          {
            fl = 0;
            break;
          }
        else
          {
            el--;
            nl--;
          };
      if (fl)
        return i;
    }
  return -1;
}

int    ext_find2(char *name, int n)
{
  int    l = strlen(name), i, nl, el, fl, k = 0;
  for (i = 0; i < extmax; i++)
    {
      el = strlen(ext[i]);
      nl = l;
      fl = 1;
      while (el >= 0)
        if (name[nl] != ext[i][el])
          {
            fl = 0;
            break;
          }
        else
          {
            el--;
            nl--;
          };
      if (fl)
        {
          if (k == n)
            return i;
          else
            k++;
        };
    }
  return -1;
}

void   load_ext()
{
  FILE  *fp;
  int    i;
  char   str[120];
  char   str1[80];
  char  *chr;
  int    show_dots = 1;
  if (ext != NULL)
    show_dots = 0;
  del_ext();
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/xnc.ext");
  if ((fp = fopen(rfile, "r")) != NULL)
    {
      i = 0;
      while (fstring(fp, str))
        if (str[0] == '.')
          i++;
      fseek(fp, 0l, SEEK_SET);
      ext = new char *[i];
      extcom = new char *[i];
      i = 0;
      while (fstring(fp, str))
        {
          chr = strscan(str, str1);
          if (str1[0] == '.')
            {
              ext[i] = new char[strlen(str1) + 1];
              strcpy(ext[i], str1);
              strscan(chr, str1);
              extcom[i] = new char[strlen(str1) + 1];
              strcpy(extcom[i], str1);
              i++;
              if (show_dots)
                fprintf(stderr, ".");
            }
        }
      extmax = i;
      fclose(fp);
    }
  else
    fprintf(stderr, "XNC Error: No extension file found...");
}

void   load_menu()
{
  FILE  *fp;
  int    i, j;
  char   str[120];
  char   str1[120];
  char  *chr;
  int    show_dots = 1;
  if (mkeys != NULL)
    show_dots = 0;
  del_menu();
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/xnc.menu");
  if ((fp = fopen(rfile, "r")) != NULL)
    {
      i = 0;
      while (fstring(fp, str))
        if (str[0] != '#' && str[0] != ' ' && str[0] != 0xa && str[0] != 0)
          i++;
      fseek(fp, 0l, SEEK_SET);
      mkeys = new KeySym[i];
      menucom = new char *[i];
      menunames = new char *[i];
      menumax = i;
      for (j = 0; i < j; j++)
        {
          menucom[i] = NULL;
          menunames[i] = NULL;
        }
      i = 0;
      while (fstring(fp, str))
        {
          chr = strscan(str, str1);
          if (str1[0] != '#')
            {
              mkeys[i] = XStringToKeysym(str1);
              chr = strscan(chr, str1);
              *(chr - 1) = 0;
              menunames[i] = new char[strlen(str) + 1];
              strcpy(menunames[i], str);
              strscan(chr, str1);
              menucom[i] = new char[strlen(str1) + 1];
              strcpy(menucom[i], str1);
              i++;
              if (show_dots)
                fprintf(stderr, ".");
            }
        }
      fclose(fp);
    }
  else
    fprintf(stderr, "XNC Error: No menu file found...");
}


//////////////////////////////////////////////////////////////////////////

char  bgchr[50] = "white", 
      fgchr[50] = "black", 
      fontchr[100] = "fixed", 
      lfontchr[100] = "fixed",
      vfontchr[100] = "fixed", 
      fixfontchr[100] = "fixed", 
      mfixfontchr[100] = "fixed",
      kbgchr[50] = "#9cb0c4", 
      *dispchr = NULL, 
      selectchr[50] = "#4000f0", 
      editname[100] = "jed",
      viewname[100] = "less", 
      syspath[2048] = ".", 
      *traise = "yes", 
      *tsticky = "yes",
      geometrychr[100] = "0x1000+0+0", 
      viewgeom[100] = "400x400+20+40", 
      *banim = "yes",
      bshow[50] = "yes", 
      *diriconchr = "yes", 
      *fileiconchr = "yes", 
      updatechr[50] = "never";

char   rfile[80];
int    allow_animation = 1;
int    allow_bookmark = 1;
int    allow_dir_icon = 1;
extern int dont_update;
int    allow_file_icon = 1;

char bgchr1[50];
char bgchr2[50];
char bgchr3[50];
char bgchr4[50];
char bgchr5[50];
char bgchr6[50];
char bgchr7[50];
char bgchr8[50];
char bgchr9[50];
char bgchr10[50];
char bgchr11[50];

Lister *panel = NULL;

X_PAR  resources[] =
{
  "leoprogs.background", "LeoProgs.Background", bgchr,
  "leoprogs.foreground", "LeoProgs.Foreground", fgchr,
  "leoprogs.keys.background", "LeoProgs.Keys.Background", kbgchr,
  "leoprogs.font", "LeoProgs.Font", fontchr,
  "leoprogs.selectedcolor", "LeoProgs.SelectedColor", selectchr,
  "leoprogs.list.font", "LeoProgs.List.Font", lfontchr,
  "leoprogs.font.fixed", "LeoProgs.Font.Fixed", fixfontchr,
  "xnc.editor.name", "Xnc.Editor.Name", editname,
  "xnc.sysfiles.path", "Xnc.SysFiles.Path", syspath,
  "xnc.geometry", "Xnc.Geometry", geometrychr,
  "leoprogs.viewer.font", "LeoProgs.Viewer.Font", vfontchr,
  "xnc.viewer.name", "Xnc.Viewer.Name", viewname,
  "xnc.viewer.geometry", "Xnc.Viewer.Geometry", viewgeom,
  "xnc.bookmark.show_and_use", "Xnc.BookMark.Show_and_Use", bshow,
  "leoprogs.font.minifixed", "LeoProgs.Font.MiniFixed", mfixfontchr,
  "xnc.afs.update", "Xnc.AFS.Update", updatechr
};

int    resn = sizeof(resources) / sizeof(X_PAR);

X_PAR  colors[] =
{
  "leoprogs.syscolor1", "LeoProgs.SysColor1", bgchr,
  "leoprogs.syscolor2", "LeoProgs.SysColor2", bgchr1,
  "leoprogs.syscolor3", "LeoProgs.SysColor3", bgchr2,
  "leoprogs.syscolor4", "LeoProgs.SysColor4", bgchr3,
  "leoprogs.syscolor5", "LeoProgs.SysColor5", bgchr4,
  "leoprogs.syscolor6", "LeoProgs.SysColor6", bgchr5,
  "leoprogs.list.normfile", "LeoProgs.SysColor7", bgchr6,
  "leoprogs.list.directory", "LeoProgs.SysColor8", bgchr7,
  "leoprogs.list.execution", "LeoProgs.SysColor9", bgchr8,
  "leoprogs.list.extensions", "LeoProgs.SysColor10", bgchr9,
  "leoprogs.list.link", "LeoProgs.SysColor11", bgchr10,
  "leoprogs.afs.color", "LeoProgs.AFS.Color", bgchr11
};

int    coln = sizeof(colors) / sizeof(X_PAR);

unsigned long keyscol[3];
unsigned long cols[12];
unsigned long skincol[256];

XFontStruct *fontstr;
XFontStruct *lfontstr;
XFontStruct *vfontstr;
XFontStruct *fixfontstr;
XFontStruct *mfixfontstr;
unsigned long bgpix, fgpix, selectpix;

XWMHints *pxwmh;
XSizeHints *pxsh;
XClassHint *pch;
XTextProperty wname;
XTextProperty iname;
Display *disp;
Window Main;
Window Key;
GC     gc;
XGCValues gcv;
XEvent ev;
XrmDatabase rdb;
XrmValue rmv;
XColor color;
Colormap defcmp;
int    done = 0;
int    scr;
int    Mainl, Mainh, Mainx, Mainy;

int    viewx, viewy;
uint   viewl, viewh;

List   el, l_exp;

Gui   *find(Window ww)
{
  List  *cur = el.next;
  while (cur != NULL)
    if (cur->w == ww)
      break;
    else
      cur = cur->next;
  if (cur)
    return cur->obj;
  return NULL;
}


Gui   *findexp(Window ww)
{
  List  *cur = l_exp.next;
  while (cur != NULL)
    if (cur->w == ww)
      break;
    else
      cur = cur->next;
  if (cur)
    return cur->obj;
  return NULL;
}

void   addto_exp(Gui * o, Window w)
{
  List  *cur = new List;
  cur->obj = o;
  cur->w = w;
  cur->next = l_exp.next;
  if (l_exp.next)
    l_exp.next->prev = cur;
  l_exp.next = cur;
  cur->prev = &l_exp;
}

void   addto_el(Gui * o, Window w)
{
  List  *cur = new List;
  cur->obj = o;
  cur->w = w;
  cur->next = el.next;
  if (el.next)
    el.next->prev = cur;
  el.next = cur;
  cur->prev = &el;
  addto_exp(o, w);
}

void   delfrom_exp(Gui * o)
{
  List  *cur = l_exp.next;
  while (cur != NULL)
    if (cur->obj == o)
      break;
    else
      cur = cur->next;
  if (cur != NULL)
    {
      cur->prev->next = cur->next;
      if (cur->next)
        cur->next->prev = cur->prev;
      delete cur;
    }
}

void   delfrom_el(Gui * o)
{
  List  *cur = el.next;
  while (cur != NULL)
    if (cur->obj == o)
      break;
    else
      cur = cur->next;
  if (cur != NULL)
    {
      cur->prev->next = cur->next;
      if (cur->next)
        cur->next->prev = cur->prev;
      delete cur;
    }
}

void   delall_el()
{
  List  *cur, *cur2;
  cur = el.next;
  while (cur != NULL)
    {
      cur2 = cur->next;
      delete cur;
      cur = cur2;
    }
}

void   delall_exp()
{
  List  *cur, *cur2;
  cur = l_exp.next;
  while (cur != NULL)
    {
      cur2 = cur->next;
      delete cur;
      cur = cur2;
    }
}


unsigned long gencol(XColor & col, int per)
{
  int    r = 0, g = 0, b = 0, pr;
  XColor cl = col;
  r = (int)col.red;
  b = (int)col.blue;
  g = (int)col.green;
  pr = 100 + per;
  r = r * pr / 100;
  g = g * pr / 100;
  b = b * pr / 100;
  if (r > 65535)
    r = 65535;
  if (g > 65535)
    g = 65535;
  if (b > 65535)
    b = 65535;
  cl.red = r;
  cl.green = g;
  cl.blue = b;
  cl.flags = DoGreen | DoRed | DoBlue;
  if (im_AllocColor(disp, defcmp, &cl) != 0)
    return cl.pixel;
  else
    fprintf(stderr, "Error in gencol\n");
  return 0;
}

void   GenerateColors()
{
  if (XParseColor(disp, defcmp, resources[2].pstr, &color) == 0 ||
      im_AllocColor(disp, defcmp, &color) == 0)
    keyscol[1] = WhitePixel(disp, scr);
  else
    keyscol[1] = color.pixel;
  keyscol[0] = gencol(color, -40);
  keyscol[2] = gencol(color, 30);
}

Pixmap picon;
Pixmap piconmask;
char  *icname = "XNC";
int    layout = 1;
char   winame[200];
extern Display *Xdisplay;
extern char l_bg_string[];
extern const char* display_name;
void   InitXClient(int argc, char **argv, int wx, int wy, int wl, int wh, char
                   *winname)
{
  struct utsname uts;
  int    i, ppx, ppy;
  XWindowAttributes xwinattr;
  uint   ppl, pph;
  char  *rmt;
  char   tmppath[256];
  XSetWindowAttributes xswa;
  make_home_file_dir();
  fprintf(stderr, "XClient..........OK [Display '%s']\n", display_name);
/*
   for(i=1;i<argc;i++)
   if(strcmp("-display",argv[i])==0 || strcmp("-d",argv[i])==0) dispchr=argv[i+1];
   if((disp=XOpenDisplay(dispchr))==NULL)
   {
   fprintf(stderr,"%s: connection to X server failed on display %s.....\n",argv[0],dispchr);
   exit(1);
   } */
  disp = Xdisplay;
  uname(&uts);
  strncpy(host, uts.nodename, 80);
  sprintf(winame, "%s  launched from host '%s'", winname, host);
  sprintf(xncvt, "VT100 for %s  Host:%s", ver, host);
  strcat(host, ":");
  winname = winame;
  scr = DefaultScreen(disp);
  XrmInitialize();
  fprintf(stderr, "Loading resources....");
  strcpy(rfile, home_files_dir);
  strcat(rfile, guiplugin->get_ini_filename());
  rdb = XrmGetFileDatabase(rfile);
  if (rdb != NULL)
    for (i = 0; i < resn; i++)
      {
        fprintf(stderr, ".");
        if (XrmGetResource(rdb, resources[i].name, resources[i].cname, &rmt, &rmv))
          strcpy(resources[i].pstr,rmv.addr);
        else
          fprintf(stderr, "%s: Error getting resource: %s\n", argv[0], resources[i].name);
      }
  else
    fprintf(stderr, "!!!XNC PANIC!!!: Can't open resource file [%s].\n", rfile);
  strcpy(l_bg_string, resources[2].pstr);
  XParseGeometry(geometrychr, &ppx, &ppy, &ppl, &pph);
  if (ppl > 0)
    {
      wx = ppx;
      wy = ppy;
      wl = ppl;
      wh = pph;
      if (wl < 640)
        wl = 640;
      if (wh < 300)
        wh = 300;
    }
  XParseGeometry(viewgeom, &viewx, &viewy, &viewl, &viewh);
  defcmp = DefaultColormap(disp, scr);

  if (XParseColor(disp, defcmp, resources[0].pstr, &color) == 0 ||
      im_AllocColor(disp, defcmp, &color) == 0)
    bgpix = WhitePixel(disp, scr);
  else
    bgpix = color.pixel;
  if (XParseColor(disp, defcmp, resources[4].pstr, &color) == 0 ||
      im_AllocColor(disp, defcmp, &color) == 0)
    selectpix = BlackPixel(disp, scr);
  else
    selectpix = color.pixel;
  if (XParseColor(disp, defcmp, resources[1].pstr, &color) == 0 ||
      im_AllocColor(disp, defcmp, &color) == 0)
    fgpix = BlackPixel(disp, scr);
  else
    fgpix = color.pixel;

  for (i = 0; i < coln; i++)
    if (XrmGetResource(rdb, colors[i].name, colors[i].cname, &rmt, &rmv))
      {
        fprintf(stderr, ".");
        strcpy(colors[i].pstr,rmv.addr);
        if (XParseColor(disp, defcmp, colors[i].pstr, &color) == 0 ||
            im_AllocColor(disp, defcmp, &color) == 0)
          {
            fprintf(stderr, "!!!XNC Panic!!!: Can't allocate color!\n");
            cols[i] = BlackPixel(disp, scr);
          }
        else
          cols[i] = color.pixel;
      }

  if (XrmGetResource(rdb, "xnc.panels.layout", "Xnc.Panels.Layout", &rmt, &rmv))
    {
      if (strcmp(rmv.addr, "horizontal") == 0)
        layout = 0;
      else if (strcmp(rmv.addr, "vertical") == 0)
        layout = 1;
      else
        layout = 2;
    }
  else
    fprintf(stderr, "!!!XNC Panic!!!: Error getting resource: Xnc.Panels.Layout\n");

  if ((fontstr = XLoadQueryFont(disp, resources[3].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", fontchr);
      exit(1);
    }

  if ((lfontstr = XLoadQueryFont(disp, resources[5].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", lfontchr);
      exit(1);
    }

  if ((fixfontstr = XLoadQueryFont(disp, resources[6].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", fixfontchr);
      exit(1);
    }
  if ((vfontstr = XLoadQueryFont(disp, resources[10].pstr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", vfontchr);
      exit(1);
    }
  if ((mfixfontstr = XLoadQueryFont(disp, mfixfontchr)) == NULL)
    {
      fprintf(stderr, "!!!XNC Panic!!!: Error loading font %s\n", mfixfontchr);
      exit(1);
    }


  fprintf(stderr, "OK\n");
  GenerateColors();
  if ((pxsh = XAllocSizeHints()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating size hints\n", argv[0]);
      exit(1);
    }

  if (strcmp(bshow, "no") == 0)
    {
      allow_bookmark = 0;
      allow_animation = 0;
    };
  if (strcmp(updatechr, "always") == 0)
    dont_update = 1;
  else if (strcmp(updatechr, "prompt") == 0)
    dont_update = 0;
  else
    dont_update = 2;
  pxsh->flags = (PPosition | PSize | PMinSize);                // | PMaxSize);

  pxsh->height = wh;
  pxsh->width = wl;
  pxsh->min_width = 450;
  pxsh->min_height = 350;
/* pxsh->max_width=pxsh->width;
   pxsh->max_height=pxsh->height; */
  pxsh->x = wx;
  pxsh->y = wy;
  Mainl = wl;
  Mainh = wh;
  sprintf(geom, "%dx%d+%d+%d", pxsh->width, pxsh->height, pxsh->x, pxsh->y);
  i = XGeometry(disp, scr, geom, geom, BDWIDTH, fontstr->max_bounds.width,
                fontstr->max_bounds.ascent + fontstr->max_bounds.descent,
             1, 1, &(pxsh->x), &(pxsh->y), &(pxsh->width), &(pxsh->height));
  if (i & (XValue | YValue))
    pxsh->flags |= USPosition;
  if (i & (WidthValue | HeightValue))
    pxsh->flags |= USSize;
  Mainx = pxsh->x;
  Mainy = pxsh->y;
  Main = XCreateSimpleWindow(disp, DefaultRootWindow(disp),
                             pxsh->x, pxsh->y, pxsh->width, pxsh->height,
                             BDWIDTH, fgpix, keyscol[1]);
  centerx = pxsh->width / 2;
  centery = pxsh->height / 2;
  if ((pch = XAllocClassHint()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating ClassHint\n", argv[0]);
      exit(1);
    }
  pch->res_name = "xnc";
  pch->res_class = "XNC";
  if (winname == NULL)
    winname = argv[0];
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "%s: Error creating TextProperty\n", argv[0]);
      exit(1);
    }
  if (XStringListToTextProperty(&icname, 1, &iname) == 0)
    {
      fprintf(stderr, "%s: Error creating TextProperty\n", argv[0]);
      exit(1);
    }
  if ((pxwmh = XAllocWMHints()) == NULL)
    {
      fprintf(stderr, "%s: Error allocating WMHints\n", argv[0]);
      exit(0);
    }
  picon = XCreateBitmapFromData(disp, Main, (char *)xnc_bits, xnc_width, xnc_height);
  piconmask = XCreateBitmapFromData(disp, DefaultRootWindow(disp), (char *)xncm_bits, xnc_width, xnc_height);
  pxwmh->flags = (InputHint | StateHint | IconMaskHint | IconPixmapHint);
  pxwmh->input = True;
  pxwmh->initial_state = NormalState;
  pxwmh->icon_pixmap = picon;
  pxwmh->icon_mask = piconmask;
  XSetWMProperties(disp, Main, &wname, &iname, argv, argc, pxsh, pxwmh, pch);

  gcv.font = fontstr->fid;
  gcv.foreground = fgpix;
  gcv.background = bgpix;
  gc = XCreateGC(disp, Main, (GCFont | GCForeground | GCBackground), &gcv);
  xswa.colormap = defcmp;
  xswa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(disp, Main, (CWColormap | CWBitGravity), &xswa);
// XSelectInput(disp,Main,ExposureMask | StructureNotifyMask);
  XSelectInput(disp, Main, FocusChangeMask | StructureNotifyMask);
  XGetWindowAttributes(disp, DefaultRootWindow(disp), &xwinattr);
  ScreenL = xwinattr.width;
  ScreenH = xwinattr.height;
  if (strcmp(syspath, ".") == 0)
    sprintf(syspath,"%s/.xnc", getenv("HOME"));
  sprintf(tmppath, "%s/AFS", syspath);
  if (mkdir(tmppath, 0700) == -1 && errno != EEXIST)
    {
      fprintf(stderr, "!!!XNC Panic!!!!: Can't access tmp directory '%s'!\n", tmppath);
      fprintf(stderr, "Archive file system will be disabled!!!\n");
      afs_disabled = 1;
    }
  sprintf(tmppath, "%s/FTPFS", syspath);
  if (mkdir(tmppath, 0700) == -1 && errno != EEXIST)
    {
      fprintf(stderr, "!!!XNC Warning!!!!: Can't access FTP tmp directory '%s'!\n", tmppath);
      fprintf(stderr, "FTP cache will be disabled!!!\n");
      ftp_cache_disabled= 1;
    }
}

void   DeinitXClient()
{
// XFreePixmap(disp,picon);

// XFreePixmap(disp,piconmask);
  delall_el();
// delall_exp();
  XFreeGC(disp, gc);
  XUnloadFont(disp, fontstr->fid);
  XUnloadFont(disp, lfontstr->fid);
  XDestroyWindow(disp, Main);
// XCloseDisplay(disp);

// exit(0);
}


Window create_win(char *winname, int wx, int wy, int wl, int wh, int mask, int inp)
{
  int    i;
  Window W;
  XSetWindowAttributes xswa;
  pxsh->flags = (PPosition | PSize | PMinSize | PMaxSize);
  pxsh->height = wh;
  pxsh->width = wl;
  pxsh->min_width = pxsh->width;
  pxsh->min_height = pxsh->height;
  pxsh->max_width = pxsh->width;
  pxsh->max_height = pxsh->height;
  pxsh->x = wx;
  pxsh->y = wy;
  sprintf(geom, "%dx%d+%d+%d", pxsh->width, pxsh->height, pxsh->x, pxsh->y);
  i = XGeometry(disp, scr, geom, geom, BDWIDTH, fontstr->max_bounds.width,
                fontstr->max_bounds.ascent + fontstr->max_bounds.descent,
             1, 1, &(pxsh->x), &(pxsh->y), &(pxsh->width), &(pxsh->height));
  if (i & (XValue | YValue))
    pxsh->flags |= USPosition;
  if (i & (WidthValue | HeightValue))
    pxsh->flags |= USSize;
  W = XCreateSimpleWindow(disp, DefaultRootWindow(disp),
                          pxsh->x, pxsh->y, pxsh->width, pxsh->height,
                          BDWIDTH, fgpix, keyscol[1]);
  pch->res_name = "leoprogs";
  pch->res_class = "LeoProgs";
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "Error creating TextProperty\n");
      exit(1);
    }
  pxwmh->flags = (InputHint | StateHint);
  if (inp)
    pxwmh->input = True;
  else
    pxwmh->input = False;
  pxwmh->initial_state = NormalState;
  XSetWMProperties(disp, W, &wname, &iname, margv, margc, pxsh, pxwmh, pch);
  xswa.colormap = defcmp;
  xswa.bit_gravity = CenterGravity;
  XChangeWindowAttributes(disp, W, (CWColormap | CWBitGravity), &xswa);
  XSelectInput(disp, W, mask);

  return W;
}

extern Menu *submenu1, *submenu2, *submenu3;
extern Window main_win;


//Placed in panel.cxx
extern int dont_ask;


char  *confref[] =
{"panel1.path",
 "panel2.path",
 "panel.active",
 "panel1.columns",
 "panel2.columns",
 "panel1.sortby",
 "panel2.sortby",
 "panel1.style",
 "panel2.style",
 "bookmark.book1",
 "bookmark.book2",
 "bookmark.book3",
 "bookmark.book4",
 "bookmark.book5",
 "bookmark.book6",
 "bookmark.book7",
 "bookmark.book8",
 "bookmark.book9",
 "panels.show_hidden_files",
 "panels.percentage",
 "panels.prompt.copy",
 "panels.prompt.move",
 "panels.prompt.delete",
 "panels.prompt.overwrite",
 "panels.prompt.exit",
 "xnc.term.sticky",
 "xnc.term.raise",
 "xnc.bookmark.animation",
 "xnc.icons.dir",
 "xnc.icons.file",
 "xnc.version.current",
 "xnc.total.starts",
 "xnc.dirscan.timeout",
 "xnc.text.shadow",
 "panel1.sort_order",
 "panel2.sort_order",
 "xnc.compare_by.size",
 "xnc.compare_by.time",
 "panels.cursor.filled",
 "xnc.ives.exit.together",
 "xnc.statusbar.show.name",
 "xnc.statusbar.show.attr",
 "xnc.statusbar.show.time",
 "xnc.statusbar.show.size",
 "xnc.statusbar.show.owner",
 "xnc.statinfo.position",
 "xnc.window_manager.position.correction",
 "xnc.magicfile.path"
};

const int confmax = sizeof(confref)/sizeof(char*);

char  *getseq(char *str, char *w, int nocase = 1)
{
  while ((*str == ' ' || *str == ':') && *str != 0)
    str++;
  while (*str != 0 && *str != 0xa && *str != ':')
    if (nocase)
      *w++ = tolower(*str++);
    else
      *w++ = *str++;
  *w = 0;
  return str;
}

int    load_config(char *fname, Lister * l1, Lister * l2)
{
  char   str[200], *s=XNCVERSION;
  char   w[200];
  int    i, nn, j;
  str2version(s+2,&xnc_orig_ver);
  FILE  *fp = fopen(fname, "r");
  if (fp == NULL)
    return 0;
  while (fgets(str, 200, fp) != NULL)
    {
      if (str[0] != '#')
        {
          s = getseq(str, w);
//    fprintf(stderr,"%s\n",w);
          for (i = 0; i < confmax; i++)
            if (strcmp(w, confref[i]) == 0)
              break;
          if (i == confmax)
            fprintf(stderr, "Unknown sequence...\n");
          else
            {
              if (i < 2 || (i > 8 && i < 18) || i==47)
                s = getseq(s, w, 0);        //Do case sensitive parsing for directory contains entries...

              else
                s = getseq(s, w);        //otherwise insensitive  :)

              switch (i)
                {
                case 0:
                  strcpy(l1->curdir, w);
                  break;
                case 1:
                  strcpy(l2->curdir, w);
                  break;
                case 2:
                  if (strcmp("panel2", w) == 0)
                    panel = l2;
                  else
                    panel = l1;
                  break;
                case 3:
                  sscanf(w, "%d", &nn);
                  if (nn == 0 || nn > 4)
                    nn = 2;
                  l1->repanel(nn);
                  submenu1->set(1 + nn);
                  break;
                case 4:
                  sscanf(w, "%d", &nn);
                  if (nn == 0 || nn > 4)
                    nn = 2;
                  l2->repanel(nn);
                  submenu2->set(1 + nn);
                  break;
                case 5:
                  if (strcmp(w, "extension") == 0)
                    {
                      l1->comp = extcmp;
                      submenu1->set(7);
                    }
                  else if (strcmp(w, "size") == 0)
                    {
                      l1->comp = sizecmp;
                      submenu1->set(8);
                    }
                  else if (strcmp(w, "time") == 0)
                    {
                      l1->comp = timecmp;
                      submenu1->set(9);
                    }
                  else if(strcmp(w, "name") == 0)
                    {
                      l1->comp = mystrcmp;
                      submenu1->set(6);
                    }
                  else
                    {
                      l1->comp = unsortcmp;
                      submenu1->set(10);
                    }
                  break;
                case 6:
                  if (strcmp(w, "extension") == 0)
                    {
                      l2->comp = extcmp;
                      submenu2->set(7);
                    }
                  else if (strcmp(w, "size") == 0)
                    {
                      l2->comp = sizecmp;
                      submenu2->set(8);
                    }
                  else if (strcmp(w, "time") == 0)
                    {
                      l2->comp = timecmp;
                      submenu2->set(9);
                    }
                  else if (strcmp(w, "name") == 0)
                    {
                      l2->comp = mystrcmp;
                      submenu2->set(6);
                    }
                  else
                    {
                      l2->comp = unsortcmp;
                      submenu2->set(10);
                    }
                  break;
                case 7:
                  if (strcmp(w, "brief") == 0)
                    {
                      l1->brief = 1;
                      submenu1->set(0);
                    }
                  else
                    {
                      l1->brief = 0;
                      submenu1->set(1);
                    };
                  break;
                case 8:
                  if (strcmp(w, "brief") == 0)
                    {
                      l2->brief = 1;
                      submenu2->set(0);
                    }
                  else
                    {
                      l2->brief = 0;
                      submenu2->set(1);
                    };
                  break;
                case 9:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(0, w, j);
                  break;
                case 10:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(1, w, j);
                  break;
                case 11:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(2, w, j);
                  break;
                case 12:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(3, w, j);
                  break;
                case 13:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(4, w, j);
                  break;
                case 14:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(5, w, j);
                  break;
                case 15:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(6, w, j);
                  break;
                case 16:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(7, w, j);
                  break;
                case 17:
                  j = detect_fs(w);
                  getseq(s, w, 0);
                  bmark->add_book(8, w, j);
                  break;
                case 18:
                  if (strcmp(w, "no") == 0)
                    {
                      hide_hidden = 1;
                    }
                  else
                    {
                      hide_hidden = 0;
                    }
                  break;
                case 19:
                  sscanf(w, "%d", &bmark->percent);
                  if (bmark->percent < 15)
                    bmark->percent = 15;
                  break;
                case 20:
                  if(strcmp(w,"no") == 0)
                  {
                          use_prompt&=~PROMPT_COPY;
                  }
                  break;
                case 21:
                  if(strcmp(w,"no") == 0)
                  {
                          use_prompt&=~PROMPT_MOVE;
                  }
                  break;
                case 22:
                  if(strcmp(w,"no") == 0)
                  {
                          use_prompt&=~PROMPT_DEL;
                  }
                  break;
                case 23:
                  if(strcmp(w,"no") == 0)
                  {
                          use_prompt&=~PROMPT_OVR;
                          dont_ask=1;
                  }
                  break;
                case 24:
                  if(strcmp(w,"no") == 0)
                  {
                          use_prompt&=~PROMPT_EXIT;
                  }
                  break;
                case 25:
                  if(strcmp(w,"no") == 0)
                  {
                          term_sticky=NO;
                  } else
                          term_sticky=YES;
                  break;
                case 26:
                  if(strcmp(w,"no") == 0)
                  {
                          allow_t_raising=NO;
                  } else
                          allow_t_raising=YES;
                  break;
                case 27:
                  if(strcmp(w,"no") == 0)
                  {
                          allow_animation=NO;
                  } else
                          allow_animation=YES;
                  if(!allow_bookmark)
                          allow_animation=NO;
                  break;
                case 28:
                  if(strcmp(w,"no") == 0)
                  {
                          allow_dir_icon=NO;
                  } else
                          allow_dir_icon=YES;
                  break;
                case 29:
                  if(strcmp(w,"no") == 0)
                  {
                          allow_file_icon=NO;
                  } else
                          allow_file_icon=YES;
                  break;
                case 30:
                        str2version(w,&xnc_ver);
                        sscanf(w+6,"%d",&init_starts);
                        break;
                case 31:
                        sscanf(w,"%d",&xnc_starts);
                        xnc_starts++;
                        break;
                case 32:
                        sscanf(w,"%d", &dirdelay);
                        break;
                case 33:
                  if(strcmp(w,"no") == 0)
                  {
                          shadow=NO;
                  } else
                          shadow=YES;
                  break;
                case 34:
                  if(strcmp(w,"reverse") == 0)
                  {
                          l1->rev_order=1;
                          submenu1->set(11);
                  } else
                          l1->rev_order=0;
                  break;
                case 35:
                  if(strcmp(w,"reverse") == 0)
                  {
                          l2->rev_order=1;
                          submenu2->set(11);
                  } else
                          l2->rev_order=0;
                  break;
                case 36:
                  if(strcmp(w,"no") == 0)
                  {
                          compare_by_size=0;
                          submenu3->set(17);
                  } else
                          compare_by_size=1;
                  break;
                case 37:
                  if(strcmp(w,"yes") == 0)
                  {
                          compare_by_time=1;
                          submenu3->set(18);
                  } else
                          compare_by_time=0;
                  break;
                case 38:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~FILLED_CURSOR;
                  } else
                          option_bits|=FILLED_CURSOR;
                  break;
                case 39:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~IVES_EXIT_TOO;
                  } else
                          option_bits|=IVES_EXIT_TOO;
                  break;
                case 40:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~STATUS_NAME;
                  } else
                          option_bits|=STATUS_NAME;
                  break;
                case 41:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~STATUS_ATTR;
                  } else
                          option_bits|=STATUS_ATTR;
                  break;
                case 42:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~STATUS_TIME;
                  } else
                          option_bits|=STATUS_TIME;
                  break;
                case 43:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~STATUS_SIZE;
                  } else
                          option_bits|=STATUS_SIZE;
                  break;
                case 44:
                  if(strcmp(w,"no") == 0)
                  {
                          option_bits&=~STATUS_OWNER;
                  } else
                          option_bits|=STATUS_OWNER;
                  break;
                case 45:
                   {
                    int ix, iy;
                    sscanf(w, "%d ,%d", &ix, &iy);
                    init_inodewin_with_position(ix, iy);
                    break;
                   }
                case 46:
                    sscanf(w, "%d", &wm_y_correction);
                    break;
                case 47:
                    strcpy(magic_file_location, w);
                    break;
                };
            }
        }
    }
  fprintf(stderr, "OK\n");
  fclose(fp);
  return 1;
}

void   load_cfg(Lister * l1, Lister * l2)
{
  char  *winname;
  XTextProperty wname;
  init_users();
  load_mnt();
  fprintf(stderr, "Loading extension file......");
  load_ext();
  fprintf(stderr, "OK\nLoading menu file......");
  load_menu();
  fprintf(stderr, "OK\nLoading config......");
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/xnc.cfg");
  panel = l1;
  l1->repanel(3);
  submenu1->set(4);
  l2->repanel(3);
  submenu2->set(4);
  l1->comp = extcmp;
  submenu1->set(7);
  l2->comp = extcmp;
  submenu2->set(7);
  l2->brief = 1;
  submenu2->set(0);
  l1->brief = 1;
  submenu1->set(0);
  if (load_config(rfile, l1, l2) == 0)
    {
      fprintf(stderr, "\n!!!XNC Panic!!!: Can't open configuration file.\n");
    }
  strcat(winame, "         User: ");
  strcat(winame, finduser(getuid()));
  strcat(winame, "  Group: ");
  strcat(winame, findgroup(getgid()));
  sprintf(xncvt, "VT100 for %s", winame);
  winname = winame;
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "XNC: Error creating TextProperty\n");
      exit(1);
    }
  else
    XSetWMName(disp, Main, &wname);
  winname = xncvt;
  if (XStringListToTextProperty(&winname, 1, &wname) == 0)
    {
      fprintf(stderr, "XNC: Error creating TextProperty\n");
      exit(1);
    }
  else
    XSetWMName(disp, main_win, &wname);
}

void   save_cfg(Lister * l1, Lister * l2)
{
  FILE  *fp;
  int ix, iy;
  deinit_users();
  del_mnt();
  if (l1 == NULL || l2 == NULL)
    return;
  strcpy(rfile, home_files_dir);
  strcat(rfile, "/xnc.cfg");
  if ((fp = fopen(rfile, "w")) != NULL)
    {
      fprintf(fp, "#This is configuration file for %s...\n", ver);
      fprintf(fp, "#WARNING: Do NOT EDIT this file. It will be overwritten...\n");
      fprintf(fp, "xnc.version.current: %d.%d.%d    %d\n",xnc_orig_ver/100,
                      (xnc_orig_ver%100)/10, xnc_orig_ver%10, init_starts);
      fprintf(fp, "xnc.total.starts: %d\n",  xnc_starts);
      fprintf(fp, "panel1.path:        %s\n", l1->curdir);
      fprintf(fp, "panel1.columns:     %d\n", l1->col);
      fprintf(fp, "panel1.sort_order:  %s\n", l1->rev_order ? "reverse" : "normal");
      if (l1->comp == mystrcmp)
        fprintf(fp, "panel1.sortby:     name\n");
      else if (l1->comp == extcmp)
        fprintf(fp, "panel1.sortby:     extension\n");
      else if (l1->comp == sizecmp)
        fprintf(fp, "panel1.sortby:     size\n");
      else if (l1->comp == timecmp)
        fprintf(fp, "panel1.sortby:     time\n");
      else
        fprintf(fp, "panel1.sortby:     unsorted\n");
      fprintf(fp, "panel1.style:      ");
      if (l1->brief)
        fprintf(fp, "brief\n");
      else
        fprintf(fp, "full\n");
      fprintf(fp, "panel2.path:        %s\n", l2->curdir);
      fprintf(fp, "panel2.columns:     %d\n", l2->col);
      fprintf(fp, "panel2.sort_order:  %s\n", l2->rev_order ? "reverse" : "normal");
      if (l2->comp == mystrcmp)
        fprintf(fp, "panel2.sortby:     name\n");
      else if (l2->comp == extcmp)
        fprintf(fp, "panel2.sortby:     extension\n");
      else if (l2->comp == sizecmp)
        fprintf(fp, "panel2.sortby:     size\n");
      else if (l2->comp == timecmp)
        fprintf(fp, "panel2.sortby:     time\n");
      else
        fprintf(fp, "panel2.sortby:     unsorted\n");
      fprintf(fp, "panel2.style:      ");
      if (l2->brief)
        fprintf(fp, "brief\n");
      else
        fprintf(fp, "full\n");
      fprintf(fp, "panel.active:       ");
      if (panel == l1)
        fprintf(fp, "panel1\n");
      else
        fprintf(fp, "panel2\n");
      bmark->save_books(fp);
      if (hide_hidden)
        fprintf(fp, "panels.show_hidden_files: no\n");
      else
        fprintf(fp, "panels.show_hidden_files: yes\n");
      fprintf(fp, "panels.percentage:  %d\n", bmark->percent);
      if(use_prompt & PROMPT_COPY)
              fprintf(fp,"panels.prompt.copy: yes\n");
      else
              fprintf(fp,"panels.prompt.copy: no\n");

      if(use_prompt & PROMPT_MOVE)
              fprintf(fp,"panels.prompt.move: yes\n");
      else
              fprintf(fp,"panels.prompt.move: no\n");

      if(use_prompt & PROMPT_DEL)
              fprintf(fp,"panels.prompt.delete: yes\n");
      else
              fprintf(fp,"panels.prompt.delete: no\n");

      if(use_prompt & PROMPT_OVR)
              fprintf(fp,"panels.prompt.overwrite: yes\n");
      else
              fprintf(fp,"panels.prompt.overwrite: no\n");

      if(use_prompt & PROMPT_EXIT)
              fprintf(fp,"panels.prompt.exit: yes\n");
      else
              fprintf(fp,"panels.prompt.exit: no\n");

      if(term_sticky)
              fprintf(fp,"xnc.term.sticky: yes\n");
      else
              fprintf(fp,"xnc.term.sticky: no\n");
              
      if(allow_t_raising)
              fprintf(fp,"xnc.term.raise: yes\n");
      else
              fprintf(fp,"xnc.term.raise: no\n");
              
      if(allow_animation)
              fprintf(fp,"xnc.bookmark.animation: yes\n");
      else
              fprintf(fp,"xnc.bookmark.animation: no\n");
              
      if(allow_dir_icon)
              fprintf(fp,"xnc.icons.dir: yes\n");
      else
              fprintf(fp,"xnc.icons.dir: no\n");
              
      if(allow_file_icon)
              fprintf(fp,"xnc.icons.file: yes\n");
      else
              fprintf(fp,"xnc.icons.file: no\n");
      if(shadow)
              fprintf(fp,"xnc.text.shadow: yes\n");
      else
              fprintf(fp,"xnc.text.shadow: no\n");
      if(compare_by_size)
              fprintf(fp,"xnc.compare_by.size: yes\n");
      else
              fprintf(fp,"xnc.compare_by.size: no\n");
      if(compare_by_time)
              fprintf(fp,"xnc.compare_by.time: yes\n");
      else
              fprintf(fp,"xnc.compare_by.time: no\n");
      fprintf(fp,"xnc.dirscan.timeout: %d\n",dirdelay);

      if(option_bits & FILLED_CURSOR)
              fprintf(fp,"panels.cursor.filled: yes\n");
      else
              fprintf(fp,"panels.cursor.filled: no\n");

      if(option_bits & IVES_EXIT_TOO)
              fprintf(fp,"xnc.ives.exit.together: yes\n");
      else
              fprintf(fp,"xnc.ives.exit.together: no\n");

      if(option_bits & STATUS_NAME)
              fprintf(fp,"xnc.statusbar.show.name: yes\n");
      else
              fprintf(fp,"xnc.statusbar.show.name: no\n");

      if(option_bits & STATUS_ATTR)
              fprintf(fp,"xnc.statusbar.show.attr: yes\n");
      else
              fprintf(fp,"xnc.statusbar.show.attr: no\n");

      if(option_bits & STATUS_TIME)
              fprintf(fp,"xnc.statusbar.show.time: yes\n");
      else
              fprintf(fp,"xnc.statusbar.show.time: no\n");

      if(option_bits & STATUS_SIZE)
              fprintf(fp,"xnc.statusbar.show.size: yes\n");
      else
              fprintf(fp,"xnc.statusbar.show.size: no\n");

      if(option_bits & STATUS_OWNER)
              fprintf(fp,"xnc.statusbar.show.owner: yes\n");
      else
              fprintf(fp,"xnc.statusbar.show.owner: no\n");

      if(get_inodewin_position(&ix, &iy))
          fprintf(fp, "xnc.statinfo.position: %d, %d\n", ix, iy);

      fprintf(fp, "xnc.window_manager.position.correction: %d\n", wm_y_correction);

      fprintf(fp, "xnc.magicfile.path: %s\n", magic_file_location);
          
      fclose(fp);
    }
  else
    fprintf(stderr, "!!!XNC PANIC!!!: Can't create configuration file. BAD!\n");
}
