/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:   leo@xnc.dubna.su
* 
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
/* $Id: main.cxx,v 1.12 2000/12/26 12:40:27 leo Exp $ */

#include "panel.h"
#include "scroll.h"
#include "ver.h"
#include "build.h"
#include "comp.h"
#include "image/image.h"
#include "bookmark.h"
#include "au/au.h"
#include "au/au_sup.h"
#include "au/key.h"
#include "ftpfs.h"
#include "internals.h"
#include "query_windows.h"
#include "ftpvisuals.h"
#include "xncversion.h"
#include "history.h"
#include "ftpcfg.h"
#include "c_externs.h"
#include "internals.h"
#include "pluginman.h"
#include "ives/ivesclient.h"

char   ver[] = "X Northern Captain "XNCVERSION;


extern Window main_win;
extern Atom   wmDeleteWindow;
extern void   init_chown_dialog(FList *);
extern void   dfs_info(int);
extern void   free_info(int);
extern void   find_panel(int);
extern int    term_sticky;
extern int    dont_ask;        //Placed in panel.cxx
extern int    layout;
extern Viewer vw1;
extern Editor ew1;
extern void   menupanel(int (*)(int, char *));
extern int    panexec2(int, char *);
extern void   newtextfile(char *, Lister *, int);
extern int    just_at_startup;
extern int    focus_fl;
extern char   shdir[];
extern AFS    afstmp;



char   dispstr[40] = "";
int    main_show = 1;
int    resize_done = 0;
BookMark *bmark;
Switcher *fsw1;
FtpVisual *fvis;

int no_ives=NO;


////////////////////////////////////IVES routines////////////////////////
IVES_client *iclient;

char ivesrun[256];

void   sendtoives(char *name, int type, int ret = 0)
{
  char umem[L_MAXPATH];
  Window focus_to;
  int    ipid,i=0;
  if(no_ives)
  {
          simple_mes("Error connecting to IVES","Editor and/or Viewer not available! Use 'xncsetup' for correct");
          return;
  }
  while (iclient->Init()==0)
    {
      XBell(disp, 0);
      show_mes("Loading IVES", "   Please wait...");
      psystem(ivesrun);
      sleep(1);
      hide_mes();
      i++;
      if(i>3)
      {
              simple_mes("Error", "IVE System not available!");
              return;
      }
    };
  if (main_show)
    focus_to = Main;
  else
    focus_to = 0;


  if (name[0] != '/')
    {
      getcwd(umem, 1024);
      strcat(umem, "/");
      strcat(umem, name);
    }
  else
    strcpy(umem, name);
  iclient->send_data(DefaultRootWindow(disp),IVES_data(Main,type,focus_to,umem,ret));
}


void   defret()
{
  if (panel->lay == 0)
    panel->panel2->reread();
  panel->reread();
// guiSetInputFocus(disp,panel->w,RevertToNone,CurrentTime);
}

void   manret()
{
  char   tmps[200];
  strcpy(tmps, syspath);
  strcat(tmps, "/xnc.tmp");
  chdir(panel->curdir);
  unlink(tmps);
  defret();
}

void   extret()
{
  load_ext();
  defret();
}

void   menuret()
{
  load_menu();
  defret();
}

void   (*funcs[]) () =
{
  defret, manret, extret, menuret
};


void   ives_retval(int ret)
{
  funcs[ret]();
}

void   viewhighlight(char *name)
{
  sendtoives(name, 3, 1);
}

void   p_info()
{
  panel->ps_info();
};
void   m_info()
{
  free_info(centerx * 2 - 40);
};
void   d_info()
{
  dfs_info(centerx * 2 - 40);
};
void   ownerfunc()
{
  init_chown_dialog(panel->cur);
};
void   findfunc()
{
  find_panel(centerx * 2 - 40);
};

void   donefunc();
void   viewfunc();
void   editfunc();
void   copyfunc();
void   movefunc();
void   delfunc();
void   mkdirfunc();
void   remntfunc();
void   manfunc();
void   revfunc1();
void   revfunc2();
void   p1col1();
void   p1col2();
void   p1col3();
void   p2col1();
void   p2col2();
void   p2col3();
void   p2col4();
void   p1col4();
void   p1ext();
void   p2ext();
void   p1name();
void   p2name();
void   p1time();
void   p2time();
void   p1size();
void   p2size();
void   p1unsort();
void   p2unsort();
void   p1brief();
void   p2brief();
void   p1full();
void   p2full();
void   configure_func() {show_config_win();};
void   edit_ext();
void   edit_menu();
void   attrfunc();
void   menu_func();
void   show_hidden_files();
void   try_clean_afs_cache();
void   compare_dirs() {panel->compare_panels();panel->panel2->compare_panels();};
void   use_sizes() {compare_by_size^=1;};
void   use_times() {compare_by_time^=1;};
MenuBar *emn;
MenuBar *ftpmn;
FList *node;

char   so1[13][25] =
{"PBrief", "pFull ", "pOne column", "PTwo columns", "pThree columns",
 "pFour columns ", "pSort by Names", "PSort by Extensions", 
 "pSort by Size", "pSort by Time", "pUnsorted ", "sReverse sort ", "FQuit"};

MenuItem subm1[] =
{
  so1[0], 5, p1brief, NULL,
  so1[1], 5, p1full, NULL,
  so1[2], 5, p1col1, NULL,
  so1[3], 5, p1col2, NULL,
  so1[4], 5, p1col3, NULL,
  so1[5], 5, p1col4, NULL,
  so1[6], 5, p1name, NULL,
  so1[7], 5, p1ext, NULL,
  so1[8], 5, p1size, NULL,
  so1[9], 5, p1time, NULL,
  so1[10], 5, p1unsort, NULL,
  so1[11], 5, revfunc1, NULL,
  so1[12], 2, donefunc, NULL
};
MenuItem optmenu[] =
{
  "FEdit menu file", 5, edit_menu, NULL,
  "FEdit extension file ", 5, edit_ext, NULL,
  "FClean AFS cache ", 5, try_clean_afs_cache, NULL,
  "FConfiguration", 1, configure_func, NULL,
};
char   so2[12][25] =
{"PBrief", "pFull ", "pOne column", "PTwo columns", "pThree columns",
 "pFour columns ", "pSort by Names", "PSort by Extensions", 
 "pSort by Size", "pSort by Time", "pUnsorted ", "sReverse sort"};
MenuItem subm2[] =
{
  so2[0], 5, p2brief, NULL,
  so2[1], 5, p2full, NULL,
  so2[2], 5, p2col1, NULL,
  so2[3], 5, p2col2, NULL,
  so2[4], 5, p2col3, NULL,
  so2[5], 5, p2col4, NULL,
  so2[6], 5, p2name, NULL,
  so2[7], 5, p2ext, NULL,
  so2[8], 5, p2size, NULL,
  so2[9], 5, p2time, NULL,
  so2[10], 5, p2unsort, NULL,
  so2[11], 5, revfunc2, NULL
};

char so3[2][25]={"SCompare by sizes", "sCompare by times"};

MenuItem submnu2[] =
{
  "FRemount current directory", 5, remntfunc, NULL,
  "FMenu", 5, menu_func, NULL,
  "FView file", 5, viewfunc, NULL,
  "FEdit file", 5, editfunc, NULL,
  "FCopy file", 5, copyfunc, NULL,
  "FMove/Rename file", 5, movefunc, NULL,
  "FMake directory", 5, mkdirfunc, NULL,
  "FDelete file", 5, delfunc, NULL,
  "FAttributes of file", 5, attrfunc, NULL,
  "FChange Owner", 5, ownerfunc, NULL,
  "FFind files", 5, findfunc, NULL,
  "FQuick ScanDir Info", 5, qview, NULL,
  "FProcesses Info", 5, p_info, NULL,
  "FMemory Info", 5, m_info, NULL,
  "FDisk Info", 5, d_info, NULL,
  "FStat Info ", 5, toggle_inodewin, NULL,
  "FCompare directories", 5, compare_dirs, NULL,
  so3[0], 5, use_sizes, NULL,
  so3[1], 5, use_times, NULL
};

Menu   *submenu1=0;
Menu   *submenu2=0;
Menu   *submenu3=0;
Menu   *submenu4=0;
MenuItem menu[] =
{"Left", 1, NULL, submenu1,
 "Commands", 1, NULL, submenu3,
 "Options", 1, NULL, submenu4,
 "-Right", 3, NULL, submenu2,
};

MenuItem ftpmenu[] =
{"FTP", 1, NULL, submenu1};

MenuItem menu2[] =
{"1.Man", 5, manfunc, NULL,
 "2.Menu", 5, menu_func, NULL,
 "3.View", 5, viewfunc, NULL,
 "4.Edit", 5, editfunc, NULL,
 "5.Copy", 5, copyfunc, NULL,
 "6.Move", 5, movefunc, NULL,
 "7.Mkdir", 5, mkdirfunc, NULL,
 "8.Delete", 5, delfunc, NULL,
 "9.Attr", 5, attrfunc, NULL,
 "-0.Quit", 2, donefunc, NULL
};

void init_submenus()
{
  submenu1=guiplugin->new_Menu(subm1, 13);
  submenu2=guiplugin->new_Menu(subm2, 12);
  submenu3=guiplugin->new_Menu(submnu2, 19);
  submenu4=guiplugin->new_Menu(optmenu, 4);
  menu[0].o=submenu1;
  menu[1].o=submenu3;
  menu[2].o=submenu4;
  menu[3].o=submenu2;
  ftpmenu[0].o=submenu1;
}

void   fqok();
void   fqcan();



void   menu_func()
{
  menupanel(panexec2);
}

Win    *w1;
KEY    *qok;
KEY    *qcan;

void   donefunc()
{
  if(use_prompt & PROMPT_EXIT)
  {
    w1=guiplugin->new_Win(300, 80, 200, 80, "Really, QUIT?", 5);
    qok=guiplugin->new_KEY(10, 35, 80, 25, "Yes", 2, fqok);
    qcan=guiplugin->new_KEY(110, 35, 80, 25, "Never", 1, fqcan);
    qok->set_iname("Q_YES");
    qcan->set_iname("Q_NEVER");
    w1->set_iname("QWIN");
    w1->init(Main);
    qok->init(w1->w);
    qcan->init(w1->w);
    w1->link(qok);
    qok->link(qcan);
    qcan->link(qok);
    qok->set_escapefunc(fqcan);
    qcan->set_escapefunc(fqcan);
    XMoveWindow(disp, w1->w, Mainl / 2 - 100, Mainh / 2 - 70);
    w1->show();
    qok->show();
    qcan->show();
   }
   else
   {
     clean_exit();
     exit(0);
   }
}

void   attrfunc()
{
  panel->attrib();
}

void   fqok()
{
  qok->hide();
  qcan->hide();
  w1->hide();
  clean_exit();
  exit(0);
}

void   fqcan()
{
  qok->hide();
  qcan->hide();
  w1->hide();
  delete qcan;
  delete qok;
  delete w1;
  guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
}

Lister *lst1;
Lister *lst2;
MenuBar *mn;
MenuBar *mn2;
Cmdline *cmdl;

void   p1brief()
{
  lst1->brief = 1;
  lst1->reread();
}

void revfunc1()
{
  lst1->rev_order^=1;
  lst1->reread();
}

void revfunc2()
{
  lst2->rev_order^=1;
  lst2->reread();
}

void   p2brief()
{
  lst2->brief = 1;
  lst2->reread();
}

void   p1full()
{
  lst1->brief = 0;
  p1col1();
}

void   p2full()
{
  lst2->brief = 0;
  p2col1();
}

void   p1ext()
{
  lst1->sortbyext();
}
void   p1name()
{
  lst1->sortbyname();
}

void   p1time()
{
  lst1->sortbytime();
}
void   p1unsort()
{
  lst1->sortbyunsort();
}
void   p2unsort()
{
  lst2->sortbyunsort();
}
void   p1size()
{
  lst1->sortbysize();
}

void   p2ext()
{
  lst2->sortbyext();
}
void   p2name()
{
  lst2->sortbyname();
}

void   p2time()
{
  lst2->sortbytime();
}
void   p2size()
{
  lst2->sortbysize();
}

void   p1col1()
{
  lst1->repanel(1);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p1col2()
{
  lst1->repanel(2);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p1col3()
{
  lst1->repanel(3);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p2col1()
{
  lst2->repanel(1);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p1col4()
{
  lst1->repanel(4);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p2col4()
{
  lst2->repanel(4);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p2col2()
{
  lst2->repanel(2);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p2col3()
{
  lst2->repanel(3);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   editfunc()
{
  panel->edit();
}

void   viewfunc()
{
  panel->view(1);
}

void   viewload(char *cur)
{
  sendtoives(cur, 2);
}

void   viewonlyload(char *cur)
{
  sendtoives(cur, 4);
}

void   edit_ext()
{
  char   name[120];
  strcpy(name, getenv("HOME"));
  strcat(name, "/.xnc/xnc.ext");
  if (strcmp(editname, "internal") == 0)
    sendtoives(name, 1, 2);
  else
    {
      tt_printf("%s %s\n", editname, name);
      panel->raise_terminal_if_need();
    }
}

void   edit_menu()
{
  char   name[120];
  strcpy(name, getenv("HOME"));
  strcat(name, "/.xnc/xnc.menu");
  if (strcmp(editname, "internal") == 0)
    sendtoives(name, 1, 3);
  else
    {
      tt_printf("%s %s\n", editname, name);
      panel->raise_terminal_if_need();
    }
}

void   editload(char *cur)
{
  sendtoives(cur, 1);
}

void   copyfunc()
{
  panel->copy();
}

void   movefunc()
{
  panel->move();
}

void   delfunc()
{
  panel->del();
}

void   mkdirfunc()
{
  panel->mkdir();
}

void   remntfunc()
{
  panel->remount();
}

void   manfunc()
{
  newtextfile("Man page", panel, 11);
}

void full_reconfig()
{
   mn->reconfigure(fsw1->l, 0, Mainl-fsw1->l, mn->menuh);
   mn->substract_from_l(fsw1->l);
   mn2->reconfigure(0, Mainh - mn2->menuh, Mainl, mn2->menuh);
   cmdl->reconfigure(0, Mainh - 3 - mn2->menuh - cmdl->h, Mainl, cmdl->h);
   fsw1->reconfigure(0,0, fsw1->l,fsw1->h);
   fvis->reconfigure(fsw1->l,0,Mainl-fsw1->l,fvis->h);
   bmark->reconfigure(0, mn->menuh, Mainl, Mainh - 23 - mn2->menuh - mn->menuh);
   bmark->expose();
   cmdl->expose();
   mn->expose();
   mn2->expose();
   XFlush(disp);
}

void   XEVENT()
{
};

int    evret;
int    iii = 0;
int    resize_done2 = 0;
int    Main_x = -1, Main_y = -1;

int    XEVENT(XEvent * event)
{
  Gui   *o;
  int    fiflg = 1;
  ev = *event;
  evret = 1;

  if (just_at_startup == 2 && ev.xany.window == Main)
    {
      guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
      just_at_startup = 0;
      full_reconfig();
      return 1;
    };
  if (ev.xany.window != Main)
    {
      if (ev.type == Expose)
        {
          o = findexp(ev.xany.window);
          if (o)
            o->click();
          else
            return 0;
        }
      else
        {
          o = find(ev.xany.window);
/*    if(o==panel && ev.type==FocusIn) fprintf(stderr,"%2d:focus  Panel %X\n",iii++,o);
   if(o==panel->panel2 && ev.type==FocusIn) fprintf(stderr,"%2d:focus  Panel2 %X\n",iii++,o); */
          if (ev.type == FocusIn)
            {
              if (o == panel->panel2)
                {
                  guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
                  return 0;
                }
              else if (o != NULL)
                o->click();
              else
                return 0;
            }
          else if (o)
            o->click();
          else
            return 0;
        }
    }
  else if (ev.type == FocusIn)
    {
      focus_fl = 1;
      if (XPending(disp))
        {
          XPeekEvent(disp, &ev);
          if (ev.type == FocusIn)
            {
              XNextEvent(disp, &ev);
              return XEVENT(&ev);
            }
          else
            guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
        }
      else
        guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
    }
  else if (ev.type == Expose && fiflg == 1 && focus_fl)
    {
      guiSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
      fiflg = 0;
    }
  else if (ev.type == ClientMessage)
    {
      xncdprintf(("Client message got\n"));
      if(!iclient->check_event(&ev))
	if (ev.xclient.format == 32 && ev.xclient.data.l[0] == wmDeleteWindow)
	  donefunc();
    }
  else if (ev.type == MapNotify)
    main_show = 1;
  else if (ev.type == UnmapNotify)
  {
    main_show = 0;
    XIconifyWindow(disp, main_win, DefaultScreen(disp));
  }
  else if (ev.type == ConfigureNotify)
    {                                //1

      if (Mainl != ev.xconfigure.width || Mainh != ev.xconfigure.height)
        {                        //2

          Mainl = ev.xconfigure.width;
          Mainh = ev.xconfigure.height;
          mn->reconfigure(fsw1->l, 0, Mainl-fsw1->l, mn->menuh);
          mn->substract_from_l(fsw1->l);
          mn2->reconfigure(0, Mainh - mn2->menuh, Mainl, mn2->menuh);
          cmdl->reconfigure(0, Mainh - 3 - mn2->menuh - cmdl->h, Mainl, cmdl->h);
          fsw1->reconfigure(0,0, fsw1->l,fsw1->h);
          fvis->reconfigure(fsw1->l,0,Mainl-fsw1->l,fvis->h);
          centerx = Mainl / 2;
          centery = Mainh / 2;
          bmark->reconfigure(0, mn->menuh, Mainl, Mainh - 23 - mn2->menuh - mn->menuh);
          if (term_sticky && resize_done2 == 0)
            {
              XResizeWindow(disp, main_win, Mainl, Mainh);
              resize_done = 1;
            };
          resize_done2 = 0;
        }
      else if (ev.xconfigure.x != Main_x || ev.xconfigure.y != Main_y)
        {
          Main_x = Mainx = ev.xconfigure.x;
          Main_y = Mainy = ev.xconfigure.y;
          {
            if (term_sticky && resize_done2 == 0 && just_at_startup == 0)        //-2,2

              {
                XMoveWindow(disp, main_win, ev.xconfigure.x, ev.xconfigure.y);        //3

                resize_done = 1;
              };                //-3

            resize_done2 = 0;
          };
        };
    };
  return evret;
}


void   xnc_sdir()
{
  char tmpdir[L_MAXPATH];
  tt_printf("cd %s\n", quote_path(tmpdir,panel->curdir));
  strcpy(shdir, panel->curdir);
}

void   sig_fault(int)
{
  signal(SIGSEGV, SIG_DFL);
  fprintf(stderr, "\n\n*******************************************************************************\n");
  fprintf(stderr, "OOPS! It seems that You found a bug in XNC!!!\n");
  fprintf(stderr, "If You can repeat this situation then send me a bug report\n");
  fprintf(stderr, "to <leo@xnc.dubna.su> with subject  'XNC - bug report'\n");
  fprintf(stderr, "Body of mail:\n");
  fprintf(stderr, "   -What are You doing to produce this bug.\n"
                  "   -XNC configuration (~/.xnc/xnc.ini) file.\n"
                  "   -Output of 'ldd xnc' command.\n"
                  "   -X Server configuration (resolution and color depth)\n");
  fprintf(stderr, "   -And Your reply mail address, for more information about situation if need\n");
  fprintf(stderr, "Do NOT include 'CORE' dump file in the following letter.\nThanks, and sorry for BUG\n");
  fprintf(stderr, "*******************************************************************************\n");
  chdir(getenv("HOME"));
}


void   xnc_main(int argc, char **argv)
{
  int    i;
  signal(SIGSEGV, sig_fault);
  fprintf(stderr, "Initialisation:\n");
  margc = argc;
  margv = argv;
  if(rs_plugin_name)
    pluginman.load_look((char*)rs_plugin_name);
  InitXClient(argc, argv, 15, 70, 740, 455, ver);
  init_imagengine();
  GuiLocale::init_locale();
  iclient=new IVES_client(ives_retval);
  if(is_show_intro() || is_new_version())
          show_intro();
  guiplugin->post_install();
  xncdprintf(("MAIN WIN is 0x%X\n",Main));
  fprintf(stderr, "Connecting to IVE System.................");
  if (strcmp(viewname, "internal") != 0 && strcmp(editname, "internal") != 0)
  {
    fprintf(stderr, "using externals\n");
    no_ives=YES;
  }
  else
    {
      strcpy(ivesrun, "ives ");
      if (argc > 1)
        {
          i = 1;
          while (i < argc - 1)
            if (strcmp(argv[i], "-d") == 0 || strcmp(argv[i], "-display") == 0)
              {
                strcat(ivesrun, argv[i]);
                strcat(ivesrun, " ");
                strcat(ivesrun, argv[i + 1]);
                strcpy(dispstr, argv[i + 1]);
                break;
              }
            else
              i++;
        }
      if (iclient->Init()==0)
	{
	  fprintf(stderr,"failed (make it later)\n");
	  no_ives=NO;
	}
      else
      {
	fprintf(stderr,"OK\n");
	no_ives=NO;
      }
    }
  compile_key_support();
  compile_AFS_supports("xnc.afs");
  compile_FTP_supports("xnc.ftp");
  init_ftp_globals();
  create_dnd_cursors();
  bmark = guiplugin->new_BookMark(35, Mainh - 63);
  bmark->set_iname("BOOKMARK");

}

void   xnc_exit();

void   xnc_sig()
{
  signal(SIGSEGV, sig_fault);
  qv_signal();
}

void   xnc_gofunc()
{
  char str[512];
  mainuid = getuid();
  maingid = getgid();
  init_scroll();
  init_xnc_alarm();
  init_qview();
  //  load_skins();
  mn = guiplugin->new_MenuBar(20, 0, menu, 4);
  mn->substract_from_l(20);
  mn->set_iname("MENU_UP");
  mn->init(Main);
  fvis= guiplugin->new_FtpVisual(20,0,Mainl-20,mn->menuh);
  init_submenus();
  mn2 = guiplugin->new_MenuBar(0, Mainh - mn->menuh, menu2, 10);
  emn = guiplugin->new_MenuBar(0, viewh - 20, NULL, 4);
  fsw1= guiplugin->new_Switcher(0,0,20,mn->menuh);
  mn2->set_iname("MENU_DN");
  fvis->set_iname("FVISUAL");
  fsw1->set_iname("MENU_SW");
  mn->substract_from_l(fsw1->l);
  fvis->init(Main);
  mn2->init(Main);
  cmdl = guiplugin->new_Cmdline(0, Mainh - 23 - mn2->menuh, Mainl, 6);
  cmdl->set_iname("CMDLINE");
  bmark->init(Main);
  fsw1->init(Main);
  fsw1->add_gui(mn);
#ifndef DISABLE_FTP
  fsw1->add_gui(fvis);
#endif
  bmark->create_listers(&lst1, &lst2, 0, mn->menuh, 23+mn2->menuh);
  lst1->init(Main);
  lst2->init(Main);
  cmdl->init(Main);
  lst1->setviewer(viewload, viewonlyload);
  lst2->setviewer(viewload, viewonlyload);
  lst1->seteditor(editload);
  lst2->seteditor(editload);
  fprintf(stderr, "Last version :  %s\n", created);
  fprintf(stderr, "Code compiled : %s\n", compiled);
  load_cfg(lst1, lst2);
  sprintf(str,"%s/.xnc/xnc.history",getenv("HOME"));
  fprintf(stderr,"Loading history........");
  init_history();
  hist_loadall(str,YES);

  fprintf(stderr, "Loading pixmaps.");
  load_pixmaps();
//  main_pixmap=get_rootwindow_pixmap();
  bmark->load_flags(7);
  if(is_back_load())
     fprintf(stderr, "later (back load)\n");
  else
     fprintf(stderr, "OK\n");
  unset_back_load();
  magic_init(magic_file_location, 1);
  hide_intro();
  fprintf(stderr, "Starting %s Build%s.....\n", ver, build_chr);

  map_vt_windows(main_pixmap);
  XMapWindow(disp, Main);
  bmark->rebuild_listers();
  lst1->show();
  lst2->show();
  mn->show();
  mn2->show();
  cmdl->show();
  fsw1->show();
  lst1->setpanel(lst2);
  lst2->setpanel(lst1);
  lst1->setcmdl(cmdl);
  lst2->setcmdl(cmdl);
  lst1->setsubmenu(submenu1);
  lst2->setsubmenu(submenu2);
  cmdl->setpath(panel->curdir);
  bmark->show();
  afstmp.set_dir_pointer(NULL, 1024);
  wmDeleteWindow = XInternAtom(disp, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(disp, Main, &wmDeleteWindow, 1);
//  full_reconfig();
  fprintf(stderr, "Copyright (c) 1995-2000 Leonid V. KHramov aka Leo <leo@xnc.dubna.su>\n");
  au_out=0;  //Switch off SUP compilation output.
}

void   xnc_animate()
{
  bmark->animate();
}

void   (*xnc_init) (int, char **) = xnc_main;
void   (*xnc_go) () = xnc_gofunc;
void   (*xnc_setsignals) () = xnc_sig;
void   (*xnc_setdir) () = xnc_sdir;
void   (*xnc_work_anim) () = xnc_animate;
int    (*xnc_look_for_key) (XEvent *) = look_for_key;
int    (*xnc_event) (XEvent *) = XEVENT;

int    xnc_ex = 1;
void   xnc_exit()
{
  char  *str;
  if (xnc_ex)
    {
      xnc_ex = 0;
      fprintf(stderr, "Exiting from XNC....");
      if (lst1 == NULL)
        {
          disp = NULL;
          fprintf(stderr, "OK\nSession aborted\n");
          return;
        };
      save_cfg(lst1, lst2);
      deinit_all_ftp();
      delete lst1;
      delete lst2;
      delete mn;
      delete mn2;
      delete cmdl;
      if (disp)
        {
          x_free_pixmaps();
        }
      str = new char[L_MAXPATH];
      sprintf(str, "rm -rf %s/.%d.*", syspath, getpid());
      psystem(str);
      sprintf(str, "rm -rf %s/AFS/afs.%d.*", syspath, getpid());
      psystem(str);
      deinit_scroll();
      if((option_bits & IVES_EXIT_TOO) && iclient && iclient->Init())
          sendtoives("shutdown", 6); //Say IVES bye, bye :)
      deinit_keysupport();
      deinit_AFS_supports();
      ftpcfg_deinit_hosts();
      sprintf(str,"%s/.xnc/xnc.history",getenv("HOME"));
      hist_saveall(str);
      delete str;
      fprintf(stderr, "OK\n");
      fprintf(stderr, "------------------------------------------------------------------------------\n");
      fprintf(stderr, "Notice:\n\tIf You like X Northern Captain and will use it,\n");
      fprintf(stderr,"\tthen send me e-mail to <leo@xnc.dubna.su> with names of\n");
      fprintf(stderr,"\tcity and country where you are using it. It's for my collection.\n");
      fprintf(stderr,"\tIf You do it, i'll be happy....\n");
      fprintf(stderr,"\t\t\tThanks,\n\t\t\tLeonid V. Khramov aka Leo <leo@xnc.dubna.su>\n");
      fprintf(stderr,"\nPS: If you have any questions, comments about xnc or you want\n"
	             "to know latest news then join to xnc mailing list <xnc@xnc.dubna.su>\n"
                     "Just mail a letter with 'SUBSCRIBE xnc' in the body of mail to\n"
	             "<majordomo@xnc.dubna.su> and you are inside.\n");
      fprintf(stderr, "------------------------------------------------------------------------------\n");
      fprintf(stderr, "Thank you. You have run X Northern Captain %d times!\n", xnc_starts);
      DeinitXClient();
    }
}
void   (*xnc_kill) () = xnc_exit;
void   (*xnc_run_once) () = 0;
