#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"
/* #define GDEBUG */

extern void createtable_setactive(struct edittable *it);
extern void createtable_setCT(struct edittable *it);
extern void start_ccompound(struct edittable *it);
extern struct setup Setup;
extern struct stat Stat;

extern int createtableNameExist(struct edittable *it, char *nom);
extern int createtableKeyExist(struct edittable *it, char *nom);
void ccomkey_setactive(struct edittable *it);
void ccomkey_varToObj(struct edittable *it);
void ccomkey_setBrowserKeylist(struct edittable *it);
void ccomkey_setBrowserParts(struct edittable *it, struct compoundkey *ck);
struct fields * ccomkey_fieldIndex(struct edittable *it, char *nom);
void ccomkey_setChoiceFields(struct edittable *it);

void ccomkey_setChoiceFields(struct edittable *it)
{
  struct fields *cur;

  fl_addto_choice(it->f_ccomkey->fieldname, "Select a column");
  
  cur = it->firstf;
  while(cur)
  {
    switch(cur->type)
    {
    case 2:  /* tinyint     */
    case 3:  /* smallint    */
    case 4:  /* mediumint   */
    case 5:  /* integer     */
    case 6:  /* big integer */
    case 7:  /* float       */
    case 8:  /* double      */
    case 9:  /* decimal     */
    case 10: /* char        */
    case 11: /* varchar     */
    case 16: /* timestamp   */
    case 17: /* date        */
    case 18: /* time        */
    {
      fl_addto_choice(it->f_ccomkey->fieldname, cur->name);
      break;
    }
    case 12: /* tinyblob    */
    case 13: /* blob        */
    case 14: /* mediumblob  */
    case 15: /* longblob    */
    {
      break;
    }
    }
    cur = cur->next;
  }
}

void ccomkey_setBrowserParts(struct edittable *it, struct compoundkey *ck)
{
  struct partkey *cur;

  if(fl_get_browser_maxline(it->f_ccomkey->parts))
    fl_clear_browser(it->f_ccomkey->parts);
  
  cur = ck->first;
  while(cur)
  {
    fl_addto_browser(it->f_ccomkey->parts, cur->nomField);
    cur = cur->next;
  }
}

void ccomkey_setBrowserKeylist(struct edittable *it)
{
  struct compoundkey *cur;
  
  if(fl_get_browser_maxline(it->f_ccomkey->keylist))
    fl_clear_browser(it->f_ccomkey->keylist);

  cur = it->firstc;
  while(cur)
  {
    fl_addto_browser(it->f_ccomkey->keylist, cur->nom);
    cur = cur->next;
  }
}

struct fields * ccomkey_fieldIndex(struct edittable *it, char *nom)
{
  struct fields *cur;
  
  cur = it->firstf;
  while(cur)
  {
    if(!stricmp(cur->name, nom))
    {
      break;
    }
    cur = cur->next;
  }
  return cur;
}


void ccomkey_varToObj(struct edittable *it)
{
  fl_freeze_form(it->f_ccomkey->ccomkey);
  fl_set_input(it->f_ccomkey->keyname, it->bufc->nom);
  switch(it->bufc->type)
  {
  case 'P' : fl_set_button(it->f_ccomkey->primary, 1); break;
  case 'U' : fl_set_button(it->f_ccomkey->unique , 1); break;
  default  : fl_set_button(it->f_ccomkey->multi  , 1);
  }
  
  /*--------------------------------------------------------------*/
  /* definit le maximum de longueurs de clee en fonction du champ */
  /*--------------------------------------------------------------*/
  {
    struct fields *cur;
    
    cur = ccomkey_fieldIndex(it, it->bufp->nomField);
    if(cur)
    {
      switch(cur->type)
      {
      case 2:  /* tinyint     */
      case 3:  /* smallint    */
      case 4:  /* mediumint   */
      case 5:  /* integer     */
      case 6:  /* big integer */
      case 7:  /* float       */
      case 8:  /* double      */
      {
	it->bufp->size = 0;
	fl_set_counter_bounds(it->f_ccomkey->keysize, 0.0, 0.0);
	break;
      }
      case 9:  /* decimal     */
      case 10: /* char        */
      case 11: /* varchar     */
      {
	fl_set_counter_bounds(it->f_ccomkey->keysize, 1.0, cur->length);
	break;
      }
      case 12: /* tinyblob    */
      case 13: /* blob        */
      case 14: /* mediumblob  */
      case 15: /* longblob    */
      case 16: /* timestamp   */
      case 17: /* date        */
      case 18: /* time        */
      {
	it->bufp->size = 0;
	fl_set_counter_bounds(it->f_ccomkey->keysize, 0.0, 0.0);
	break;
      }
      }
    }
  }
  fl_set_counter_value(it->f_ccomkey->keysize, (double) it->bufp->size);
  if(it->bufp->nomField[0])
  {
    fl_set_choice_text(it->f_ccomkey->fieldname, it->bufp->nomField);
  }
  else
  {
    fl_set_choice(it->f_ccomkey->fieldname, 1);
  }
  fl_unfreeze_form(it->f_ccomkey->ccomkey);

}


void ccomkey_setactive(struct edittable *it)
{
  int ligne;
  int totLignes;

  createtable_setCT(it);
  
  fl_freeze_form(it->f_ccomkey->ccomkey);

  /*-------------------------------------------------*/
  /* dans tous les cas, je desactive tous les champs */
  /* sauf le champ exit                              */
  /* les champs necessaires seront actives selon     */
  /* le contenu de la structure pointee par it->bufc */
  /*-------------------------------------------------*/
  g_activate_object(it->f_ccomkey->keylist);
  g_deactivate_object(it->f_ccomkey->keyname);
  g_deactivate_object(it->f_ccomkey->keyup);
  g_deactivate_object(it->f_ccomkey->keydn);
  g_deactivate_object(it->f_ccomkey->primary);
  g_deactivate_object(it->f_ccomkey->unique);
  g_deactivate_object(it->f_ccomkey->multi);
  g_deactivate_object(it->f_ccomkey->addkey);
  g_deactivate_object(it->f_ccomkey->modkey);
  g_deactivate_object(it->f_ccomkey->delkey);
  g_deactivate_object(it->f_ccomkey->parts);
  g_deactivate_object(it->f_ccomkey->partup);
  g_deactivate_object(it->f_ccomkey->partdn);
  g_deactivate_object(it->f_ccomkey->fieldname);
  g_deactivate_object(it->f_ccomkey->addpart);
  g_deactivate_object(it->f_ccomkey->modpart);
  g_deactivate_object(it->f_ccomkey->delpart);
  g_deactivate_object(it->f_ccomkey->keysize);

  
  
  /* si aucune selection dans keylist */
  ligne = fl_get_browser(it->f_ccomkey->keylist);
  if(ligne < 1)
  {
    g_activate_object(it->f_ccomkey->keyname);
    g_activate_object(it->f_ccomkey->unique);
    g_activate_object(it->f_ccomkey->multi);
    if(!it->ct->primary)
    {
      g_activate_object(it->f_ccomkey->primary);
    }
    if(it->ct->qtKeys < 16)
    {
      g_activate_object(it->f_ccomkey->addkey);
    }
  }
  else
  {
    /*-----------------------------------------*/
    /* un element est selectionne dans keylist */
    /*-----------------------------------------*/
    totLignes = fl_get_browser_maxline(it->f_ccomkey->keylist);

    g_activate_object(it->f_ccomkey->keyname);
    g_activate_object(it->f_ccomkey->unique);
    g_activate_object(it->f_ccomkey->multi);
    if(!it->ct->primary)
    {
      g_activate_object(it->f_ccomkey->primary);
    }
    if(it->ct->qtKeys < 16)
    {
      g_activate_object(it->f_ccomkey->addkey);
    }
    /*---------------------------------*/
    /* activation des fleches de clees */
    /*---------------------------------*/
    if(ligne < totLignes)
    {
      g_activate_object(it->f_ccomkey->keydn);
    }
    if(ligne > 1)
    {
      g_activate_object(it->f_ccomkey->keyup);
    }
    
    /*-------------------------------------------*/
    /* active modification et effacement de clee */
    /*-------------------------------------------*/
    g_activate_object(it->f_ccomkey->addkey);
    g_activate_object(it->f_ccomkey->modkey);
    g_activate_object(it->f_ccomkey->delkey);

    /*------------------------------------------------------*/
    /* active le browser part et les champs pour en ajouter */
    /*------------------------------------------------------*/
    g_activate_object(it->f_ccomkey->parts);
    g_activate_object(it->f_ccomkey->fieldname);
    g_activate_object(it->f_ccomkey->keysize);

    if(fl_get_choice(it->f_ccomkey->fieldname) > 1)
    {
      g_activate_object(it->f_ccomkey->addpart);
    }
    ligne = fl_get_browser(it->f_ccomkey->parts);
    totLignes = fl_get_browser_maxline(it->f_ccomkey->parts);
    if(ligne > 0)
    {
      if(fl_get_choice(it->f_ccomkey->fieldname) > 1)
      {
	g_activate_object(it->f_ccomkey->modpart);
	g_activate_object(it->f_ccomkey->delpart);
      }
      if(ligne > 1)
      {
	g_activate_object(it->f_ccomkey->partup);
      }
      if(ligne < totLignes)
      {
	g_activate_object(it->f_ccomkey->partdn);
      }
    }
  }
  fl_unfreeze_form(it->f_ccomkey->ccomkey);
}

void start_ccompound(struct edittable *it)
{
  /*--------------------------------------------------*/
  /* reserve la memoire des structure de travail      */
  /* place les pointeurs de la liste de champs a null */
  /*--------------------------------------------------*/
  it->bufc = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));
  it->bufp = (struct partkey *) calloc(1, sizeof(struct partkey));
  
  /*-----------------------------------*/
  /* cree et montre la forme de saisie */
  /*-----------------------------------*/
  it->f_ccomkey = create_form_ccomkey();
  it->f_ccomkey->vdata = (struct edittable *) it;

  fl_show_form(it->f_ccomkey->ccomkey, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin Compound keys");


  fl_freeze_form(it->f_ccomkey->ccomkey); 

  /*--------------------------------------*/
  /* limite la longueur des champs input  */
  /*--------------------------------------*/
  fl_set_input_maxchars(it->f_ccomkey->keyname, 32);

  /*-----------------------------*/
  /* change le font des browsers */
  /*-----------------------------*/
  fl_set_browser_fontstyle(it->f_ccomkey->parts, FL_FIXED_STYLE);
  fl_set_browser_fontsize(it->f_ccomkey->parts, FL_NORMAL_SIZE);
  fl_set_browser_fontstyle(it->f_ccomkey->keylist, FL_FIXED_STYLE);
  fl_set_browser_fontsize(it->f_ccomkey->keylist, FL_NORMAL_SIZE);


  /*----------------------------------*/
  /* set le browse des clees definies */
  /*----------------------------------*/
  ccomkey_setBrowserKeylist(it);
  
  /*---------------------------------------------------*/
  /* set le choix des champs a choisir comme sous clef */
  /*---------------------------------------------------*/
  ccomkey_setChoiceFields(it);
  
  /*----------------------*/
  /* desactive les objets */
  /*----------------------*/
  ccomkey_setactive(it);

  fl_unfreeze_form(it->f_ccomkey->ccomkey);

}
  
void ccomkey_close(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;
  fl_hide_form(it->f_ccomkey->ccomkey);
  fl_free_form(it->f_ccomkey->ccomkey);
  free(it->f_ccomkey);
  free(it->bufc);
  free(it->bufp);
  createtable_setactive(it);
}

void ccomkey_keylist(FL_OBJECT *obj, long data)
{
  int ligne;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  if(fl_get_browser_maxline(it->f_ccomkey->parts))
    fl_clear_browser(it->f_ccomkey->parts);
  
  memset(it->bufc, '\0', sizeof(struct compoundkey));
  ligne = fl_get_browser(obj);
  if(ligne > 0)
  {
    struct compoundkey *cur;
    int i = 1;
    cur = it->firstc;
    while(cur)
    {
      if(i == ligne) 
      {
	break;
      }
      cur = cur->next;
      i++;
    }
  
    if(cur)
    {
      memcpy(it->bufc, cur, sizeof(struct compoundkey));
      ccomkey_varToObj(it);
      ccomkey_setBrowserParts(it, cur);
    }
  }
  ccomkey_setactive(it);
}

void ccomkey_keyname(FL_OBJECT *obj, long data)
{
  char nom[33];
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  
  strcpy(nom, fl_get_input(obj));
  trim(nom);

  /*-------------------------------------------------------*/
  /* verifie si le nom du champ est valide dans sa syntaxe */
  /*-------------------------------------------------------*/
  {
    char *p;
    p = nom;
    while(*p)
    {
      if(isspace(*p) || (ispunct(*p) && *p != '_') || iscntrl(*p))
      {
        fl_set_input(obj, "");
        return;
      }
      p++;
    }
  }

  /*-----------------------------------*/
  /* verifie si le nom existe ailleurs */
  /*-----------------------------------*/
  if(createtableKeyExist(it, nom))
  {
    fl_show_alert("The key name", nom, "already exist", 1);
    nom[0] = '\0';
    return;
  }

  strcpy(it->bufc->nom, nom);
  ccomkey_varToObj(it);
  ccomkey_setactive(it);
}

void ccomkey_keyup(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct compoundkey *cur;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  cur = it->firstc;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct compoundkey *cp, *cn, *cpp;

    cp = cur->prev;
    cpp= cur->prev->prev;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cn)
    {
      cn->prev = cp;
    }
    else
    {
      it->lastc = cp;
    }
    cp->next = cn;

    /* rattache courant */
    cur->next = cp;
    cur->prev = cpp;
    cp->prev = cur;
    if(cpp)
    {
      cpp->next = cur;
    }
    else
    {
      it->firstc = cur;
    }
  }

  ccomkey_setBrowserKeylist(it);
  index--;
  fl_select_browser_line(it->f_ccomkey->keylist, index);
  ccomkey_setactive(it);
}
void ccomkey_keydn(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct compoundkey *cur;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  cur = it->firstc;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct compoundkey *cp, *cn, *cnn;

    cp = cur->prev;
    cnn= cur->next->next;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cp)
    {
      cp->next = cn;
    }
    else
    {
      it->firstc = cn;
    }
    cn->prev = cp;

    /* rattache courant */
    cur->next = cnn;
    cur->prev = cn;
    cn->next = cur;
    if(cnn)
    {
      cnn->prev = cur;
    }
    else
    {
      it->lastc = cur;
    }
  }
  
  ccomkey_setBrowserKeylist(it);
  index++;
  fl_select_browser_line(it->f_ccomkey->keylist, index);
  ccomkey_setactive(it);
}

void ccomkey_primary(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  it->bufc->type = 'P';
  ccomkey_setactive(it);
}
void ccomkey_unique(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  it->bufc->type = 'U';
  ccomkey_setactive(it);
}
void ccomkey_multi(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  it->bufc->type = 'M';
  ccomkey_setactive(it);
}

void ccomkey_addkey(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /*------------------------*/
  /* validation des donnees */
  /*------------------------*/
  if(fl_get_button(it->f_ccomkey->primary))
  {
    it->bufc->type = 'P';
  }
  if(fl_get_button(it->f_ccomkey->unique))
  {
    it->bufc->type = 'U';
  }
  if(fl_get_button(it->f_ccomkey->multi))
  {
    it->bufc->type = 'M';
  }

		     
  /*------------------------------------------------*/
  /* si le nom du champ courant != nom dans l'input */
  /* process l'input                                */
  /*------------------------------------------------*/
  if(strcmp(it->bufc->nom, fl_get_input(it->f_createtable->fieldName)))
  {
    ccomkey_keyname(it->f_ccomkey->keyname, 0L);
  }

  if(!it->bufc->nom[0])
  {
    fl_show_alert("The key name","must be provided","", 1);
    return;
  }
  if(createtableKeyExist(it, it->bufc->nom))
  {
    fl_show_alert("The key name", it->bufc->nom, "already exist", 1);
    return;
  }

  /*--------------------------------*/
  /* ajout de la clee dans la liste */
  /*--------------------------------*/
  {
    struct compoundkey *cur;
    cur = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));
    if(!it->firstc)
    {
      it->firstc = it->lastc = cur;
    }
    else
    {
      it->lastc->next = cur;
      cur->prev = it->lastc;
      it->lastc = cur;
    }
    cur->index = 1000;
    cur->type  = it->bufc->type;
    strcpy(cur->nom, it->bufc->nom);
  }
  
  /*---------------------------------------------------*/
  /* reload le browser et selectionne le dernier champ */
  /*---------------------------------------------------*/
  if(fl_get_browser_maxline(it->f_ccomkey->parts))
    fl_clear_browser(it->f_ccomkey->parts);
  ccomkey_setBrowserKeylist(it);
  fl_select_browser_line(it->f_ccomkey->keylist, fl_get_browser_maxline(it->f_ccomkey->keylist));
  createtable_setCT(it);
  ccomkey_setactive(it);
}

void ccomkey_modkey(FL_OBJECT *obj, long data)
{
  int index;
  int indexCur;
  struct compoundkey *cur, *bcur, *bbuf;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->keylist);
  indexCur = 1;

  cur = it->firstc;
  while(cur && indexCur < index)
  {
    indexCur++;
    cur = cur->next;
  }

  if(!cur) return;

  /*-----------------------------------------*/
  /* prend un backup de l'information de cur */
  /* et de it->buff                    */
  /*-----------------------------------------*/
  bcur = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));
  bbuf = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));
  memcpy(bcur, cur, sizeof(struct compoundkey));
  memcpy(bbuf, it->buff, sizeof(struct compoundkey));

  /*--------------------------------------*/
  /* efface l'information pointee par cur */
  /* afin de faire le bon compte setCT    */
  /*--------------------------------------*/
  cur->nom[0] = '\0';
  createtable_setCT(it);

  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /* verifie si la fiche modifiee est valide */
  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /*------------------------------------------------*/
  /* si le nom du champ courant != nom dans l'input */
  /* process l'input                                */
  /*------------------------------------------------*/
  if(strcmp(it->bufc->nom, fl_get_input(it->f_createtable->fieldName)))
  {
    ccomkey_keyname(it->f_ccomkey->keyname, 0L);
  }

  /*----------------------------*/
  /* le nom du champ est requis */
  /*----------------------------*/
  if(!it->bufc->nom[0])
  {
    fl_show_alert("key name is required","","",1);
    memcpy(cur, bcur, sizeof(struct compoundkey));
    memcpy(it->bufc, bbuf, sizeof(struct compoundkey));
    free(bcur);
    free(bbuf);
    createtable_setCT(it);
    return;
  }


  /*-------------------------------*/
  /* tout est ok, modifie l'entree */
  /*-------------------------------*/
  cur->index = 1000;
  cur->type  = it->bufc->type;
  strcpy(cur->nom, it->bufc->nom);
  free(bcur);
  free(bbuf);

  ccomkey_varToObj(it);
  ccomkey_setBrowserKeylist(it);
  fl_select_browser_line(it->f_ccomkey->keylist, indexCur);
  createtable_setCT(it);
  ccomkey_setactive(it);
}
void ccomkey_delkey(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct compoundkey *cur, *cp, *cn;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  cur = it->firstc;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;


  /*------------------------------------*/
  /* efface les champs parts de la clee */
  /*------------------------------------*/
  {
    struct partkey *part;
    part = cur->first;
    while(part)
    {
      cur->first = cur->first->next;
      free(part);
      part = cur->first;
    }
  }
  
  /*------------------------------*/
  /* detache le champ de la liste */
  /*------------------------------*/
  cp = cur->prev;
  cn = cur->next;
  if(!cn && !cp)
  {
    it->firstc = it->lastc = NULL;
  }
  else
  {
    if(!cn)
    {
      cp->next = NULL;
      it->lastc = cp;
    }
    else
    {
      if(!cp)
      {
        cn->prev = NULL;
        it->firstc = cn;
      }
      else
      {
        cn->prev = cp;
        cp->next = cn;
      }
    }
  }

  /* efface l'element de la liste */
  free(cur);

  /* efface l'affichage courant de l'element */
  memset(it->bufc, '\0', sizeof(struct compoundkey));

  ccomkey_varToObj(it);
  ccomkey_setBrowserKeylist(it);
  createtable_setCT(it);
  ccomkey_setactive(it);
}

void ccomkey_parts(FL_OBJECT *obj, long data)
{
  int ligne;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  memset(it->bufp, '\0', sizeof(struct partkey));
  ligne = fl_get_browser(obj);
  if(ligne > 0)
  {
    struct partkey *cur;
    int i = 1;
    cur = it->bufc->first;
    while(cur)
    {
      if(i == ligne) 
      {
	break;
      }
      cur = cur->next;
      i++;
    }
  
    if(cur)
    {
      memcpy(it->bufp, cur, sizeof(struct partkey));
      ccomkey_varToObj(it);
    }
  }
  ccomkey_setactive(it);
}
void ccomkey_partup(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct partkey *cur;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->parts);
  i = 1;

  cur = it->bufc->first;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct partkey *cp, *cn, *cpp;

    cp = cur->prev;
    cpp= cur->prev->prev;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cn)
    {
      cn->prev = cp;
    }
    else
    {
      it->bufc->last = cp;
    }
    cp->next = cn;

    /* rattache courant */
    cur->next = cp;
    cur->prev = cpp;
    cp->prev = cur;
    if(cpp)
    {
      cpp->next = cur;
    }
    else
    {
      it->bufc->first = cur;
    }
  }

  ccomkey_setBrowserParts(it, it->bufc);
  index--;
  fl_select_browser_line(it->f_ccomkey->parts, index);
  ccomkey_setactive(it);
  
}
void ccomkey_partdn(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct partkey *cur;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->parts);
  i = 1;

  cur = it->bufc->first;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct partkey *cp, *cn, *cnn;

    cp = cur->prev;
    cnn= cur->next->next;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cp)
    {
      cp->next = cn;
    }
    else
    {
      it->bufc->first = cn;
    }
    cn->prev = cp;

    /* rattache courant */
    cur->next = cnn;
    cur->prev = cn;
    cn->next = cur;
    if(cnn)
    {
      cnn->prev = cur;
    }
    else
    {
      it->bufc->last = cur;
    }
  }
  
  
  ccomkey_setBrowserParts(it, it->bufc);
  index++;
  fl_select_browser_line(it->f_ccomkey->parts, index);
  ccomkey_setactive(it);

}
void ccomkey_fieldname(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;
  
  if(fl_get_choice(it->f_ccomkey->fieldname) > 1)
  {
    strcpy(it->bufp->nomField, fl_get_choice_text(obj));
  }
  else
  {
    it->bufp->nomField[0] = '\0';
  }

  /*------------------------------------------------------------*/
  /* definit le defaut de longueur de clee en fonction du champ */
  /*------------------------------------------------------------*/
  if(it->bufp->nomField[0])
  {
    struct fields *cur;
    
    cur = ccomkey_fieldIndex(it, it->bufp->nomField);
    if(cur)
    {
      switch(cur->type)
      {
      case 2:  /* tinyint     */
      case 3:  /* smallint    */
      case 4:  /* mediumint   */
      case 5:  /* integer     */
      case 6:  /* big integer */
      case 7:  /* float       */
      case 8:  /* double      */
      {
	it->bufp->size = 0;
	break;
      }
      case 9:  /* decimal     */
      case 10: /* char        */
      case 11: /* varchar     */
      {
	it->bufp->size = (int) cur->length;
	break;
      }
      case 12: /* tinyblob    */
      case 13: /* blob        */
      case 14: /* mediumblob  */
      case 15: /* longblob    */
      case 16: /* timestamp   */
      case 17: /* date        */
      case 18: /* time        */
      {
	it->bufp->size = 0;
	break;
      }
      }
    
      fl_set_counter_value(it->f_ccomkey->keysize, (double) it->bufp->size);
    }
  }
  
  ccomkey_varToObj(it);
  ccomkey_setactive(it);
}
void ccomkey_addpart(FL_OBJECT *obj, long data)
{
  int index, i;
  struct compoundkey *ck;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* field name is required */
  if(!it->bufp->nomField[0])
  {
    return;
  }

  /*--------------------------------------------------------*/
  /* trouve la position dans la liste de index proprietaire */
  /*--------------------------------------------------------*/
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  ck = it->firstc;
  while(ck && i < index)
  {
    i++;
    ck = ck->next;
  }

  if(!ck) return;
  
  /*--------------------------------*/
  /* ajout de la clee dans la liste */
  /*--------------------------------*/
  {
    struct partkey *cur;
    cur = (struct partkey *) calloc(1, sizeof(struct partkey));
    if(!ck->first)
    {
      ck->first = ck->last = cur;
    }
    else
    {
      ck->last->next = cur;
      cur->prev = ck->last; 
      ck->last = cur;
    }

    /* copie les informations de la clef dans la liste */
    ck->index = 1000;
    cur->index = 1000;
    cur->size = it->bufp->size;
    strcpy(cur->nomField, it->bufp->nomField);
  }
  
  /*---------------------------------------------------*/
  /* reload le browser et selectionne le dernier champ */
  /*---------------------------------------------------*/
  ccomkey_setBrowserParts(it, ck);
  fl_select_browser_line(it->f_ccomkey->parts, fl_get_browser_maxline(it->f_ccomkey->parts));
  createtable_setCT(it);
  ccomkey_setactive(it);
}
void ccomkey_modpart(FL_OBJECT *obj, long data)
{
  int index, i;
  int indexCur;
  struct compoundkey *ck;
  struct partkey *cur;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* field name is required */
  if(!it->bufp->nomField[0])
  {
    return;
  }

  
  /* trouve la position dans la liste des compound keys */
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  ck = it->firstc;
  while(ck && i < index)
  {
    i++;
    ck = ck->next;
  }

  if(!ck) return;
  
  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->parts);
  indexCur = 1;

  cur = ck->first;
  while(cur && indexCur < index)
  {
    indexCur++;
    cur = cur->next;
  }

  if(!cur) return;

  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /* verifie si la fiche modifiee est valide */
  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /*-------------------------------*/
  /* tout est ok, modifie l'entree */
  /*-------------------------------*/
  ck->index = 1000;
  cur->index = 1000;
  cur->size = it->bufp->size;
  strcpy(cur->nomField, it->bufp->nomField);

  ccomkey_varToObj(it);
  ccomkey_setBrowserParts(it, ck);
  fl_select_browser_line(it->f_ccomkey->parts, indexCur);
  ccomkey_setactive(it);
}
void ccomkey_delpart(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct compoundkey *ck;
  struct partkey *cur, *cp, *cn;
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  /* trouve la position dans la liste des compound keys */
  index = fl_get_browser(it->f_ccomkey->keylist);
  i = 1;

  ck = it->firstc;
  while(ck && i < index)
  {
    i++;
    ck = ck->next;
  }

  if(!ck) return;


  ck->index = 1000;  
  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_ccomkey->parts);
  i = 1;

  cur = ck->first;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /*------------------------------*/
  /* detache le champ de la liste */
  /*------------------------------*/
  cp = cur->prev;
  cn = cur->next;
  if(!cn && !cp)
  {
    ck->first = ck->last = NULL;
  }
  else
  {
    if(!cn)
    {
      cp->next = NULL;
      ck->last = cp;
    }
    else
    {
      if(!cp)
      {
        cn->prev = NULL;
        ck->first = cn;
      }
      else
      {
        cn->prev = cp;
        cp->next = cn;
      }
    }
  }

  /* efface l'element de la liste */
  free(cur);

  /* efface l'affichage courant de l'element */
  memset(it->bufp, '\0', sizeof(struct partkey));
  
  
  ccomkey_setBrowserParts(it, ck);
  ccomkey_setactive(it);
}
void ccomkey_keysize(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_ccomkey *cc;
  cc = (FD_ccomkey *) obj->form->fdui;
  it = (struct edittable *) cc->vdata;

  it->bufp->size = (int) fl_get_counter_value(obj);
}

