#include "XmysqlDB.h"
#include "XmysqlErr.h"
#include "Xmysql_def.h"

/* prototypes */
char *strmov (char *dst, const char *src);
char *strfill (char *s, uint len, int fill);

/* this macro is used to make sure all returns clean up resources */
#define RETURN(res) \
{ \
	ChangeCursor(0); \
	if (data != 0) { \
		mysql_free_result(data); \
		data = 0; \
	} \
	if (sock) { \
		mysql_close(sock); \
		sock = 0; \
	} \
	return res; \
}

int
XmysqlDB (int dbaction, int results_to_file)
{
	FD_Xmysql_query_results *fd = 0;
	char browserStr[MAX_BROWSER_STR + 1000];
	char dataLine[MAX_BROWSER_STR + 1000];
	char errStr[50];
	char sqlStr[MAX_BROWSER_STR + 1000];
	MYSQL_RES *data = 0;
	MYSQL_ROW cursor;
	FieldInfo *f = 0;
	int count, rc;
	int rows, cols, x, headers;
	const char *input = 0;
	MYSQL *sock = 0, mysql;
	unsigned long rows_affected = 0;
	char *semicolon = 0;
	char *pos = 0, *r = 0, *r_end = 0;
	unsigned long *lengths = 0;
	int total_lines = 0;
	int maxSize = 0;
	int maxLen = 0;
	int emptyLines = 0;
	char fillSpace = 0;
	const char *user = 0;
	const char *pass = 0;
	unsigned int port = MYSQL_PORT;
	const char *isocket = 0;

	/* save last DB request for later output use */
	LAST_DB_ACTION = dbaction;

	rc = FALSE;										/* it worked */
	count = rows = cols = 0;

	/* clear out status for all open windows */
	XmysqlErr ("INFO",
						 " ",
						 " ",
						 " ");

	/* connect */
	if (CURRENT_USER[0] != 0)
		user = CURRENT_USER;
	if (CURRENT_PASSWORD[0] != 0)
		pass = CURRENT_PASSWORD;
	if (CURRENT_PORT[0] != 0)
		port = atoi (CURRENT_PORT);
	if (CURRENT_SOCKET[0] != 0)
		isocket = CURRENT_SOCKET;
	else
		isocket = MYSQL_UNIX_ADDR;

	ChangeCursor (XC_watch);

#ifndef HAVE_MYSQL_REAL_CONNECT
	if (!(sock = mysql_connect (&mysql, CURRENT_SERVER,
															(char *) user,
															(char *) pass))) {
		sprintf (dataLine, "Host: %s, Port: %d, Socket: %s",
						 CURRENT_SERVER, port, isocket);
		XmysqlErr ("ALERT",
							 "ERROR: Can't connect to MySQL Server:",
							 dataLine,
							 " ");
		RETURN (TRUE);
	}
#else
#if MYSQL_VERSION_ID < 32200
	if (!(sock = mysql_real_connect (&mysql, CURRENT_SERVER,
																	 (char *) user,
																	 (char *) pass,
																	 port,
																	 isocket, 0)))
#else
	mysql_init (&mysql);
	if (!(sock = mysql_real_connect (&mysql, CURRENT_SERVER,
																	 (char *) user,
																	 (char *) pass,
																	 (char *) 0,	/* No database */
																	 port,
																	 isocket, 0)))
#endif
	{
		sprintf (dataLine, "Host: %s, Port: %d, Socket: %s\nError: '%s'",
						 CURRENT_SERVER, port, isocket, mysql_error (&mysql));
		XmysqlErr ("ALERT",
							 "ERROR: Can't connect to MySQL Server:",
							 dataLine,
							 " ");
		RETURN (TRUE);
	}
#endif

	switch (dbaction) {
		case XMYSQL_BUILD_TABLEFIELD_INFO:
			if (mysql_select_db (sock, CURRENT_DATABASE) < 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't select database.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			sprintf (sqlStr, "%s%s LIMIT %d", "SELECT * FROM ",
							 CURRENT_TABLE, 1);
			rc = mysql_query (sock, sqlStr);
			if (rc >= 0) {
				data = mysql_store_result (sock);
				cols = mysql_num_fields (data);
				/* clean up any previous memory used for tablefieldinfo */
				FreeTableFieldInfo ();
				/* create new tablefieldinfo */
				TABLEFIELDINFO.tableName = strdup (CURRENT_TABLE);
				TABLEFIELDINFO.databaseName = strdup (CURRENT_DATABASE);
				TABLEFIELDINFO.nbrFields = cols;
				TABLEFIELDINFO.fields = (FieldInfo **) calloc (sizeof (FieldInfo), cols);
				for (count = 0; count < cols; count++) {
					f = (FieldInfo *) calloc (sizeof (FieldInfo), 1);
					f->field.name = strdup (data->fields[count].name);
					f->field.table = strdup (data->fields[count].table);
					if (data->fields[count].def)
						f->field.def = strdup (data->fields[count].def);
					f->field.type = data->fields[count].type;
					f->field.length = data->fields[count].length;
					f->field.max_length = data->fields[count].max_length;
					f->field.flags = data->fields[count].flags;
					f->field.decimals = data->fields[count].decimals;
					TABLEFIELDINFO.fields[count] = f;
				}
			}
			break;

		case XMYSQL_GET_DATABASES:
			fl_clear_browser (Xmysql_main_screen->xmysql_databases);
			sprintf (sqlStr, "SHOW DATABASES");
			rc = mysql_query (sock, sqlStr);
			if (rc >= 0) {
				data = mysql_store_result (sock);
				rows = data->row_count;
				cols = mysql_num_fields (data);
				if (rows > 0) {
					fl_freeze_form (Xmysql_main_screen->Xmysql_main);
					for (count = 0; count < rows; count++) {
						cursor = mysql_fetch_row (data);
						sprintf (dataLine, "%s", cursor[cols - 1]);
						fl_add_browser_line (Xmysql_main_screen->xmysql_databases,
																 dataLine);
					}
					fl_unfreeze_form (Xmysql_main_screen->Xmysql_main);
					fl_set_browser_topline (Xmysql_main_screen->xmysql_databases, 1);
				}
				else {
					sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
					XmysqlErr ("INFO",
										 "ERROR: No databases!",
										 mysql_error (sock),
										 errStr);
					RETURN (FALSE);
				}
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't show databases.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			break;

		case XMYSQL_GET_TABLES:
		case XMYSQL_SQLGET_TABLES:
		case XMYSQL_ADMIN_TABLES:
			if (dbaction == XMYSQL_GET_TABLES)
				fl_clear_browser (Xmysql_main_screen->xmysql_tables);
			else if (dbaction == XMYSQL_SQLGET_TABLES)
				fl_clear_browser (Xmysql_sql_screen->xmysql_sql_tables);
			else
				fl_clear_browser (Xmysql_table_admin_screen->xmysql_tables);

			sprintf (sqlStr, "SHOW TABLES FROM %s", CURRENT_DATABASE);
			rc = mysql_query (sock, sqlStr);
			if (rc >= 0) {
				data = mysql_store_result (sock);
				rows = data->row_count;
				cols = mysql_num_fields (data);
				if (rows > 0) {
					for (count = 0; count < rows; count++) {
						cursor = mysql_fetch_row (data);
						sprintf (dataLine, "%s", cursor[cols - 1]);
						if (dbaction == XMYSQL_SQLGET_TABLES)
							fl_add_browser_line (Xmysql_sql_screen->xmysql_sql_tables,
																	 dataLine);
						else if (dbaction == XMYSQL_GET_TABLES)
							fl_add_browser_line (Xmysql_main_screen->xmysql_tables,
																	 dataLine);
						else
							fl_add_browser_line (Xmysql_table_admin_screen->xmysql_tables,
																	 dataLine);
					}
					if (dbaction == XMYSQL_SQLGET_TABLES)
						fl_set_browser_topline (Xmysql_sql_screen->xmysql_sql_tables, 1);
					else if (dbaction == XMYSQL_GET_TABLES)
						fl_set_browser_topline (Xmysql_main_screen->xmysql_tables, 1);
					else
						fl_set_browser_topline (Xmysql_table_admin_screen->xmysql_tables, 1);
				}
				else {
					sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
					XmysqlErr ("INFO",
										 "ERROR: No tables!",
										 mysql_error (sock),
										 errStr);
					RETURN (FALSE);
				}
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't show tables.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}

			break;

		case XMYSQL_GET_FIELDS_MAIN:
		case XMYSQL_SQLGET_FIELDS:
			if (dbaction == XMYSQL_GET_FIELDS_MAIN) {
				fl_clear_browser (Xmysql_main_screen->xmysql_tableFieldDefinitions);
				sprintf (sqlStr, "SHOW FIELDS FROM %s FROM %s",
								 CURRENT_TABLE,
								 CURRENT_DATABASE);
			}
			else {
				fl_clear_browser (Xmysql_sql_screen->xmysql_fields);
				sprintf (sqlStr, "SHOW FIELDS FROM %s FROM %s",
								 CURRENT_SQL_TABLE,
								 CURRENT_DATABASE);
			}
			rc = mysql_query (sock, sqlStr);
			if (rc >= 0) {
				if (dbaction == XMYSQL_SQLGET_FIELDS)
					fl_add_browser_line (Xmysql_sql_screen->xmysql_fields, "*");
				data = mysql_store_result (sock);
				rows = data->row_count;
				cols = mysql_num_fields (data);
				if (rows > 0) {
					if (dbaction == XMYSQL_GET_FIELDS_MAIN) {
						sprintf (dataLine, "%-32s %-30s %-20s %-20s %-20s",
							"FIELDS", "TYPE", "Key=PRI/MUL Null=YES", "DEFAULT", "EXTRA");
						fl_add_browser_line (Xmysql_main_screen->xmysql_tableFieldDefinitions,
																 dataLine);
						sprintf (dataLine, "%-32s %-30s %-20s %-20s %-20s",
										 "================================",
										 "==============================",
										 "====================",
										 "====================",
										 "====================");
						fl_add_browser_line (Xmysql_main_screen->xmysql_tableFieldDefinitions,
																 dataLine);
					}

					for (count = 0; count < rows; count++) {
						cursor = mysql_fetch_row (data);
						memset (browserStr, 0, sizeof (browserStr));
						if (dbaction == XMYSQL_GET_FIELDS_MAIN) {
							for (x = 0; x < cols; x++) {
								if (cursor[x] && *cursor[x]) {
									if (x == 0)
										sprintf (dataLine, "%-32s", cursor[x]);
									else if (x == 1)
										sprintf (dataLine, "%-30s", cursor[x]);
									else
										sprintf (dataLine, "%-20s", cursor[x]);
									strcat (browserStr, dataLine);
									if ((x + 1) < cols)
										strcat (browserStr, " ");
								}
							}
							fl_add_browser_line (Xmysql_main_screen->xmysql_tableFieldDefinitions,
																	 browserStr);
						}
						else {
							sprintf (browserStr, "%s", cursor[0]);
							fl_add_browser_line (Xmysql_sql_screen->xmysql_fields,
																	 browserStr);
						}
					}
					if (dbaction == XMYSQL_GET_FIELDS_MAIN)
						fl_set_browser_topline (Xmysql_main_screen->xmysql_tableFieldDefinitions, 1);
					else
						fl_set_browser_topline (Xmysql_sql_screen->xmysql_fields, 1);
				}
				else {
					sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
					XmysqlErr ("INFO",
										 "ERROR: No fields!",
										 mysql_error (sock),
										 errStr);
					RETURN (FALSE);
				}
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't show fields.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}

			break;

		case XMYSQL_FINDREC_FOR_UPDATE:
			if (mysql_select_db (sock, TABLEFIELDINFO.databaseName) < 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't select database.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			rc = mysql_query (sock, BATCH_SQL);
			if (rc >= 0) {
				data = mysql_store_result (sock);
				rows = data->row_count;
				cols = mysql_num_fields (data);
				cursor = mysql_fetch_row (data);
				if (rows > 1 || rows == 0) {
					XmysqlErr ("INFO",
										 "ERROR: More than one record found or none found.",
										 "Please provide the proper WHERE clause.",
										 "Update not possible.");
					RETURN (TRUE);
				}
				/* find longest field name */
				maxSize = GetMaxFieldSize ();
				for (x = 0; x < cols; x++) {
					f = TABLEFIELDINFO.fields[x];
					sprintf (browserStr, "%-*s %s",
									 maxSize,
									 f->field.name,
									 cursor[x] ? cursor[x] : "NULL");
					fl_add_browser_line (Xmysql_addrec_screen->xmysql_record, browserStr);
				}
				RETURN (FALSE);
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't perform query.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}

			break;

		case XMYSQL_ADDREC:
			if (mysql_select_db (sock, TABLEFIELDINFO.databaseName) < 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't select database.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			total_lines = fl_get_browser_maxline (Xmysql_addrec_screen->xmysql_record);
			/* find longest field name */
			maxSize = GetMaxFieldSize ();

			memset (browserStr, 0, sizeof (browserStr));
			sprintf (browserStr, "INSERT INTO %s (", TABLEFIELDINFO.tableName);
			for (x = 1; x <= total_lines; x++) {
				f = TABLEFIELDINFO.fields[x - 1];
				strcat (browserStr, f->field.name);
				if (x < total_lines)
					strcat (browserStr, ",");
				else
					strcat (browserStr, ") VALUES (");
			}
			for (x = 1; x <= total_lines; x++) {
				input = fl_get_browser_line (Xmysql_addrec_screen->xmysql_record, x);
				memset (sqlStr, 0, sizeof (sqlStr));
				strcpy (sqlStr, &input[maxSize + 1]);
				if (strlen (sqlStr) == 0)
					emptyLines++;
				f = TABLEFIELDINFO.fields[x - 1];

				switch (f->field.type) {
					case FIELD_TYPE_CHAR:
					case FIELD_TYPE_VAR_STRING:
					case FIELD_TYPE_STRING:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_SET:
					case FIELD_TYPE_INTERVAL:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_DECIMAL:
					case FIELD_TYPE_SHORT:
					case FIELD_TYPE_LONG:
					case FIELD_TYPE_LONGLONG:
					case FIELD_TYPE_INT24:
#if MYSQL_VERSION_ID >= 3220
					case FIELD_TYPE_YEAR:
#endif
						strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_FLOAT:
					case FIELD_TYPE_DOUBLE:
						strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_NULL:
						if (strlen (sqlStr) == 0)
							strcat (browserStr, "NULL");
						else
							strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_DATE:
#if MYSQL_VERSION_ID >= 32200
					case FIELD_TYPE_NEWDATE:
#endif
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_TIMESTAMP:
#if MYSQL_VERSION_ID >= 32200
					case FIELD_TYPE_DATETIME:
#endif
						if (strlen (sqlStr) == 0)
							strcat (browserStr, "NULL");
						else {
							strcat (browserStr, "\"");
							strcat (browserStr, sqlStr);
							strcat (browserStr, "\"");
						}
						break;

					case FIELD_TYPE_TIME:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_TINY_BLOB:
					case FIELD_TYPE_MEDIUM_BLOB:
					case FIELD_TYPE_LONG_BLOB:
					case FIELD_TYPE_BLOB:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;
				}
				if (x < total_lines)
					strcat (browserStr, ",");
				else
					strcat (browserStr, ")");
			}
			if (emptyLines == total_lines) {
				XmysqlErr ("INFO",
									 "ERROR: Record not added for:",
									 TABLEFIELDINFO.tableName,
									 "Record had all empty fields!");
				RETURN (TRUE);
			}
			rc = mysql_query (sock, browserStr);
			if (rc >= 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "SUCCESS: Record was added for:",
									 TABLEFIELDINFO.tableName,
									 errStr);
				RETURN (FALSE);
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Record not added for:",
									 TABLEFIELDINFO.tableName,
									 mysql_error (sock));
				RETURN (TRUE);
			}
			break;

		case XMYSQL_UPDATEREC:
			if (mysql_select_db (sock, TABLEFIELDINFO.databaseName) < 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't select database.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			total_lines = fl_get_browser_maxline (Xmysql_addrec_screen->xmysql_record);
			/* find longest field name */
			maxSize = GetMaxFieldSize ();

			memset (browserStr, 0, sizeof (browserStr));
			sprintf (browserStr, "UPDATE %s SET ", TABLEFIELDINFO.tableName);
			for (x = 1; x <= total_lines; x++) {
				f = TABLEFIELDINFO.fields[x - 1];
				strcat (browserStr, f->field.name);
				strcat (browserStr, "=");
				input = fl_get_browser_line (Xmysql_addrec_screen->xmysql_record, x);
				memset (sqlStr, 0, sizeof (sqlStr));
				strcpy (sqlStr, &input[maxSize + 1]);
				if (strlen (sqlStr) == 0)
					emptyLines++;

				switch (f->field.type) {
					case FIELD_TYPE_CHAR:
					case FIELD_TYPE_VAR_STRING:
					case FIELD_TYPE_STRING:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_SET:
					case FIELD_TYPE_INTERVAL:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_DECIMAL:
					case FIELD_TYPE_SHORT:
					case FIELD_TYPE_LONG:
					case FIELD_TYPE_LONGLONG:
					case FIELD_TYPE_INT24:
#if MYSQL_VERSION_ID >= 3220
					case FIELD_TYPE_YEAR:
#endif
						strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_FLOAT:
					case FIELD_TYPE_DOUBLE:
						strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_NULL:
						if (strlen (sqlStr) == 0)
							strcat (browserStr, "NULL");
						else
							strcat (browserStr, sqlStr);
						break;

					case FIELD_TYPE_DATE:
#if MYSQL_VERSION_ID >= 32200
					case FIELD_TYPE_NEWDATE:
#endif
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_TIMESTAMP:
					case FIELD_TYPE_DATETIME:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_TIME:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;

					case FIELD_TYPE_TINY_BLOB:
					case FIELD_TYPE_MEDIUM_BLOB:
					case FIELD_TYPE_LONG_BLOB:
					case FIELD_TYPE_BLOB:
						strcat (browserStr, "\"");
						strcat (browserStr, sqlStr);
						strcat (browserStr, "\"");
						break;
				}
				if (x < total_lines)
					strcat (browserStr, ",");
				else
					strcat (browserStr, UPDATE_WHERE);
			}
			if (emptyLines == total_lines) {
				XmysqlErr ("INFO",
									 "ERROR: Record not updated for:",
									 TABLEFIELDINFO.tableName,
									 "Record had all empty fields!");
				RETURN (TRUE);
			}
			rc = mysql_query (sock, browserStr);
			if (rc >= 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "SUCCESS: Record was updated for:",
									 TABLEFIELDINFO.tableName,
									 errStr);
				RETURN (FALSE);
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Record not updated for:",
									 TABLEFIELDINFO.tableName,
									 mysql_error (sock));
				RETURN (TRUE);
			}
			break;

		case XMYSQL_SUBMIT_SQL:
		case XMYSQL_QUICK_SELECT:
		case XMYSQL_BATCH_SQL:
		case XMYSQL_SUBMIT_TABLESQL:
			if (mysql_select_db (sock, CURRENT_DATABASE) < 0) {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't select database.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}

			if (dbaction == XMYSQL_SUBMIT_SQL) {
				input = fl_get_input (Xmysql_sql_screen->xmysql_freeForm);
				sprintf (sqlStr, "%s", input);
				semicolon = 0;
				semicolon = strrchr (sqlStr, ';');
				if (semicolon)
					*semicolon = ' ';
			}
			else if (dbaction == XMYSQL_SUBMIT_TABLESQL) {
				input = fl_get_input (Xmysql_table_admin_screen->xmysql_freeform);
				sprintf (sqlStr, "%s", input);
				semicolon = 0;
				semicolon = strrchr (sqlStr, ';');
				if (semicolon)
					*semicolon = ' ';
			}
			else if (dbaction == XMYSQL_QUICK_SELECT) {
				if (QUICK_LIMIT > 0)
					sprintf (sqlStr, "%s%s LIMIT %d", "SELECT * FROM ",
									 CURRENT_TABLE, QUICK_LIMIT);
				else
					sprintf (sqlStr, "%s%s", "SELECT * FROM ", CURRENT_TABLE);
			}
			else if (dbaction == XMYSQL_BATCH_SQL)
				sprintf (sqlStr, "%s", BATCH_SQL);

			if (results_to_file) {
				strcat (sqlStr, " INTO OUTFILE \"");
				strcat (sqlStr, FILE_OUT);
				strcat (sqlStr, "\"");
			}

			XmysqlErr ("INFO",
								 "Running query... Please wait!",
								 "",
								 "");
			ChangeCursor (XC_watch);
			XFlush (fl_display);

			rc = mysql_query (sock, sqlStr);
			if (rc >= 0) {
				data = mysql_store_result (sock);
				rows_affected = mysql.affected_rows;
				if (data == 0 && dbaction == XMYSQL_BATCH_SQL) {
					sprintf (dataLine, "%ld", rows_affected);
					XmysqlErr ("INFO",
								 "SUCCESS: However, batch query had no results to display.",
										 "Rows Affected:",
										 dataLine);
					RETURN (FALSE);
				}
				else if (data == 0 && (dbaction == XMYSQL_SUBMIT_TABLESQL
															 || dbaction == XMYSQL_SUBMIT_SQL
															 || dbaction == XMYSQL_QUICK_SELECT)) {
					sprintf (dataLine, "%ld", rows_affected);
					XmysqlErr ("INFO",
										 "SUCCESS: However, there are no results to display.",
										 "Rows Affected:",
										 dataLine);
					RETURN (FALSE);
				}
				rows = data->row_count;
				cols = mysql_num_fields (data);

				if (rows > 0) {
					if (Xmysql_query_results_screen == 0) {
						fd = create_form_Xmysql_query_results ();
						fl_show_form (Xmysql_query_results_screen->Xmysql_query_results,
													FL_PLACE_CENTER | FL_FREE_SIZE,
													FL_FULLBORDER,
													"SQL Query Results");
					}
					else {
						fl_clear_browser (Xmysql_query_results_screen->xmysql_results);
						fl_set_input (Xmysql_query_results_screen->xmysql_rows_affected,
													"0");
					}
					ChangeCursor (XC_watch);
					fl_freeze_form (Xmysql_query_results_screen->Xmysql_query_results);
					sprintf (dataLine, "%ld", rows_affected);
					fl_set_input (Xmysql_query_results_screen->xmysql_rows_affected,
												dataLine);

					memset (RESULT_HEADER, 0, sizeof (RESULT_HEADER));
					/* add field headers */
					for (headers = 0; headers < cols; headers++) {
						if (data->fields[headers].max_length > strlen (data->fields[headers].name))
							maxLen = data->fields[headers].max_length;
						else
							maxLen = strlen (data->fields[headers].name);
						if (maxLen < 4)
							maxLen = 4;				/* To align with any NULLs */
						sprintf (dataLine, "%-*s", maxLen, data->fields[headers].name);
						if (headers == 0)
							sprintf (browserStr, "%s", dataLine);
						else
							strcat (browserStr, dataLine);
						strcat (browserStr, " ");
						sprintf (RESULT_HEADER, "%s", browserStr);
					}
					fl_set_input_color (Xmysql_query_results_screen->xmysql_header,
															FL_RED, FL_COL1);
					fl_set_input (Xmysql_query_results_screen->xmysql_header,
												RESULT_HEADER);

					for (count = 0; count < rows; count++) {
						memset (browserStr, 0, sizeof (browserStr));
						cursor = mysql_fetch_row (data);
						lengths = mysql_fetch_lengths (data);
						sprintf (browserStr, "@_");
						pos = &browserStr[2];
						for (x = 0; x < cols; x++) {
							if (data->fields[x].max_length > strlen (data->fields[x].name))
								maxLen = data->fields[x].max_length;
							else
								maxLen = strlen (data->fields[x].name);
							if (maxLen < 4)
								maxLen = 4;			/* To align with any NULLs */
							if (cursor[x]) {
								fillSpace = 0;
								if (lengths[x] == 0) {
									strfill (pos, maxLen, ' ');
									pos += maxLen;
									fillSpace = 1;
								}
								else {
									memcpy (pos, cursor[x], lengths[x]);
									pos += lengths[x];
								}

								/* Here is a simple fix for newline and ASCII 0 replacing */
								for (r = pos, r_end = pos + lengths[x]; r != r_end; r++)
									if ((int) (unsigned char) *r < 32)
										*r = '?';

								if (lengths[x] < maxLen) {
									if (fillSpace == 0)
										pos = strfill (pos, maxLen - lengths[x], ' ');
								}
							}
							else {
								pos = strmov (pos, "NULL");
								if (maxLen > 4)
									pos = strfill (pos, maxLen - 4, ' ');
							}

							if ((x + 1) < cols)
								*pos++ = ' ';
						}
						*pos = 0;						/* Add end null */
						fl_add_browser_line (Xmysql_query_results_screen->xmysql_results,
																 browserStr);
					}

					fl_unfreeze_form (Xmysql_query_results_screen->Xmysql_query_results);
					fl_set_browser_topline (Xmysql_query_results_screen->xmysql_results, 1);
				}
				else {
					sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
					XmysqlErr ("INFO",
										 "No data to display.",
										 " ",
										 errStr);
				}
			}
			else {
				sprintf (errStr, "MySQL ErrNo: %d", mysql_errno (sock));
				XmysqlErr ("INFO",
									 "ERROR: Can't perform query.",
									 mysql_error (sock),
									 errStr);
				RETURN (TRUE);
			}
			break;
	}															/* end of dbaction switch */

	if (data != 0) {
		mysql_free_result (data);
		data = 0;
	}
	if (sock) {
		mysql_close (sock);
		sock = 0;
	}
	RETURN (rc);
}
