#ifndef _XMYSQL_DEF_H
#define _XMYSQL_DEF_H

#include "Xmysql.h"
#include "mysql.h"
#include "forms.h"

#define XMYSQL_VERSION "1.10"
#define MYSQL_VERSION  "3.22.8  Xforms 0.88"

#define XMYSQL_WRAP_LENGTH        40  /* 20 seems good for me */
#define XMYSQL_MAX_FREEFORM_LINES 300
#define XMYSQL_MAX_FREEFORM_LINE  200

#define MAX_BROWSER_STR 10000
#define MAX_SQL_STR     2048
#define MAX_ARG_STRING  100

#define SPECIAL_ADD_REC        1
#define SPECIAL_UPDATE_REC     2

#define USAGE_LINE \
"\nUSAGE:\nxmysql [-host hst] [-user usr -password [pw]] [-port #] [-socket pth] [-qlimit #]\n"

typedef struct _FieldInfo {
  MYSQL_FIELD field;
} FieldInfo;

typedef struct _TableFieldInfo {
  char *tableName;
  char *databaseName;
  int nbrFields;
  FieldInfo **fields;
} TableFieldInfo;

/* **********************
    GLOBAL SCREENS
 *************************/
#ifdef _MAIN_XMYSQL
FD_Xmysql_main *Xmysql_main_screen = 0;
FD_Xmysql_sql *Xmysql_sql_screen = 0;
FD_Xmysql_query_results *Xmysql_query_results_screen = 0;
FD_Xmysql_batch_query *Xmysql_batch_query_screen = 0;
FD_Xmysql_table_admin *Xmysql_table_admin_screen = 0;
FD_Xmysql_about *Xmysql_about_screen = 0;
FD_Xmysql_help *Xmysql_help_screen = 0;
FD_Xmysql_config *Xmysql_config_screen = 0;
FD_Xmysql_add_record *Xmysql_addrec_screen = 0;
char CURRENT_RD[FL_PATH_MAX]=XMYSQL_XPMPATH;
char CURRENT_HD[FL_PATH_MAX]=XMYSQL_HELPPATH;
char CURRENT_DATABASE[NAME_LEN];
char CURRENT_TABLE[NAME_LEN];
char CURRENT_SQL_TABLE[NAME_LEN];
char CURRENT_FIELD[NAME_LEN];
char CURRENT_SERVER[MAX_ARG_STRING];
char BATCH_SQL[MAX_SQL_STR];
char UPDATE_WHERE[MAX_SQL_STR];
char CURRENT_USER[MAX_ARG_STRING];
char CURRENT_PASSWORD[MAX_ARG_STRING];
char CURRENT_SOCKET[MAX_ARG_STRING];
char CURRENT_PORT[MAX_ARG_STRING];
int QUICK_LIMIT = -1;
const char *FILE_OUT = 0;
int LAST_DB_ACTION = -1;
TableFieldInfo TABLEFIELDINFO = {NULL, NULL, 0, NULL};
int SPECIAL_EDIT = -1;
char RESULT_HEADER[MAX_BROWSER_STR];
#else
extern FD_Xmysql_main *Xmysql_main_screen;
extern FD_Xmysql_sql *Xmysql_sql_screen;
extern FD_Xmysql_query_results *Xmysql_query_results_screen;
extern FD_Xmysql_batch_query *Xmysql_batch_query_screen;
extern FD_Xmysql_table_admin *Xmysql_table_admin_screen;
extern FD_Xmysql_about *Xmysql_about_screen;
extern FD_Xmysql_help *Xmysql_help_screen;
extern FD_Xmysql_config *Xmysql_config_screen;
extern FD_Xmysql_add_record *Xmysql_addrec_screen;
extern char CURRENT_RD[FL_PATH_MAX];
extern char CURRENT_HD[FL_PATH_MAX];
extern char CURRENT_DATABASE[NAME_LEN];
extern char CURRENT_TABLE[NAME_LEN];
extern char CURRENT_SQL_TABLE[NAME_LEN];
extern char CURRENT_FIELD[NAME_LEN];
extern char CURRENT_SERVER[MAX_ARG_STRING];
extern char BATCH_SQL[MAX_SQL_STR];
extern char UPDATE_WHERE[MAX_SQL_STR];
extern char CURRENT_USER[MAX_ARG_STRING];
extern char CURRENT_PASSWORD[MAX_ARG_STRING];
extern int QUICK_LIMIT;
extern const char *FILE_OUT;
extern int LAST_DB_ACTION;
extern TableFieldInfo TABLEFIELDINFO;
extern int SPECIAL_EDIT;
extern char RESULT_HEADER[MAX_BROWSER_STR];
extern char CURRENT_SOCKET[MAX_ARG_STRING];
extern char CURRENT_PORT[MAX_ARG_STRING];
#endif

/* prototypes */
int XmysqlDefaultAtCloseCB(FL_FORM *form, void *data);
void Build_SQL(char *str, int screen);
void DoHelp(char *str);
void FreeTableFieldInfo(void);
int GetMaxFieldSize(void);
void ChangeCursor(int cursor);
int Results_IdleCB(XEvent *ev, void *data);
#endif


