/*	$Csoft: sun.h,v 1.1 2001/08/31 00:09:04 vedge Exp $	*/

/*
 * Copyright (c) 2001, CubeSoft Communications, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistribution in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of CubeSoft Communications, nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _OUTPUT_SUN_SUN_H
#define _OUTPUT_SUN_SUN_H

#include "config.h"
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/audioio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include "xmms/plugin.h"
#include "libxmms/configfile.h"

/* Debugging */
/* #define SUN_DEBUG */

/* Default path to audio device. */
#ifndef SUN_DEV_AUDIO
#define SUN_DEV_AUDIO "/dev/audio"
#endif

/* Default path to audioctl device */
#ifndef SUN_DEV_AUDIOCTL
#define SUN_DEV_AUDIOCTL "/dev/audioctl"
#endif

/* Default path to mixer device */
#ifndef SUN_DEV_MIXER
#define SUN_DEV_MIXER "/dev/mixer"
#endif

/* Default mixer device to control */
#ifndef SUN_DEFAULT_VOLUME_DEV
#define SUN_DEFAULT_VOLUME_DEV "dac"
#endif

/* Default hardware block size */
#ifndef SUN_DEFAULT_BLOCKSIZE
#define SUN_DEFAULT_BLOCKSIZE 8800
#endif

/* Default `requested' buffer size */
#ifndef SUN_DEFAULT_BUFFER_SIZE
#define SUN_DEFAULT_BUFFER_SIZE 32768
#endif

/* Minimum total buffer size */
#ifndef SUN_MIN_BUFFER_SIZE
#define SUN_MIN_BUFFER_SIZE 14336
#endif

/* Default prebuffering (%) */
#ifndef SUN_DEFAULT_PREBUFFER_SIZE
#define SUN_DEFAULT_PREBUFFER_SIZE 25
#endif

#define SUN_AUDIO 0
#define SUN_MIXER 1

#define SUN_VERSION "0.3"

typedef struct {
	gchar          *devaudio;		/* path to audio device */
	gchar          *devaudioctl;		/* path to audioctl device */
	gchar          *devmixer;		/* path to mixer device */
	gchar          *mixer_voldev;		/* audio volume device */

	gint            fd;			/* audio fd */
	gint            mixerfd;		/* mixer fd */
	gboolean        mixer_keepopen;		/* keep mixer device open */

	gchar           format_name[16];	/* current encoding name */
	gint            format;			/* XMMS AFormat enum */
	gint            sun_format;		/* sun format notation */

	gint            channels;		/* number of channels */
	gint            frequency, efrequency;	/* sample rate */

	gint            device_buffer_size;	/* device buffer size */
	gpointer        buffer;			/* audio buffer */
	gint            blocksize;		/* H/W read/write block size */
	guint64         written;		/* written bytes */
	guint64         output_bytes;

	gboolean        prebuffer;		/* prebuffering */
	gboolean        remove_prebuffer;	/* remove prebuffer */

	gboolean        realtime;		/* XMMS realtime priority */
	gboolean        going;			/* playing */
	gboolean        paused;			/* paused */
	gboolean        unpause;		/* request unpause */
	gboolean        do_pause;		/* request pause */
	gboolean        flushing;		/* flushing */

	gint            req_prebuffer_size;	/* requested prebuffer size */
	gint            req_buffer_size;	/* requested buffer size */
	gint            prebuffer_size;		/* current prebuffer size */
	gint            buffer_size;		/* current buffer size */

	gint            device_buffer_used;	/* buffer progress (GETOOFFS) */
	gint            rd_index, wr_index;	/* read/write indexes */
	gint            output_time_offset;	/* output time offset */

	gint            bps, ebps;		/* bytes per second */

	gint            input_bps;		/* input bps */
	gint            input_format;		/* input format (XMMS) */
	gint            input_frequency;	/* input sample rate */
	gint            input_channels;		/* input channels */

	pthread_t       buffer_thread;		/* thread for sun_loop() */
	pthread_mutex_t mixer_mutex;		/* mutex for accessing mixer */
} sunAudio;

typedef struct _sunStatsFrame {
	int		fd;
	int		active;
	
	GtkWidget	*mode_label, *blocksize_label, *ooffs_label;
	pthread_mutex_t	audioctl_mutex, active_mutex;
} sunStatsFrame;

extern	OutputPlugin	op;
extern	sunAudio	audio;
extern	sunStatsFrame	stats_frame;

void            sun_init();
void            sun_about();
void            sun_configure();
void            sun_get_volume(int *l, int *r);
void            sun_set_volume(int l, int r);
gint            sun_open(AFormat fmt, int rate, int nch);
void            sun_write(void *ptr, int length);
void            sun_close();
void            sun_flush(int time);
void            sun_pause(short p);
gint            sun_free();
gint            sun_playing();
gint            sun_get_output_time();
gint            sun_get_written_time();
void            sun_cleanup();

#endif				/* _OUTPUT_SUN_SUN_H */
