/*  misc.c - miscellaneous functions
 *  Copyright (C) 2000-2001  Jason Jordan (shnutils@freeshell.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * $Id: misc.c,v 1.5 2001/12/30 05:12:04 jason Exp $
 */

#include <stdlib.h>
#include <string.h>
#include "shorten.h"

int filename_contains_a_dot(char *filename)
{
	char *slash,*dot;

	dot = strrchr(filename,'.');
	if (!dot)
		return 0;

	slash = strrchr(filename,'/');
	if (!slash)
		return 1;

	if (slash < dot)
		return 1;
	else
		return 0;
}

void length_to_str(shn_file *info)
{
	ulong newlength,rem1,rem2,frames;

	newlength = info->wave_header.length;
	rem1 = info->wave_header.data_size % info->wave_header.rate;

	if (PROB_NOT_CD(info->wave_header)) {
		if (rem1 >= (info->wave_header.rate / 2))
			newlength++;
		sprintf(info->wave_header.m_ss,"%lu:%02lu",newlength/60,newlength%60);
	}
	else {
		rem2 = rem1 % CD_BLOCK_SIZE;

		frames = rem1 / CD_BLOCK_SIZE;
		if (rem2 >= (CD_BLOCK_SIZE / 2))
			frames++;

		if (frames == CD_BLOCKS_PER_SEC) {
			frames = 0;
			newlength++;
		}

		sprintf(info->wave_header.m_ss,"%lu:%02lu.%02lu",newlength/60,newlength%60,frames);
	}
}
