# Configure paths for ESD
# Manish Singh    98-9-30
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_ESD([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for ESD, and define ESD_CFLAGS and ESD_LIBS
dnl
AC_DEFUN(AM_PATH_ESD,
[dnl 
dnl Get the cflags and libraries from the esd-config script
dnl
AC_ARG_WITH(esd-prefix,[  --with-esd-prefix=PFX   Prefix where ESD is installed (optional)],
            esd_prefix="$withval", esd_prefix="")
AC_ARG_WITH(esd-exec-prefix,[  --with-esd-exec-prefix=PFX Exec prefix where ESD is installed (optional)],
            esd_exec_prefix="$withval", esd_exec_prefix="")
AC_ARG_ENABLE(esdtest, [  --disable-esdtest       Do not try to compile and run a test ESD program],
		    , enable_esdtest=yes)

  if test x$esd_exec_prefix != x ; then
     esd_args="$esd_args --exec-prefix=$esd_exec_prefix"
     if test x${ESD_CONFIG+set} != xset ; then
        ESD_CONFIG=$esd_exec_prefix/bin/esd-config
     fi
  fi
  if test x$esd_prefix != x ; then
     esd_args="$esd_args --prefix=$esd_prefix"
     if test x${ESD_CONFIG+set} != xset ; then
        ESD_CONFIG=$esd_prefix/bin/esd-config
     fi
  fi

  AC_PATH_PROG(ESD_CONFIG, esd-config, no)
  min_esd_version=ifelse([$1], ,0.2.7,$1)
  AC_MSG_CHECKING(for ESD - version >= $min_esd_version)
  no_esd=""
  if test "$ESD_CONFIG" = "no" ; then
    no_esd=yes
  else
    ESD_CFLAGS=`$ESD_CONFIG $esdconf_args --cflags`
    ESD_LIBS=`$ESD_CONFIG $esdconf_args --libs`

    esd_major_version=`$ESD_CONFIG $esd_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    esd_minor_version=`$ESD_CONFIG $esd_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    esd_micro_version=`$ESD_CONFIG $esd_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_esdtest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $ESD_CFLAGS"
      LIBS="$LIBS $ESD_LIBS"
dnl
dnl Now check if the installed ESD is sufficiently new. (Also sanity
dnl checks the results of esd-config to some extent
dnl
      rm -f conf.esdtest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <esd.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.esdtest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_esd_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_esd_version");
     exit(1);
   }

   if (($esd_major_version > major) ||
      (($esd_major_version == major) && ($esd_minor_version > minor)) ||
      (($esd_major_version == major) && ($esd_minor_version == minor) && ($esd_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'esd-config --version' returned %d.%d.%d, but the minimum version\n", $esd_major_version, $esd_minor_version, $esd_micro_version);
      printf("*** of ESD required is %d.%d.%d. If esd-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If esd-config was wrong, set the environment variable ESD_CONFIG\n");
      printf("*** to point to the correct copy of esd-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_esd=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_esd" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$ESD_CONFIG" = "no" ; then
       echo "*** The esd-config script installed by ESD could not be found"
       echo "*** If ESD was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the ESD_CONFIG environment variable to the"
       echo "*** full path to esd-config."
     else
       if test -f conf.esdtest ; then
        :
       else
          echo "*** Could not run ESD test program, checking why..."
          CFLAGS="$CFLAGS $ESD_CFLAGS"
          LIBS="$LIBS $ESD_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <esd.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding ESD or finding the wrong"
          echo "*** version of ESD. If it is not finding ESD, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means ESD was incorrectly installed"
          echo "*** or that you have moved ESD since it was installed. In the latter case, you"
          echo "*** may want to edit the esd-config script: $ESD_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     ESD_CFLAGS=""
     ESD_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(ESD_CFLAGS)
  AC_SUBST(ESD_LIBS)
  rm -f conf.esdtest
])
dnl
dnl GNOME_INIT_HOOK (script-if-gnome-enabled, [failflag], [additional-inits])
dnl
dnl if failflag is "fail" then GNOME_INIT_HOOK will abort if gnomeConf.sh
dnl is not found. 
dnl

AC_DEFUN([GNOME_INIT_HOOK],[
	AC_SUBST(GNOME_LIBS)
	AC_SUBST(GNOMEUI_LIBS)
	AC_SUBST(GNOMEGNORBA_LIBS)
	AC_SUBST(GTKXMHTML_LIBS)
	AC_SUBST(ZVT_LIBS)
	AC_SUBST(GNOME_LIBDIR)
	AC_SUBST(GNOME_INCLUDEDIR)

	AC_ARG_WITH(gnome-includes,
	[  --with-gnome-includes   Specify location of GNOME headers],[
	CFLAGS="$CFLAGS -I$withval"
	])
	
	AC_ARG_WITH(gnome-libs,
	[  --with-gnome-libs       Specify location of GNOME libs],[
	LDFLAGS="$LDFLAGS -L$withval"
	gnome_prefix=$withval
	])

	AC_ARG_WITH(gnome,
	[  --with-gnome            Specify prefix for GNOME files],
		if test x$withval = xyes; then
	    		want_gnome=yes
	    		dnl Note that an empty true branch is not
			dnl valid sh syntax.
	    		ifelse([$1], [], :, [$1])
        	else
	    		if test "x$withval" = xno; then
	        		want_gnome=no
	    		else
	        		want_gnome=yes
	    			LDFLAGS="$LDFLAGS -L$withval/lib"
	    			CFLAGS="$CFLAGS -I$withval/include"
	    			gnome_prefix=$withval/lib
	    		fi
  		fi,
		want_gnome=yes)

	if test "x$want_gnome" = xyes; then

	    AC_PATH_PROG(GNOME_CONFIG,gnome-config,no)
	    if test "$GNOME_CONFIG" = "no"; then
	      no_gnome_config="yes"
	    else
	      AC_MSG_CHECKING(if $GNOME_CONFIG works)
	      if $GNOME_CONFIG --libs-only-l gnome >/dev/null 2>&1; then
	        AC_MSG_RESULT(yes)
	        GNOME_GNORBA_HOOK([],$2)
	        GNOME_LIBS="`$GNOME_CONFIG --libs-only-l gnome`"
	        GNOMEUI_LIBS="`$GNOME_CONFIG --libs-only-l gnomeui`"
	        GNOMEGNORBA_LIBS="`$GNOME_CONFIG --libs-only-l gnorba gnomeui`"
	        GTKXMHTML_LIBS="`$GNOME_CONFIG --libs-only-l gtkxmhtml`"
		ZVT_LIBS="`$GNOME_CONFIG --libs-only-l zvt`"
	        GNOME_LIBDIR="`$GNOME_CONFIG --libs-only-L gnorba gnomeui`"
	        GNOME_INCLUDEDIR="`$GNOME_CONFIG --cflags gnorba gnomeui`"
                $1
	      else
	        AC_MSG_RESULT(no)
	        no_gnome_config="yes"
              fi
            fi

	    if test x$exec_prefix = xNONE; then
	        if test x$prefix = xNONE; then
		    gnome_prefix=$ac_default_prefix/lib
	        else
 		    gnome_prefix=$prefix/lib
	        fi
	    else
	        gnome_prefix=`eval echo \`echo $libdir\``
	    fi
	
	    if test "$no_gnome_config" = "yes"; then
              AC_MSG_CHECKING(for gnomeConf.sh file in $gnome_prefix)
	      if test -f $gnome_prefix/gnomeConf.sh; then
	        AC_MSG_RESULT(found)
	        echo "loading gnome configuration from" \
		     "$gnome_prefix/gnomeConf.sh"
	        . $gnome_prefix/gnomeConf.sh
	        $1
	      else
	        AC_MSG_RESULT(not found)
 	        if test x$2 = xfail; then
	          AC_MSG_ERROR(Could not find the gnomeConf.sh file that is generated by gnome-libs install)
 	        fi
	      fi
            fi
	fi

	if test -n "$3"; then
	  n="$3"
	  for i in $n; do
	    AC_MSG_CHECKING(extra library $i)
	    case $i in 
	      applets)
		AC_SUBST(GNOME_APPLETS_LIBS)
		GNOME_APPLETS_LIBS=`$GNOME_CONFIG --libs-only-l applets`
		AC_MSG_RESULT($GNOME_APPLETS_LIBS);;
	      capplet)
		AC_SUBST(GNOME_CAPPLET_LIBS)
		GNOME_CAPPLET_LIBS=`$GNOME_CONFIG --libs-only-l capplet`
		AC_MSG_RESULT($GNOME_CAPPLET_LIBS);;
	      *)
		AC_MSG_RESULT(unknown library)
	    esac
	  done
	fi
])

dnl
dnl GNOME_INIT ([additional-inits])
dnl

AC_DEFUN([GNOME_INIT],[
	GNOME_INIT_HOOK([],fail,$1)
])
dnl
dnl GNOME_GNORBA_HOOK (script-if-gnorba-found, failflag)
dnl
dnl if failflag is "failure" it aborts if gnorba is not found.
dnl

AC_DEFUN([GNOME_GNORBA_HOOK],[
	GNOME_ORBIT_HOOK([],$2)
	AC_CACHE_CHECK([for gnorba libraries],gnome_cv_gnorba_found,[
		gnome_cv_gnorba_found=no
		if test x$gnome_cv_orbit_found = xyes; then
			GNORBA_CFLAGS="`gnome-config --cflags gnorba gnomeui`"
			GNORBA_LIBS="`gnome-config --libs gnorba gnomeui`"
			if test -n "$GNORBA_LIBS"; then
				gnome_cv_gnorba_found=yes
			fi
		fi
	])
	AM_CONDITIONAL(HAVE_GNORBA, test x$gnome_cv_gnorba_found = xyes)
	if test x$gnome_cv_orbit_found = xyes; then
		$1
		GNORBA_CFLAGS="`gnome-config --cflags gnorba gnomeui`"
		GNORBA_LIBS="`gnome-config --libs gnorba gnomeui`"
		AC_SUBST(GNORBA_CFLAGS)
		AC_SUBST(GNORBA_LIBS)
	else
	    	if test x$2 = xfailure; then
			AC_MSG_ERROR(gnorba library not installed or installation problem)
	    	fi
	fi
])

AC_DEFUN([GNOME_GNORBA_CHECK], [
	GNOME_GNORBA_HOOK([],failure)
])
dnl
dnl GNOME_ORBIT_HOOK (script-if-orbit-found, failflag)
dnl
dnl if failflag is "failure" it aborts if orbit is not found.
dnl

AC_DEFUN([GNOME_ORBIT_HOOK],[
	AC_PATH_PROG(ORBIT_CONFIG,orbit-config,no)
	AC_PATH_PROG(ORBIT_IDL,orbit-idl,no)
	AC_CACHE_CHECK([for working ORBit environment],gnome_cv_orbit_found,[
		if test x$ORBIT_CONFIG = xno -o x$ORBIT_IDL = xno; then
			gnome_cv_orbit_found=no
		else
			gnome_cv_orbit_found=yes
		fi
	])
	AM_CONDITIONAL(HAVE_ORBIT, test x$gnome_cv_orbit_found = xyes)
	if test x$gnome_cv_orbit_found = xyes; then
		$1
		ORBIT_CFLAGS=`orbit-config --cflags client server`
		ORBIT_LIBS=`orbit-config --use-service=name --libs client server`
		AC_SUBST(ORBIT_CFLAGS)
		AC_SUBST(ORBIT_LIBS)
	else
    		if test x$2 = xfailure; then
			AC_MSG_ERROR(ORBit not installed or installation problem)
    		fi
	fi
])

AC_DEFUN([GNOME_ORBIT_CHECK], [
	GNOME_ORBIT_HOOK([],failure)
])

# Configure paths for libmikmod
#
# Derived from libmikmod.m4 (Owen Taylor 97-11-3)
#

dnl AM_PATH_LIBMIKMOD([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for libmikmod, and define LIBMIKMOD_CFLAGS, LIBMIKMOD_LIBS and
dnl LIBMIKMOD_LDADD
dnl
AC_DEFUN(AM_PATH_LIBMIKMOD,
[dnl 
dnl Get the cflags and libraries from the libmikmod-config script
dnl
AC_ARG_WITH(libmikmod-prefix,[  --with-libmikmod-prefix=PFX   Prefix where libmikmod is installed (optional)],
            libmikmod_config_prefix="$withval", libmikmod_config_prefix="")
AC_ARG_WITH(libmikmod-exec-prefix,[  --with-libmikmod-exec-prefix=PFX Exec prefix where libmikmod is installed (optional)],
            libmikmod_config_exec_prefix="$withval", libmikmod_config_exec_prefix="")
AC_ARG_ENABLE(libmikmodtest, [  --disable-libmikmodtest       Do not try to compile and run a test libmikmod program],
		    , enable_libmikmodtest=yes)

  if test x$libmikmod_config_exec_prefix != x ; then
     libmikmod_config_args="$libmikmod_config_args --exec-prefix=$libmikmod_config_exec_prefix"
     if test x${LIBMIKMOD_CONFIG+set} != xset ; then
        LIBMIKMOD_CONFIG=$libmikmod_config_exec_prefix/bin/libmikmod-config
     fi
  fi
  if test x$libmikmod_config_prefix != x ; then
     libmikmod_config_args="$libmikmod_config_args --prefix=$libmikmod_config_prefix"
     if test x${LIBMIKMOD_CONFIG+set} != xset ; then
        LIBMIKMOD_CONFIG=$libmikmod_config_prefix/bin/libmikmod-config
     fi
  fi

  AC_PATH_PROG(LIBMIKMOD_CONFIG, libmikmod-config, no)
  min_libmikmod_version=ifelse([$1], ,3.1.5,$1)
  AC_MSG_CHECKING(for libmikmod - version >= $min_libmikmod_version)
  no_libmikmod=""
  if test "$LIBMIKMOD_CONFIG" = "no" ; then
    no_libmikmod=yes
  else
    LIBMIKMOD_CFLAGS=`$LIBMIKMOD_CONFIG $libmikmod_config_args --cflags`
    LIBMIKMOD_LIBS=`$LIBMIKMOD_CONFIG $libmikmod_config_args --libs`
    LIBMIKMOD_LDADD=`$LIBMIKMOD_CONFIG $libmikmod_config_args --ldadd`
    libmikmod_config_major_version=`$LIBMIKMOD_CONFIG $libmikmod_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\1/'`
    libmikmod_config_minor_version=`$LIBMIKMOD_CONFIG $libmikmod_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\2/'`
    libmikmod_config_micro_version=`$LIBMIKMOD_CONFIG $libmikmod_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\3/'`
    if test "x$enable_libmikmodtest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $LIBMIKMOD_CFLAGS $LIBMIKMOD_LDADD"
      LIBS="$LIBMIKMOD_LIBS $LIBS"
dnl
dnl Now check if the installed libmikmod is sufficiently new. (Also sanity
dnl checks the results of libmikmod-config to some extent
dnl
      rm -f conf.mikmodtest
      AC_TRY_RUN([
#include <mikmod.h>
#include <stdio.h>
#include <stdlib.h>

char* my_strdup (char *str)
{
  char *new_str;

  if (str) {
    new_str = malloc ((strlen (str) + 1) * sizeof(char));
    strcpy (new_str, str);
  } else
    new_str = NULL;

  return new_str;
}

int main()
{
  int major,minor,micro;
  int libmikmod_major_version,libmikmod_minor_version,libmikmod_micro_version;
  char *tmp_version;

  system ("touch conf.mikmodtest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_libmikmod_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_libmikmod_version");
     exit(1);
   }

  libmikmod_major_version=(MikMod_GetVersion()>>16)&255;
  libmikmod_minor_version=(MikMod_GetVersion()>> 8)&255;
  libmikmod_micro_version=(MikMod_GetVersion()    )&255;

  if ((libmikmod_major_version != $libmikmod_config_major_version) ||
      (libmikmod_minor_version != $libmikmod_config_minor_version) ||
      (libmikmod_micro_version != $libmikmod_config_micro_version))
    {
      printf("\n*** 'libmikmod-config --version' returned %d.%d.%d, but libmikmod (%d.%d.%d)\n", 
             $libmikmod_config_major_version, $libmikmod_config_minor_version, $libmikmod_config_micro_version,
             libmikmod_major_version, libmikmod_minor_version, libmikmod_micro_version);
      printf ("*** was found! If libmikmod-config was correct, then it is best\n");
      printf ("*** to remove the old version of libmikmod. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If libmikmod-config was wrong, set the environment variable LIBMIKMOD_CONFIG\n");
      printf("*** to point to the correct copy of libmikmod-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else if ((libmikmod_major_version != LIBMIKMOD_VERSION_MAJOR) ||
	   (libmikmod_minor_version != LIBMIKMOD_VERSION_MINOR) ||
           (libmikmod_micro_version != LIBMIKMOD_REVISION))
    {
      printf("*** libmikmod header files (version %d.%d.%d) do not match\n",
	     LIBMIKMOD_VERSION_MAJOR, LIBMIKMOD_VERSION_MINOR, LIBMIKMOD_REVISION);
      printf("*** library (version %d.%d.%d)\n",
	     libmikmod_major_version, libmikmod_minor_version, libmikmod_micro_version);
    }
  else
    {
      if ((libmikmod_major_version > major) ||
        ((libmikmod_major_version == major) && (libmikmod_minor_version > minor)) ||
        ((libmikmod_major_version == major) && (libmikmod_minor_version == minor) && (libmikmod_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of libmikmod (%d.%d.%d) was found.\n",
               libmikmod_major_version, libmikmod_minor_version, libmikmod_micro_version);
        printf("*** You need a version of libmikmod newer than %d.%d.%d.\n",
	       major, minor, micro);
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the libmikmod-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of libmikmod, but you can also set the LIBMIKMOD_CONFIG environment to point to the\n");
        printf("*** correct copy of libmikmod-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_libmikmod=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_libmikmod" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$LIBMIKMOD_CONFIG" = "no" ; then
       echo "*** The libmikmod-config script installed by libmikmod could not be found"
       echo "*** If libmikmod was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the LIBMIKMOD_CONFIG environment variable to the"
       echo "*** full path to libmikmod-config."
     else
       if test -f conf.mikmodtest ; then
        :
       else
          echo "*** Could not run libmikmod test program, checking why..."
          CFLAGS="$CFLAGS $LIBMIKMOD_CFLAGS"
          LIBS="$LIBS $LIBMIKMOD_LIBS"
          AC_TRY_LINK([
#include <mikmod.h>
#include <stdio.h>
],      [ return (MikMod_GetVersion()!=0); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding libmikmod or finding the wrong"
          echo "*** version of libmikmod. If it is not finding libmikmod, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location. Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means libmikmod was incorrectly installed"
          echo "*** or that you have moved libmikmod since it was installed. In the latter case, you"
          echo "*** may want to edit the libmikmod-config script: $LIBMIKMOD_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     LIBMIKMOD_CFLAGS=""
     LIBMIKMOD_LIBS=""
     LIBMIKMOD_LDADD=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(LIBMIKMOD_CFLAGS)
  AC_SUBST(LIBMIKMOD_LIBS)
  AC_SUBST(LIBMIKMOD_LDADD)
  rm -f conf.mikmodtest
])

AC_DEFUN(AC_FIND_FILE,
    [
	$3=NO
	for i in $2;
	do
	  for j in $1;
	  do
	    if test -r "$i/$j"; then
		  $3=$i
		  break 2
		fi
	  done
	done
    ]
)

AC_DEFUN(AC_PATH_LIBSIDPLAY,
[
AC_MSG_CHECKING([for SIDPLAY includes and library])
ac_sidplay_cflags=NO
ac_sidplay_library=NO
sidplay_cflags=""
sidplay_library=""

AC_ARG_WITH(sidplay-includes,
  [  --with-sidplay-includes=DIR
                          where the sidplay includes are located],
  [ac_sidplay_cflags="$withval"
  ])

AC_ARG_WITH(sidplay-library,
  [  --with-sidplay-library=DIR
                          where the sidplay library is installed],
  [ac_sidplay_library="$withval"
  ])

if test "$ac_sidplay_cflags" = NO || test "$ac_sidplay_library" = NO; then
#search common locations

AC_CACHE_VAL(ac_cv_have_sidplay,
[
sidplay_incdirs="$ac_sidplay_cflags /usr/include /usr/local/include /usr/lib/sidplay/include /usr/local/lib/sidplay/include"
AC_FIND_FILE(sidplay/sidtune.h,$sidplay_incdirs,sidplay_foundincdir)
ac_sidplay_cflags=$sidplay_foundincdir

sidplay_libdirs="$ac_sidplay_library /usr/lib /usr/local/lib /usr/lib/sidplay /usr/local/lib/sidplay"
AC_FIND_FILE(libsidplay.so libsidplay.so.1 libsidplay.so.1.36 libsidplay.so.1.37,$sidplay_libdirs,sidplay_foundlibdir)
ac_sidplay_library=$sidplay_foundlibdir

if test "$ac_sidplay_cflags" = NO || test "$ac_sidplay_library" = NO; then
  ac_cv_have_sidplay="have_sidplay=no"
  ac_sidplay_notfound=""
  if test "$ac_sidplay_cflags" = NO; then
    if test "$ac_sidplay_library" = NO; then
      ac_sidplay_notfound="(headers and library)";
    else
      ac_sidplay_notfound="(headers)";
    fi
  else
    ac_sidplay_notfound="(library)";
  fi
  eval "$ac_cv_have_sidplay"
  AC_MSG_RESULT([$have_sidplay])
else
  have_sidplay=yes
fi

])  dnl AC_CACHE_VAL(ac_cv_have_sidplay,
else
  have_sidplay=yes
fi  dnl if (have_to_search)

eval "$ac_cv_have_sidplay"

if test "$have_sidplay" != yes; then
  AC_MSG_RESULT([$have_sidplay]);
else
  ac_cv_have_sidplay="have_sidplay=yes \
    ac_sidplay_cflags=$ac_sidplay_cflags ac_sidplay_library=$ac_sidplay_library"
  AC_MSG_RESULT([library $ac_sidplay_library, headers $ac_sidplay_cflags])
  
  sidplay_library=$ac_sidplay_library
  sidplay_cflags=$ac_sidplay_cflags
  
  SIDPLAY_LIBS="-L$sidplay_library -lsidplay"
  all_libraries="$SIDPLAY_LIBS $all_libraries"
  SIDPLAY_CFLAGS="-I$sidplay_cflags"
  all_includes="$SIDPLAY_CFLAGS $all_includes"
fi

dnl Test compilation.

AC_MSG_CHECKING([whether -lsidplay works])
ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
ac_libs_safe=$LIBS

CXXFLAGS="$CXXFLAGS -I$sidplay_cflags"
LDFLAGS="$LDFLAGS -L$sidplay_library"
LIBS="-lsidplay"

AC_CACHE_VAL(ac_cv_sidplay_works,
[
    AC_TRY_LINK(
	    [#include <sidplay/sidtune.h>],
		[sidTune* myTest;],
		[ac_cv_sidplay_works=yes],
		[ac_cv_sidplay_works=no]
   )
])

CXXFLAGS="$ac_cxxflags_safe"
LDFLAGS="$ac_ldflags_safe"
LIBS="$ac_libs_safe"

AC_MSG_RESULT([$ac_cv_sidplay_works])
if test "$ac_cv_sidplay_works" != yes; then
  have_sidplay=no
fi

dnl

AC_SUBST(SIDPLAY_CFLAGS)
AC_SUBST(SIDPLAY_LIBS)

AC_SUBST(sidplay_library)
AC_SUBST(sidplay_cflags)

])

# ogg.m4
# Configure paths for libogg
# Jack Moffitt <jack@icecast.org> 10-21-2000
# Shamelessly stolen from Owen Taylor and Manish Singh

dnl AM_PATH_OGG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libogg, and define OGG_CFLAGS and OGG_LIBS
dnl
AC_DEFUN(AM_PATH_OGG,
[dnl 
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(ogg-prefix,[  --with-ogg-prefix=PFX   Prefix where libogg is installed (optional)], ogg_prefix="$withval", ogg_prefix="")
AC_ARG_ENABLE(oggtest, [  --disable-oggtest       Do not try to compile and run a test Ogg program],, enable_oggtest=yes)

  if test x$ogg_prefix != x ; then
    ogg_args="$ogg_args --prefix=$ogg_prefix"
    OGG_CFLAGS="-I$ogg_prefix/include"
    OGG_LIBS="-L$ogg_prefix/lib"
  fi

  OGG_LIBS="$OGG_LIBS -logg"

  AC_MSG_CHECKING(for Ogg)
  no_ogg=""


  if test "x$enable_oggtest" = "xyes" ; then
    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $OGG_CFLAGS"
    LIBS="$LIBS $OGG_LIBS"
dnl
dnl Now check if the installed Ogg is sufficiently new.
dnl
      rm -f conf.oggtest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ogg/ogg.h>

int main ()
{
  system("touch conf.oggtest");
  return 0;
}

],, no_ogg=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
  fi

  if test "x$no_ogg" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$1], , :, [$1])     
  else
     AC_MSG_RESULT(no)
     if test -f conf.oggtest ; then
       :
     else
       echo "*** Could not run Ogg test program, checking why..."
       CFLAGS="$CFLAGS $OGG_CFLAGS"
       LIBS="$LIBS $OGG_LIBS"
       AC_TRY_LINK([
#include <stdio.h>
#include <ogg/ogg.h>
],     [ return 0; ],
       [ echo "*** The test program compiled, but did not run. This usually means"
       echo "*** that the run-time linker is not finding Ogg or finding the wrong"
       echo "*** version of Ogg. If it is not finding Ogg, you'll need to set your"
       echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
       echo "*** to the installed location  Also, make sure you have run ldconfig if that"
       echo "*** is required on your system"
       echo "***"
       echo "*** If you have an old version installed, it is best to remove it, although"
       echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
       [ echo "*** The test program failed to compile or link. See the file config.log for the"
       echo "*** exact error that occured. This usually means Ogg was incorrectly installed"
       echo "*** or that you have moved Ogg since it was installed. In the latter case, you"
       echo "*** may want to edit the ogg-config script: $OGG_CONFIG" ])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
     OGG_CFLAGS=""
     OGG_LIBS=""
     ifelse([$2], , :, [$2])
  fi
  AC_SUBST(OGG_CFLAGS)
  AC_SUBST(OGG_LIBS)
  rm -f conf.oggtest
])

# vorbis.m4
# Configure paths for libvorbis
# Jack Moffitt <jack@icecast.org> 10-21-2000
# Shamelessly stolen from Owen Taylor and Manish Singh

dnl AM_PATH_VORBIS([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libvorbis, and define VORBIS_CFLAGS and VORBIS_LIBS
dnl
AC_DEFUN(AM_PATH_VORBIS,
[dnl 
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(vorbis-prefix,[  --with-vorbis-prefix=PFX   Prefix where libvorbis is installed (optional)], vorbis_prefix="$withval", vorbis_prefix="")
AC_ARG_ENABLE(vorbistest, [  --disable-vorbistest       Do not try to compile and run a test Vorbis program],, enable_vorbistest=yes)

  if test x$vorbis_prefix != x ; then
    vorbis_args="$vorbis_args --prefix=$vorbis_prefix"
    VORBIS_CFLAGS="-I$vorbis_prefix/include"
    VORBIS_LIBS="-L$vorbis_prefix/lib"
  fi

  VORBIS_LIBS="$VORBIS_LIBS -lvorbisfile -lvorbis -lm"

  AC_MSG_CHECKING(for Vorbis)
  no_vorbis=""


  if test "x$enable_vorbistest" = "xyes" ; then
    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $VORBIS_CFLAGS"
    LIBS="$LIBS $VORBIS_LIBS $OGG_LIBS"
dnl
dnl Now check if the installed Vorbis is sufficiently new.
dnl
      rm -f conf.vorbistest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vorbis/codec.h>

int main ()
{
  system("touch conf.vorbistest");
  return 0;
}

],, no_vorbis=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
  fi

  if test "x$no_vorbis" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$1], , :, [$1])     
  else
     AC_MSG_RESULT(no)
     if test -f conf.vorbistest ; then
       :
     else
       echo "*** Could not run Vorbis test program, checking why..."
       CFLAGS="$CFLAGS $VORBIS_CFLAGS"
       LIBS="$LIBS $VORBIS_LIBS $OGG_LIBS"
       AC_TRY_LINK([
#include <stdio.h>
#include <vorbis/codec.h>
],     [ return 0; ],
       [ echo "*** The test program compiled, but did not run. This usually means"
       echo "*** that the run-time linker is not finding Vorbis or finding the wrong"
       echo "*** version of Vorbis. If it is not finding Vorbis, you'll need to set your"
       echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
       echo "*** to the installed location  Also, make sure you have run ldconfig if that"
       echo "*** is required on your system"
       echo "***"
       echo "*** If you have an old version installed, it is best to remove it, although"
       echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
       [ echo "*** The test program failed to compile or link. See the file config.log for the"
       echo "*** exact error that occured. This usually means Vorbis was incorrectly installed"
       echo "*** or that you have moved Vorbis since it was installed." ])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
     VORBIS_CFLAGS=""
     VORBIS_LIBS=""
     ifelse([$2], , :, [$2])
  fi
  AC_SUBST(VORBIS_CFLAGS)
  AC_SUBST(VORBIS_LIBS)
  rm -f conf.vorbistest
])

# Test for libxml by Haavard Kvaalen <havardk@xmms.org>
# Based on GLIB test by Owen Taylor

dnl AM_PATH_LIBXML([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for libxml, and define XML_CFLAGS and XML_LIBS
dnl
AC_DEFUN(AM_PATH_LIBXML,
[dnl 
dnl Get the cflags and libraries from the xml-config script
dnl
AC_ARG_WITH(libxml-prefix, [  --with-libxml-prefix=PFX   Prefix where libxml is installed (optional)],
            libxml_prefix="$withval", libxml_prefix="")
AC_ARG_ENABLE(libxmltest, [  --disable-libxmltest       Do not try to compile and run a test libxml program],
		    , enable_libxmltest=yes)

  if test x$libxml_config_prefix != x ; then
     libxml_config_args="$libxml_config_args --prefix=$libxml_config_prefix"
     if test x${XML_CONFIG+set} != xset ; then
        XML_CONFIG=$libxml_config_prefix/bin/xml-config
     fi
  fi

  AC_PATH_PROG(XML_CONFIG, xml-config, no)
  min_libxml_version=ifelse([$1], ,1.0.0, $1)
  AC_MSG_CHECKING(for libxml - version >= $min_libxml_version)
  no_libxml=""
  if test "$XML_CONFIG" = "no" ; then
    no_libxml=yes
  else
    XML_CFLAGS=`$XML_CONFIG $libxml_config_args --cflags`
    XML_LIBS=`$XML_CONFIG $libxml_config_args --libs`
    libxml_major_version=`$XML_CONFIG $libxml_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    libxml_minor_version=`$XML_CONFIG $libxml_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    libxml_micro_version=`$XML_CONFIG $libxml_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_libxmltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $XML_CFLAGS"
      LIBS="$XML_LIBS $LIBS"
dnl
dnl Now check if the installed libxml is sufficiently new. (Also sanity
dnl checks the results of xml-config to some extent
dnl
      rm -f conf.libxmltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <parser.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
  {
      new_str = malloc((strlen (str) + 1) * sizeof(char));
      strcpy(new_str, str);
  }
  else
    new_str = NULL;
  
  return new_str;
}

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.libxmltest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_libxml_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_libxml_version");
     exit(1);
  }

  if (($libxml_major_version > major) ||
      (($libxml_major_version == major) && ($libxml_minor_version > minor)) ||
      (($libxml_major_version == major) && ($libxml_minor_version == minor) && ($libxml_micro_version >= micro)))
  {
        return 0;
  }
  else
  {
        printf("\n*** An old version of libxml (%d.%d.%d) was found.\n",
               $libxml_major_version, $libxml_minor_version, $libxml_micro_version);
        printf("*** You need a version of libxml newer than %d.%d.%d.\n",
	       major, minor, micro);
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the xml-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of libxml, but you can also set the XML_CONFIG environment to point to the\n");
        printf("*** correct copy of xml-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
  }
  return 1;
}
],, no_libxml=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_libxml" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     if test "$XML_CONFIG" = "no" ; then
	:
     else
       if test -f conf.libxmltest ; then
        :
       else
          echo "*** Could not run LIBXML test program, checking why..."
          CFLAGS="$CFLAGS $XML_CFLAGS"
          LIBS="$LIBS $XML_LIBS"
          AC_TRY_LINK([
#include <parser.h>
#include <stdio.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding libxml or finding the"
          echo "*** wrong version of libxml. If it is not finding libxml, you will"
          echo "*** need to set your LD_LIBRARY_PATH environment variable, or"
          echo "*** edit /etc/ld.so.conf to point to the installed location  Also,"
          echo "*** make sure you have run ldconfig if that is required on your system"],
        [ echo "*** The test program failed to compile or link. See the file config.log"
          echo "*** for the exact error that occured. This usually means libxml was"
          echo "*** incorrectly installed or that you have moved libxml since it was"
          echo "*** installed."])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     XML_CFLAGS=""
     XML_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(XML_CFLAGS)
  AC_SUBST(XML_LIBS)
  rm -f conf.libxmltest
])


dnl XMMS_FUNC_POSIX(FUNCTION... [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for functions in posix libraries, and define POSIX_LIBS
AC_DEFUN(XMMS_FUNC_POSIX,
[dnl
    xmms_posix4=no
    xmms_rt=no
    for xmms_func in $1
    do
        xmms_have_func=no
        AC_CHECK_FUNC($xmms_func,xmms_have_func=yes,[
            dnl try in libposix4 if not found in current LIBS
            AC_CHECK_LIB(posix4,$xmms_func,[xmms_have_func=yes xmms_posix4=yes],[
                dnl try in librt, if not found so far
                AC_CHECK_LIB(rt,$xmms_func,[xmms_have_func=yes xmms_rt=yes])
            ])
        ])
        if test $xmms_have_func = yes; then
            changequote(, )dnl
            xmms_tr_func=HAVE_`echo $xmms_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
            changequote([, ])dnl
            AC_DEFINE_UNQUOTED($xmms_tr_func)
            ifelse([$2], , :, [$2])
        else
            ifelse([$3], , :, [$3])
        fi
    done
    POSIX_LIBS=
    if test $xmms_posix4 = yes; then
        POSIX_LIBS=-lposix4
    fi
    if test $xmms_rt = yes; then
        POSIX_LIBS="$POSIX_LIBS -lrt"
    fi
    AC_SUBST(POSIX_LIBS)
])

