/*  Joystick plugin for xmms by Tim Ferguson (timf@dgs.monash.edu.au
 *                                  http://www.dgs.monash.edu.au/~timf/) ...
 *  14/12/2000 - patched to allow 5 or more buttons to be used (Justin Wake <justin@globalsoft.com.au>)
 *  XMMS is Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */
#include "xmms/i18n.h"
#include "joy.h"

static GtkWidget *dialog = NULL;

/* ---------------------------------------------------------------------- */
static void about_close_cb(GtkWidget * w, gpointer data)
{
	gtk_widget_destroy(dialog);
	dialog = NULL;
}

/* ---------------------------------------------------------------------- */
void joy_about(void)
{
	GtkWidget *button, *label;

	if (dialog)
		return;
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), _("About Joystick Driver"));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(dialog), 5);
	label = gtk_label_new(_("Joystick Control Plugin\n\n "
				"Created by Tim Ferguson <timf@dgs.monash.edu.au>.\n "
				"http://www.dgs.monash.edu.au/~timf/\n\n "
				"5+ button support by Justin Wake <justin@globalsoft.com.au>\n\n "
				"Control XMMS with one or two joysticks.\n ")
);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);

	button = gtk_button_new_with_label(_(" Close "));
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(about_close_cb), NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);

	gtk_widget_show(label);
	gtk_widget_show(button);
	gtk_widget_show(dialog);
	gtk_widget_grab_focus(button);
}
