/*
 *   xmmix - Motif(tm) Audio Mixer
 *
 *   Copyright (C) 1994-1996  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef LINT
static char *_main_c_ident_ = "@(#)main.c	3.3 96/11/07";
#endif

#include "appenv.h"
#include "resource.h"
#include "widget.h"
#include "mixer.h"


/* Global data */
bool_t			exit_flag;	/* Flag indicating end of application */
appdata_t		app_data;	/* Options data */
widgets_t		widgets;	/* Holder of all widgets */
FILE			*errfp = stderr;/* Error message stream */


/***********************
 *  internal routines  *
 ***********************/


/*
 * onsig
 *	Signal handler.  Causes the application to shut down gracefully.
 *
 * Args:
 *	sig - The signal number received.
 *
 * Return:
 *	Nothing.
 */
STATIC void
onsig(int sig)
{
	signal(sig, SIG_IGN);
	exit_flag = TRUE;
}


/*
 * usage
 *	Display command line usage syntax
 *
 * Args:
 *	argc, argv
 *
 * Return:
 *	Nothing.
 */
STATIC void
usage(int argc, char **argv)
{
	int	i;

	fprintf(errfp, "Unknown option:\n");
	for (i = 1; i < argc; i++)
		fprintf(errfp, "%s ", argv[i]);

	fprintf(errfp, "\n\nUsage: %s %s %s %s %s\n",
		"[-dev device]",
		"[-autoload path]",
		"[-exitreset]",
		"[-demo]",
		"[-debug]",
		argv[0]);

 	fprintf(errfp,
		"\nStandard Xt Intrinsics and Motif options are supported.\n");
}


/*
 * main
 *	The main function
 */
void
main(int argc, char **argv)
{
	XtAppContext	app;
	XEvent		ev;

	/* Initialize variables */
	exit_flag = FALSE;

	/* Handle some signals */
	signal(SIGINT, onsig);
	signal(SIGHUP, onsig);
	signal(SIGTERM, onsig);

#if (XtSpecificationRelease >= 5)
	/* Set locale */
	XtSetLanguageProc(NULL, NULL, NULL);
#endif

	/* Initialize X toolkit */
	widgets.toplevel = XtVaAppInitialize(
		&app,
		"XMmix",
		options, XtNumber(options),
		&argc, argv,
		fallbacks,
		XmNmappedWhenManaged, False,
		NULL
	);

	/* Get application options */
	XtVaGetApplicationResources(
		widgets.toplevel,
		(XtPointer) &app_data,
		resources,
		XtNumber(resources),
		NULL
	);
		
	/* Check command line for unknown arguments */
	if (argc > 1) {
		usage(argc, argv);
		exit(1);
	}

	/* Sound driver specific initialization */
	mx_init_drv();

	/* Initialize widget-related data */
	widget_init(&widgets);

	/* Initialize mixer hardware */
	mx_init_hw(&widgets);

	/* Create all widgets */
	create_widgets(&widgets);

	/* Display widgets */
	XtRealizeWidget(widgets.toplevel);

	/* Configure resources after realizing widgets */
	post_realize_config(&widgets);

	/* Register callback routines */
	register_callbacks(&widgets);

	/* Initialize screen controls */
	mx_start(&widgets);

	/* Make the main window visible */
	XtMapWidget(widgets.toplevel);

	/* Event processing loop */
	while (!exit_flag) {
		XtAppNextEvent(app, &ev);
		XtDispatchEvent(&ev);
	}

	exit(0);
}

