/******************************************************************************
Copyright (c) 1994, 1997 by Jin Yu.
All rights reserved.

The software provided hereunder is on an "AS IS" basis. Permission to
use, copy, modify, and distribute this software and its documentation
for any non-commercial purpose, without fee, and without written
agreement is hereby granted, provided that the above copyright notice
appears in all copies of this software.
******************************************************************************/

#include "xminehunter.h"


void mine_hunter_T::open_mine_cb(Widget w, XtPointer client_data,
				 XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;
  int x, y;

  if (cd->app_part->first_move) {
    mine_hunter_T::update_time(XtPointer(cd));
    cd->app_part->first_move = False;
  }

  cd->get_coordinates(w, x, y);

  if (cd->app_part->state[x][y].open)
    XBell(XtDisplay(w), 0);
  else
    if (cd->app_part->state[x][y].surface == Flag)
      XBell(XtDisplay(w), 0);
    else
      if (cd->app_part->state[x][y].bottom == Bomb) {
        XtVaSetValues(cd->gui_part->BlockW[x][y],
		      XmNshadowThickness, 0,
		      XmNlabelPixmap, cd->gui_part->openbomb_bmap,
		      NULL);
	cd->app_part->state[x][y].open = True;
	cd->lose();
      }
      else {
        cd->show_bottom(x, y);
	cd->app_part->open_counter++;
        if (cd->app_part->state[x][y].bottom == Empty)
	  cd->widen(x, y);
	if (	cd->app_part->open_counter ==
		cd->app_part->field_width *
		cd->app_part->field_height -
		cd->app_part->num_of_mines
             &&
		cd->app_part->flag_counter ==
		cd->app_part->num_of_mines
	   )
          cd->win();
      }

}


void mine_hunter_T::update_time(XtPointer client_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;
  Arg args[1];
  char time_str[80];

  sprintf(time_str, "%d", ++(cd->app_part->time));
  XmString xm_str = XmStringCreate(time_str, "TAG1");
  XtVaSetValues(cd->gui_part->TimeW, XmNlabelString, xm_str, NULL);
  XmStringFree(xm_str);

  cd->gui_part->Timer = XtAppAddTimeOut(cd->gui_part->AppCon,
	1000, XtTimerCallbackProc(&mine_hunter_T::update_time), cd);
}


void mine_hunter_T::file_quit_cb(Widget w, XtPointer client_data,
                                 XmAnyCallbackStruct *call_data)
{
  XtCloseDisplay(XtDisplay(XtParent(w)));
  exit(0);
}


void mine_hunter_T::game_easy_cb(Widget w, XtPointer client_data,
                  		 XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  cd->app_part->game_mode = Easy;
  cd->new_game(10, 10, 10);
}


void mine_hunter_T::game_medium_cb(Widget w, XtPointer client_data,
                    		   XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  cd->app_part->game_mode = Medium;
  cd->new_game(40, 16, 16);
}


void mine_hunter_T::game_hard_cb(Widget w, XtPointer client_data,
                  		 XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  cd->app_part->game_mode = Hard;
  cd->new_game(99, 30, 15);
}


void mine_hunter_T::game_customized_cb(Widget w, XtPointer client_data,
                        	       XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  XtManageChild(cd->gui_part->GameDialogW);
}


void mine_hunter_T::about_cb(Widget w, XtPointer client_data,
			     XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  XtManageChild(cd->gui_part->AboutDialogW);
}


void mine_hunter_T::help_cb(Widget w, XtPointer client_data,
			    XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  XtManageChild(cd->gui_part->HelpDialogW);
}


void mine_hunter_T::new_game_cb(Widget w, XtPointer client_data,
                                XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;

  cd->new_game(cd->app_part->num_of_mines,
	       cd->app_part->field_width, cd->app_part->field_height);
}


void mine_hunter_T::high_score_cb(Widget w, XtPointer client_data,
				  XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;
  XmString xm_str;
  char num_str[80];
  int i;
  int fd;

  if (cd->app_part->game_mode == Customized)
    return;

  if ( (fd = cd->lock()) == -1 ) return;
  if ( ! cd->read() ) {
    cd->unlock(fd);
    return;
  }
  if ( ! cd->unlock(fd) ) return;

  switch (cd->app_part->game_mode) {
  case Easy:
    xm_str = XmStringCreate("Fastest Mine Hunters (Easy)", "TAG1");
    break;
  case Medium:
    xm_str = XmStringCreate("Fastest Mine Hunters (Medium)", "TAG1");
    break;
  case Hard:
    xm_str = XmStringCreate("Fastest Mine Hunters (Hard)", "TAG1");
    break;
  }

  XtVaSetValues(cd->gui_part->HighScoreDialogW,
		XmNmessageString, xm_str,
		NULL);
  XmStringFree(xm_str);

  for (i=0; i<10; i++) {
    if (*(cd->app_part->high_score[i].name))
      xm_str = XmStringCreate(cd->app_part->high_score[i].name, "TAG2");
    else
      xm_str = XmStringCreate("Anonymous", "TAG2");
    XtVaSetValues(cd->gui_part->NameW[i], XmNlabelString, xm_str, NULL);
    XmStringFree(xm_str);
    if (cd->app_part->high_score[i].score != INT_MAX) {
      sprintf(num_str, "%d", cd->app_part->high_score[i].score);
      xm_str = XmStringCreate(num_str, "TAG2");
    }
    else
      xm_str = XmStringCreate("", "TAG2");
    XtVaSetValues(cd->gui_part->ScoreW[i], XmNlabelString, xm_str, NULL);
    XmStringFree(xm_str);
  }

  XtManageChild(cd->gui_part->HighScoreDialogW);
}


void mine_hunter_T::game_dialog_ok_cb(Widget w, XtPointer client_data,
				      XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;
  char *str;
  int mine_num, width_of_field, height_of_field;

  str = XmTextGetString(cd->gui_part->NumOfMinesTextFW);
  mine_num = atoi(str);
  XtFree(str);

  str = XmTextGetString(cd->gui_part->FieldWidthTextFW);
  width_of_field = atoi(str);
  XtFree(str);

  str = XmTextGetString(cd->gui_part->FieldHeightTextFW);
  height_of_field = atoi(str);
  XtFree(str);

  if ( mine_num > 0 && width_of_field > 0 && height_of_field > 0 &&
       mine_num < width_of_field * height_of_field ) {
    cd->app_part->game_mode = Customized;
    cd->new_game(mine_num, width_of_field, height_of_field);
  }
  else {
    XBell(XtDisplay(w), 0);
    XtManageChild(cd->gui_part->WarningW);
  }

}


void mine_hunter_T::enter_name_ok_cb(Widget w, XtPointer client_data,
				     XmAnyCallbackStruct *call_data)
{
  mine_hunter_T *cd = (mine_hunter_T*) client_data;
  XmSelectionBoxCallbackStruct *cbs =
    (XmSelectionBoxCallbackStruct *) call_data;
  char *name;
  int fd;

  if (! XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &name))
    return;

  if ( ! name || ! *name )
    return;

  if ( (fd = cd->lock()) == -1 ) return;
  if ( ! cd->update_score(name) ) {
    cd->unlock(fd);
    XtFree(name);
    return;
  }
  XtFree(name);
  if ( ! cd->unlock(fd) ) return;

  high_score_cb(NULL, cd, NULL);
}
