/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xinfo.c                                                       *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : display info text routines                               *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcImagesInfo()          - Display images info          *
 *                XMdcFileInfo()            - Display general file info    *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xinfo.c,v 1.1.1.1 2000/10/28 16:51:50 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcImagesInfo(GtkWidget *widget, Uint32 nr)
{
  GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *separator;
  GtkWidget *table;
  GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  GtkWidget *text;

  IMG_DATA *id;
  Uint32 i;

  i  = my.realnumber[nr];
  id = &my.fi->image[i];

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(window, 500, 500);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);

  gtk_signal_connect(GTK_OBJECT(window), "destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

  gtk_window_set_title(GTK_WINDOW(window),XMdcGetImageLabel(nr));
  gtk_container_set_border_width(GTK_CONTAINER(window),0);

  box1 = gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(window),box1);
  gtk_widget_show(box1);

  box2 = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(box2), 0);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_widget_show(box2);

  table = gtk_table_new(2, 2, FALSE);
  gtk_table_set_row_spacing(GTK_TABLE(table), 0, 2);
  gtk_table_set_col_spacing(GTK_TABLE(table), 0, 2);
  gtk_box_pack_start(GTK_BOX(box2),table,TRUE,TRUE,0);
  gtk_widget_show(table);

  text = gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(text),FALSE);
  gtk_text_set_word_wrap (GTK_TEXT(text), TRUE);
  gtk_table_attach(GTK_TABLE(table),text, 0, 1, 0, 1,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show(text);
  hscrollbar = gtk_hscrollbar_new(GTK_TEXT(text)->hadj);
  gtk_table_attach(GTK_TABLE(table), hscrollbar, 0, 1, 1, 2,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(hscrollbar);

  vscrollbar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
  gtk_table_attach(GTK_TABLE(table), vscrollbar, 1, 2, 0, 1,
                   GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show(vscrollbar);

  gtk_text_freeze(GTK_TEXT(text));

  gtk_widget_realize(text);

  /* create the info text */
  gdk_color_alloc(gtk_widget_get_colormap(window), &Blue);

  sprintf(xmdcstr,"IMAGE: %02u     PAGE: %02u        NR: %03u\n\n",
          nr+1, my.curpage+1, i+1);
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nPixel Dimensions\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dimension: %ux%u\npixeltype: %s\n",
          id->width, id->height, MdcGetStrPixelType(id->type));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nReal Dimensions\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"pixel xsize   : %+e mm\npixel ysize   : %+e mm\n",
          id->pixel_xsize, id->pixel_ysize);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"slice width   : %+e mm\n", id->slice_width);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"slice spacing : %+e mm\n", id->slice_spacing);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"\nct zoom factor: %+e\n", id->ct_zoom_fctr);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nRescale Factors\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"rescale factor: %+e ", id->rescale_fctr);
  if (MDC_QUANTIFY == MDC_YES) {
    strcat(xmdcstr,"(= quantification)\n");
  }else if (MDC_CALIBRATE == MDC_YES) {
    strcat(xmdcstr,"(= quantification * calibration)\n");
  }else{
    strcat(xmdcstr,"(= none)\n");
  }
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"quantification: %+e\n",id->quant_scale);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"calibration   : %+e\n", id->calibr_fctr);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nPixel Values\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image  min value: %+e\t\timage  max value: %+e\n",
          id->min, id->max);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"frame  min value: %+e\t\tframe  max value: %+e\n",
          id->fmin, id->fmax);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nQuantified Values\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image qmin value: %+e\t\timage qmax value: %+e\n",
           id->qmin, id->qmax);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"frame qmin value: %+e\t\tframe qmax value: %+e\n",
           id->qfmin, id->qfmax);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nTime Specifications\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"frame start   : %+e ms\nframe duration: %+e ms\n",
          id->frame_start, id->frame_duration);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nOrientation\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient/slice orientation : %d (= %s)\n",
           id->pat_slice_orient,MdcGetStrPatSlOrient(id->pat_slice_orient));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient position          : %s\n",id->pat_pos); 
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient orientation       : %s\n",id->pat_orient);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image modality            : %s\n",id->image_mod);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image position device     : %+e\\%+e\\%+e\n",
                                                    id->image_pos_dev[0],
                                                    id->image_pos_dev[1],
                                                    id->image_pos_dev[2]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image position patient    : %+e\\%+e\\%+e\n",
                                                    id->image_pos_pat[0],
                                                    id->image_pos_pat[1],
                                                    id->image_pos_pat[2]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image orientation device  : %+e\\%+e\\%+e\\%+e\\%+e\\%+e\n",
                                                    id->image_orient_dev[0],
                                                    id->image_orient_dev[1],
                                                    id->image_orient_dev[2],
                                                    id->image_orient_dev[3],
                                                    id->image_orient_dev[4],
                                                    id->image_orient_dev[5]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"image orientation patient : %+e\\%+e\\%+e\\%+e\\%+e\\%+e\n",
                                                    id->image_orient_pat[0],
                                                    id->image_orient_pat[1],
                                                    id->image_orient_pat[2],
                                                    id->image_orient_pat[3],
                                                    id->image_orient_pat[4],
                                                    id->image_orient_pat[5]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  gtk_text_thaw(GTK_TEXT(text));

  /* create separator and close button */
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(box1),separator,FALSE,TRUE,0);
  gtk_widget_show(separator);

  box2 = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(box2), 0);
  gtk_box_pack_start(GTK_BOX(box1),box2, FALSE, FALSE, 0);
  gtk_widget_show(box2);

  button = gtk_button_new_with_label("Close");
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(window));

  gtk_box_pack_start(GTK_BOX(box2),button,FALSE,FALSE,0);
  gtk_widget_show(button);

  gtk_widget_show(window);

}

void XMdcFileInfo(GtkWidget *widget, gpointer data)
{
  GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *separator;
  GtkWidget *table;
  GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  GtkWidget *text;

  Uint32 i;
  int v;

  if (XMdcNoFileOpened()) return;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(window,500,500);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE); 

  gtk_signal_connect(GTK_OBJECT(window),"destroy",
                     GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

  sprintf(mdcbufr,"FileInfo: %s",my.fi->ifname); 
  gtk_window_set_title(GTK_WINDOW(window),mdcbufr);
  gtk_container_set_border_width(GTK_CONTAINER(window),0);

  box1 = gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(window),box1);
  gtk_widget_show(box1);

  box2 = gtk_vbox_new(FALSE,0);
  gtk_container_set_border_width(GTK_CONTAINER(box2), 0);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_widget_show(box2);

  table = gtk_table_new(2, 2, FALSE);
  gtk_table_set_row_spacing(GTK_TABLE(table), 0, 2);
  gtk_table_set_col_spacing(GTK_TABLE(table), 0, 2);
  gtk_box_pack_start(GTK_BOX(box2),table,TRUE,TRUE,0);
  gtk_widget_show(table);

  text = gtk_text_new(NULL,NULL);
  gtk_text_set_editable(GTK_TEXT(text),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
  gtk_table_attach(GTK_TABLE(table),text, 0, 1, 0, 1,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show(text);
  hscrollbar = gtk_hscrollbar_new(GTK_TEXT(text)->hadj);
  gtk_table_attach(GTK_TABLE(table), hscrollbar, 0, 1, 1, 2,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(hscrollbar);

  vscrollbar = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
  gtk_table_attach(GTK_TABLE(table), vscrollbar, 1, 2, 0, 1,
                   GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show(vscrollbar);

  gtk_text_freeze(GTK_TEXT(text));

  gtk_widget_realize(text);

  /* create the general info text */
  gdk_color_alloc(gtk_widget_get_colormap(window), &Blue);

  sprintf(xmdcstr,"\nGeneral File Information\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"FILE *ifp   : ");
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  if (my.fi->ifp == NULL) 
    sprintf(xmdcstr,"<null>\n");
  else
    sprintf(xmdcstr,"%p\n",my.fi->ifp);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"FILE *ofp   : ");
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  if (my.fi->ofp == NULL)
    sprintf(xmdcstr,"<null>\n");
  else
    sprintf(xmdcstr,"%p\n",my.fi->ofp);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"ipath       : %s\n",my.fi->ipath);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"opath       : %s\n",my.fi->opath);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  if (my.fi->idir != NULL) 
    sprintf(xmdcstr,"idir        : %s\n",my.fi->idir);
  else
    sprintf(xmdcstr,"idir        : <null>\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  if (my.fi->odir != NULL)
    sprintf(xmdcstr,"odir        : %s\n",my.fi->odir);
  else
    sprintf(xmdcstr,"odir        : <null>\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"ifname      : %s\n",my.fi->ifname);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"ofname      : %s\n",my.fi->ofname);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->format;
  sprintf(xmdcstr,"format      : %d (= %s)\n",v,FrmtString[v]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->rawconv;
  sprintf(xmdcstr,"rawconv     : %d (= %s)\n",v,MdcGetStrRawConv(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->endian;
  sprintf(xmdcstr,"endian      : %d (= %s)\n",v,MdcGetStrEndian(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->compression;
  sprintf(xmdcstr,"compression : %d (= %s)\n",v,MdcGetStrCompression(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->truncated;
  sprintf(xmdcstr,"truncated   : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->diff_type;
  sprintf(xmdcstr,"diff_type   : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->diff_size;
  sprintf(xmdcstr,"diff_size   : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nGeneral Image Information\n"); 
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"number      : %u\n",my.fi->number);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"mwidth      : %u\n",my.fi->mwidth);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"mheight     : %u\n",my.fi->mheight);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"bits        : %hu\n",my.fi->bits);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->type;
  sprintf(xmdcstr,"type        : %hu (= %s)\n",v,MdcGetStrPixelType(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"dim[0]      : %-5hd (= total in use)\n",my.fi->dim[0]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[1]      : %-5hd (= pixels X-dim)\n",my.fi->dim[1]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[2]      : %-5hd (= pixels Y-dim)\n",my.fi->dim[2]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[3]      : %-5hd (= planes | (time) slices)\n",my.fi->dim[3]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[4]      : %-5hd (= frames | time slots | phases)\n",my.fi->dim[4]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[5]      : %-5hd (= gates  | R-R intervals)\n",my.fi->dim[5]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[6]      : %-5hd (= beds   | detector heads)\n",my.fi->dim[6]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"dim[7]      : %-5hd (= ...    | energy windows)\n",my.fi->dim[7]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"pixdim[0]   : %+e\n",my.fi->pixdim[0]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"pixdim[1]   : %+e [mm]\n",my.fi->pixdim[1]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"pixdim[2]   : %+e [mm]\n",my.fi->pixdim[2]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"pixdim[3]   : %+e [mm]\n",my.fi->pixdim[3]);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  for (i=4; i<8; i++) {
     sprintf(xmdcstr,"pixdim[%u]   : %+e\n",i,my.fi->pixdim[i]);
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  }
  sprintf(xmdcstr,"glmin       : %+e\n",my.fi->glmin);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"glmax       : %+e\n",my.fi->glmax);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"qglmin      : %+e\n",my.fi->qglmin);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"qglmax      : %+e\n",my.fi->qglmax);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nPatient Information\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient_sex : %s\n",my.fi->patient_sex);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient_name: %s\n",my.fi->patient_name);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"patient_id  : %s\n",my.fi->patient_id);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  sprintf(xmdcstr,"\nStudy Information\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1); 
  sprintf(xmdcstr,"study_descr      : %s\n",my.fi->study_descr);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_name       : %s\n",my.fi->study_name);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_date_day   : %d\n",my.fi->study_date_day);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_date_month : %d\n",my.fi->study_date_month);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_date_year  : %d\n",my.fi->study_date_year);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_time_hour  : %d\n",my.fi->study_time_hour);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_time_minute: %d\n",my.fi->study_time_minute);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"study_time_second: %d\n",my.fi->study_time_second);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->decay_corrected;
  sprintf(xmdcstr,"decay_corrected  : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->flood_corrected;
  sprintf(xmdcstr,"flood_corrected  : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->acquisition_type;
  sprintf(xmdcstr,"acquisition_type : %d (= %s)\n",v,MdcGetStrAcquisition(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  v = (int)my.fi->reconstructed;
  sprintf(xmdcstr,"reconstructed    : %d (= %s)\n",v,MdcGetStrYesNo(v));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"recon_method     : %s\n",my.fi->recon_method);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"radiopharma      : %s\n",my.fi->radiopharma);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"filter_type      : %s\n",my.fi->filter_type);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"isotope_code     : %s\n",my.fi->isotope_code);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"isotope_halflife : %+e [sec]\n",my.fi->isotope_halflife);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"gantry_tilt      : %+e [degrees]\n",my.fi->gantry_tilt);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  if ((my.fi->acqnr > 0) && (my.fi->acqdata != NULL)) {
    sprintf(xmdcstr,"\nAcquisition Data\n");
    gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
    sprintf(xmdcstr,"acqnr              : %u\n",my.fi->acqnr);
    gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
    for (i=0; i<my.fi->acqnr; i++) {
     ACQ_DATA *acq = &my.fi->acqdata[i];
     sprintf(xmdcstr,"-------- [ %.3u ] --------\n",i+1);
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
     v = (int)acq->rotation_direction;
     sprintf(xmdcstr,"rotation_direction : %d (= %s)\n",v,MdcGetStrRotation(v));
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
     v = (int)acq->detector_motion;
     sprintf(xmdcstr,"detector_motion    : %d (= %s)\n",v,MdcGetStrMotion(v));
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
     sprintf(xmdcstr,"angle_start        : %g\n",acq->angle_start);
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
     sprintf(xmdcstr,"angle_step         : %g [degrees]\n",acq->angle_step);
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
     sprintf(xmdcstr,"scan_arc           : %g [degrees]\n",acq->scan_arc);
     gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
    }
  }
  sprintf(xmdcstr,"\nInternal Information\n");
  gtk_text_insert(GTK_TEXT(text),sfixed,&Blue,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"map         : %u (= %s)\n",my.fi->map,
                                      MdcGetStrColorMap((int)my.fi->map));
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"comm_length : %u\n",my.fi->comm_length);
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  sprintf(xmdcstr,"comment     : ");
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);
  if (my.fi->comm_length != 0 && my.fi->comment != NULL) {
    strncpy(xmdcstr,my.fi->comment,my.fi->comm_length);
    xmdcstr[my.fi->comm_length]='\0';
  }else{
    sprintf(xmdcstr,"<null>\n");
  }
  gtk_text_insert(GTK_TEXT(text),sfixed,NULL,NULL,xmdcstr,-1);

  gtk_text_thaw(GTK_TEXT(text));

  /* create separator and close button */
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(box1),separator,FALSE,TRUE,0);
  gtk_widget_show(separator);

  box2 = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(box2), 0);
  gtk_box_pack_start(GTK_BOX(box1),box2, FALSE, FALSE, 0);
  gtk_widget_show(box2);

  button = gtk_button_new_with_label("Close");
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(window));

  gtk_box_pack_start(GTK_BOX(box2),button,FALSE,FALSE,0);
  gtk_widget_show(button);

  gtk_widget_show(window);

}

