/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xerror.c                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : error display routines                                   *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Note         : This code gets linked in (X)MedCon library with X-support*
 *                                                                         *
 * Functions    : XMdcFatalErrorKill()   - Quit program with fatal error   *
 *                XMdcDisplayDialog()    - Display a dialog window         *
 *                XMdcDisplayWarn()      - Display a  warning              *
 *                XMdcDisplayMesg()      - Display a  message              *
 *                XMdcDisplayErr()       - Display an error                *
 *                XMdcDisplayFatalErr()  - Display a  fatal error          *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xerror.c,v 1.1.1.1 2000/10/28 16:51:42 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/
#include <gtk/gtk.h>
#include "medcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcFatalErrorKill(GtkWidget *button, int *code)
{
  gtk_exit(*code);
}

void *XMdcDisplayDialog(int code, char *windowtitle, char *info)
{
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;

  /* gdk_beep(); */

  dialog =  gtk_dialog_new(); 

  gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),0);

  if (code != MDC_OK) {
    gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
                       GTK_SIGNAL_FUNC(XMdcFatalErrorKill), &code);
  }else{
    gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
  }
  /* gtk_widget_set_uposition(dialog,100,100); */
  gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_title(GTK_WINDOW(dialog), windowtitle);
  gtk_container_set_border_width(GTK_CONTAINER(dialog), 0);

  label = gtk_label_new(info);
  gtk_misc_set_padding(GTK_MISC(label), 30, 5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
                     label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                     button, TRUE, TRUE, 0);

  if (code != MDC_OK) {
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(XMdcFatalErrorKill), &code);
  }else{
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy),
                              GTK_OBJECT(dialog));
  }

  gtk_widget_show(button);

  gtk_widget_show_now(dialog);

  XMdcUpdateDrawing();

  return(dialog);
}

void *XMdcDisplayWarn(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  va_end(args);

  return(XMdcDisplayDialog(MDC_OK,"Warning",errmsg));
}


void *XMdcDisplayMesg(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  va_end(args);
 
  return(XMdcDisplayDialog(MDC_OK,"Message",errmsg));
}


void *XMdcDisplayErr(char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  va_end(args);

  return(XMdcDisplayDialog(MDC_OK,"Error",errmsg));
}

void XMdcDisplayFatalErr(int code, char *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  va_end(args);

  XMdcDisplayDialog(code, "Fatal Error", errmsg);

}

