/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: medcon.c                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : main routines                                            *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : main()             -  The hart of the project            *
 *                                                                         * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: medcon.c,v 1.1.1.1 2000/10/28 16:51:38 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S  
****************************************************************************/

#include "medcon.h"

/****************************************************************************
                                M A I N 
****************************************************************************/

int main(int argc, char *argv[])
{
  FILEINFO fi;
  int   *total = mdc_arg_total;    /* total arguments of files & conversions */
  int   *convs = mdc_arg_convs;    /* counter for each conversion format     */
  char **files = mdc_arg_files;    /* array of pointers to input filenames   */
  int   f, c;                      /* some counters                          */
  int   t=0;                       /* counter for the output name prefix     */
  int   convert, error;            /* some variables                         */
  char *msg=NULL;

  XMDC_MEDCON = MDC_NO;            /* make sure it is command line driven    */

  /* parse the command line arguments */
  if (MdcHandleArgs(&fi,argc,argv,MDC_MAX_FILES) != MDC_OK) 
    MdcPrintUsage(NULL);

  /* ignore floating exceptions */
  if (!MDC_SIGFPE) MdcIgnoreSIGFPE();

  /* initialize raw read input */
  if (MDC_INTERACTIVE) MdcInitRawPrevInput();

  /* do the stuff for each input file */
  for (f=0; f<total[MDC_FILES]; f++) {

     /* open the file, initialize FILEINFO structure */
     if ((error = MdcOpenFile(&fi, files[f])) != MDC_OK) return(error);
 
#if MDC_INCLUDE_ACR
     /* hack file for Acr/Nema tags */
     if (MDC_HACK_ACR) {
       if ((msg = MdcHackACR(&fi)) != NULL)
         /* tolerate errors */
         MdcPrntWarn("Error reading - %s",msg); 
       if (MDC_DEBUG) MdcPrintFI(&fi);
       MdcCleanUpFI(&fi);
       continue;
     }
#endif

     /* read the file */
     if ((error = MdcReadFile(&fi,f+1)) != MDC_OK) return(error);

     /* only printing database info */
     if (MDC_INFO_DB) continue;

     /* anonymize patient information */
     if (MDC_PATIENT_ANON) MdcMakePatAnonymous(&fi);

     /* ask for patient information */
     if (MDC_PATIENT_IDENT) MdcGivePatInformation(&fi);

     /* edit the FILEINFO structure */
     if (MDC_EDIT_FI) {
       if ((msg = MdcEditFI(&fi)) != NULL) {
         MdcCleanUpFI(&fi);
         MdcPrntErr(MDC_BAD_CODE,msg);
       }
     }

     /* print FILEINFO structure */  
     if (MDC_DEBUG)  MdcPrintFI(&fi);

     /* print out pixel requested values */
     if (MDC_PIXELS) MdcDisplayPixels(&fi);

     /* extract some images */
     if (MDC_EXTRACT) { 
       if ((error = MdcExtractImages(&fi)) != MDC_OK) {
         MdcCleanUpFI(&fi);
         MdcPrntErr(error,"Images extraction NOT succeeded!");
       }
     }

     /* when conversions selected */
     if ( total[MDC_CONVS] > 0 ) {

       /* rename base filename */
       if (MDC_RENAME) MdcRenameFile(fi.ifname);

       /* go through all the formats */
       for (c=1; c<MDC_MAX_FRMTS; c++) {
          convert = convs[c];
          /* write output format when selected */
          while (convert-- > 0) {
               if ((error = MdcWriteFile(&fi, c, t++)) != MDC_OK) {
                 MdcCleanUpFI(&fi);
                 return(error);
               } 
          }
       }

     }

     /* clean up FILEINFO struct */
     MdcCleanUpFI(&fi);

  }

  /* bye */
  return(MDC_OK);
}
