/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-sigfpe.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : allow, ignore floating exceptions (core dumps)           *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : MdcIgnoreSIGFPE() - ignore floating point exception      *
 *                MdcAcceptSIGFPE() - accept floating point exception      *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-sigfpe.c,v 1.1.1.1 2000/10/28 16:51:07 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include <signal.h>


/****************************************************************************
                              D E F I N E S 
****************************************************************************/

void (*mdc_old_handler)(int);

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void MdcIgnoreSIGFPE(void)                  /* before Accept! */
{
  mdc_old_handler = signal(SIGFPE, SIG_IGN);
}

void MdcAcceptSIGFPE(void)                  /* after  Ignore! */
{
  signal(SIGFPE, mdc_old_handler);
}

