# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# filename: acinclude.m4                                                  #
#                                                                         #
# UTILITY text: Medical Image Conversion Utility                          #
#                                                                         #
# purpose     : m4 macro's for configure script                           #
#                                                                         #
# project     : (X)MedCon by Erik Nolf                                    #
#                                                                         #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

dnl Define some MedCon macro's

dnl MDC_MESSAGE(TEXT)
dnl display some text without newline (similar to AC_MSG_CHECKING)
AC_DEFUN(MDC_MESSAGE,
[echo $ac_n "$1""$ac_c"])

dnl MDC_CHECK_XSUPPORT(XSUPPORT)
dnl check GTK and GDK_PIXBUF package
AC_DEFUN(MDC_CHECK_XSUPPORT,[
AC_MSG_CHECKING([for X-support])
if test x$1 = xyes; then
  if test x$ac_cv_prog_gtk = xno -o x$ac_cv_prog_gdk_pixbuf = xno ; then
    XSUPPORTED=0
    XMDCETC="<unused>"
    mdc_cv_xsupport=no
  else
    XSUPPORTED=1
    if test x${prefix} != xNONE ; then
      XMDCETC=${prefix}/etc
    else
      XMDCETC=${ac_default_prefix}/etc
    fi
  fi
fi
if test x$mdc_cv_xsupport = xno; then
  XSUPPORTED=0
  XMDCETC="<unused>"
  echo "no"
else
  echo "yes"
fi
])

dnl Get answer to set variable
AC_DEFUN(ReadAnswer,[
read answ 
if test x$answ = xn -o x$answ = xno -o x$answ = xN -o x$answ = xNO;
then
  echo "no" 
else
  echo "yes"
fi
])

