/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xpages.c                                                      *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : image pages routines                                     *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : XMdcPagesSelected()          - Handle selected page      *
 *                XMdcPagesCreateMenu()        - Create pages menu         *
 *                XMdcPagesNext()              - Go to next     page       *
 *                XMdcPagesPrev()              - Go to previous page       *
 *                XMdcPagesToFrames()          - Set #pages = #frames      *
 *                XMdcPagesNotToFrames()       - Set #pages not #frames    *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xpages.c,v 1.1.1.1 2000/10/28 16:51:55 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcPagesSelected(GtkWidget *widget, Uint32 *pagenr)
{
  if ( (Uint32)(*pagenr) != my.curpage) {

    my.curpage = (Uint32)(*pagenr);
    MdcDebugPrint("DEBUG: one-based selected page = %u\n",my.curpage + 1);

    XMdcMainWidgetsInsensitive();

    XMdcRemovePreviousColorMap();
    XMdcRemovePreviousImages();
    XMdcBuildColorMap();
    XMdcBuildCurrentImages();

    my.prevpage = my.curpage;

    XMdcMainWidgetsResensitive();
  }
}

GtkWidget *XMdcPagesCreateMenu(void)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  GSList *group;
  Uint32 i;

  menu = gtk_menu_new();
  group= NULL;

  for(i=0; i<my.number_of_pages; i++) {

    sprintf(mdcbufr,"Page: %4u/%u",i+1,my.number_of_pages);
    menuitem = gtk_radio_menu_item_new_with_label(group,mdcbufr);
    gtk_signal_connect(GTK_OBJECT (menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcPagesSelected),
                         (Uint32 *)&my.pagenumber[i]);
    group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(menuitem));
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(menuitem),TRUE);
    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
  }

  return(menu);
}

void XMdcPagesNext(void)
{
  GtkWidget *menu;
  GtkWidget *active;
  Uint32 nextpage;

  nextpage = my.curpage + 1;

  if (nextpage < my.number_of_pages) {
    gtk_option_menu_set_history(GTK_OPTION_MENU(my.pagemenu),nextpage);
    menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(my.pagemenu));
    gtk_menu_set_active(GTK_MENU(menu),nextpage);
    active = gtk_menu_get_active(GTK_MENU(menu));
    gtk_menu_item_activate(GTK_MENU_ITEM(active));
  }

} 


void XMdcPagesPrev(void)
{
  GtkWidget *menu;
  GtkWidget *active;
  Uint32 prevpage;

  if (my.curpage > 0) {
    prevpage = my.curpage - 1;
    gtk_option_menu_set_history(GTK_OPTION_MENU(my.pagemenu),prevpage);
    menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(my.pagemenu));
    gtk_menu_set_active(GTK_MENU(menu),prevpage);
    active = gtk_menu_get_active(GTK_MENU(menu));
    gtk_menu_item_activate(GTK_MENU_ITEM(active));
  } 

}

void XMdcPagesToFrames(void)
{

  if (pages_to_frames == MDC_NO) {

    pages_to_frames = MDC_YES;

    if ((XMDC_FILE_OPEN == MDC_YES) && (my.fi->dim[3] != my.fi->number)) {
      XMdcBeginProgressBar("Reprocessing:");
      XMdcViewerHide();
      XMdcViewerEnableAutoShrink();
      XMdcViewerReset();
      XMdcDisplayImages();
      XMdcViewerShow();
      XMdcViewerDisableAutoShrink();
      XMdcEndProgressBar();
    }
  }   
}

void XMdcPagesNotToFrames(void)
{
  if (pages_to_frames == MDC_YES) {

    pages_to_frames = MDC_NO;

    if ((XMDC_FILE_OPEN == MDC_YES) && (my.fi->dim[3] != my.fi->number)) {
      XMdcBeginProgressBar("Reprocessing:");
      XMdcViewerHide();
      XMdcViewerEnableAutoShrink();
      XMdcViewerReset();
      XMdcDisplayImages();
      XMdcViewerShow();
      XMdcViewerDisableAutoShrink();
      XMdcEndProgressBar();
    }
  } 

}
