/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xmnuftry.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : menu creation factory                                    *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Note         : basic code extracted from Gtk+ tutorial                  *
 *                                                                         *
 * Functions    : XMdcMenusGetMain()      - Get main menu                  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xmnuftry.c,v 1.1.1.1 2000/10/28 16:51:52 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

static GtkItemFactoryEntry menu_items[] = {
  {"/_File", NULL, NULL, 0, "<Branch>"},
  {"/File/Open", "<control>O", XMdcFileSelOpen, 0, NULL},
  {"/File/Open Raw", "<control>I", XMdcFileSelOpen, XMDC_RAW, NULL},
  {"/File/SepA", NULL, NULL, 0, "<Separator>" },
  {"/File/Info", "<control>I", XMdcFileInfo, 0, NULL},
  {"/File/SepB", NULL, NULL, 0, "<Separator>" },
  {"/File/Save", "<control>S", XMdcFileSelSave,MDC_MAX_FRMTS, NULL},
  {"/File/Save _As", NULL, NULL, 0, "<Branch>" },
  {"/File/Save As/Raw Binary", NULL, XMdcFileSelSave, MDC_FRMT_RAW, NULL},
  {"/File/Save As/Raw Ascii",  NULL, XMdcFileSelSave, MDC_FRMT_ASCII, NULL},
#if MDC_INCLUDE_ACR
  {"/File/Save As/AcrNema",    NULL, XMdcFileSelSave, MDC_FRMT_ACR, NULL},
#endif
#if MDC_INCLUDE_ANLZ
  {"/File/Save As/Analyze",    NULL, XMdcFileSelSave, MDC_FRMT_ANLZ, NULL},
#endif
#if MDC_INCLUDE_ECAT
  {"/File/Save As/Ecat",       NULL, XMdcFileSelSave, MDC_FRMT_ECAT, NULL},
#endif
#if MDC_INCLUDE_GIF
  {"/File/Save As/Gif89a",     NULL, XMdcFileSelSave, MDC_FRMT_GIF, NULL},
#endif
#if MDC_INCLUDE_INTF
  {"/File/Save As/InterFile",  NULL, XMdcFileSelSave, MDC_FRMT_INTF, NULL},
#endif
#if MDC_INCLUDE_INW
  {"/File/Save As/INW (RUG)",  NULL, XMdcFileSelSave, MDC_FRMT_INW, NULL},
#endif
#if MDC_INCLUDE_DICM
  {"/File/Save As/DICOM",  NULL, XMdcFileSelSave, MDC_FRMT_DICM, NULL},
#endif
  {"/File/SepC", NULL, NULL, 0, "<Separator>" },
  {"/File/Close", NULL, XMdcFileClose, 0, NULL},
  {"/File/Quit", "<control>Q", XMdcMedconQuit, 0, NULL},
  {"/_Images", NULL, NULL, 0, "<Branch>" },
  {"/Images/View", "<control>V", XMdcImagesView, 0, NULL},
  {"/Images/Extract", "<control>E", XMdcExtractStyleSel, 0, NULL},
  {"/_Options", NULL,  NULL, 0, "<Branch>"},
  {"/Options/MedCon", "<control>M", XMdcOptionsMedconSel, 0, NULL},
  {"/Options/XMedCon", NULL, NULL, 0, "<Branch>"},
  {"/Options/XMedCon/Render", "<control>R", XMdcOptionsRenderSel, 0, NULL},
  {"/Options/XMedCon/Colors", "<control>C", XMdcOptionsColorMapSel, 0, NULL},
  {"/Options/XMedCon/Labels", "<control>L", XMdcOptionsLabelSel, 0, NULL},
  {"/Options/XMedCon/Pages", "<control>P", XMdcOptionsPagesSel, 0, NULL},
  {"/Options/XMedCon/Resize", "<control>Z", XMdcOptionsResizeSel, 0, NULL},
  {"/_Help", NULL, NULL, 0, "<Branch>"},
  {"/Help/Info", NULL, XMdcHelp, 0, NULL},
  {"/Help/About", NULL, XMdcAbout, 0, NULL}
};

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcMenusGetMain(GtkWidget *window, GtkWidget **menubar)
{
    int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
    GtkItemFactory *factory;
    GtkAccelGroup *accel_group;

    accel_group = gtk_accel_group_new();

    factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);

    gtk_item_factory_create_items(factory, nmenu_items, menu_items, NULL);

    gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

    if (menubar)
      *menubar = gtk_item_factory_get_widget(factory, "<main>");

}

