/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xmedcon.c                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : main routine                                             *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : main()      - Main XMedCon routine                       *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xmedcon.c,v 1.1.1.1 2000/10/28 16:51:52 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */


/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "xmedcon.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
int main(int argc, char *argv[])
{
    GtkWidget *main_vbox;
    GtkWidget *menubar;
    FILEINFO fi;

    my.fi = &fi;

    printf("X-Windows Medical Image Conversion Utility\n");
    printf("XMedCon %s\n",MdcGetLibShortVersion());
    printf("Copyright (C) 1997-2000 by Erik Nolf\n");

    /* some MedCon options initialized */
    XMDC_MEDCON=MDC_YES;
    MDC_INFO=MDC_NO;
    MDC_VERBOSE=MDC_NO;
    MDC_MAKE_GRAY=MDC_YES;
    MDC_COLOR_MAP=MDC_MAP_GRAY;
 
    if (!MDC_SIGFPE) MdcIgnoreSIGFPE();

    /* some XMedCon options initialized */
    sLabelSelection.CurState = MDC_YES;
    sLabelSelection.CurColor = XMDC_LABEL_YELLOW;
    sLabelSelection.CurStyle = XMDC_LABEL_STYLE_ABS;
    sColormapSelection.CurMap = MDC_MAP_GRAY;
    sExtractSelection.input = &mdcextractinput;
    sExtractSelection.input->style = MDC_INPUT_NORM_STYLE;
    sResizeSelection.CurType = XMDC_RESIZE_ORIGINAL;
    sRenderSelection.Dither = GDK_RGB_DITHER_MAX;
    sRenderSelection.Interp = GDK_INTERP_BILINEAR;
    sGbc.mod.gamma = 256;
    sGbc.mod.brightness = 256;
    sGbc.mod.contrast = 256;
    XMdcSetGbcCorrection(&sGbc.mod);
    sGbc.im = NULL;
    mdcrawinput.abs_offset = NULL;
    MdcInitRawPrevInput();

    /* initialize the GTK/GDK_RGB engines */
    gtk_init(&argc, &argv);
    gdk_rgb_init();

    /* prevent unwanted Gdk-ERROR messages */
    gtk_widget_set_default_colormap(gdk_rgb_get_cmap());
    gtk_widget_set_default_visual(gdk_rgb_get_visual());

    /* initialize XMedCon global struct */
    my.viewwindow = NULL; XMdcStructsReset();


    /* process possible medcon settings */
    switch (argc) {
      case 1:  /* without arguments */ 
          break; 
      case 2:  /* one     argument  */
          if ( ( strcmp(argv[1],"-h") == 0     )  || 
               ( strcmp(argv[1],"/?") == 0     )  ||
               ( strcmp(argv[1],"--help") == 0 ) ) {
            /* requesting merely some help */
            MdcPrintUsage(argv[0]);

          }else{

            if ( argv[1][0] == '-' ) {
              /* an option, sorry no files starting with - allowed */
              if (MdcHandleArgs(&fi,argc,argv,1) != MDC_OK) {
                MdcPrintUsage(argv[0]);
              }

            }else{    
              /* must be an image file */
              mdc_arg_files[0]=argv[1]; mdc_arg_total[MDC_FILES]=1;
            }
          }
          break;
      default: /* several arguments */
          if (MdcHandleArgs(&fi,argc,argv,1) != MDC_OK) {
            MdcPrintUsage(argv[0]);
          }
    }

    /* set the initial palette we want */
    switch (MDC_COLOR_MAP) {
      case MDC_MAP_GRAY:
        sColormapSelection.CurMap = MDC_MAP_GRAY;
        sColormapSelection.Inverted = MDC_CMAP_INVERS;
        break;
      case MDC_MAP_RAINBOW: 
        sColormapSelection.CurMap = MDC_MAP_RAINBOW;
        break;
      case MDC_MAP_COMBINED:
        sColormapSelection.CurMap = MDC_MAP_COMBINED;
        break;
      case MDC_MAP_HOTMETAL:
        sColormapSelection.CurMap = MDC_MAP_HOTMETAL;
        break;
      case MDC_MAP_LOADED:
        sColormapSelection.CurMap = MDC_MAP_LOADED;
    }

    XMdcConfigureXMedcon();

    my.mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_signal_connect(GTK_OBJECT(my.mainwindow), "destroy", 
		       GTK_SIGNAL_FUNC(XMdcMedconQuit), 
		       "WM destroy");
    gtk_window_set_title(GTK_WINDOW(my.mainwindow), "XMedCon");
    gtk_window_set_policy(GTK_WINDOW(my.mainwindow),FALSE,TRUE,FALSE);

    main_vbox = gtk_vbox_new(FALSE, 1);
    gtk_container_set_border_width(GTK_CONTAINER(main_vbox), 1);
    gtk_container_add(GTK_CONTAINER(my.mainwindow), main_vbox);
    gtk_widget_show(main_vbox);

    XMdcMenusGetMain(my.mainwindow, &menubar);

    gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, TRUE, 0);
    gtk_widget_show(menubar);

    gtk_widget_show(my.mainwindow);

    /* get some prefered stuff */
    XMdcMakeMyCursors(); /* cursors for over pixmaps images  */
    XMdcMakeMyColors();  /* colors  for the  pixmaps labels  */
    XMdcMakeMyFonts();   /* fixed fonts                      */

    if (mdc_arg_total[MDC_FILES] == 1) XMdcDisplayFile(mdc_arg_files[0]);

    gtk_main();
    
    return(0);
}
