/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xhelp.c                                                       *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : help routines (send URL to Netscape)                     *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * note         : Some `mozilla'-code was addapted from the file           *
 *                http://home.netscape.com/newsref/std/x-remote.html       *
 *                                                                         *
 * Functions    : mozilla_remote_check_window() - check if Netscape window *
 *                mozilla_remote_init_atoms()   - initialize atoms         *
 *                mozilla_remote_find_window()  - find  a  Netscape window *
 *                XMdcHelp()                    - Send help to Netscape    * 
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xhelp.c,v 1.1.1.1 2000/10/28 16:51:47 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/
#include "xmedcon.h"


#ifndef _WIN32
#include <X11/Xatom.h>

#define MOZILLA_VERSION_PROP   "_MOZILLA_VERSION"
#define MOZILLA_LOCK_PROP      "_MOZILLA_LOCK"
#define MOZILLA_COMMAND_PROP   "_MOZILLA_COMMAND"
#define MOZILLA_RESPONSE_PROP  "_MOZILLA_RESPONSE"
static Atom XA_MOZILLA_VERSION  = 0;
static Atom XA_MOZILLA_LOCK     = 0;
static Atom XA_MOZILLA_COMMAND  = 0;
static Atom XA_MOZILLA_RESPONSE = 0;

#endif

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

#ifdef _WIN32

void XMdcHelp(GtkWidget *widget, gpointer data)
{
  XMdcDisplayMesg("Documentation at <http://xmedcon.sourceforge.net>");
}

#else

/* two following routines used to be in gdk, but seem to be disappeared !? */
/* Gtk+1.0.6: gdk_get_client_window(Display *dpy, Window    win)           */
/*            getchildren(Display *dpy, Window win, Atom WM_STATE)         */

/* 
 * used only by below routine and recursively
 */
static Window XMdcGetChildren (Display     *dpy, 
             Window       win, 
             Atom         WM_STATE)
{
  Window root, parent, *children, inf = 0;
  Atom type = None;
  unsigned int nchildren, i;
  int format;
  unsigned long nitems, after;
  unsigned char *data;

  if (XQueryTree(dpy, win, &root, &parent, &children, &nchildren) == 0)
    return 0;

  for (i = 0; !inf && (i < nchildren); i++)
    {
      XGetWindowProperty (dpy, children[i], WM_STATE, 0, 0, False,
                          AnyPropertyType, &type, &format, &nitems,
                          &after, &data);
      if (type != 0)
        inf = children[i];
      XFree(data);
    }

  for (i = 0; !inf && (i < nchildren); i++)
    inf = XMdcGetChildren (dpy, children[i], WM_STATE);

  if (children != None)
    XFree ((char *) children);

  return inf;
}

static Window XMdcGetClientWindow (Display  *dpy, Window    win)
{
  Atom WM_STATE;
  Atom type = None;
  int format;
  unsigned long nitems, after;
  unsigned char *data;
  Window inf;

  if (win == 0)
    return DefaultRootWindow(dpy);

  if ((WM_STATE = XInternAtom (dpy, "WM_STATE", True)) == 0)
    return win;

  XGetWindowProperty (dpy, win, WM_STATE, 0, 0, False, AnyPropertyType,
                      &type, &format, &nitems, &after, &data);
  if (type)
    return win;

  inf = XMdcGetChildren(dpy, win, WM_STATE);

  if (inf == 0)
    return win;
  else
    return inf;
}

static int
mozilla_remote_check_window (Display *dpy, Window window)
{
  Atom type;
  int format;
  unsigned long nitems, bytesafter;
  unsigned char *version = 0;
  int status = XGetWindowProperty (dpy, window, XA_MOZILLA_VERSION,
                                   0, (65536 / sizeof (long)),
                                   False, XA_STRING,
                                   &type, &format, &nitems, &bytesafter,
                                   &version);
  if (status != Success || !version)
    {
      /* not a Netscape window */
      return(MDC_NO);
    }

  XFree (version);

  return(MDC_YES);
}

static void
mozilla_remote_init_atoms (Display *dpy)
{
  if (! XA_MOZILLA_VERSION)
    XA_MOZILLA_VERSION = XInternAtom (dpy, MOZILLA_VERSION_PROP, False);
  if (! XA_MOZILLA_LOCK)
    XA_MOZILLA_LOCK = XInternAtom (dpy, MOZILLA_LOCK_PROP, False);
  if (! XA_MOZILLA_COMMAND)
    XA_MOZILLA_COMMAND = XInternAtom (dpy, MOZILLA_COMMAND_PROP, False);
  if (! XA_MOZILLA_RESPONSE)
    XA_MOZILLA_RESPONSE = XInternAtom (dpy, MOZILLA_RESPONSE_PROP, False);
}

static Uint32
mozilla_remote_find_window (Display *dpy)
{
  int i;
  Window root = RootWindowOfScreen (DefaultScreenOfDisplay (dpy));
  Window root2, parent, *kids;
  unsigned int nkids;
  Window result = 0;

  if (! XQueryTree (dpy, root, &root2, &parent, &kids, &nkids))
    {
      XMdcDisplayErr("XQueryTree failed on display %s",DisplayString (dpy));
      return(0);
    }

  /* root != root2 is possible with virtual root WMs. */

  if (! (kids && nkids))
    {
      /* no kids at all */
      return(0);
    }

  for (i = nkids-1; i >= 0; i--)
    {
      Atom type;
      int format;
      unsigned long nitems, bytesafter;
      unsigned char *version = 0;
      Window w = XMdcGetClientWindow(dpy, kids[i]);
      int status = XGetWindowProperty (dpy, w, XA_MOZILLA_VERSION,
                                       0, (65536 / sizeof (long)),
                                       False, XA_STRING,
                                       &type, &format, &nitems, &bytesafter,
                                       &version);

      if (! version)
        continue;
      XFree (version);
      if (status == Success && type != None)
        {
          result = w;
          break;
        }
    }

  if (result)
    {
      return result;
    }
  else
    {
      /* no Netscape running */
      return(0);
    }
}


void XMdcHelp(GtkWidget *widget, gpointer data)
{
  Int8 NETSCAPE=MDC_NO;
  Window mozilla;

  XSynchronize(gdk_display,True);
  mozilla_remote_init_atoms(gdk_display);
  mozilla = mozilla_remote_find_window(gdk_display);
  if (mozilla) {
    NETSCAPE = mozilla_remote_check_window(gdk_display,mozilla);
  }
  XSynchronize(gdk_display,False);

  if (NETSCAPE) { 
    /* already a Netscape window open */
    sprintf(xmdcstr,"netscape -remote 'openURL(%s)' &",XMDCHELP);
  }else{
    /* start up a new Netscape window */
    sprintf(xmdcstr,"netscape '%s' &",XMDCHELP);
  }

  system(xmdcstr);

  XMdcDisplayMesg("Sending XMedCon URL helpfile to Netscape");

}

#endif
