/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-global.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : define global variables                                  *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-global.c,v 1.1.1.1 2000/10/28 16:51:08 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/


#include <stdio.h>
#include "m-defs.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

/* all our version constants */
const Uint32 MDC_MAJOR = MEDCON_MAJOR;
const Uint32 MDC_MINOR = MEDCON_MINOR;
const Uint32 MDC_MICRO = MEDCON_MICRO;
const char  *MDC_PRGR  = MEDCON_PRGR;
const char  *MDC_DATE  = MEDCON_DATE;
const char  *MDC_VERSION = MEDCON_VERSION;
const char  *MDC_LIBVERS = MEDCON_LIBVERS;

/* fill in host endian and default write endian */
#ifdef ENLF_LITTLEENDIAN
Int8 MDC_HOST_ENDIAN = MDC_LITTLE_ENDIAN;
Int8 MDC_WRITE_ENDIAN= MDC_LITTLE_ENDIAN;
#else
Int8 MDC_HOST_ENDIAN = MDC_BIG_ENDIAN;
Int8 MDC_WRITE_ENDIAN= MDC_BIG_ENDIAN;
#endif

char prefix[MDC_MAX_PREFIX + 1]="eNlf-"; /* 5  + '\O' */

char FrmtString[MDC_MAX_FRMTS][15]= {
    "Unknown     ",    /* MDC_FRMT_BAD   */
    "Raw Binary  ",    /* MDC_FRMT_RAW   */
    "Raw Ascii   ",    /* MDC_FRMT_ASCII */
    "Gif89a      ",    /* MDC_FRMT_GIF   */
    "Acr/Nema    ",    /* MDC_FRMT_ACR   */
    "INW (RUG)   ",    /* MDC_FRMT_INW   */
    "Ecat/Matrix ",    /* MDC_FRMT_ECAT  */
    "InterFile   ",    /* MDC_FRMT_INTF  */
    "Analyze     ",    /* MDC_FRMT_ANLZ  */
    "DICOM       "     /* MDC_FRMT_DICM  */
  /*"............"                       */
};

char FrmtExt[MDC_MAX_FRMTS][4]= {
    "BAD",    /* MDC_FRMT_BAD   */
    "bin",    /* MDC_FRMT_RAW   */
    "asc",    /* MDC_FRMT_ASCII */
    "gif",    /* MDC_FRMT_GIF   */
    "ima",    /* MDC_FRMT_ACR   */
    "im",     /* MDC_FRMT_INW   */
    "img",    /* MDC_FRMT_ECAT  */
    "h33",    /* MDC_FRMT_INTF  */
    "hdr",    /* MDC_FRMT_ANLZ  */
    "dcm"     /* MDC_FRMT_DICM  */
  /*"..."                       */
};

char mdcbufr[MDC_2KB_OFFSET+1]; /* 2KB global buffer */
char errmsg[MDC_1KB_OFFSET+1];  /* 1KB error  buffer */

/* flags & options */
Int8 MDC_COLOR_MAP =  MDC_NO; 
Int8 MDC_ANLZ_REV  =  MDC_NO;   /* Analyze: reverse planes, rows & columns    */
Int8 MDC_ANLZ_SPM  =  MDC_NO;   /* Analyze for SPM with use of scaling factor */
Int8 MDC_ANLZ_OPTIONS = MDC_NO; /* Analyze for SPM & user supplied parameters */
Int8 MDC_INFO=MDC_YES, MDC_FILE_ENDIAN;
Int8 MDC_INTERACTIVE=MDC_NO, MDC_CONVERT=MDC_NO;
Int8 MDC_EXTRACT=MDC_NO, MDC_PIXELS=MDC_NO, MDC_NEGATIVE=MDC_NO;
Int8 MDC_QUANTIFY=MDC_NO, MDC_CALIBRATE=MDC_NO, MDC_DEBUG=MDC_NO;
Int8 MDC_GIF_OPTIONS=MDC_NO, MDC_MAKE_GRAY=MDC_NO;
Int8 MDC_VERBOSE=MDC_NO, MDC_RENAME=MDC_NO;
Int8 MDC_NORM_OVER_FRAMES = MDC_NO;     /* normalize over images in a frame */
                                        /* instead of all images            */
Int8 MDC_FORCE_INT = MDC_NO;            /* force integer pixels             */
Int8 MDC_INT16_BITS_USED = 16;          /* bits to use for Int16 type       */

Int8 MDC_CMAP_INVERS = MDC_NO;          /* inverted colormap (gray)         */

Int8 MDC_PATIENT_ANON = MDC_NO;         /* make patient anonymous           */
Int8 MDC_PATIENT_IDENT = MDC_NO;        /* give patient identification      */
Int8 MDC_EDIT_FI = MDC_NO;              /* edit FILEINFO struct             */

#if   MDC_INCLUDE_DICM                  /* fallback read format             */
Int8 MDC_FALLBACK_FRMT = MDC_FRMT_DICM;
#elif MDC_INCLUDE_ECAT
Int8 MDC_FALLBACK_FRMT = MDC_FRMT_ECAT;
#elif MDC_INCLUDE_ANLZ
Int8 MDC_FALLBACK_FRMT = MDC_FRMT_ANLZ;
#else
Int8 MDC_FALLBACK_FRMT = MDC_FRMT_BAD;
#endif

/* undocumented options, for debugging purposes only */
Int8 MDC_SIGFPE=MDC_NO;
Int8 MDC_MY_DEBUG=MDC_NO;
Int8 MDC_INFO_DB=MDC_NO;
Int8 MDC_HACK_ACR=MDC_NO;

/* XMedCon */
Int8 XMDC_MEDCON=MDC_NO;                /* is this program XMedCon !? */
Int8 XMDC_WRITE_FRMT = MDC_FRMT_RAW;    /* default format to save     */
