/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-error.c                                                     *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : Handle warnings and errors                               *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : MdcPrntWarn()         - Print a warning                  *
 *                MdcPrntMesg()         - Print a message                  *
 *                MdcPrntErr()          - Print error and leave            *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-error.c,v 1.1.1.1 2000/10/28 16:50:58 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "m-defs.h"
#include "m-global.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

void MdcPrntWarn(char *fmt, ...);
void MdcPrntMesg(char *fmt, ...);
void MdcPrntErr(int code, char *fmt, ...);

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void MdcPrntWarn(char *fmt, ...)
{
  va_list args; 

  fprintf(stdout,"\n%s: Warning: ",MDC_PRGR);

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  fprintf(stdout,"%s\n\n",errmsg);
  va_end(args);

}

void MdcPrntMesg(char *fmt, ...)
{
  va_list args;

  fprintf(stdout,"\n%s: Message: ",MDC_PRGR);

  va_start(args,fmt);
  vsprintf(errmsg, fmt, args);
  fprintf(stdout,"%s\n\n",errmsg);
  va_end(args);

}


void MdcPrntErr(int code, char *fmt, ...)
{
  va_list args;

  fprintf(stderr,"\n%s: Error  : ",MDC_PRGR);

  va_start(args, fmt);
  vsprintf(errmsg, fmt, args);
  fprintf(stderr,"%s\n\n",errmsg);
  va_end(args);

  exit(code);
}

