/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-debug.c                                                     *
 *                                                                         * 
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : print FILEINFO structure                                 *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : MdcPrintFI()       - Display FILEINFO struct             *
 *                MdcDebugPrint()    - Print MDC_MY_DEBUG info             *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-debug.c,v 1.1.1.1 2000/10/28 16:50:58 enlf Exp $
 */

/*
   Copyright (C) 1997-2000 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "medcon.h"


/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void MdcPrintFI(FILEINFO *fi)
{ 
  Uint32 i, j;
  int v;
  IMG_DATA *id;

  printf("\n");
  MdcPrintLine('#',MDC_FULL_LENGTH);
  printf("FILEINFO - Global Data\n");
  MdcPrintLine('#',MDC_FULL_LENGTH);
  printf("FILE *ifp          : ");
  if (fi->ifp == NULL) printf("<null>\n");
  else printf("%p\n",fi->ifp);
  printf("FILE *ofp          : ");
  if (fi->ofp == NULL) printf("<null>\n");
  else printf("%p\n",fi->ofp);
  printf("ipath              : %s\n",fi->ipath);
  printf("opath              : %s\n",fi->opath);
  if (fi->idir == NULL) 
  printf("idir               : <null>\n");
  else
  printf("idir               : %s\n",fi->idir);
  if (fi->odir == NULL)
  printf("odir               : <null>\n");
  else
  printf("odir               : %s\n",fi->odir);
  printf("ifname             : %s\n",fi->ifname);
  printf("ofname             : %s\n",fi->ofname);
  printf("format             : %d (= %s)\n",fi->format,FrmtString[fi->format]);
  v = (int)fi->rawconv;
  printf("rawconv            : %d (= %s)\n",v,MdcGetStrRawConv(v));
  v = (int)fi->endian;
  printf("endian             : %d (= %s)\n",v,MdcGetStrEndian(v));
  v = (int)fi->compression;
  printf("compression        : %d (= %s)\n",v,MdcGetStrCompression(v));
  printf("truncated          : %d ",fi->truncated);
  MdcPrintYesNo(fi->truncated);
  printf("diff_type          : %d ",fi->diff_type);
  MdcPrintYesNo(fi->diff_type);
  printf("diff_size          : %d ",fi->diff_size);
  MdcPrintYesNo(fi->diff_size);
  printf("number             : %u\n",fi->number);
  printf("mwidth             : %u\n",fi->mwidth);
  printf("mheight            : %u\n",fi->mheight);
  printf("bits               : %hu\n",fi->bits);
  v = (int)fi->type;
  printf("type               : %d (= %s)\n",v,MdcGetStrPixelType(v));
  printf("dim[0]             : %-5hd (= total in use)\n",fi->dim[0]);
  printf("dim[1]             : %-5hd (= pixels X-dim)\n",fi->dim[1]);
  printf("dim[2]             : %-5hd (= pixels Y-dim)\n",fi->dim[2]);
  printf("dim[3]             : %-5hd (= planes | (time) slices)\n",fi->dim[3]);
  printf("dim[4]             : %-5hd (= frames | time slots | phases)\n",fi->dim[4]);
  printf("dim[5]             : %-5hd (= gates  | R-R intervals)\n",fi->dim[5]);
  printf("dim[6]             : %-5hd (= beds   | detector heads)\n",fi->dim[6]);
  printf("dim[7]             : %-5hd (= ...    | energy windows)\n",fi->dim[7]);
  printf("pixdim[0]          : %+e\n",fi->pixdim[0]);
  printf("pixdim[1]          : %+e [mm]\n",fi->pixdim[1]);
  printf("pixdim[2]          : %+e [mm]\n",fi->pixdim[2]);
  printf("pixdim[3]          : %+e [mm]\n",fi->pixdim[3]);
  for (i=4; i<8; i++)
  printf("pixdim[%u]          : %+e\n",i,fi->pixdim[i]);
  printf("glmin              : %+e\n",fi->glmin);
  printf("glmax              : %+e\n",fi->glmax);
  printf("qglmin             : %+e\n",fi->qglmin);
  printf("qglmax             : %+e\n",fi->qglmax);
  printf("patient_sex        : %s\n",fi->patient_sex);
  printf("patient_name       : %s\n",fi->patient_name);
  printf("patient_id         : %s\n",fi->patient_id);
  printf("study_descr        : %s\n",fi->study_descr);
  printf("study_name         : %s\n",fi->study_name);
  printf("study_date_day     : %d\n",fi->study_date_day);
  printf("study_date_month   : %d\n",fi->study_date_month);
  printf("study_date_year    : %d\n",fi->study_date_year);
  printf("study_time_hour    : %d\n",fi->study_time_hour);
  printf("study_time_minute  : %d\n",fi->study_time_minute);
  printf("study_time_second  : %d\n",fi->study_time_second);
  printf("decay_corrected    : %d ",fi->decay_corrected);
  MdcPrintYesNo(fi->decay_corrected);
  printf("flood_corrected    : %d ",fi->flood_corrected);
  MdcPrintYesNo(fi->flood_corrected);
  v = fi->acquisition_type;
  printf("acquisition_type   : %d (= %s)\n",v,MdcGetStrAcquisition(v));
  printf("reconstructed      : %d ",fi->reconstructed);
  MdcPrintYesNo(fi->reconstructed);
  printf("recon_method       : %s\n",fi->recon_method);
  printf("radiopharma        : %s\n",fi->radiopharma);
  printf("filter_type        : %s\n",fi->filter_type);
  printf("isotope_code       : %s\n",fi->isotope_code);
  printf("isotope_halflife   : %+e [sec]\n",fi->isotope_halflife);
  printf("gantry_tilt        : %+e [degrees]\n",fi->gantry_tilt);
  v = (int) fi->map;
  printf("map                : %u (= %s)\n",v,MdcGetStrColorMap(v));
  printf("comm_length        : %u\n",fi->comm_length);
  printf("comment            : ");
  if ((fi->comment != NULL) && (fi->comm_length != 0)) {
    for (i=0; i<fi->comm_length; i++) printf("%c",fi->comment[i]);
  }else{
    printf("<null>");
  }
  printf("\n");

  /* ACQUISITION DATA */
  printf("acqnr              : %u\n",fi->acqnr);
  if (fi->acqdata != NULL) {
    for (i=0; i < fi->acqnr; i++) {
       ACQ_DATA *acq = &fi->acqdata[i];

       printf("\n");
       MdcPrintLine('-',MDC_FULL_LENGTH);
       printf("FILEINFO - Acquisition Data #%.3u\n",i+1);
       MdcPrintLine('-',MDC_FULL_LENGTH);
       v = acq->rotation_direction;
       printf("rotation_direction : %d (= %s)\n",v,MdcGetStrRotation(v));
       v = acq->detector_motion;
       printf("detector_motion    : %d (= %s)\n",v,MdcGetStrMotion(v));
       printf("angle_start        : %g\n",acq->angle_start);
       printf("angle_step         : %g [degrees]\n",acq->angle_step);
       printf("scan_arc           : %g [degrees]\n",acq->scan_arc);
    }
  }else{
    printf("acqdata            : <null>\n");
  }

  /* IMAGE DATA */
  for (i=0; i<fi->number; i++) {
     id = &fi->image[i];
     printf("\n");
     MdcPrintLine('-',MDC_FULL_LENGTH);
     printf("FILEINFO - Image Data #%.3u\n",i+1);  
     MdcPrintLine('-',MDC_FULL_LENGTH);
     printf("width              : %u\n",id->width);
     printf("height             : %u\n",id->height);
     printf("bits               : %hd\n",id->bits);
     printf("type               : %hd (= %s)\n",id->type
                                             ,MdcGetStrPixelType(id->type));
     printf("flags              : 0x%x\n",id->flags);
     printf("min                : %+e\n",id->min);
     printf("max                : %+e\n",id->max);
     printf("qmin               : %+e\n",id->qmin);
     printf("qmax               : %+e\n",id->qmax);
     printf("fmin               : %+e\n",id->fmin);
     printf("fmax               : %+e\n",id->fmax);
     printf("qfmin              : %+e\n",id->qfmin);
     printf("qfmax              : %+e\n",id->qfmax);
     printf("rescale_fctr       : %+e\n",id->rescale_fctr);
     printf("rescaled           : %d ",id->rescaled);
     MdcPrintYesNo(id->rescaled);
     printf("rescaled_min       : %+e\n",id->rescaled_min);
     printf("rescaled_max       : %+e\n",id->rescaled_max);
     printf("rescaled_fctr      : %+e\n",id->rescaled_fctr);
     printf("buf                : %p\n",id->buf);
     printf("quant_units        : %hd\n",id->quant_units);
     printf("calibr_units       : %hd\n",id->calibr_units);
     printf("quant_scale        : %+e\n",id->quant_scale);
     printf("calibr_fctr        : %+e\n",id->calibr_fctr);
     printf("pixel_xsize        : %+e [mm]\n",id->pixel_xsize);
     printf("pixel_ysize        : %+e [mm]\n",id->pixel_ysize);
     printf("slice_width        : %+e [mm]\n",id->slice_width);
     printf("frame_start        : %+e [ms]\n",id->frame_start);
     printf("frame_duration     : %+e [ms]\n",id->frame_duration);
     printf("recon_scale        : %+e\n",id->recon_scale);
     printf("pat_slice_orient   : %d (= %s)\n",id->pat_slice_orient,
                                  MdcGetStrPatSlOrient(id->pat_slice_orient));
     printf("pat_pos            : %s\n",id->pat_pos);
     printf("pat_orient         : %s\n",id->pat_orient);
     printf("image_mod          : %s\n",id->image_mod);
     for (j=0; j<3; j++)
        printf("image_pos_dev[%u]   : %+e [mm]\n",j,id->image_pos_dev[j]);
     for (j=0; j<3; j++)
        printf("image_pos_pat[%u]   : %+e [mm]\n",j,id->image_pos_pat[j]);
     for (j=0; j<6; j++) 
        printf("image_orient_dev[%u]: %+e [mm]\n",j,id->image_orient_dev[j]);
     for (j=0; j<6; j++)
        printf("image_orient_pat[%u]: %+e [mm]\n",j,id->image_orient_pat[j]);
     printf("slice_spacing      : %+e [mm]\n",id->slice_spacing);
     printf("ct_zoom_fctr       : %+e\n",id->ct_zoom_fctr);
 }

}


void MdcDebugPrint(char *fmt, ...)
{
  va_list args;

  if (MDC_MY_DEBUG) {
    va_start(args,fmt);
    vsprintf(mdcbufr, fmt, args);
    fprintf(stdout,"%s",mdcbufr);
    va_end(args);
    fflush(stdout);
  }

}

