/*
   XMascot Ver 2.5
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

#include "xmascot.h"

extern Display *dpy;			/* display          */

extern Widget mascot, *chain;
extern int chain_num, chain_disp_num;
extern double disp_dpm;	 /* dot per mm */

extern volatile int time_fl;	/* $B%?%$%^MQ%U%i%0(B     */

#ifdef BIFF
extern Widget   biff;
extern unsigned biff_r;
extern unsigned biff_h;
extern unsigned biff_w_off;

#ifdef USE_DOUBLE
extern double biff_th;
#else
extern int biff_th;
#endif

extern int 		mbox_flag;
#endif

extern Pixmap pixmap[17];		/* mascot $BMQ(B pixmap */
#ifdef SHAPE
extern Pixmap bitmap[17];		/* mask   $BMQ(B bitmap */
#endif

extern int px,py;			/* pin Geometry */
extern unsigned ms;			/* mascot size  */

#ifdef USE_CHAINPAT
extern unsigned chain_w;
extern unsigned chain_h;
#define CHAIN_W chain_w
#define CHAIN_H chain_h
#else
#define CHAIN_W (CHAIN_SIZE/2)
#define CHAIN_H (CHAIN_SIZE/2)
#endif

extern double damping;		/* $B8:?j78?t(B     */
extern int chain_len;		/* $BI3$ND9$5(B		*/

double sim_param;

#ifdef USE_DOUBLE
double th;					/* $B3QEY(B            */
double om = 0;				/* $B3QB.EY(B          */
#else
int th;						/* $B3QEY(B            */
int om = 0;					/* $B3QB.EY(B          */
#endif

static int so=8,mxo=0,myo=0;	/* $B0JA0$N>uBV(B */

extern AppData adat;	/* $B4pK\%j%=!<%9(B */
extern unsigned mh;
extern int map_fl;		/* $B%^%9%3%C%H$OI=<($5$l$F$$$k$+(B */

/* $B%7%_%e%l!<%7%g%sMQ%Q%i%a!<%?@_Dj(B */
void set_sim_param( void )
{
	int i;

	sim_param=adat.grav * disp_dpm * 10 / chain_len;

	/* $B:?$NI=<(8D?t7hDj(B ($B1#$l$kItJ,$OI=<($7$J$$(B) */
	
	if( chain_len < mh-CHAIN_H ){
		chain_disp_num = 0;
	}else{
		chain_disp_num = chain_num-
			(mh-CHAIN_H)/(chain_len/(chain_num+1)); 
	}
	if( map_fl ){
		for(i=0;i<chain_disp_num;i++)
			XtMapWidget(chain[i]);
		for(;i<chain_num;i++)
			XtUnmapWidget(chain[i]);
	}
}

void reset_pos(void)
{
	so = mxo = myo = -9999;
}

/* $B0LCV$N7W;;(B $B$*$h$S(B $BI=<(%Q%?!<%s$NJQ99(B */
void set_pos(void)
{
	int mx,my;
	int i,s;
	Window win = XtWindow( mascot );

#ifdef USE_DOUBLE
	double bx,by,dx,dy;
	double sn = sin(th) * chain_len, cs = cos(th) * chain_len;
	mx = px + sn;
	my = py + cs;
#else
	int bx,by,dx,dy;
	int sn = isin(th) * chain_len, cs = icos(th) * chain_len;
	mx = px + (sn >> 8);
	my = py + (cs >> 8);
#endif

	if( mxo != mx || myo != my ){	/* $BI=<(0LCV$,F0$$$?(B */
		/* $BI=<(%Q%?!<%s$N7hDj(B */
#ifdef USE_DOUBLE
		s = sqrt(fabs(th))*8/sqrt(ANGLE_PI/4);
#else
		s = sqrt(abs(th))*8/sqrt(ANGLE_PI/4);
#endif
		if(th<0) s=s+8; else s=8-s;
		if(s>16) s=16;
		if(s<0)  s=0;
		if(s!=so){ /* $BI=<(%Q%?!<%s$NJQ99(B */
			XSetWindowBackgroundPixmap(dpy,win,pixmap[s]);
#ifdef SHAPE
			XShapeCombineMask(dpy,win,ShapeBounding,0,0,bitmap[s],ShapeSet);
#endif
			XClearWindow(dpy,win);
			so = s;
		}

#ifdef BIFF
		if( mbox_flag ){
#ifdef USE_DOUBLE
			double th2;
#else
			int th2;
#endif
			/* $B3QEY@)8B(B */
			if( th > ANGLE_PI/4 )
				th2 = biff_th + ANGLE_PI/4;
			else if( th < -ANGLE_PI/4 )
				th2 = biff_th - ANGLE_PI/4;
			else
				th2 = biff_th + th;
			if( th2 > ANGLE_PI )
				th2 -= ANGLE_PI*2;
			else if( th2 <= -ANGLE_PI )
				th2 += ANGLE_PI*2;

#ifdef USE_DOUBLE
			bx = mx - biff_r*sin(th2);
			by = my - biff_r*cos(th2);
#else
			bx = mx - (( biff_r*isin(th2) ) >> 8);
			by = my - (( biff_r*icos(th2) ) >> 8);
#endif
			XtMoveWidget(biff,(Position)(bx-biff_w_off),
						      (Position)(by-biff_h));
		}
#endif

		/* $B:?$NI=<((B */
#ifdef USE_DOUBLE
		dx = sn/(chain_num+1);
		dy = cs/(chain_num+1);
#else
		dx = sn/(chain_num+1) >> 8;
		dy = cs/(chain_num+1) >> 8;
#endif

		bx = px + dx - CHAIN_W;
		by = py + dy - CHAIN_H;

		XtMoveWidget(mascot,(Position)(mx-ms),(Position)(my-ms));
		for(i=0;i<chain_num;i++,bx+=dx,by+=dy)
			XtMoveWidget(chain[i],(Position)bx,(Position)by);

		/* $BA4ItIA$/$^$GBT$D(B */
		XSync(dpy,False);
		mxo = mx;myo = my;
	}
}


/* $B?6;R$N%7%_%e%l!<%7%g%s(B */
void sim(void)
{
#ifdef USE_DOUBLE
	double dom;
#else
	int dom;
#endif
	while( time_fl > 0 ){
#ifdef USE_DOUBLE
		dom = sim_param * sin(th);
#else
		dom = sim_param * isin(th);
#endif
		om -= dom * DT/1000.0 + damping * om;
		th += om * DT/1000.0;
		while( th >   ANGLE_PI ) th -= ANGLE_PI*2;
		while( th <= -ANGLE_PI ) th += ANGLE_PI*2;

#ifdef USE_DOUBLE
		if( fabs(om) < 0.02  && fabs(dom) < 0.02 ){
#else
		if( abs(om)  < 5  && abs(dom)  < 5 ){
#endif
			stop_timer();
			om=0; dom=0;
		}
		time_fl--;
	}
	set_pos();
}
