/*
   XMascot Ver 2.5
   Copyright(c) 1996 Go Watanabe	 go@cclub.tutcc.tut.ac.jp
					 Tsuyoshi IIda	 iida@cclub.tutcc.tut.ac.jp
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "xmascot.h"
#include <X11/Shell.h>

#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

extern Display *dpy;
extern Window root;
extern int    screen;
extern Colormap cmap;
extern int    depth;
extern Widget top, mascot, *chain;

extern int    chain_num;
extern double magnify;
extern int map_fl;   /* $B8=:_%^%9%3%C%H$O%^%C%W$5$l$F$$$k$+!)(B */

unsigned ms;		 /* $B%^%9%3%C%H$N(B Pixmap $B$NBg$-$5(B */
unsigned mh;		 /* $B%^%9%3%C%H$N(B Pixmap $B=DI}(B     */

#ifdef USE_CHAINPAT
unsigned chain_w = CHAIN_SIZE/2;
unsigned chain_h = CHAIN_SIZE/2;
#endif

#ifdef BIFF
extern Widget biff;
unsigned biff_r;
unsigned biff_w;
unsigned biff_h;
unsigned biff_w_off;

#ifdef USE_DOUBLE
double biff_th;
#else
int biff_th;
#endif

#endif

unsigned pin_w;
unsigned pin_h;

extern unsigned long pixels[256];

/* pin $B$N%Q%?!<%s$r@_Dj$9$k(B */
void set_pin_pat(char *name,int c,int r)
{
	ImageData base;

	Pixmap    pix;
#ifdef SHAPE
	Pixmap bit;
#endif

	base = get_image(name,c,r);
	if(base.data == NULL){
		err_out("Can't Set PIN pattern.\n");
		exit(1);
	}
	set_col( &base, cmap );

	XtVaSetValues(top, XtNsaveUnder,True,
				  XtNwidth,(Dimension)(base.w + SHADOW_LEN),
				  XtNheight,(Dimension)(base.h + SHADOW_LEN),
				  XtNminWidth,(Dimension)(base.w + SHADOW_LEN), 
				  XtNminHeight,(Dimension)(base.h + SHADOW_LEN),
				  XtNmaxWidth,(Dimension)(base.w + SHADOW_LEN),
				  XtNmaxHeight,(Dimension)(base.h + SHADOW_LEN),
				  NULL);
#ifdef SHAPE
	pix = image2pixmap(&base,&bit);
	XShapeCombineMask(dpy,XtWindow(top),ShapeBounding,0,0,bit,ShapeSet);
	XFreePixmap(dpy,bit);
#else
	pix = image2pixmap(&base,NULL);
#endif
	XSetWindowBackgroundPixmap(dpy,XtWindow(top),pix);
	XFreePixmap(dpy,pix);
	free_image( &base );

	pin_w = base.w / 2;
	pin_h = base.h / 2;
}

#ifdef BIFF
/* biff $B$N%Q%?!<%s$r@_Dj$9$k(B */
void set_biff_pat(char *name,int c,int r)
{
	ImageData base;

	Pixmap pix;
#ifdef SHAPE
	Pixmap bit;
#endif

	base = get_image(name,c,r);
	if(base.data == NULL){
		err_out("Can't Set BIFF pattern.\n");
		exit(1);
	}
	set_col( &base, cmap );

	biff_w = base.w;
	biff_h = base.h;
	XtResizeWidget(biff,biff_w+ + SHADOW_LEN,biff_h + SHADOW_LEN,0);
#ifdef SHAPE
	pix = image2pixmap(&base,&bit);
	XShapeCombineMask(dpy,XtWindow(biff),ShapeBounding,0,0,bit,ShapeSet);
	XFreePixmap(dpy,bit);
#else
	pix = image2pixmap(&base,NULL);
#endif
	XSetWindowBackgroundPixmap(dpy,XtWindow(biff),pix);
	XFreePixmap(dpy,pix);
	free_image( &base );
}
#endif

#ifdef USE_CHAINPAT
/* chain $B$N%Q%?!<%s$r@_Dj$9$k(B */
void set_chain_pat(char *name,int c,int r)
{
	int i;
	ImageData base;

	Pixmap pix;
#ifdef SHAPE
	Pixmap bit;
#endif

	base = get_image(name,c,r);
	if(base.data == NULL){
		err_out("Can't Set Chain pattern.\n");
		exit(1);
	}
	set_col( &base, cmap );

	chain_w = base.w / 2;
	chain_h = base.h / 2;
	for(i=0;i<chain_num;i++)
		XtResizeWidget(chain[i],base.w+SHADOW_LEN,base.h+SHADOW_LEN,0);
#ifdef SHAPE
	pix = image2pixmap(&base,&bit);
	for(i=0;i<chain_num;i++)
		XShapeCombineMask(dpy,XtWindow(chain[i]),
						  ShapeBounding,0,0,bit,ShapeSet);
	XFreePixmap(dpy,bit);
#else
	pix = image2pixmap(&base,NULL);
#endif
	for(i=0;i<chain_num;i++)
		XSetWindowBackgroundPixmap(dpy,XtWindow(chain[i]),pix);
	XFreePixmap(dpy,pix);
	free_image( &base );
}
#endif

Pixmap pixmap[17];
#ifdef SHAPE
Pixmap bitmap[17];
#endif

/* $B%G!<%?$N2sE>(B */
static void roll( ImageData *base, double mmag )
{
	int i;
	GC gc,gc2;
#ifdef SHADOW
	unsigned long black = BlackPixel(dpy,screen);
#endif
	unsigned long white = WhitePixel(dpy,screen);

	XImage *img_data;
#ifdef SHAPE
	XImage *img_mask;
#endif
	unsigned w = base->w;			   /* $B2#I}(B	 */
	unsigned h = base->h;			   /* $B=DI}(B	 */
	unsigned s = sqrt((double)(w*w + h*h))*mmag; /* $BBP3QD9(B */
	
	/* pixmap $B$N@8@.(B */
	for(i=0;i<17;i++){
		pixmap[i] = XCreatePixmap(dpy,root,s,s,depth);
#ifdef SHAPE		
		bitmap[i] = XCreatePixmap(dpy,root,s,s,1);
#endif
	}

	/* Image $B@8@.(B */
	img_data = XGetImage(dpy,pixmap[0],0,0,s,s,AllPlanes,ZPixmap);
#ifdef SHAPE
	img_mask = XGetImage(dpy,bitmap[0],0,0,s,s,1,ZPixmap);
#endif
	
	/* gc $B$N(B $B@8@.(B */
	gc	= XCreateGC(dpy,pixmap[0],0,NULL);
#ifdef SHAPE
	gc2 = XCreateGC(dpy,bitmap[0],0,NULL);
#endif

	for(i=0;i<17;i++){
		int x,y;
		int c;
		int d1 = s/2;
		int d2 = w/2;
		int d3 = h/2;
		double u,v,du,dv;
		double co,si;
		double d;
		msg_out("\rmaking rotete image %2d/17 ",i+1);
		d = (8-i)/8.0*sqrt((double)M_PI/4);
		d = d*d*((i<8)?-1.0:1.0);
		co = cos(d)/mmag;
		si = sin(d)/mmag;
		du = ( (d1)*co +(d1)*si) + d2;
		dv = (-(d1)*si +(d1)*co) + d3;
		for(y=s-1;y>=0;y--){
			u = du;
			v = dv;
			for(x=s-1;x>=0;x--){
				if(u>=0 && u<w && v>=0 && v<h){
					c = (int)v*w+(int)u;
#ifdef SHAPE		
#ifdef SHADOW
					if(SHADOW_LEN){
						if( base->mask[c] ){
							XPutPixel(img_data,x,y,
									  base->pixels[base->use[base->data[c]]]);
							XPutPixel(img_mask,x,y,1);
							if( (x+y) & 1 )
								if( x+SHADOW_LEN < ms &&
								    y+SHADOW_LEN < ms )
									XPutPixel(img_mask,
											  x+SHADOW_LEN,y+SHADOW_LEN,1);
						}else{
							XPutPixel(img_data,x,y,black);
							XPutPixel(img_mask,x,y,0);
						}
					}else
#endif
					{
						XPutPixel(img_data,x,y,
								  base->pixels[base->use[base->data[c]]]);
						XPutPixel(img_mask,x,y,base->mask[c]);
					}
#else /* not SHAPE */
					XPutPixel(img_data,x,y,
							  base->pixels[base->use[base->data[c]]]);
#endif
				}else{
#ifdef SHADOW
				if(SHADOW_LEN)	
					XPutPixel(img_data,x,y,black);
				else
#endif
					XPutPixel(img_data,x,y,white);
#ifdef SHAPE
					XPutPixel(img_mask,x,y,0L);
#endif
				}
				u -= co;
				v += si;
			}
			du -= si;
			dv -= co;
		}
		XPutImage(dpy,pixmap[i],gc,img_data,0,0,0,0,s,s);
#ifdef SHAPE
		XPutImage(dpy,bitmap[i],gc2,img_mask,0,0,0,0,s,s);
#endif
	}	
	msg_out("..done.\n");
	XDestroyImage(img_data);
	XFreeGC(dpy,gc);
#ifdef SHAPE
	XDestroyImage(img_mask);
	XFreeGC(dpy,gc2);
#endif
}

/* mascot $B$NI=<(%Q%?!<%s$r@_Dj$9$k(B */
void set_mas(Mascot *m)
{
	static ImageData base;
	int i;
	static int inited = 0;

	int c       = m->col0;
	int r       = m->rgb0;
	double mmag = m->mmag * magnify; /* $B4pK\3HBgN($r$+$1$k(B */

	if(map_fl)
		XtUnmapWidget(mascot);

	if(inited)
		free_col( &base );

	base = get_image(m->fname,c,r);
	if(base.data == NULL){
		err_out("Can't Set MASCOT[%s].\n",m->title);
		if( inited )
			return;
		else
			exit(1);
	}
	set_col(&base, cmap);

	if(inited)
		for(i=0;i<17;i++){
			XFreePixmap(dpy,pixmap[i]);
#ifdef SHAPE
			XFreePixmap(dpy,bitmap[i]);
#endif
		}	
	else
		inited = 1;

	ms = sqrt((double)(base.w*base.w + base.h*base.h))*mmag;	/* $BBP3Q@~$ND9$5(B */
    mh = base.h / 2 *mmag;							/* $B=D$ND9$5(B     */

#ifdef BIFF
	/* biff $BE~Ce%&%#%s%I%&I=<(0LCV7hDj(B */
	if( base.w > base.h )
		biff_r = base.w * mmag / 2;
	else
		biff_r = base.h * mmag / 2;
	if( m->biff_justify == XtJustifyCenter){
		biff_th = 0;
		biff_w_off = biff_w * mmag / 2;
	}else{
		biff_th = (ANGLE_PI/2) - atan((double)base.h/base.w)/RAD;
		biff_w_off	= biff_w * mmag;
		if( m->biff_justify == XtJustifyRight ){
			biff_th = - biff_th;
			biff_w_off = 0;
		}
	}
#endif

	XtResizeWidget(mascot,ms,ms,0);

	roll( &base, mmag );		/* $B2sE>%Q%?!<%s$N@8@.(B */
	free_image( &base );
	ms /= 2;
	if( map_fl )
		XtMapWidget(mascot);
}
