/*
   XMascot Ver 2.4
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

#ifndef __XMASCOT
#define __XMASCOT

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "image.h"

#define CHAIN_SIZE 8

#define DT 100

#ifdef USE_DOUBLE
#define ANGLE_PI (M_PI)
#else
/* isin.c */
void isin_init(void);
int isin(int deg);
int icos(int deg);
#define ANGLE_PI (M_PI*256)
#endif

#define ROLL_DEG  (ANGLE_PI/32)
#define RAD       (M_PI/ANGLE_PI)

#define ALARM_NUM 3							/* $B%"%i!<%`$N?t(B     */
#define ALARM_ALLNUM (ALARM_NUM+4)			/* $B%"%i!<%`4XO"Am?t(B */
#define XtRRgb	"Rgb"

/* $B%^%9%3%C%H9=B$BN(B */
typedef struct{
	Widget entry;	
	String title;		/* $B%^%9%3%C%HL>>N(B */
	String fname;		/* $B%U%!%$%kL>(B     */
	int    col0;		/* $BF)L@?'(B(pixel)  */
	int    rgb0;		/* $BF)L@?'(B(rgb)    */
	float  mmag;		/* $B3HBgN((B */
#ifdef SOUND
	String start_snd;	/* $B5/F0%5%&%s%I(B   */
	String click_snd;   /* $B%/%j%C%/%5%&%s%I(B */
	String end_snd;		/* $B=*N;%5%&%s%I(B   */
#ifdef BIFF
	String mail_snd;	/* $B%a!<%kCe?.%5%&%s%I(B */
#endif
#endif
#ifdef BIFF
	XtJustify biff_justify;	/* $B%a!<%kE~Ce%^!<%/0LCV(B */
#endif
} Mascot;

/* $B%^%9%3%C%H%a%K%e!<9=B$BN(B */
typedef struct{
	String title;		/* $B%a%K%e!<L>>N(B     */
	int n_mascots;		/* $B%^%9%3%C%HAm?t(B   */
	Mascot *mascots;	/* $B%^%9%3%C%H9=B$BN(B */
} MascotMenu;

/* $B%"%i!<%`9=B$BN(B */
typedef struct{
	int sw;				/* $B%"%i!<%`$OM-8z$+!)(B */
	int hour;			/* $B%"%i!<%`(B $B;~4V(B      */
	int min;			/*          $BJ,(B        */
	String action;		/* $B%"%i!<%`%"%/%7%g%s(B */
	XtIntervalId id;	/* $B3d$j9~$_(B ID        */
} Alarm;

/* $B%j%=!<%9<hF@MQ9=B$BN(B */
typedef struct{
	Boolean	verbose;		/* $B>\:YI=<((B   */
	int 	grav;			/* $B=ENODj?t(B   */
	int 	chain_len;		/* $B:?$ND9$5(B   */
	float 	damping;		/* $B8:?j78?t(B   */
	float	magnify;		/* $B4pK\3HBgN((B */
	String 	search_path; 	/* $B%5!<%A%Q%9(B */
	String	pin_pat;		/* $B%T%s$N%Q%?!<%s%U%!%$%k(B     */
	int		pcol0;			/* $B%T%s$NF)L@?'%$%s%G%C%/%9(B   */
	int		prgb0;			/* $B%T%s$NF)L@?'(B RGB           */
	int		chain_num;		/* $B:?$N?t(B */
#ifdef USE_CHAINPAT
	String	chain_pat;		/* $BI3(B($B:?(B)$B$N%Q%?!<%s%U%!%$%k(B     */
	int		ccol0;			/* $BI3(B($B:?(B)$B$NF)L@?'%$%s%G%C%/%9(B   */
	int		crgb0;			/* $BI3(B($B:?(B)$B$NF)L@?'(B RGB           */
#endif
	int		menus_num;		/* $B%a%K%e!<$NAm?t(B */
	int     menu_no;		/* $B5/F0;~%a%K%e!<HV9f(B   */
	int 	no;				/* $B5/F0;~%^%9%3%C%HHV9f(B */
	String	def_act;		/* $B%G%U%)%k%H$N%"%/%7%g%s@_Dj(B */
	int     th;				/* $B=i4|3QEY(B  */
	Boolean random;			/* $B%-%c%i%/%?$N%i%s%@%`JQ99(B */
	int		change_time;	/* $B@ZBX$^$G$N;~4V(B ($BJ,;XDj(B)  */
	Boolean all_menu;		/* $B@ZBX$(A4%a%K%e!<(B         */
#ifdef BIFF
	Boolean biff_mode;		/* biff $B$OM-8z$+!)(B   */
	String  biff_action;	/* biff $B$N%"%/%7%g%s(B */
	int	    biff_update;	/* biff $B99?74V3V(B     */
	Boolean biff_once;  	/* $B0l2s$@$1%"%/%7%g%s$r5/$3$9(B */
	String  biff_cmd;		/* $B%a%$%kE~Ce%A%'%C%/%3%^%s%I(B */
	String	biff_pat;		/* biff $BE~Ce%^!<%/%Q%?!<%s%U%!%$%k(B           */
	String  biff_filter;	/* biff $B%a!<%k0lMwI=<(MQ%U%#%k%?(B             */
	int     biff_popdown;	/* biff $B$NE~Ce%a!<%k0lMw$N>C$($k$^$G$N;~4V(B   */
	int		bcol0;			/* biff $BE~Ce%^!<%/%Q%?!<%sF)L@?'%$%s%G%C%/%9(B */
	int		brgb0;			/* biff $BE~Ce%^!<%/%Q%?!<%sF)L@?'(B RGB         */
#ifdef YOUBIN
	char *server;			/* youbin server $B%[%9%HL>(B */
	int   youbin;			/* youbin $B%b!<%I$+$I$&$+(B  */
#endif
#endif
#ifdef SOUND
	String snd_cmd;			/* $B2;@<:F@8MQ%3%^%s%I(B */
#endif
#ifdef SHADOW
	int		shadow;			/* $B1F$NI}(B */
#endif
}AppData, *AppDataPtr;

/* menu.c */

void menu_add_line(Widget menu);
Widget menu_add_cascade(Widget menu,char *title,Widget cascade);
Widget menu_add_dialog(Widget menu,char *title,Widget dialog);
Widget menu_add_callback(Widget menu,char *title,XtCallbackProc callback);

Widget change_menu(Widget top,int n);
Widget preference_dialog(Widget top);
Widget alarm_dialog(Widget top);
Widget about_dialog(Widget top);
void set_new_string( String *s, String new );

/* resource.c */
void set_sim_param( void );
void get_resources(Widget top);
void usage(int *argc, char **argv);

/* etc.c */
#include "etc.h"

/* pattern.c */
void set_mas(Mascot *mas);
void set_pin_pat(char *name,int c, int r);
void set_chain_pat(char *name,int c, int r);
#ifdef BIFF
void set_biff_pat(char *name,int c,int r);
#endif

/* timer.c */
void start_timer(void);
void stop_timer(void);
void restart_timer(void);

/* action.c */

void change_mascot(Widget w,XtPointer dat,XtPointer call);
void change_mascot_with_sound(Widget w,XtPointer dat,XtPointer call);

void RaiseAll(void);
void ExitApp(void);
void Quit(Widget w,XEvent *e,String *p,Cardinal *n);
void Quit2(Widget w,XEvent *e,String *p,Cardinal *n);
void MapWin(Widget w,XEvent *e,String *p,Cardinal *n);
void UnMapWin(Widget w,XEvent *e,String *p,Cardinal *n);
void ConfigWin(Widget w,XEvent *e,String *p,Cardinal *n);
void Press(Widget w,XEvent *e,String *p,Cardinal *n);
void ReleasePin(Widget w,XEvent *e,String *p,Cardinal *n);
void ReleaseMascot(Widget w,XEvent *e,String *p,Cardinal *n);
void MotionPin(Widget w,XEvent *e,String *p,Cardinal *n);
void MotionMascot(Widget w,XEvent *e,String *p,Cardinal *n);

void Sound(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundStart(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundClick(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundEnd(Widget w,XEvent *e,String *p,Cardinal *n);
void SoundMail(Widget w,XEvent *e,String *p,Cardinal *n);

void ChangeMascot(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotFile(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotNext(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotNextAll(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotRandom(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeMascotRandomAll(Widget w,XEvent *e,String *p,Cardinal *n);

void StartMove(Widget w,XEvent *e,String *p,Cardinal *);
void System(Widget w,XEvent *e,String *p,Cardinal *n);
void ChangeParam(Widget w,XEvent *e,String *p,Cardinal *n);
void Bell(Widget w,XEvent *e,String *p,Cardinal *n);

/* sim.c */
void reset_pos(void);
void set_pos(void);
void sim(void);

#ifdef SOUND
/* sound.c */
void sound_play(char *name);
void sounds_play(char **names,int num);
#endif

#ifdef BIFF
/* biff.c */

void set_biff( void );

void ShowBiffNotice(Widget w,XEvent *e,String *p,Cardinal *n);
void BiffEnter(Widget w,XEvent *e,String *p,Cardinal *n);

#endif

/* alarm.c */
void set_alarms( void );

/* file.c */
void get_rcfile(void);
void put_rcfile(void);
void action_parse(char *action);

enum{ NODAT, STRING, ID, SYMBOL, RESERVE } TokenType;
void set_token( char *p );
int get_token2( void );

/* main.c */
void create_chains(int num);

#endif

