/*
   XMascot Ver 2.5
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifndef XAW3D
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Toggle.h>
#else
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/SmeBSB.h>
#include <X11/Xaw3d/SmeLine.h>
#include <X11/Xaw3d/Label.h>
#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Scrollbar.h>
#include <X11/Xaw3d/Toggle.h>
#endif

#include "SmeCascade.h"
#include "CascadeMenu.h"
#include "xmascot.h"

extern Pixmap select_mark;  /* $BA*Br%^!<%/(B           */
extern Pixmap icon;			/* $B%"%$%3%s$N%Q%?!<%s(B   */
extern Pixmap cascade_mark;	/* $B%+%9%1!<%I%a%K%e!<MQ(B */
extern Pixmap cclub_logo;	/* TUT CCLUB $B$N%m%4(B     */

extern AppData adat;
extern MascotMenu *mascot_menus;	/* $B%^%9%3%C%H%a%K%e!<9=B$BN(B */

extern int mascot_number;			/* $BA*BrCf%^%9%3%C%H(B       */
extern int n_mascots;	   			/* $B%^%9%3%C%HAm?t(B         */
extern Mascot *mascots;				/* $B%^%9%3%C%H%G!<%?9=B$BN(B */

extern Alarm alarm_dat[];

/* $B%a%K%e!<$K@~$rDI2C(B */
void menu_add_line(Widget menu)
{
	XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
}

/* $B%a%K%e!<$K%+%9%1!<%I%a%K%e!<$rDI2C(B */
Widget menu_add_cascade(Widget menu,char *title,Widget cascade)
{
	Widget entry = XtVaCreateManagedWidget(title,smeCascadeObjectClass,menu,
										   XtNmenu,cascade,
										   XtNrightMargin,(Position)20,
										   XtNrightBitmap,cascade_mark,NULL);
	return entry;
}
	
/* $B%a%K%e!<$N>l=j$.$a(B */
static void menu_setpos(Widget ww)
{
	Dimension w,h;
	Window root,child;
	int rx,ry;
	int wx,wy;
	unsigned  mask;

	if(!XtIsRealized(ww))
		XtRealizeWidget(ww);

	XtVaGetValues(ww, XtNwidth, &w, XtNheight, &h, NULL );
	/* $B8=:_$N%^%&%9$N%]%$%s%H$rF@$k(B */
	XQueryPointer( XtDisplay(ww),XtWindow(ww), 
				  &root, &child, &rx, &ry, &wx, &wy, &mask );
	rx -= w/2;
	ry -= h/2;

	if(rx<0)
		rx = 0;
	else if(rx > (wx = WidthOfScreen(XtScreen(ww))-w))
		rx = wx;
	if(ry<0)
		ry = 0;
	else if(ry > (wy = HeightOfScreen(XtScreen(ww))-h))
		ry = wy;
	XtVaSetValues(ww,XtNx,(Position)rx,XtNy,(Position)ry,NULL);
}

/* $BDL>o$N%@%$%"%m%0MQ$N8F$S=P$7%3!<%k%P%C%/(B */
static void popup_menu(Widget w,XtPointer dat,XtPointer call)
{
	Widget m = (Widget)dat;
	menu_setpos(m);
	XtPopup(m,XtGrabNone);
}

/* $B%a%K%e!<$KDL>o$N%@%$%"%m%0$rDI2C(B */
Widget menu_add_dialog(Widget menu,char *title,Widget dialog)
{
	Widget entry=XtVaCreateManagedWidget(title,smeBSBObjectClass,menu,NULL);
	XtAddCallback(entry,XtNcallback,popup_menu,(XtPointer)dialog);
	return entry;
}

/* $B%a%K%e!<$K%3!<%k%P%C%/$rDI2C(B */
Widget menu_add_callback(Widget menu,char *title,XtCallbackProc callback)
{
	Widget entry=XtVaCreateManagedWidget(title,smeBSBObjectClass,menu,NULL);
	XtAddCallback(entry,XtNcallback,callback,NULL);
	return entry;
}
	
/* $B%-%c%s%;%kMQ%3!<%k%P%C%/(B */
static void popdown(Widget w,XtPointer dat, XtPointer a)
{
	XtPopdown(dat);
}

/* About $B%@%$%"%m%0@8@.(B */
Widget about_dialog(Widget top)
{
	Widget base,form,cmd;
	base = XtVaCreatePopupShell("aboutBase",
								transientShellWidgetClass,top,NULL);
	form = XtVaCreateManagedWidget("about",boxWidgetClass,base,NULL);
	XtVaCreateManagedWidget("logo",coreWidgetClass,form,
							XtNbackgroundPixmap,cclub_logo,
							XtNwidth,(Dimension)48,
							XtNheight,(Dimension)48,NULL);
	XtVaCreateManagedWidget("label1",labelWidgetClass,form,
							XtNleftBitmap,icon,XtNheight,(Dimension)40,NULL);
	XtVaCreateManagedWidget("label2",labelWidgetClass,form,NULL);
	cmd  = XtVaCreateManagedWidget("ok",commandWidgetClass,form,NULL);
	XtAddCallback(cmd,XtNcallback,popdown,base);
	return base;
}

static void set_change_menu(Widget w,XtPointer dat,XtPointer call)
{
	int i,num = (int)dat;
	Mascot *mas = mascot_menus[num].mascots;
	int n       = mascot_menus[num].n_mascots;
	if(num==0 && mas[n].entry != NULL) n++;

	if(mas != mascots){
		for(i=0;i<n;i++)
			XtVaSetValues(mas[i].entry,XtNleftBitmap,None,NULL);
	}else{
		for(i=0;i<n;i++)
			if(i == mascot_number)
				XtVaSetValues(mas[i].entry,XtNleftBitmap,select_mark,NULL);
			else
				XtVaSetValues(mas[i].entry,XtNleftBitmap,None,NULL);
	}
}

/* $BJQ99MQ%a%K%e!<(B $B@8@.(B */
Widget change_menu(Widget top,int num)
{
	long i;
	Widget menu,entry;
	char name[20];
	Mascot *mas;
	int n;

	mas      = mascot_menus[num].mascots;	
	n        = mascot_menus[num].n_mascots;

	menu = XtVaCreatePopupShell("change",cascadeMenuWidgetClass,top,NULL);
	XtAddCallback(menu,XtNpopupCallback,set_change_menu,(XtPointer)num);
	XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
	for(i=0;i<n;i++){
		sprintf(name,"mascot%ld",i);
		entry = XtVaCreateManagedWidget(name,smeBSBObjectClass,menu,NULL);
		XtAddCallback(entry,XtNcallback,change_mascot_with_sound,
					  (XtPointer)((num<<8)+i));
		XtVaSetValues(entry,XtNleftMargin,(Dimension)20,NULL);
		if( mas[i].title == NULL ){
			XtVaSetValues(entry,XtNlabel,(String)"None",
						  XtNsensitive,False,NULL);
		}else{
			XtVaSetValues(entry,XtNlabel,(String)mas[i].title,
						  XtNsensitive,
						  (search(mas[i].fname)==NULL)?False:True,NULL);
		}
		mas[i].entry = entry;
	}

	/* $B0l$D$a$N%a%K%e!<$N$_(B */
	/* $B%3%^%s%I%i%$%s$+$i;XDj$7$?$b$N(B */
	if(num==0){
		if(mas[i].title != NULL ){
			XtVaCreateManagedWidget("line2",smeLineObjectClass,menu,NULL);
			sprintf(name,"mascot%ld",i);
			entry = XtVaCreateManagedWidget(name,smeBSBObjectClass,menu,NULL);
			XtAddCallback(entry,XtNcallback,change_mascot_with_sound,
						  (XtPointer)i);
			XtVaSetValues(entry,XtNleftMargin,(Dimension)20,NULL);
			XtVaSetValues(entry,XtNlabel,mas[i].title,XtNsensitive,
						  (search(mas[i].fname)==NULL)?False:True,NULL);
			mas[i].entry = entry;
		}else
			mas[i].entry = NULL;
	}
	return menu;
}
	
/* $B%"%i!<%`$N@_Dj(B */

Widget alarm_sw[ALARM_ALLNUM];
Widget alarm_hour[ALARM_ALLNUM];
Widget alarm_min[ALARM_ALLNUM];
Widget alarm_act[ALARM_ALLNUM];

#ifdef BIFF
extern String biff_action;
Widget biff_act;
#endif

void set_new_string( String *s, String new )
{
	if( *s != NULL )
		XtFree(*s);
	*s = XtNewString(new);
}

/* $B%"%i!<%`%@%$%"%m%0$N@_Dj(B */
void set_alarm_dialog(Widget w, XtPointer dat, XtPointer call)
{
	int i;
	char str[20];
	for(i=0;i<ALARM_ALLNUM;i++){
		if( alarm_dat[i].sw )
			XtVaSetValues(alarm_sw[i],XtNstate,True, NULL);
		else
			XtVaSetValues(alarm_sw[i],XtNstate,False, NULL);
		/* $B;~9o$N@_Dj$,$"$k(B */
		if(i <= ALARM_NUM+1){
			sprintf(str,"%02d",alarm_dat[i].hour);
			XtVaSetValues(alarm_hour[i],XtNstring,XtNewString(str),NULL);
			sprintf(str,"%02d",alarm_dat[i].min);
			XtVaSetValues(alarm_min[i],XtNstring,XtNewString(str),NULL);
			XtVaSetValues(alarm_hour[i],XtNinsertPosition,(Position)2,NULL);
			XtVaSetValues(alarm_min[i],XtNinsertPosition,(Position)2,NULL);
		}
		if( alarm_dat[i].action != NULL )
			XtVaSetValues(alarm_act[i],XtNstring,
						  XtNewString(alarm_dat[i].action),NULL);
		else
			XtVaSetValues(alarm_act[i],XtNstring,XtNewString(""),NULL);
	}
#ifdef BIFF
	/* for biff */
	if( biff_action != NULL )
		XtVaSetValues(biff_act,XtNstring,XtNewString(biff_action),NULL);
	else
		XtVaSetValues(biff_act,XtNstring,XtNewString(""),NULL);
#endif
}

/* $B%"%i!<%`$N@_Dj40N;(B */
static void ok_alarm(Widget w,XtPointer dat,XtPointer a)
{
	int i,h,m;
	Boolean sw;
	String str;

	XtPopdown(dat);
	for(i=0;i<ALARM_ALLNUM;i++){
		XtVaGetValues(alarm_sw[i],XtNstate,&sw,NULL);
		alarm_dat[i].sw = ( sw == True );
		/* $B;~9o$N@_Dj$,$"$k(B */
		if(i <= ALARM_NUM+1){
			XtVaGetValues(alarm_hour[i],XtNstring,&str,NULL);
			h = atoi(str);	
			XtVaGetValues(alarm_min[i],XtNstring,&str,NULL);
			m = atoi(str);	
			if( h >= 24 || h < 0 ) h = 0;
			if( m >= 60 || m < 0 ) m = 0;
			alarm_dat[i].hour = h;
			alarm_dat[i].min  = m;
		}
		XtVaGetValues(alarm_act[i],XtNstring,&str,NULL);
		set_new_string(&alarm_dat[i].action,str);
	}

#ifdef BIFF
	/* for biff */
	XtVaGetValues(biff_act,XtNstring,&str,NULL);
	set_new_string(&biff_action,str);
#endif
	put_rcfile();
	set_alarms();
}	

/* $B%"%i!<%`$NF0:n;n83(B */
static void test_alarm(Widget w,XtPointer dat,XtPointer a)
{
	String str;
	Widget w2 = (Widget)dat;
	XtVaGetValues(w2,XtNstring,&str,NULL);
	action_parse( str );
}

/* $B%"%i!<%`%@%$%"%m%0$N@_DjMQ(B */
static Widget setup(Widget form,Widget upper,char *title,int i,int mode)
{
	Widget test;

	upper = XtVaCreateManagedWidget(title,labelWidgetClass,form,
									XtNfromVert,upper,NULL);
	upper = XtVaCreateManagedWidget("box",boxWidgetClass,form,
									XtNorientation,"horizontal",
									XtNfromVert,upper,NULL);
	alarm_sw[i]	= XtVaCreateManagedWidget("sw",toggleWidgetClass,upper,
										  XtNbitmap,select_mark,NULL);
	if(mode){
		alarm_hour[i] = XtVaCreateManagedWidget("hour",asciiTextWidgetClass,
												upper,XtNeditType,XawtextEdit,
												XtNtype,XawAsciiString,NULL);
		XtVaCreateManagedWidget("sep",labelWidgetClass,upper,
								XtNlabel,(String)":",
								XtNborderWidth,(Dimension)0,
								XtNinternalWidth,(Dimension)0,NULL);
		alarm_min[i] = XtVaCreateManagedWidget("min",asciiTextWidgetClass,
											   upper,XtNeditType,XawtextEdit,
											   XtNtype,XawAsciiString,NULL);
	}
	alarm_act[i] = XtVaCreateManagedWidget("action",asciiTextWidgetClass,
										   upper,XtNeditType,XawtextEdit,NULL);
	test = XtVaCreateManagedWidget("test",commandWidgetClass,upper,NULL);
	XtAddCallback(test,XtNcallback,test_alarm,(XtPointer)alarm_act[i]);
	return upper;
}

/* $B%"%i!<%`%@%$%"%m%0(B */
Widget alarm_dialog(Widget top)
{
	int i;
	Widget base,form,test,upper;

	base = XtVaCreatePopupShell("alarmBase",
								transientShellWidgetClass,top,NULL);
	XtAddCallback(base,XtNpopupCallback,set_alarm_dialog,NULL);
	form = XtVaCreateManagedWidget("alarm",formWidgetClass,base,NULL);
	upper = XtVaCreateManagedWidget("title",labelWidgetClass,form,NULL);
	for(i=0;i<ALARM_NUM;i++)
		upper = setup(form,upper,"alarm",i,1);
	upper = setup(form,upper,"timer",ALARM_NUM,1);
	upper = setup(form,upper,"interval",ALARM_NUM+1,1);
	upper = setup(form,upper,"hourchime",ALARM_NUM+2,0);
	upper = setup(form,upper,"halfchime",ALARM_NUM+3,0);

#ifdef BIFF
	/* for biff */
	upper = XtVaCreateManagedWidget("biff",labelWidgetClass,form,
									XtNfromVert,upper,NULL);
	upper = XtVaCreateManagedWidget("biff_box",boxWidgetClass,form,
									XtNorientation,"horizontal",
									XtNfromVert,upper,NULL);
	biff_act = XtVaCreateManagedWidget("action",asciiTextWidgetClass,upper,
									   XtNeditType,XawtextEdit,NULL);
	test = XtVaCreateManagedWidget("test",commandWidgetClass,upper,NULL);
	XtAddCallback(test,XtNcallback,test_alarm,(XtPointer)biff_act);
#endif

	/* OK/CANCEL */
	upper = XtVaCreateManagedWidget("ok_box",boxWidgetClass,form,
									XtNorientation,XtorientHorizontal,
									XtNfromVert,upper,NULL);
	test = XtVaCreateManagedWidget("ok",    commandWidgetClass,upper,NULL);
	XtAddCallback(test,XtNcallback,ok_alarm,base);
	test = XtVaCreateManagedWidget("cancel",commandWidgetClass,upper,NULL);
	XtAddCallback(test,XtNcallback,popdown,base);
	return base;
}
