/*
   XMascot Ver 2.5
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <signal.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xmu/Converters.h>

#include "CascadeMenu.h"
#include "xmascot.h"


/* $B%&%#%s%I%&4pK\B0@-(B */
Display *dpy;
int      screen;
int      depth;				     
Colormap cmap;
Window   root;
double   disp_dpm;	
Atom     wm_protocols[2];

XtAppContext app;

/* $B%&%#%8%'%C%H(B */
Widget top,mascot;
Widget *chain=NULL;
#ifdef BIFF
Widget biff;
#endif

/* $B%j%=!<%9(B */
extern AppData	adat;			    /* $B%j%=!<%9%G!<%?9=B$BN(B     */
extern MascotMenu *mascot_menus;	/* $B%^%9%3%C%H%a%K%e!<9=B$BN(B */

extern int	  mascot_number;	    /* $BA*BrCf$N%^%9%3%C%H(B		*/
extern Mascot *mascots;		        /* $B%^%9%3%C%H%G!<%?9=B$BN(B	*/
extern int	  n_mascots;		    /* $B%^%9%3%C%HAm?t(B			*/
extern int 	  chain_num;

Pixmap cclub_logo;	/* TUT CCLUB $B%m%4%^!<%/(B */

/* $BJQ99%a%K%e!<MQ$NA*Br%^!<%/(B */
Pixmap select_mark;
#include "xbmfile/select.xbm"
/* $B%+%9%1!<%I%a%K%e!<MQ$N%^!<%/(B */
Pixmap cascade_mark;
#include "xbmfile/cascade.xbm"
/* $B%"%$%3%s(B */
Pixmap icon;
#include "xbmfile/icon.xbm"

/* $B%+!<%=%k(B */
Cursor cursor_normal;
#include "xbmfile/yubi.xbm"
#include "xbmfile/yubi_mask.xbm"
Cursor cursor_click;
#include "xbmfile/osu.xbm"
#include "xbmfile/osu_mask.xbm"
Cursor cursor_drag;
#include "xbmfile/tumamu.xbm"
#include "xbmfile/tumamu_mask.xbm"

/* $B%3%^%s%I%i%$%s%*%W%7%g%s(B */
static XrmOptionDescRec options[]={
	{ "-verbose",		".verbose",			XrmoptionNoArg, "True"},
	{ "-gravity",		".gravity",	 		XrmoptionSepArg, NULL},
	{ "-chainlength",	".chainLen",  		XrmoptionSepArg, NULL},
	{ "-damping",		".dampCoeff", 		XrmoptionSepArg, NULL},
	{ "-degree",		".degree",			XrmoptionSepArg, NULL},
	{ "-menuno",   	    ".menuNo",			XrmoptionSepArg, NULL},
	{ "-no",    	    ".mascotNo",		XrmoptionSepArg, NULL},
	{ "-magnify",		".magnifyBase",		XrmoptionSepArg, NULL},
	{ "-tcolor",		".masDatX.col0",	XrmoptionSepArg, NULL},
	{ "-trgb",			".masDatX.rgb0",	XrmoptionSepArg, NULL},
	{ "-pinpat",		".pinPattern",		XrmoptionSepArg, NULL},
	{ "-ptcolor",		".pcol0",			XrmoptionSepArg, NULL},
	{ "-ptrgb",			".prgb0",			XrmoptionSepArg, NULL},
	{ "-random",		".random",			XrmoptionNoArg,"True"},
	{ "-changetime",	".changeTime",		XrmoptionSepArg, NULL},
	{ "-allmenu",		".allMenu",			XrmoptionNoArg,"True"},
	{ "-chainnum",		".chainNum",		XrmoptionSepArg, NULL},
#ifdef USE_CHAINPAT
	{ "-chainpat",		".chainPattern",	XrmoptionSepArg, NULL},
	{ "-ctcolor",		".ccol0",			XrmoptionSepArg, NULL},
	{ "-ctrgb",			".crgb0",			XrmoptionSepArg, NULL},
#endif
	{ "-searchpath",	".search",			XrmoptionSepArg, NULL},
#ifdef SOUND
	{ "-soundcmd",		".soundCommand",	XrmoptionSepArg, NULL},
	{ "-soundstart",	".masDatX.startSnd",	XrmoptionSepArg, NULL},
	{ "-soundclick",	".masDatX.clickSnd",	XrmoptionSepArg, NULL},
	{ "-soundend",		".masDatX.endSnd",  	XrmoptionSepArg, NULL},
#ifdef BIFF
	{ "-soundmail",		".masDatX.mailSnd",  	XrmoptionSepArg, NULL},
#endif /* BIFF */
#endif /* SOUND */
#ifdef BIFF
	{ "-nobiff",		".biff",  			XrmoptionNoArg, "False"},
	{ "-update",		".update",			XrmoptionSepArg, NULL},
	{ "-noonce",    	".biffOnce",		XrmoptionNoArg,	"False"},
	{ "-biffcmd",		".biffCmd",			XrmoptionSepArg, NULL},
	{ "-biffpat",		".biffPattern",		XrmoptionSepArg, NULL},
	{ "-btcolor",		".bcol0",			XrmoptionSepArg, NULL},
	{ "-btrgb",			".brgb0",			XrmoptionSepArg, NULL},
	{ "-biffpos",		".MasDat.biffPos",	XrmoptionSepArg, NULL},
#ifdef BIFF_LIST
	{ "-biffgeometry",	".biffList.geometry", XrmoptionSepArg, NULL}, 
	{ "-bifffilter",	".biffFilter",		XrmoptionSepArg, NULL},
	{ "-popdowntime",   ".biffPopdown",		XrmoptionSepArg, NULL},
	{ "-nobifflists",   ".biffPopdown",     XrmoptionNoArg, "0"  },
#endif
#ifdef YOUBIN
	{ "-noyoubin",      ".youbin",          XrmoptionNoArg, "False"},
	{ "-server",        ".server",          XrmoptionSepArg, NULL},
#endif
#endif
#ifdef SHADOW
	{ "-shadow",		".shadow",			XrmoptionSepArg, NULL},
	{ "-noshadow",		".shadow",			XrmoptionNoArg, "0" },
#endif
};

/* $B%T%s$N%G%U%)%k%H%"%/%7%g%s(B */
String trans = 
"<Message>WM_PROTOCOLS: quit2()\n"
"<MapNotify>: map()\n"
"<UnmapNotify>: unmap()\n"
"<ConfigureNotify>: config()\n"
"<Btn1Down>: press()\n"
"<Btn1Up>: release_pin()\n"
"<Btn1Motion>: motion_pin()\n"
"<Btn3Down>: XawPositionSimpleMenu(popup) XtMenuPopup(popup)";

/* $B%^%9%3%C%H$N%G%U%)%k%H%"%/%7%g%s(B */
String trans_mas = 
"<Btn1Down>: press()\n"
"<Btn1Up>: release_mascot()\n"
"<Btn1Motion>: motion_mascot()\n"
"<Btn3Down>: snd_click()";

#ifdef BIFF
#ifdef BIFF_LIST
String trans_biff = "<Btn1Down>: showbiff()";
#endif
#endif

/* $B%"%/%7%g%s%j%9%H(B */
static XtActionsRec actions[]={
	{"quit2", Quit2},
	{"map", MapWin},
	{"unmap",UnMapWin},
	{"config", ConfigWin},
	{"press", Press},
	{"release_pin",ReleasePin},
	{"release_mascot",ReleaseMascot},
	{"motion_pin",MotionPin},
	{"motion_mascot",MotionMascot},

	{"quit", Quit},
	{"change",ChangeMascot},
	{"chg_file",ChangeMascotFile},
	{"chg_next",ChangeMascotNext},
	{"chg_next_all",ChangeMascotNextAll},
	{"chg_random",ChangeMascotRandom},
	{"chg_random_all",ChangeMascotRandomAll},
	{"start_move",StartMove},

	{"sound",Sound},
	{"snd_start",SoundStart},
	{"snd_click",SoundClick},
	{"snd_end",SoundEnd},
	{"snd_mail",SoundMail},

	{"system",System},
	{"chg_param",ChangeParam},
	{"bell",Bell},
#ifdef BIFF
#ifdef BIFF_LIST
	{"showbiff",ShowBiffNotice},
	{"biffnopdown", BiffEnter}, 
#endif
#endif
};

/* RGB$BJ8;zNs(B -> int $B$N%3%s%P!<%?(B */
static void XtRgbCvt(XrmValue *args,Cardinal *num,
				XrmValuePtr from, XrmValuePtr to )
{
	char str[20];
	static int rgb;
	strcpy( str, (String)from->addr );

	if( !strcmp(str,"auto") || !strcmp(str,"AUTO") ){
		to->size = sizeof(int);
		rgb = -1;
		to->addr = (XtPointer)&rgb;
		return;
	}

	if(strlen(str)==6) {
		if(isxdigit(str[0])&&
		   isxdigit(str[1])&&
		   isxdigit(str[2])&&
		   isxdigit(str[3])&&
		   isxdigit(str[4])&&
		   isxdigit(str[5])){
            sscanf(str,"%x",&rgb);
			to->size = sizeof(int);
			to->addr = (XtPointer)&rgb;
			return;
		}
	}
	XtDisplayStringConversionWarning(dpy,from->addr,"XtRRgb");
	to->addr = NULL;
	to->size = 0;
}

/* $B%^%&%9%+!<%=%k$N@8@.(B */
Cursor set_cursor(char *pat,char *mask,unsigned w, unsigned h, int x, int y)
{
	XColor black,white;
	Pixmap cur_pat,cur_mask;
	Cursor ret;

	black.red = black.green = black.blue = 0;
	white.red = white.green = white.blue = 0xffff;

	cur_pat  = XCreateBitmapFromData(dpy,root,pat,w,h);
	cur_mask = XCreateBitmapFromData(dpy,root,mask,w,h);
	ret = XCreatePixmapCursor(dpy,cur_pat,cur_mask,&black,&white,x,y);

	XFreePixmap(dpy,cur_pat);
	XFreePixmap(dpy,cur_mask);
	return ret;
}

/* $B:?$N@8@.(B (2$B2s0J>e8F$S=P$72DG=(B) */
void create_chains(int num)
{
	int i;
	if(chain){
		for(i=0;i<chain_num;i++)
			XtDestroyWidget(chain[i]);
		XtFree((char*)chain);
	}
	chain = (Widget*)XtMalloc(sizeof(Widget)*num);
	for(i=0;i<num;i++){
		chain[i] = XtCreateWidget("chains",
								  overrideShellWidgetClass,top,NULL,0);
		XtVaSetValues(chain[i],XtNsaveUnder,True,
					  XtNoverrideRedirect,True,NULL);
		XtSetMappedWhenManaged(chain[i],False);
		XtResizeWidget(chain[i],(Dimension)CHAIN_SIZE,(Dimension)CHAIN_SIZE,
					   (Dimension)1);
		XtRealizeWidget(chain[i]);
	}
	chain_num = num;
}			

/* $B%a%K%e!<4XO"(B */

#if defined(BIFF) && defined(BIFF_LIST)
/* $B%a!<%k0lMw(B */
static Widget ml_menu;
extern int mbox_flag;
static void MailLists(Widget w,XtPointer dat,XtPointer call)
{
	ShowBiffNotice(NULL,NULL,NULL,NULL);
}
/* $B%a%$%s%a%K%e!<$N=i4|@_Dj(B */
static void set_main_menu(Widget w,XtPointer dat,XtPointer call)
{
	if(mbox_flag)
		XtVaSetValues(ml_menu,XtNsensitive,True,NULL);
	else
		XtVaSetValues(ml_menu,XtNsensitive,False,NULL);
}
#endif

/* $B=*N;(B */
void ExitDialog(Widget w,XtPointer dat,XtPointer call)
{
	ExitApp();
}


/* X $B4XO"$N=i4|2=(B */
void xinit(int *argc, char **argv)
{
	int i;
	Widget popup;
	ImageData base;
	
	/* $B%"%W%j$N=i4|2=(B */
	top = XtVaAppInitialize(&app,"XMascot",options,XtNumber(options),
							argc,argv,NULL,NULL);
	/* $B%j%=!<%9%3%s%P!<%?$NEPO?(B */
	XtAddConverter(XtRString,XtRJustify,XmuCvtStringToJustify, 
				   (XtConvertArgList)NULL, 0 );
	XtAddConverter(XtRString,XtRRgb,XtRgbCvt, 
				   (XtConvertArgList)NULL, 0 );

	/* $B3F<o%Q%i%a!<%?JQ?t(B */
	dpy      = XtDisplay(top);
	screen   = XScreenNumberOfScreen(XtScreen(top));
	root     = DefaultRootWindow(dpy);
	cmap     = DefaultColormap(dpy,screen);
	depth    = DefaultDepth(dpy,screen);
	disp_dpm = HeightOfScreen(XtScreen(top))
							  /HeightMMOfScreen(XtScreen(top));

	imagelib_init(dpy,screen,root,depth);

	get_resources(top);

	/* $B0z?t$K%^%9%3%C%H$N%U%!%$%kL>$r;XDj$7$?>l9g(B */
	if( *argc != 1 ){
		n_mascots = mascot_menus[0].n_mascots;
		mascots   = mascot_menus[0].mascots;
		mascot_number = n_mascots;
		mascots[n_mascots].fname =
		mascots[n_mascots].title = argv[1];
	}

	XawSimpleMenuAddGlobalActions(app);
	XtAppAddActions(app, actions, XtNumber(actions));
	XtOverrideTranslations(top,XtParseTranslationTable(trans));
	XtResizeWidget(top,(Dimension)1,(Dimension)1,(Dimension)0);
	XtSetMappedWhenManaged(top,False);	
	XtRealizeWidget(top);
	XSelectInput(dpy,XtWindow(top),
				 XtBuildEventMask(top)|PointerMotionHintMask);

	/* $BA*Br%^!<%/$N%S%C%H%^%C%W@8@.(B */
	select_mark = XCreateBitmapFromData(dpy,root,(char*)select_bits,
										select_width,select_height);
	/* $B%+%9%1!<%I%a%K%e!<MQ$N%^!<%/(B */
	cascade_mark  = XCreateBitmapFromData(dpy,root,(char*)cascade_bits,
										  cascade_width,cascade_height);
	/* $B%"%$%3%s$N%S%C%H%^%C%W@8@.(B */
	icon = XCreateBitmapFromData(dpy,root,(char*)icon_bits,
								 icon_width,icon_height);
	XtVaSetValues(top,XtNiconPixmap,icon,NULL);

	/* $B%+!<%=%k@8@.(B */
	cursor_normal = set_cursor((char*)yubi_bits,(char*)yubi_mask_bits,
							   yubi_width,yubi_height,yubi_x_hot,yubi_y_hot);
	cursor_click  = set_cursor((char*)osu_bits,(char*)osu_mask_bits,
							   osu_width,osu_height,osu_x_hot,osu_y_hot);
	cursor_drag = set_cursor((char*)tumamu_bits,(char*)tumamu_mask_bits,
							 tumamu_width,tumamu_height,
							 tumamu_x_hot,tumamu_y_hot);

	/* TUT cclub $B$N%m%4(B */
	base = get_image("logo.mag",0,0);
	if(base.data == NULL){
		cclub_logo = XtUnspecifiedPixmap;
	}else{
		set_col(&base,cmap);
		cclub_logo = image2pixmap(&base,NULL);
	}
	free_image(&base);

	/* $B=*N;MQ%W%m%Q%F%#(B */
	wm_protocols[0] = XInternAtom(dpy,"WM_DELETE_WINDOW",False);
	wm_protocols[1] = XInternAtom(dpy,"WM_SAVEYOURSELF",False);
	XSetWMProtocols(dpy,XtWindow(top),wm_protocols,2);

	/* $B%a%$%s%a%K%e!<(B */
	popup = XtVaCreatePopupShell("popup",cascadeMenuWidgetClass,top,NULL);

	menu_add_line(popup);
	for(i=0;i<adat.menus_num;i++)
		menu_add_cascade(popup,mascot_menus[i].title,change_menu(top,i));
	menu_add_line(popup);
	menu_add_dialog(popup,"preference",preference_dialog(top));
	menu_add_dialog(popup,"alarm",alarm_dialog(top));
#if defined(BIFF) && defined(BIFF_LIST)
	ml_menu = menu_add_callback(popup,"list",MailLists);
	XtAddCallback(popup,XtNpopupCallback,set_main_menu,NULL);
#endif
	menu_add_line(popup);
	menu_add_dialog(popup,"about",about_dialog(top));
	menu_add_callback(popup,"exit",ExitDialog);

	/* mascot Window */
	mascot = XtCreateWidget("mascot_base",overrideShellWidgetClass,top,NULL,0);
	XtVaSetValues(mascot,XtNsaveUnder,True,XtNoverrideRedirect,True,NULL);
	XtOverrideTranslations(mascot,XtParseTranslationTable(trans_mas));
	XtSetMappedWhenManaged(mascot,False);
	XtResizeWidget(mascot,(Dimension)1,(Dimension)1,(Dimension)0);
	XtRealizeWidget(mascot);
	XSelectInput(dpy,XtWindow(mascot),
				 XtBuildEventMask(mascot)|PointerMotionHintMask);

	/* chains Window */
	create_chains(chain_num);

#ifdef BIFF 
	/* biff Window */
	biff = XtCreateWidget("biff",overrideShellWidgetClass,top,NULL,0);
	XtVaSetValues(biff,XtNsaveUnder,True,XtNoverrideRedirect,True,NULL);
#ifdef BIFF_LIST
	XtOverrideTranslations(biff,XtParseTranslationTable(trans_biff));
#endif
	XtSetMappedWhenManaged(biff,False);
	XtResizeWidget(biff,(Dimension)1,(Dimension)1,(Dimension)0);
	XtRealizeWidget(biff);
#endif
	XDefineCursor(dpy,XtWindow(top),cursor_normal);
	XDefineCursor(dpy,XtWindow(mascot),cursor_normal);
}

extern volatile int time_fl;	/* $B%?%$%^MQ%U%i%0(B     */

/* $B;R%W%m%;%9$N=hM}(B */
static void ChildTerm(int dummy)
{
	int s;
	wait(&s);
	signal(SIGCHLD,ChildTerm);
}

/* $B%^%9%3%C%HDj4|@ZBX$(MQ%O%s%I%i(B ($BDL>o(B) */
static void ChangeHand1(XtPointer cl,XtIntervalId *id)
{
	if( adat.all_menu )
		ChangeMascotNextAll(NULL,NULL,NULL,NULL);
	else
		ChangeMascotNext(NULL,NULL,NULL,NULL);
	XtAppAddTimeOut(app,adat.change_time*60000,ChangeHand1,NULL);
}

/* $B%^%9%3%C%HDj4|@ZBX$(MQ%O%s%I%i(B ($B%i%s%@%`(B) */
static void ChangeHand2(XtPointer cl,XtIntervalId *id)
{
	if( adat.all_menu )
		ChangeMascotRandomAll(NULL,NULL,NULL,NULL);
	else
		ChangeMascotRandom(NULL,NULL,NULL,NULL);
	XtAppAddTimeOut(app,adat.change_time*60000,ChangeHand2,NULL);
}

/* $B%a%$%s(B */
int main(int argc,char *argv[])
{
	signal(SIGCHLD,ChildTerm);
	srand( (unsigned)getpid() );	/* $BMp?t7O=i4|2=(B */

#ifdef I18N
	/* Athene Widget I18N client */
	XtSetLanguageProc(NULL,NULL,NULL);
#endif
	xinit(&argc,argv);	/* widget/window $B@8@.(B */
	usage(&argc,argv);	/* $B%*%W%7%g%s$N%A%'%C%/(B */
	get_rcfile();		/* $B@_Dj%U%!%$%k$rFI$_9~$`(B */

#ifndef USE_DOUBLE
	isin_init();							/* isin,icos $B=i4|2=(B */
#endif

	/* pin  $B$N%Q%?!<%s@_Dj(B */
	set_pin_pat(adat.pin_pat, adat.pcol0, adat.prgb0);
#ifdef BIFF
	/* biff $B$N%Q%?!<%s@_Dj(B */
	set_biff_pat(adat.biff_pat, adat.bcol0, adat.brgb0);
#endif

#ifdef USE_CHAINPAT
	/* chain $B$N%Q%?!<%s@_Dj(B */
	set_chain_pat(adat.chain_pat, adat.ccol0, adat.crgb0);
#endif

	/* $B%^%9%3%C%H$N%Q%?!<%s@_Dj(B */
	set_mas(&mascots[mascot_number]);
	XtMapWidget(top);  	/* $B%^%C%T%s%0(B   */
	set_alarms();		/* $B%"%i!<%`@_Dj(B */
#ifdef BIFF
	set_biff();			/* biff $B@_Dj(B    */
#endif

	if( adat.change_time != 0 )
		if( adat.random )	
			XtAppAddTimeOut(app,adat.change_time*60000,ChangeHand1,NULL);
		else	
			XtAppAddTimeOut(app,adat.change_time*60000,ChangeHand2,NULL);

	/* $B%$%Y%s%H%k!<%W(B */
	for(;;){
		if( XtAppPending(app) || time_fl <= 0 )
			XtAppProcessEvent(app,XtIMAll);		/* X$B$N%$%Y%s%H$r=hM}(B */
		else
		sim();		/* $B?6;R$N%7%_%e%l!<%7%g%s(B */
	}
}
