/*
   XMascot Ver 2.5   image-lib
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/
#ifndef __IMAGE_H
#define __IMAGE_H

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>

#include "etc.h"

#ifdef SHADOW
#define SHADOW_LEN image_get_shadow_len()
#else
#define SHADOW_LEN 0
#endif

#define MAX_COL_NUM 256

typedef struct{			/* $B%Q%l%C%H$N%G!<%?(B */
	unsigned r,g,b;		/* RBG      */
} PalletData;

typedef struct{
	unsigned	w,h;				/* $B2hA|%5%$%:(B               */
	int			n;					/* $B;HMQ$7$F$$$k?'$N?t(B       */
	PalletData 	pal[MAX_COL_NUM];	/* $B%Q%l%C%H$N%G!<%?(B         */
	int			use[MAX_COL_NUM];	/* $B;HMQIQEY(B $B7s(B $BJQ49%F!<%V%k(B */
	u_long		*pixels;			/* $B<B:]$N%T%/%;%k%G!<%?(B     */
	u_char     	*data;				/* $B2hA|%G!<%?(B               */
#ifdef SHAPE
	u_char		*mask;				/* $B%^%9%/$N%G!<%?(B */
#endif
	Colormap	colormap;			/* $B%+%i!<%^%C%W$N<oN`(B		*/
} ImageData;

void imagelib_init( Display *ds,int sc ,Window r, int de );
void image_set_shadow_len(int s);
int image_get_shadow_len();
void init_image( ImageData *img );
void free_image( ImageData *img );
void free_col( ImageData *img );
int get_col( ImageData *img, int r, int g, int b );
void set_col( ImageData *imgm, Colormap cmap );
ImageData get_image( char *name, int c0, int r0 );
Pixmap image2pixmap( ImageData *img, Pixmap *mask );

#endif
