/*
   XMascot Ver 2.5
   Copyright(c) 1996 Go Watanabe     go@cclub.tutcc.tut.ac.jp
                     Tsuyoshi IIda   iida@cclub.tutcc.tut.ac.jp
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "xmascot.h"

extern XtAppContext app;
extern Atom wm_protocols[2];
extern Display *dpy;
extern Window root;

extern Widget top,mascot,*chain;
extern int chain_num, chain_disp_num;

extern Cursor cursor_normal;
extern Cursor cursor_click;
extern Cursor cursor_drag;

#ifdef BIFF
extern Widget biff;
extern int mbox_flag;
#endif

extern int n_mascots;		/* $B%^%9%3%C%H$NAm?t(B       */
extern int mascot_number;	/* $BA*BrCf$N%^%9%3%C%H(B     */
extern Mascot *mascots;		/* $B%^%9%3%C%H%G!<%?9=B$BN(B */
extern MascotMenu *mascot_menus;	/* $B%^%9%3%C%H%a%K%e!<9=B$BN(B */

extern AppData adat;		/* $B%j%=!<%972(B */
extern double damping;		/* $B8:?j78?t(B   */
extern double magnify;		/* $B4pK\3HBgN((B */
extern int chain_len;		/* $B:?$ND9$5(B   */

#ifdef USE_DOUBLE
extern double th;			/* $B3QEY(B           */
extern double om;			/* $B3QB.EY(B         */
#else
extern int th;				/* $B3QEY(B           */
extern int om;				/* $B3QB.EY(B         */
#endif


/* $B%^%9%3%C%H$NJQ99(B */
void change_mascot(Widget w,XtPointer dat,XtPointer call)
{
	adat.menu_no  = (int)dat >> 8;
    mascot_number = (int)dat & 0xff; 
	mascots   = mascot_menus[adat.menu_no].mascots;
	n_mascots = mascot_menus[adat.menu_no].n_mascots; 
	set_mas(&mascots[mascot_number]);
	set_sim_param();
	reset_pos();				/* $B:FIA2h(B */
	set_pos();
}

/* $B2;@<$D$-%^%9%3%C%HJQ99(B */
void change_mascot_with_sound(Widget w,XtPointer dat,XtPointer call)
{
	change_mascot(w,dat,call);
#ifdef SOUND
	sound_play(mascots[(long)dat & 0xff].start_snd);
#endif
}	

/* $BA4BN$r(B raise $B$9$k(B */
void RaiseAll(void)
{
	int i;
	for(i=0;i<chain_num;i++)
		XRaiseWindow(dpy,XtWindow(chain[i]));
	XRaiseWindow(dpy,XtWindow(top));
	XRaiseWindow(dpy,XtWindow(mascot));
#ifdef BIFF
	if( mbox_flag )
		XRaiseWindow(dpy,XtWindow(biff));
#endif
}

/* $B=*N;=hM}(B */
void ExitApp(void)
{
#ifdef SOUND
	sound_play(mascots[mascot_number].end_snd);
#endif
	XCloseDisplay(dpy);
	put_rcfile();
	exit(0);
}

/* $B=*N;=hM}(B */
void Quit(Widget w,XEvent *e,String *p,Cardinal *n)
{
	ExitApp();
}

/* $B=*N;%a%C%;!<%8$N<uM}(B */
void Quit2(Widget w,XEvent *e,String *p,Cardinal *n)
{
	if(e->xclient.data.l[0] == wm_protocols[0] ||
	   e->xclient.data.l[0] == wm_protocols[1] ){
		ExitApp();
	}
}

int map_fl = 0;   /* $B8=:_%^%9%3%C%H$O%^%C%W$5$l$F$$$k$+!)(B */

/* $B%^%C%T%s%0(B */
void MapWin(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef SOUND
	static int firstmap = 0;
#endif
	int i;
	set_sim_param();
	reset_pos();
	set_pos();
	for(i=0;i<chain_disp_num;i++)
		XtMapWidget(chain[i]);
	XtMapWidget(mascot);
#ifdef BIFF
	if( mbox_flag ){
		XtMapWidget(biff);
	}
#endif
	start_timer();
	RaiseAll();
#ifdef SOUND
	if( firstmap == 0 ){
		firstmap = 1;
		sound_play(mascots[mascot_number].start_snd);
	}
#endif
	map_fl = 1;
}

/* $B%"%s%^%C%W(B */
void UnMapWin(Widget w,XEvent *e,String *p,Cardinal *n)
{
	int i;
	stop_timer();
	for(i=0;i<chain_num;i++)
		XtUnmapWidget(chain[i]);
	XtUnmapWidget(mascot);
#ifdef BIFF
	XtUnmapWidget(biff);
#endif
	map_fl = 0;
}

int px,py;				/* pin $B$N(B geometry */
extern unsigned pin_w;	/* pin $B$N%Q%?!<%s$N2#I}(B */
extern unsigned pin_h;	/* pin $B$N%Q%?!<%s$N=DI}(B */

/* $B>l=j$N0\F0(B */
void ConfigWin(Widget w,XEvent *e,String *p,Cardinal *n)
{
	Window dmy;
	XTranslateCoordinates(dpy,XtWindow(w),root,0,0,&px,&py,&dmy);
	px += pin_w;
	py += pin_h;
	set_pos();
}

static int motion_fl;		/* $B%I%i%C%0$7$?$+(B?             */

/* $B%\%?%s$r2!$7$?(B */
void Press(Widget w,XEvent *e,String *p,Cardinal *n)
{
	stop_timer();			/* $B?6;R$N%7%_%e%l!<%7%g%s$rDd;_(B */
	motion_fl = 0;
	XDefineCursor(dpy,XtWindow(w),cursor_click);
	RaiseAll();
}

/* $B%^%9%3%C%H(B $B%\%?%s$rN%$7$?(B */
void ReleaseMascot(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef USE_DOUBLE
	om = ( motion_fl )?0:om+((om<0)?-1:1)*M_PI;
#else
	om = ( motion_fl )?0:om+((om<0)?-1:1)*M_PI*256;
#endif
	XtUngrabPointer(w,CurrentTime);
	XDefineCursor(dpy,XtWindow(w),cursor_normal);
	restart_timer();	/* $B?6;R$N%7%_%e%l!<%7%g%s$N:F3+(B */
}

/* Pin $B%\%?%s$rN%$7$?(B */
void ReleasePin(Widget w,XEvent *e,String *p,Cardinal *n)
{
	XtUngrabPointer(w,CurrentTime);
	XDefineCursor(dpy,XtWindow(w),cursor_normal);
	restart_timer();	/* $B?6;R$N%7%_%e%l!<%7%g%s$N:F3+(B */
}

/* Mascot $B$N0\F0(B */
void MotionMascot(Widget w,XEvent *e,String *p,Cardinal *n)
{
	XEvent ev;
	Window root,child;
	int rx,ry,x,y;
	u_int key;

	if(!motion_fl){
		XtGrabPointer(w,False,ButtonReleaseMask|Button1MotionMask,
					  GrabModeAsync,GrabModeAsync,
					  None,cursor_drag,CurrentTime);
		motion_fl = 1;
	}
	while(XCheckMaskEvent(dpy,Button1MotionMask,&ev));
	if(!XQueryPointer(dpy,XtWindow(top),&root,&child,
					  &rx,&ry,&x,&y,&key))
		return;
	x = rx - px;
	y = ry - py;
	th = atan2(x,y)/RAD;
	chain_len = sqrt((double)(x*x+y*y));
	set_sim_param();
	set_pos();
}

/* PIN $B$N0\F0(B */
void MotionPin(Widget w,XEvent *e,String *p,Cardinal *n)
{
	XEvent ev;
	Window root,child;
	int rx,ry,x,y;
	u_int key;

	if(!motion_fl){
		XtGrabPointer(w,False,ButtonReleaseMask|Button1MotionMask,
					  GrabModeAsync,GrabModeAsync,
					  None,cursor_drag,CurrentTime);
		motion_fl = 1;
	}
	while(XCheckMaskEvent(dpy,Button1MotionMask,&ev));
	if(!XQueryPointer(dpy,XtWindow(top),&root,&child,
					  &rx,&ry,&x,&y,&key))
		return;
	XtMoveWidget(w,rx-pin_w,ry-pin_h);
}


/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B;XDj$7$?HV9f(B */
void ChangeMascot(Widget w,XEvent *e,String *p,Cardinal *n)
{
	long m,i;
	if(*n == 1){
		i = atoi(p[0]);
		if(i>=0 && i<mascot_menus[0].n_mascots)
			change_mascot(w,(XtPointer)i,NULL);
	}else if(*n == 2){
		i = atoi(p[0]);	
		m = atoi(p[1]);
		if(i>=0 && i<mascot_menus[m].n_mascots)
			change_mascot(w,(XtPointer)((m<<8)+i),NULL);
	}
		
}

/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B%U%!%$%k$rFI$_9~$`(B */
void ChangeMascotFile(Widget w,XEvent *e,String *p,Cardinal *n)
{
	if(*n > 0){
		mascots   = mascot_menus[0].mascots;
		n_mascots = mascot_menus[0].n_mascots;
		mascots[n_mascots].fname = p[0];
		mascots[n_mascots].title = ( *n > 2 )? p[1]:p[0];
		change_mascot(w,(XtPointer)((long)n_mascots),NULL);
	}
}

/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B<!$N%(%s%H%j(B */
void ChangeMascotNext(Widget w,XEvent *e,String *p,Cardinal *n)
{
	long i = mascot_number+1;
	if(i >= n_mascots) i=0;
	change_mascot(w,(XtPointer)((adat.menu_no<<8)+i),NULL);
}

/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B<!$N%(%s%H%j(B ($BA4%a%K%e!<(B) */
void ChangeMascotNextAll(Widget w,XEvent *e,String *p,Cardinal *n)
{
	long m = adat.menu_no;
	long i = mascot_number+1;
	if(i >= n_mascots){
		i=0;
		m++;
		if(m >= adat.menus_num){
			m=0;
		}
	}
	change_mascot(w,(XtPointer)((m<<8)+i),NULL);
}

/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B%i%s%@%`(B */
void ChangeMascotRandom(Widget w,XEvent *e,String *p,Cardinal *n)
{
	long i = rand() % n_mascots;
	change_mascot(w,(XtPointer)((adat.menu_no<<8)+i),NULL);
}

/* $B%"%/%7%g%s(B $B%^%9%3%C%H$NJQ99(B $B%i%s%@%`(B $BA4%a%K%e!<(B */
void ChangeMascotRandomAll(Widget w,XEvent *e,String *p,Cardinal *n)
{
	long m = rand() % adat.menus_num;
	long i = rand() % mascot_menus[m].n_mascots;
	change_mascot(w,(XtPointer)((m<<8)+i),NULL);
}

/* $B%"%/%7%g%s(B $BMI$l$k(B */
void StartMove(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef USE_DOUBLE
	om = om+((om<0)?-1:1)*M_PI;
#else
	om = om+((om<0)?-1:1)*M_PI*256;
#endif
	restart_timer();
}

/* $B%"%/%7%g%s(B $B2;@<$N:F@8(B */
void Sound(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef SOUND
	sounds_play(p,*n);
#endif
}

/* $B%"%/%7%g%s(B $B3+;O;~2;@<(B */
void SoundStart(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef SOUND
	sound_play(mascots[mascot_number].start_snd);
#endif
}

/* $B%"%/%7%g%s(B $B%/%j%C%/;~2;@<(B */
void SoundClick(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef SOUND
	sound_play(mascots[mascot_number].click_snd);
#endif
}

/* $B%"%/%7%g%s(B $B=*N;;~2;@<(B */
void SoundEnd(Widget w,XEvent *e,String *p,Cardinal *n)
{
#ifdef SOUND
	sound_play(mascots[mascot_number].end_snd);
#endif
}

/* $B%"%/%7%g%s(B $B%a!<%k2;@<(B */
void SoundMail(Widget w,XEvent *e,String *p,Cardinal *n)
{
#if defined(BIFF) && defined(SOUND)
	sound_play(mascots[mascot_number].mail_snd);
#endif
}

/* $B%"%/%7%g%s(B $B30It%3%^%s%I8F$S$@$7(B */
void System(Widget w,XEvent *e,String *p,Cardinal *n)
{
	if(*n > 0)
		system(p[0]);
}	

/* $B%"%/%7%g%s(B $B%Q%i%a!<%?JQ99(B */
void ChangeParam(Widget w,XEvent *e,String *p,Cardinal *n)
{	
	int i;
	for(i=0;i<*n;i+=2){
		if( !strcmp(p[i],"clen") ){
			chain_len = atoi(p[i+1]);
			set_sim_param();
			reset_pos();
			set_pos();
		}else if(!strcmp(p[i],"damp")){
			damping = atof(p[i+1]);
			if( damping < 0 ) damping = 0;
			if( damping > 1 ) damping = 1;
		}else if(!strcmp(p[i],"mag")){
			magnify = atof(p[i+1]);
			if( magnify < 0.01 ) magnify = 0.01;
			change_mascot(w,(XtPointer)((long)mascot_number),NULL);
		}else if(!strcmp(p[i],"grav")){
			adat.grav = atoi(p[i+1]);
			set_sim_param();
		}
	}
}

/* $B%"%/%7%g%s(B $B%Y%k$r$J$i$9(B */
void Bell(Widget w,XEvent *e,String *p,Cardinal *n)
{
	int i;
	if( *n > 0 ){
		i = atoi( p[0] );
		if( i<-100 ) i=-100;
		if( i>100  ) i= 100;
		XBell( dpy, i );
	}else
		XBell( dpy, 100 );
}
