/* the main goal of the list is to identify 
   roms
    currently not used
	bad dumps
	merged, combined, modified sets */

static struct {
	int crc32; int size; char *text;
} roms[]= {
	{ 0x5be0a51f,  0x200, "VIP monitor" },
	{ 0x3e0f50f0,  0x200, "VIP chip8 interpreter" },
	{ 0xa494b339,  0x800, "STUDIO2 bios" },

	{ 0x279e33d1 , 0x400, "ADVENTURE VISION bios" },

	{ 0x04694ed9 , 0x400, "31253 CHANNELF" },
	{ 0x9c047ba3 , 0x400, "31254 CHANNELF" },
	{ 0x2882c02d , 0x800, "MERGED! CHANNELF 31253+31254" },

	{ 0xebc77f3a , 0x2000, "ASTROCADE" },

	{ 0x3aa93ef3 , 0x2000, "COLECO" },
	{ 0x39bb16fc , 0x2000, "COLECO alternate" },
	{ 0x05a37a34, 0x2000, "ADAM eos" },
	{ 0x58d86a2a, 0x8000, "ADAM wp" },

	{ 0xba13fb57 , 0x2000, "VECTREX" },
	{ 0x20af7f3f , 0x8000, "RAASPEC" },

	{ 0x8016a315 , 0x400, "ODYSSEY2" },

	{ 0x5e607dcf, 0x2000, "FAMICOM disk" },
	{ 0x38000b6b, 0x40, "SNES" },

	{ 0x3b601fc8, 0x80000, "PSX scph1000" },
	{ 0x318178bf, 0x80000, "PSX 41A" },

	{ 0xcbce86f7, 0x2000, "INTV" },
	{ 0x683a4158, 0x800, "INTV" },

/* Sega ***********************************************************************/
	{ 0xf691f9c7, 0x8000, "SC3000 basic 2j" },
	{ 0x155fd01f, 0x8000, "SC3000 basic 31" },

	{ 0x5c12eae8, 0x100, "SYS32X" },
	{ 0xdd9c46b8, 0x800, "SYS32X" },
	{ 0xbfda1fe5, 0x400, "SYS32X" },

	{ 0x2aba43c2, 0x80000, "SATURN 100" },
	{ 0x224b752c, 0x80000, "SATURN 101" },

/* NEC ***********************************************************************/
	{ 0xf82771f1, 0x2000, "PCEngine cdrom bios" },

	{ 0xe983ad21, 0x8000, "BAD DUMP PC6001 (2nd half 0xff)" },
	{ 0x1a63a57a, 0x2000, "BAD DUMP PC6001 (1st and 2nd half equal)" },
	{ 0x950ac401, 0x8000, "PC6001 basic" }, /*62? */
	{ 0xb5364f8b, 0x2000, "PC6001 char" },
	{ 0x20c8f3eb, 0x8000, "PC6001 kanji" },
	{ 0x49b4f917, 0x4000, "PC6001 voice" },

	{ 0xc0b01772, 0x8000, "PC6601 basic" },
	{ 0xd2434f29, 0x2000, "PC6601 char" },
	{ 0x3ce48c33, 0x2000, "PC6601 char" },
	{ 0xf952b567, 0x8000, "PC6601 kanji" },
	{ 0x91d078c1, 0x4000, "PC6601 voice" },

	{ 0x516b1be3, 0x8000, "PC6601 basic" }, /*68?? */
	{ 0x331473a9, 0x2000, "PC6601 char" },
	{ 0x03ba2cf1, 0x2000, "PC6601 char" },
	{ 0x07318218, 0x2000, "PC6601 system2" },
	{ 0x37ff3829, 0x4000, "PC6601 voice" },

	{ 0xeb1d90ca, 0x1c000, "PC8801" },
	{ 0x7a6edb47, 0x1800, "PC8801 char" },
	{ 0x0f60c51f, 0x20000, "PC8801 kanji1" },
	{ 0x8e67a330, 0x20000, "PC8801 kanji2" },

	{ 0x6e299128 , 0x8000, "BAD DUMP/ROM? PC9821 00000" },
	{ 0xf2a262b0 , 0x8000, "BAD DUMP/ROM? PC9821 c8000" },
	{ 0x5dda57cc , 0x8000, "BAD DUMP/ROM? PC9821 d8000" },
	{ 0x4e32081e , 0x8000, "PC9821 e8000" },
	{ 0x4da85a6c , 0x8000, "PC9821 f0000" },
	{ 0x2b1e45b1 , 0x8000, "MODIFIED? PC9821 f8000" },

/* apple ******************************************************************************/
	{ 0xa30b6af5 , 0x100, "APPLE1 bios" },
	{ 0xbe70bb85 , 0x400, "APPLE1 characterset" },

	{ 0x24d73c7b, 0x1000, "APPLE2 d000" },
	{ 0x0d494efd, 0x1000, "APPLE2 e000" },
	{ 0xb58f1ca1, 0x1000, "APPLE2 f000" },
	{ 0xf66f9c26 , 0x3000, "MERGED APPLE2? (0x24d73c7b+0x0d494efd+0xb58f1ca1)" },

	{ 0xe248835e , 0x2000, "APPLE2E bios c000 (?+0x24d73c7b)" },
	{ 0xfc3d59d8 , 0x2000, "APPLE2E bios e000 (0x0d494efd+?)" },
	{ 0x443aa7c4 , 0x2000, "APPLE2EE bios c000" },
	{ 0x95e10034 , 0x2000, "APPLE2EE bios e000" },

	{ 0x65989942, 0x4000, "BAD DUMP APPLE2E (0x?+0x95e10034!+0x443aa7c4+0x95e10034!)" },

	{ 0x02b648c8 , 0x4000, "APPLE2EP bios c000" },
	{ 0xf0edaa1b , 0x4000, "APPLE2C bios" },
	{ 0xc8b979b3 , 0x8000, "APPLE2C0 bios" },
	{ 0x0b996420 , 0x8000, "APPLE2CP bios" },

	{ 0xce7144f6 , 0x100, "APPLE2E disk" },
	{ 0x816a86f1 , 0x1000, "APPLE2E characterset" },
	{ 0x2651014d , 0x1000, "APPLE2C characterset" },

	{ 0x42f124b0 , 0x20000, "APPLE2GS" },

	{ 0xecfceb45 , 0x800, "INCOMPLETE? APPLE characterset ???" },
	{ 0xc506efb9 , 0x800, "INCOMPLETE? APPLE characterset ???" },
	{ 0x2b6da315 , 0x1000, "BAD DUMP? APPLE characterset 0xc506efb9+0xc506efb9!" },
	{ 0x0b0759cc , 0x1000, "BAD DUMP? APPLE characterset (first half 0xff)+0xc506efb9" },

	{ 0xadfd4516 , 0x2000, "LISA2 hi" },
	{ 0x546d6603 , 0x2000, "LISA2 lo" },
	{ 0xbc6364f1 , 0x1000, "LISA2 6504" },
	{ 0x75904783 , 0x100, "LISA2 vidprom" },

	{ 0xb72a2c70, 0x100, "lisa vidprom ??" },
	{ 0x223f3917, 0x100, "lisa vidprom few differences to 0xb72a2c70 ??" },
	{ 0xe343fe74, 0x1000, "lisa ??" },
	{ 0x8c67959a, 0x1000, "lisa ??" },
	{ 0xef19130f, 0x1000, "lisa ??" },
	{ 0xa26ef1c6, 0x800, "lisa ??" },
	{ 0x25e86e95, 0x2000, "lisa ??" },
	{ 0xe693057b, 0x2000, "lisa ??" },
	{ 0x80add605, 0x2000, "lisa 68000 hi??" },
	{ 0xedf5222f, 0x2000, "lisa 68000 lo??" },

	{ 0xf69697e6 , 0x10000, "? MAC + v1 even" },
	{ 0x49f25913 , 0x10000, "? MAC + v1 odd" },
	{ 0xb2102e8e , 0x20000, "COMBINED MAC + v1" },
	{ 0xe133094a , 0x21d50, "COMBINED MAC + v1 and additional data!?" },
	{ 0x6eb97aff , 0x10000, "342-0341 MAC + v2 even" },
	{ 0xbfdc37d1 , 0x10000, "342-0342 MAC + v2 odd" },
	{ 0x7624ef58 , 0x20000, "COMBINED MAC 342-0341+342-0342" },
	{ 0xf7c4b876 , 0x1ffff, "INCOMPLETE COMBINED MAC 342-0341+342-0342" },

	{ 0xce3b966f , 0x40000, "MAC 256k" },

	{ 0x71681726 , 0x80000, "MAC 512k 350EACF0" },
	{ 0xa92145b3 , 0x80000, "MAC 512k 35C28F5F" },
	{ 0x46adbf74 , 0x80000, "MAC 512k 368cadfe" },

	{ 0x88ea2081 , 0x100000, "MAC 1M 420DBFF3" },
	{ 0xa893cb0f , 0x100000, "MAC 1M EDE66CBD" },
	{ 0xb8514689 , 0x100000, "MAC 1M FF7439EE" },
	{ 0x4e70e3c0 , 0x100000, "MAC Quad 650" },

/* acorn **********************************************************************/
	{ 0xc604db3d , 0x1000, "ATOM kernel" },
	{ 0x81d86af7 , 0x1000, "ATOM floating point" },
	{ 0x43798b9b , 0x1000, "ATOM basic" },
	{ 0xc431a9b7 , 0x1000, "ATOM dos" },
	{ 0x3c14fc70 , 0x4000, "PROTON kernel" },
	{ 0x79434781 , 0x4000, "PROTON basic" },
	{ 0xe7e2a294 , 0x4000, "PROTON advromm" },
	{ 0x9a50231f , 0x4000, "PROTON exmon" },
	{ 0xc1505821 , 0x4000, "PROTON help" },
	{ 0x557ce483 , 0x4000, "PROTON toolkit" },
	{ 0x4345359f , 0x4000, "PROTON view" },
	{ 0x9fb8d13f , 0x4000, "PROTON dfs144" },

	{ 0x1356d440, 0x20000, "Z88 v4.00" },
	{ 0x802cb9aa, 0x20000, "Z88 ???" },
	{ 0xad0c407d, 0x20000, "Z88 ???" },

	{ 0xc1adde84 , 0x80000, "ARCHIMEDES 310 bios 20000" },
	{ 0x15d89664 , 0x80000, "ARCHIMEDES 310 bios 28000" },
	{ 0xa81ceb7c , 0x80000, "ARCHIMEDES 310 bios 30000" },
	{ 0x707b0c6c , 0x80000, "ARCHIMEDES 310 bios 38000" },

/* atari ******************************************************************************/
	{ 0x649913e5 , 0x1000, "ATARI7800 bios" },

	{ 0x6a5d766e , 0x800, "CO12399B? A800 floating point d800" },
	{ 0x8e547f56 , 0x1000, "CO15199? A800 PAL A e000" },
	{ 0xbe55b413 , 0x1000, "CO15299? A800 PAL A f000" },
	{ 0xd818f3e8 , 0x1000, "CO12499B? A800 NTSC B e000" },
	{ 0xc1690a9b , 0x1000, "CO14599B? A800 NTSC B f000" },
	{ 0x6ea08467 , 0x1000, "?? A800 PAL B? (few differences to NTSC B) e000" },
	{ 0x7509ffc4 , 0x1000, "?? A800 PAL B? (few differences to NTSC B) f000" },
	{ 0xcb4db9af , 0x2000, "MERGED! A800 0x6ea08467+0x7509ffc4" },
	{ 0x3e28a1fe , 0x2800, "MERGED! A800 0x6a5d766e+0x6ea08467+0x7509ffc4" },
	{ 0x72b3fed4 , 0x2800, "MERGED! A800 PAL A co12399b+CO15199+CO15299?" },
	{ 0x0e86d61d , 0x2800, "MERGED! A800 NTSC B co12399b+CO12499B+CO14599B?" },

	{ 0x0391386b , 0x2000, "co60616a A800XL rev 10 part 1" },
	{ 0xb502f1e7 , 0x2000, "co60617a A800XL rev 10 part 2" },
	{ 0xc5c11546 , 0x4000, "MERGED! CO60616A, CO60617a A800XL REV10" },
	{ 0x643bcc98 , 0x4000, "CO62024 A800XL REV01" },
	{ 0x1f9cd270 , 0x4000, "CO61598B A800XL REV02" },
	{ 0x29f133f7 , 0x4000, "C300717 A800XL REV03" },
	{ 0x1eaf4002 , 0x4000, "PART OF C101687 A800XL REV04" },
	{ 0x89d5661d , 0x1000, "co12402 A800XL Basic REV A part 1" },
	{ 0x4b4e6762 , 0x1000, "co12502 A800XL Basic REV A part 2" },
	{ 0x4bec4de2 , 0x2000, "MERGED! A800XL co12402+co12502" },
	{ 0xf0202fb3 , 0x2000, "CO60302A A800XL BASIC REV B" },
	{ 0x7d684184 , 0x2000, "CO24947A A800XL BASIC REV C" },

	{ 0x4248d3e3 , 0x800, "ATARI5200 bios" },

	{ 0xd331af30 , 0x30000, "ATARIST TOS 100" },
	{ 0x3b5cd0c5, 0x30000, "ATARIST TOS 104" },
	{ 0x08538e39, 0x40000, "ATARIST TOS 206" },

	{ 0xe1ffecb6, 0x200, "LYNX saved (fff9 not authentic)" },
	{ 0x0d973c9d, 0x200, "LYNX saved (fff9 different to 0xe1ffecb6)" },

	{ 0xfb731aaa, 0x20000, "JAGUAR" },

/* amstrad *********************************************************************/
	{ 0x0219bb74 , 0x4000, "CPC6128 os" },
	{ 0xcdb86700 , 0x4000, "CPC6128 os french" },
	{ 0xa9937f75 , 0x4000, "CPC6128 os spanish" },
	{ 0x7f9ab3f7 , 0x4000, "KCCOMPACT os" },
	{ 0xca6af63d , 0x4000, "CPC basic" },
	{ 0x4ff8190c , 0x4000, "CPC6128 basic french" },
	{ 0xb6e4acd2 , 0x4000, "CPC6128 basic spanish" },
	{ 0x40852f25, 0x8000, "CPC464" },
	{ 0x39185397, 0x8000, "CPC464 Danish (homebrew?)" },
	{ 0x9ab5a036, 0x8000, "CPC664" },
	{ 0x9e827fe1, 0x8000, "MERGED CPC6128 0x0219bb74+0xca6af63d" },
	{ 0x1fe22ecd, 0x4000, "CPC Disk" },
	{ 0x37f1bb31, 0x4000, "BAD DUMP CPC Disk (1st half equal 0x1fe22ecd, 2nd half 0)" },
	{ 0xf36086de, 0x2000, "CPC Multiface" },

	{ 0xbec456b1, 0x4000, "CPC464+ os" },
	{ 0xc0cb1145, 0x4000, "CPC464+ basic" },
	{ 0xf6159e18, 0x4000, "BAD DUMP CPC464+ disk (2nd half ff)" },

	{ 0xdf31eb22, 480, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0x621d58a7, 589, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0xb3140dcb, 608, "REPROGRAMMED PCW8256 older than 0x679b0287" },
	{ 0x679b0287, 608, "REPROGRAMMED PCW8256" },
	{ 0xc642f498 , 0x80000, "PCW16 045" },

	{ 0x849884f9, 0x40000, "NC100" },
	{ 0xa699eca3, 0x40000, "NC100a" },
	{ 0xbb8180e7, 0x80000, "NC200" },

/* commodore pet series *******************************************************************/
	{ 0xa055e33a, 0x800, "901447-01, 901439-01, maybe 6540-011 PET basic1 c000" },	
	{ 0x03cf16d0, 0x800, "901447-09, 901439-09, 6540-019 PET basic1 c000 newer revision" },
	{ 0x69fd8a8f, 0x800, "901447-02, 901439-05, 6540-012 PET basic1 c800" },
	{ 0xd349f2d4, 0x800, "901447-03, 901439-02, 6540-013 PET basic1 d000" },
	{ 0x850544eb, 0x800, "901447-04, 901439-06, 6540-014 PET basic1 d800" },
	{ 0x9e1c5cea, 0x800, "901447-05, 901439-03, 6540-015 PET e000" },
	{ 0x661a814a, 0x800, "901447-06, 901439-04, 6540-016 PET f000" },
	{ 0xc4f47ad1, 0x800, "901447-07, 904139-07, 6540-018 PET f800" },

	{ 0x63a7fe4a, 0x1000, "901465-01 PET basic2 c000" },
	{ 0xae4cb035, 0x1000, "901465-02 PET basic2 d000" },
	{ 0xe459ab32, 0x800, "901447-24, 6540-024 PET e000" },
	{ 0x05db957e, 0x800, "901474-01 PET business keyboard e000" }, 
	{ 0xf02238e2, 0x1000, "901465-03 PET f000" },
	
	{ 0x3a5f5721, 0x1000, "901465-19 PET basic4 b000" },
	{ 0xae3deac0, 0x1000, "901465-23 PET basic4 b000 newer revision" },
	{ 0x0fc17b9c, 0x1000, "901465-20 PET basic4 c000" },
	{ 0x36d91855, 0x1000, "901465-21 PET basic4 d000" },
	{ 0x5f85bdf8, 0x800, "901499-01 PET crtc 60hertz e000" },
	{ 0x3370e359, 0x800, "901498-01 PET crtc 50hertz e000" },
	{ 0x75ff4af7, 0x800, "901474-02 PET business keyboard e000" },
	{ 0x5674dd5e, 0x800, "901474-03 PET 80columns business keyboard, 60 hertz e000" },
	{ 0xc1ffca3a, 0x800, "901474-04-3681 PET 80columns business keyboard, 50 hertz e000 (1981, week36)" },
	{ 0x845a44e6, 0x800, "901474-04? PET 80columns business keyboard, 50 hertz e000" },
	{ 0xabb000e7, 0x800, "901474-04 PET 80columns business keyboard, 50 hertz e000" },
	{ 0x1c1e597d, 0x800, "? PET 80columns business keyboard, 50 Hertz, german e000" },
	{ 0x75901dd7, 0x800, "? PET 80columns business keyboard, 50 Hertz, swedish e000" },
	{ 0xcc5298a1, 0x1000, "901465-22 PET f000" },

	{ 0x54f32f45, 0x800, "901447-08 PET 8x8 petscii character set" },/* 6540-010 = 901439-08 */
	{ 0xd8408674, 0x800, "901447-10 PET 8x8 business character set" },
	{ 0x3bb8cb87, 0x800, "? PET 8x8 business german character set" },
	{ 0x48c77d29, 0x800, "901447-14 PET 8x8 business swedish character set" },
	{ 0xa02d8122, 0x800, "? PET 8x8 business hungarian character set" }, /* Editor rom missing */

	{ 0xd262bacd, 0x2000, "BAD DUMP! 324878-01 PET cost reduced set" },
	{ 0x5e00476d, 0x2000, "BAD DUMP! 324878-02 PET cost reduced set" },

	{ 0xaff78300, 0x2000, "MERGED! PET 901447-09 + 901447-02 + 901447-03 + 901447-04" },
	{ 0xf0186492, 0x1000, "MERGED! PET 901447-06 + 901447-07" },
	{ 0xcf35e68b, 0x2000, "MERGED! PET 901465-01 + 901465-02" },
	{ 0x2a940f0a, 0x3000, "MERGED! PET 901465-23 + 901465-20 + 901465-21" },
		
	{ 0x728a998b, 0x1000, "901898-01 SUPERPET m6809 a000" },
	{ 0x6beb7c62, 0x1000, "901898-02 SUPERPET m6809 b000" },
	{ 0x5db4983d, 0x1000, "901898-03 SUPERPET m6809 c000" },
	{ 0xf55fc559, 0x1000, "901898-04 SUPERPET m6809 d000" },
	{ 0xb2cee903, 0x800, "901897-01 SUPERPET m6809 e000" },
	{ 0xf42df0cb, 0x1000, "901898-05 SUPERPET m6809 f000" },

	{ 0xee8229c4, 0x1000, "901640-01 SUPERPET 8x8chars 256 PETSCII, 256 ASCII" },
	{ 0xda1cd630, 0x1000, "? SUPERPET 8x8chars 256 PETSCII Swedish, 256 ASCII\n9014147-14+256 chars ascii from above)" },

/* Commodore C16/C116/Plus4/1551 *************************************************************/
	{ 0x74eaae87, 0x4000, "318006.01 PLUS4 Basic 8000" },
	{ 0x77bab934, 0x4000, "318004.03 PLUS4 Kernel Pal R3 c000" },
	{ 0xbe54ed79, 0x4000, "318004.04 PLUS4 Kernel Pal R4 c000" },
	{ 0x71c07bd4, 0x4000, "318004.05 PLUS4 Kernel Pal R5 c000" },
	{ 0x775f60c5, 0x4000, "318004.05 PLUS4 Kernel Pal R5, hungarian character set, HACK? c000" },
	{ 0x84fd4f7a, 0x4000, "? PLUS4 Kernel NTSC R1 c000" },
	{ 0x799a633d, 0x4000, "318005.04 PLUS4 Kernel NTSC R4 c000" },
	{ 0x70295038, 0x4000, "318005.05 PLUS4 Kernel NTSC R5 c000" },
	{ 0x4fd1d8cb, 0x4000, "317053.01 PLUS4 3PLUS1 8000/bank2" },
	{ 0x109de2fc, 0x4000, "317054.01 PLUS4 3PLUS1 c000/bank2" },
	{ 0x5227c2ee, 0x4000, "? PLUS4 voice 8000/bank4" },
	{ 0x6d16d024, 0x4000, "318008.01 C1551/PLUS4 Floppy c000" },
	{ 0xaab61387, 0x4000, "BAD DUMP of 317054.01 (from running machine) PLUS4 3PLUS1 c000/bank2" },
	{ 0x7d464449, 0x8000, "BAD DUMP of 317053.01 + 317054.01 (from running machine) PLUS4 3PLUS1 8000/bank2" },
	{ 0xf284199b, 0x800, "UNUSEABLE PART PLUS4 character set d000" },
	{ 0x5b6a2b88, 0x800, "UNUSEABLE PART PLUS4 hungarian character set d000" },

/* Commodore VIC20 **************************************************************************/
	{ 0xdb4c43c1, 0x2000, "901486.01 VIC20 Basic c000" },
	{ 0xe5e7c174, 0x2000, "901486.06 VIC20 Kernel NTSC e000" },
	{ 0x4be07cb4, 0x2000, "901486.07 VIC20 Kernel PAL e000" },
	{ 0x83e032a6, 0x1000, "901460.03 VIC20 character set 8000" },
	{ 0xd808551d, 0x1000, "nec22101.207 VIC20 swedish character set 8000" },
	{ 0xb2a60662, 0x2000, "nec22081.206 VIC20 swedish Kernel e0000" },
	{ 0xd37b6335, 0x800, "325329-04 VIC20 IEEE Cartridge b000" },

/* Commodore 65 Prototype ******************************************************************/
	{ 0x0888b50f, 0x20000, "C65 911001" },
	{ 0x3ee40b06, 0x20000, "C65 910828" },
	{ 0x12527742, 0x20000, "C65 910626" },
	{ 0xe8235dd4, 0x20000, "C65 910523" },
	{ 0xb025805c, 0x20000, "C65 910429 German" },
	{ 0xc5d8d32e, 0x20000, "C65 910111" },

/* commodore b series *********************************************************************/
	{ 0x9d0366f9, 0x2000, "901243-02b CBMB basic 128kb f8000" },
	{ 0x837978b5, 0x2000, "901242-02b CBMB basic 128kb fa000" },
	{ 0xb0dcb56d, 0x2000, "901243-04a CBMB basic 128kb f8000" },
	{ 0xde04ea4f, 0x2000, "901242-04a CBMB basic 128kb fa000" },
	{ 0x5a680d2a, 0x2000, "?901242-04 CBMB some additions to 901242-04a fa000" },
	{ 0x8eed0d7e, 0x4000, "? CBMB basic 256kb f8000" },
	{ 0x5c1f3347, 0x2000, "901241-03 CBMB basic 256kb f8000" },
	{ 0x72aa44e1, 0x2000, "901240-03 CBMB basic 256kb fa000" },
	{ 0x4276dbba, 0x2000, "901244-03b CBMB kernel monitor instead of tape fe000" },
	{ 0x87bc142b, 0x2000, "901244-03 CBMB Kernel swedish/finish fe000" },
	{ 0x19bf247e, 0x2000, "? CBMB kernel fe000" },
	{ 0x09a5667e, 0x2000, "901244-04a CBMB kernel fe000" },
	{ 0x0ea8ca4d, 0x2000, "? CBMB hungarian kernel fe000" },
	{ 0x1acf5098, 0x1000, "901237-01 CBMB 8x8 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0x1fb5e596, 0x2000, "? CBMB 8x8 in 8x16 2x256 hungarian character" },
	{ 0x3a350bc3, 0x1000, "901232-01 CBMB 9x14 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0x09518b19, 0x1000, "901233-03 CBMB swedish/finnish 9x14 in 8x16 2x128 character set (needs inversion hardware)" },
	{ 0xc62ab16f, 0x2000, "901236-02 CBM500 basic 128kb f8000" },
	{ 0x20b7df33, 0x2000, "901235-02 CBM500 basic 128kb fa000" },
	{ 0xf46bbd2b, 0x2000, "901234-02 CBM500 kernal monitor instead of type fe000" },
	{ 0xec4272ee, 0x1000, "901225-01 CBM500 8x8 character set" },
	{ 0xdf83bbb9, 0x4000, "MERGED! CBMB 901243-02b + 901242-02b" },
	{ 0xa8ff9372, 0x4000, "MERGED! CBMB 901243-04a + 901242-04a" },
	{ 0x5db15870, 0x4000, "MERGED! CBMB 901241-03 + 901240-03" },

/* commodore 64 ********************************************************************/
	{ 0xf833d117 , 0x2000, "901226.01 C64 basic a000" },
	{ 0x2b1b7381 , 0x2000, "SCRAP? C64 kernel e000" }, /* modified for alec 64  */
	{ 0xb8f49365 , 0x2000, "SCRAP C64 kernel speeddos, unique copyright" },
	{ 0xbeed6d49 , 0x2000, "SCRAP? C64 kernel" },
	{ 0xcfb58230 , 0x2000, "SCRAP? C64 kernel" },
	{ 0x6ec94629 , 0x2000, "SCRAP? C64 kernel (basic x 2)" },
	{ 0xdce782fa , 0x2000, "901227.01 C64 kernel r1" },
	{ 0xa5c687b3 , 0x2000, "901227.02 C64 kernel r2" },
	{ 0xdbe3e7c7 , 0x2000, "901227.03 C64 kernel r3" },
	{ 0xf10c2c25 , 0x2000, "901227-03? C64 swedish kernel" },
	{ 0x789c8cc5 , 0x2000, "901246.01 C64 pet64 kernel" },
	{ 0x2c5965d4 , 0x4000, "251104.04 C64 SX64 kernel" },
	{ 0x7858d3d7 , 0x4000, "251104.04? C64 SX64 swedish kernel" },
	{ 0xf80eb87b , 0x2000, "??? C64 kernel few differences to 901227.02" },
	{ 0x8e5c500d , 0x2000, "??? C64 kernel few differences to 901227.03" },
	{ 0xc13310c2 , 0x2000, "??? C64 kernel few differences 901227.03" },
	{ 0x97d9a4df , 0x2000, "??? C64 kernel 64er system v1" },
	{ 0x5096b3bd , 0x2000, "??? C64 kernel 64er system v3" },
	{ 0x4e54d020 , 0x2000, "??? C64 kernel Exos v3" },
	{ 0x26f3339e , 0x2000, "??? C64 kernel Exos v3 2 bytes different to 0x4e54d020" },
	{ 0x2f79984c , 0x2000, "??? C64 kernel Jiffydos v6.01" },
	{ 0xc9bb21bc , 0x2000, "??? C64 kernel Dolphin mager" },
	{ 0xffaeb9bc , 0x2000, "??? C64 kernel Dolphin dos20" },
	{ 0x8438e77b , 0x2000, "??? C64 kernel speeddos plus" },
	{ 0x10aee0ae , 0x2000, "??? C64 kernel speeddos plus +" },
	{ 0xe801dadc , 0x2000, "??? C64 kernel 80 column" },
	{ 0x0010ec31 , 0x4000, "251913-01 C64 cost reduced (901225-01 + 901227-03)" },
	{ 0xb0a9c2da , 0x4000, "390852.01 C64GS a000,c000" },
	{ 0xec4272ee , 0x1000, "901225.01 C64 8x8 character set d000" },
	{ 0xbee9b3fd , 0x1000, "? C64 swedish character set d000" },

/* commodore 128 *************************************************************************/
	{ 0x2ee6e2fa , 0x4000, "318018-02 C128 basic r0 4000" },
	{ 0xd551fce0 , 0x4000, "318019-02 C128 basic r0 8000" },
	{ 0xe857df90 , 0x8000, "318022-01 C128 basic r0 4000 (318018-02 + 318019-02)" },
	{ 0xbc07ed87 , 0x8000, "252343-03 C128 basic r? 4000 (maybe 318018-03 + 318019-03)" },
	{ 0x9f9c355b , 0x4000, "318018-04 C128 basic r1 1986 4000" },
	{ 0x6e2c91a7 , 0x4000, "318019-04 C128 basic r1 1986 8000" },
	{ 0xaf1ae1e8 , 0x8000, "318022-02 C128 basic r1 1986 4000 (318018-04 + 318019-04)" },
	{ 0x1e94bb02 , 0x4000, "318020-03 C128 Kernel r0 c000" },
	{ 0xba456b8e , 0x4000, "318020-05 C128 Kernel r1 1986 c000" },
	{ 0xa51e2168 , 0x4000, "315078-01 C128 Kernel german c000" },
	{ 0xb275bb2e , 0x4000, "315078-02 C128 Kernel german c000" },
	{ 0x2df282b8 , 0x4000, "? C128 Kernel french (0x3e086a24 z80bios 0xca5e1179)" },
	{ 0xd3ecea84 , 0x4000, "? C128 Kernel finish1 (0x71002a97 z80bios 0x167b8364)" },
	{ 0x9526fac4 , 0x4000, "? C128 Kernel finish2 (0xb7ff5efe z80bios 0x5ce42fc8)" },
	{ 0x74d6b084 , 0x4000, "? C128 Kernel italian (0x8df58148 z80bios 0x7b0d2140)" },
	{ 0xa5406848 , 0x4000, "? C128 Kernel norwegian (0x84c55911 z80bios 0x3ba48012)" },
	{ 0xeedc120a , 0x8000, "318023-02 C128 c64+kernel (252913-01+318020-05=" },
	{ 0xcc6bdb69 , 0x8000, "252343-04 C128 c64+kernel (252913-01+0x98f2a2ed maybe 318020-04)" },
	{ 0xeb6e2c8f , 0x8000, "318077-01 C128 c64+kernel german(251913-01+0xbff7550b)" },
	{ 0xcb4e1719 , 0x8000, "318034-01 Ker.Sw/Fi C128 c64+kernel swedish (901226.01+ 0xf10c2c25 +0x1cf7f729)" },
	{ 0x3e086a24 , 0x1000, "UNUSEABLE PART! C128 Kernel french c000" },
	{ 0xca5e1179 , 0x2000, "UNUSEABLE PART! C128 Kernel french e000" },
	{ 0x71002a97 , 0x1000, "UNUSEABLE PART! C128 Kernel finish1 c000" },
	{ 0x167b8364 , 0x2000, "UNUSEABLE PART! C128 Kernel finish1 e000" },
	{ 0xb7ff5efe , 0x1000, "UNUSEABLE PART! C128 Kernel finish2 c000" },
	{ 0x5ce42fc8 , 0x2000, "UNUSEABLE PART! C128 Kernel finish2 e000" },
	{ 0x8df58148 , 0x1000, "UNUSEABLE PART! C128 Kernel italian c000" },
	{ 0x7b0d2140 , 0x2000, "UNUSEABLE PART! C128 Kernel italian e000" },
	{ 0x84c55911 , 0x1000, "UNUSEABLE PART! C128 Kernel norwegian c000" },
	{ 0x3ba48012 , 0x2000, "UNUSEABLE PART! C128 Kernel norwegian e000" },
	{ 0xc38d83c6 , 0x1000, "UNUSEABLE PART! C128 Z80 Bios d000" },
	{ 0x6aaaafe6 , 0x1000, "390059-01 C128 8x8 character set c64, c128" },
	{ 0xfe5a2db1 , 0x1000, "315079-01 C128 8x8 character set c64, c128 german" },
	{ 0x7a70d9b8 , 0x1000, "325181-01 C128 8x8 character set c64, c128 swedish" },
	{ 0xbad36b88 , 0x1000, "325167-01 I/F/B C128 8x8 characters sets" }, /*italian and french verified to be the same */

/* commodore ieee bus devices ******************************************************/
	{ 0x0ab338dc, 0x400, "901466-04 CBM2040 dos 2 6530" },
	{ 0x25b5eed5, 0x1000, "901468-06 CBM2040 dos 1 e000" },
	{ 0x9b09ae83, 0x1000, "901468-07 CBM2040 dos 1 f000" },
	{ 0xb7157458, 0x1000, "901468-11 CBM2040 dos 2 d000" },
	{ 0x02c44ff9, 0x1000, "901468-12 CBM2040 dos 2 e000" },
	{ 0xcbd785b3, 0x1000, "901468-13 CBM2040 dos 2 f000" },
	{ 0xbc4d4872, 0x1000, "901468-14 CBM2040 dos 2r d000" },
	{ 0xb6970533, 0x1000, "901468-15 CBM2040 dos 2r e000" },
	{ 0x1f5eefb7, 0x1000, "901468-16 CBM2040 dos 2r f000" },
	{ 0xd04c1fbb , 0x2000, "MERGED! 901468-06+901468-07" },
	{ 0xf4967a7f , 0x3000, "MERGED! 901468-11+901468-12+901468-13" },
	{ 0x40e0ebaa , 0x3000, "MERGED! 901468-14+901468-15+901468-16" },

	{ 0xee4b893b, 0x2000, "901484-03 CBM2031 C000" },
	{ 0x6a629054, 0x2000, "901484-05 CBM2031 E000" },
	{ 0x21b80fdf , 0x4000, "MERGED! 901484-03+901484-05" },

	{ 0xf0aa31bd,  0x400,  "251257-02A CBM1001 FDC" },
	{ 0x0073b8b2, 0x2000, "901887-01 CBM8050 DOS 2.7 c000" },
	{ 0xde9b6132, 0x2000, "901888-01 CBM8050 DOS 2.7 e000" },
	{ 0xa23337eb, 0x800, "901467-01 CBM8050 ?" },
	{ 0x09a609b9, 0x2000, "901482-03 CBM8050 dos 2.5 c000" },
	{ 0x1bcf9df9, 0x2000, "901482-04 CBM8050 dos 2.5 e000" },
	{ 0x3cbd2756, 0x2000, "901482-06 CBM8050 dos 2.5r c000" },
	{ 0xc7532d90, 0x2000, "901482-07 CBM8050 dos 2.5r e000" },
	{ 0x9e83fa70, 0x400, "901483-03 CBM8050 dos2.5 micropolis" },
	{ 0x2915327a, 0x400, "901869-01 CBM8050 dos2.7 mpi" },
	{ 0xbab998c9, 0x400, "901885-04 CBM8050 dos2.7 micropolis" },
	{ 0x87e6a94e , 0x4000, "MERGED! 901887-01+901888-01" },

	{ 0xcb07b2db, 0x800, "BADDUMP! 300541-001 CBM8280" },
	{ 0x3c6eee1e, 0x2000, "300542-001 CBM8280 c000" },
	{ 0xf58e665e, 0x2000, "300543-001 CBM8280 e000" },

	{ 0x99e096f7, 0x800, "300515-001 CBM9090 4c" },
	{ 0x566df630, 0x2000, "BADDUMP! 300517-001? CBM9090 7d" },
	{ 0x49adf4fb, 0x800, "300515-002 CBM9060 4c" },
	{ 0x2d758a14, 0x2000, "300516-002 CBM9060 7c" },
	{ 0xf0382bc3, 0x2000, "300517-002 CBM9060 7d" },

	{ 0xc6bb0977 , 0x2000, "? CBM4023 printer 4023 /P 360-02 (1526 hardware?)" },
	{ 0xb6d8519c , 0x1000, "901472-06 CBM3022 printer" },
	{ 0xe5c4a58c , 0x2000, "325320-02 CBM8023P printer" },
	{ 0x9d662c74 , 0x2000, "? CBM8028 printer german cpu" },
	{ 0x209e70a1 , 0x800, "? CBM8028 printer german car" },
	{ 0x05d30d5f , 0x800, "? CBM8028 printer german dsy" },

/* commodore serial bus devices ************************************************/
	{ 0x29ae9752 , 0x2000, "325302-01 CBM1540 c000" },
	{ 0x10b39158 , 0x2000, "325303-01 CBM1540 e000" },
	{ 0x9a48d3f0 , 0x2000, "901229-01 CBM1541 e000" },
	{ 0xb29bab75 , 0x2000, "901229-02 CBM1541 e000" },
	{ 0x9126e74a , 0x2000, "901229-03 CBM1541 e000" },
	{ 0x361c9f37 , 0x2000, "901229-05 CBM1541 e000" },
	{ 0x899fa3c5 , 0x4000, "251968-03 CBM1541II c000" },
	{ 0x1b3ca08d , 0x4000, "251968-01 CBM1541C c000" },
	{ 0x2d862d20 , 0x4000, "251968-02 CBM1541C c000" },
	{ 0x5b84bcef , 0x2000, "? CBM1541 c000 (with 0x2d8c1fde gives CBM1541II rom)" },
	{ 0x2d8c1fde , 0x2000, "? CBM1541 e000 (with 0x5b84bcef gives CBM1541II rom" },
	{ 0x57224cde , 0x4000, "MERGED! (0x29ae9752 + 0x361c9f37)" },
	{ 0xd3a5789c , 0x4000, "MERGED! (0x29ae9752 + 0xb29bab75)" },
	{ 0xdd409902 , 0x4000, "? CBM1541 jiffydos upgrade (together with c64 v6.01?)" },
	{ 0x71708062 , 0x4000, "? CBM1541 64er upgrade (together with 64er system v3?)" },
	{ 0xf9db1eac , 0x4000, "? CBM1541 Speeddos upgrade (together with speeddos plus +?)" },
	{ 0xbd8e42b2 , 0x6000, "? Dolphin (CBM1541 compatible) a000" },
	{ 0x5a0c7937 , 0x8000, "315090.01 CBM1570 bios 8000" },
	{ 0x3889b8b8 , 0x8000, "310654.03 CBM1571 bios 8000" },
	{ 0x5755bae3 , 0x8000, "310654-05 CBM1571 8000" },
	{ 0xf24efcc4 , 0x8000, "318047-01 CBM1571 8000" },
	{ 0x113af078 , 0x8000, "318045-01 CBM1581 bios 8000" },
	{ 0xa9011b84 , 0x8000, "318045-02 CBM1581 bios 8000" },
	{ 0xecc223cd , 0x8000, "? CBM1581 beta 8000" },
	{ 0xe08801d7 , 0x8000, "? CBM1581 modified 8000" },

	{ 0x3ef63c59 , 0x2000, "? CBM1526 printer rev05?" },
	{ 0x21051f69 , 0x2000, "? CBM1526 printer rev07b scandinavian?" },
	{ 0x38f85b4a , 0x2000, "? CBM1526 printer rev07c?" },
	{ 0xf8a9f45c , 0x10000, "? CBM1230 printer pdl2 german" },

	{ 0xecc43f0f , 0x1000, "Wiesemann Interface (CBM Serial bus to Centronics Printer)" },



	{ 0xf6290043 , 0x80000, "AMIGA kickstart 1.3" },

/* ibm pc and compatibles ******************************************************/
	{ 0x80d3cf5d , 0x2000, "IBM PC basic c1.10 f6000" },
	{ 0x673a4acc , 0x2000, "IBM PC basic c1.10 f8000" },
	{ 0xaac3fc37 , 0x2000, "IBM PC basic c1.10 fa000" },
	{ 0x3062b3fc , 0x2000, "IBM PC basic c1.10 fc000" },
	{ 0xebacb791 , 0x8000, "MERGED! (0x80d3cf5d + 0x673a4acc + 0xaac3fc37 + 0x5c3f0256)" },
	{ 0x5c3f0256 , 0x2000, "IBM PC bios fe000 5000-026 08/16/82" },
	{ 0xe88792b3 , 0x2000, "IBM PC bios fe000 1501-476 10/27/82" },
	{ 0x031aafad , 0x2000, "PC bios fe000" },
	{ 0xd435a405 , 0x2000, "Bondwell PC fe000" },
	{ 0x1775a11d , 0x8000, "50145 Europc bios f8000" },
	{ 0x1305dcf5 , 0x2000, "50146 Europc character sets" },
	{ 0x0c19c1a8 , 0x8000, "INCOMPLETE IBM PC Junior basic c1.2 f6000 (f0000-f5fff missing)" },
	{ 0x98463f95 , 0x2000, "INCOMPLETE IBM PC Junior bios fe000 (f0000-f5fff missing)" },
	{ 0xd37a1d5f , 0x10000, "Tandy 1000 HX bios f0000" },
	{ 0x83727c42 , 0x8000, "IBM XT bios even f0000" },
	{ 0x2a629953 , 0x8000, "IBM XT bios odd f0000" },
	{ 0x71b84616 , 0x2000, "Amstrad PC20 bios even fc000 (v2)" },
	{ 0x41302eb8 , 0x2000, "Amstrad PC20 bios odd fc000 (v2)" },
	{ 0x668fcc94 , 0x2000, "40044 Amstrad PC1512 bios even fc000 (v1)" },
	{ 0xf72f1582 , 0x2000, "40043 Amstrad PC1512 bios odd fc000 (v1)" },
	{ 0xd2d1f1ae,  0x8000, "40100 Amstrad PC1640 ega bios c0000" },
	{ 0xe40a1513 , 0x2000, "40043 Amstrad PC1640 bios odd fc000 (v3)" },
	{ 0xf1c074f3 , 0x2000, "40044 Amstrad PC1640 bios even fc000 (v3)" },
	{ 0x4995be7a , 0x8000, "IBM AT bios even f0000" },
	{ 0xc32713e4 , 0x8000, "IBM AT bios odd f0000" },
	{ 0x679296a7 , 0x8000, "AT ami bios even f0000" },
	{ 0x65ae1f97 , 0x8000, "AT ami bios odd f0000" },
	{ 0x4c36e61d , 0x8000, "NEAT ami bios even f0000" },
	{ 0x4e90f294 , 0x8000, "NEAT ami bios odd f0000" },
	{ 0x3df9732a , 0x10000, "AT386 bios f0000" },
	{ 0x31214616 , 0x10000, "AT486 bios f0000" },
	{ 0x8e9e2bd4 , 0x2000, "PC harddisk controller bios c8000" },
	{ 0xa96317da , 0x2000, "PC harddisk controller bios c8000" },
	{ 0x318c5f43 , 0x8000, "PC oak vga bios c0000" },
	{ 0xa903540d , 0x8000, "PC et4000 vga bios oem c0000" },
	{ 0xf01e4be0 , 0x8000, "PC et4000 vga vios c0000" },
	{ 0xaca81498 , 0x2000, "PC aga character sets" },
	{ 0x7e8c9d76 , 0x1000, "AUTHENTIC? PC hercules character set" },
	{ 0xac1686f3 , 0x1000, "NOT AUTHENTIC PC hercules character set" },
	{ 0xa362ffe6 , 0x800, "AUTHENTIC? PC cga character set" },
	{ 0x42009069 , 0x1000, "AUTHENTIC? PC cga character set" },

/* sinclair **********************************************************************/
	{ 0x4c7fc597 , 0x1000, "ZX80" },
	{ 0x6c123536 , 0x1000, "ASZMIC" },

	{ 0x4b1dd6eb , 0x2000, "ZX81" },
	{ 0xa350f2b1 , 0x2000, "PC8300" },
	{ 0x6bd0408c , 0x100, "PC8300 font" },
	{ 0x8a49b2c3 , 0x2000, "POW3000" },
	{ 0x1c42fe46 , 0x100, "POW3000 font" },

	{ 0xddee531f , 0x4000, "ZX48" },
	{ 0x7e0f47cb , 0x4000, "ZX48 PLUS4 upgrade" },
	{ 0x1511cddb , 0x4000, "ZX48 busysoft upgrade" },
	{ 0xabf18c45 , 0x4000, "ZX48 De Groot's upgrade" },
	{ 0xd1be99ee , 0x4000, "ZX48 imc upgrade" },
	{ 0x5b5c92b1 , 0x4000, "ZX48 lec upgrade" },
	{ 0x8ff7a4d1 , 0x4000, "INVES" },
	{ 0x3e785f6f , 0x4000, "TK90X" },
	{ 0x17368e07 , 0x4000, "TK95" },
	{ 0xf1b5fa67 , 0x4000, "TC2048" },
	{ 0xbf44ec3f , 0x4000, "TS2068" },
	{ 0xae16233a , 0x2000, "TS2068" },

	{ 0xe76799d2 , 0x4000, "ZX128 0000" },
	{ 0xb96a36be , 0x4000, "ZX128 4000" },
	{ 0x453d86b2 , 0x4000, "ZX128 spain 0000" },
	{ 0x6010e796 , 0x4000, "ZX128 spain 4000" },
	{ 0x5d2e8c66 , 0x4000, "ZX128 plus2 0000" },
	{ 0x98b1320b , 0x4000, "ZX128 plus2 4000" },
	{ 0xc684c535 , 0x4000, "ZX128 plus2 france 0000" },
	{ 0xf5e509c5 , 0x4000, "ZX128 plus2 france 4000" },
	{ 0xe807d06e , 0x4000, "ZX128 plus2 spain 0000" },
	{ 0x41981d4b , 0x4000, "ZX128 plus2 spain 4000" },
	{ 0x30c9f490 , 0x4000, "ZX128 plus2a 0" },
	{ 0xa7916b3f , 0x4000, "ZX128 plus2a 1" },
	{ 0xc9a0b748 , 0x4000, "ZX128 plus2a 2" },
	{ 0xb88fd6e3 , 0x4000, "ZX128 plus2a 3" },
	{ 0x17373da2 , 0x4000, "ZX128 plus3 0" },
	{ 0xf1d1d99e , 0x4000, "ZX128 plus3 1" },
	{ 0x3dbf351d , 0x4000, "ZX128 plus3 2" },
	{ 0x04448eaa , 0x4000, "ZX128 plus3 3" },
	{ 0x1f86147a , 0x4000, "ZX128 plus3 spain 0" },
	{ 0xa8ac4966 , 0x4000, "ZX128 plus3 spain 1" },
	{ 0xf6bb0296 , 0x4000, "ZX128 plus3 spain 2" },
	{ 0xf6d25389 , 0x4000, "ZX128 plus3 spain 3" },
	{ 0x7c20e2c9 , 0x8000, "ZX128 plus3e" },
	{ 0x4a700c7e , 0x8000, "ZX128 plus3e" },

	{ 0x5cc6b3ac, 0xc000, "QL mcg" },
	{ 0x54e93572, 0xc000, "QL mf" },
	{ 0xe2b94296, 0xc000, "QL jm" },
	{ 0x0f95aab5, 0xc000, "QL js" },
	{ 0x953f8f51, 0xc000, "QL js-4," },

/* tandy *************************************************************************/
	{ 0x73316e3e , 0x2000, "NOT AUTHENTIC COCO basic 1.0" },
	{ 0x6270955a , 0x2000, "COCO basic 1.1" },
	{ 0x54368805 , 0x2000, "COCO basic 1.2" },
	{ 0xd8f4d15e , 0x2000, "COCO basic 1.3" },
	{ 0xa04a8732 , 0x2000, "COCO basic 1.3 (1byte different to 0xd8f4d15e" },
	{ 0x6111a086 , 0x2000, "NOT AUTHENTIC COCO extbasic 1.0" },
	{ 0xa82a6254 , 0x2000, "COCO extbasic 1.1" },
	{ 0x2ea0fb7f , 0x4000, "MERGED! 0xa82a6254+0x54368805" },
	{ 0xb4f9968e , 0x2000, "COCO disk 1.0" },
	{ 0x0b9c5415 , 0x2000, "COCO disk 1.1" },
	{ 0x7eaa44e3 , 0x2000, "COCO disk (2bytes different to 0x0b9c5415" },
	{ 0x5fb295a7 , 0x6000, "MERGED! 0xa82a6254+0x54368805+0x7eaa44e3" },
	{ 0xb4c88d6c , 0x8000, "COCO3" },
	{ 0x31aec822 , 0x7e00, "INCOMPLETE COCO3 saved from running machine 0xb4c88d6c without end" },
	{ 0xdfce21e5 , 0x7f00, "INCOMPLETE COCO3 saved from running machine" },
	{ 0x7d48ba8e , 0x2000, "??? COCO3 disk?" },
	{ 0xe3879310 , 0x4000, "DRAGON32" },
	{ 0xb44536f6 , 0x2000, "DRAGON DOS 1.0" },
	{ 0x878396a5 , 0x4000, "CP400 basic" },
	{ 0xe9ad60a0 , 0x2000, "CP400 disk" },
	{ 0x11fda97e , 0x2000, "MC10" },

	{ 0x70d06dff , 0x1000, "TRS80 Level1 0000" },
	{ 0x83dbbbe2 , 0x1000, "TRS80 0000" },
	{ 0x05818718 , 0x1000, "TRS80 1000" },
	{ 0x306e5d66 , 0x1000, "TRS80 2000" },
	{ 0xd6fd9041 , 0x3000, "MERGED! 0x83dbbbe2+0x05818718+0x306e5d66" },
	{ 0xbe46faf5 , 0x1000, "TRS80 alternate 0000" },
	{ 0x6c791c2d , 0x1000, "TRS80 alternate 1000" },
	{ 0x55b3ad13 , 0x1000, "TRS80 alternate 2000" },
	{ 0xa8e60d9a , 0x3000, "MERGED! 0xbe46faf5+0x6c791c2d+0x55b3ad13" },
	{ 0x8f5214de , 0x1000, "SYS80 0000" },
	{ 0x46e88fbf , 0x1000, "SYS80 1000" },
	{ 0x2bfef8f7 , 0x3000, "MERGED! 0x8f5214de+0x46e88fbf+0x306e5d66" },
	{ 0x37c59db2 , 0x1000, "TRS80 level 2 (7 differences to 0x83dbbbe2)" },
	{ 0x0d8a132e , 0x3000, "MERGED TRS80 level 2 (0x37c59db2+0x05818718+306e5d66)" },
	{ 0xbddbf843 , 0x3800, "MERGED! trs80 model 3" },
	{ 0x1a92d54d , 0x3800, "TRS80 model 4 (first 0x3000 byte same as 0xbddbf843" },
	{ 0x7ff336f4 , 504, "SCRAP? TRS80 disk?" },
	{ 0x0033f2b9 , 0x400, "TRS80 char 128 6x8 char Arrows (should be the same as 0xac21c5a2)" },
	{ 0x2d9b8d3d , 0xc00, "MODIFIED? 256 TRS81 6x12 char [/]" },
	{ 0xac21c5a2 , 0xc00, "MODIFIED? 256 TRS81 6x12 char Arrows" },
	{ 0xacfc3200 , 0xc00, "MODIFIED? 256 TRS81 6x12 char real lower case letters, 0-31 are also big letters" },
	{ 0xc7039103 , 0x1500, "TRS80 448 8x12 char" },
	{ 0xddd8f7b2 , 0x1500, "TRS80 448 8x12 char international" },
	{ 0x9820d71a , 0x1500, "TRS80 448 8x12 char linegraphics" },

/* msx ***************************************************************************/
	{ 0xd9ec9db7 , 0x4000, "MSX basic" },
	{ 0x2f74e2c5 , 0x4000, "MSX basic 0xd9ec9db7 with some modifications" },
	{ 0x86f11f42 , 0x4007, "MODIFIED MSX 0x2f74e2c5 with 7 byte header" },
	{ 0xdaec9af0 , 0x4000, "MSX bios" },
	{ 0x94ee12f3 , 0x8000, "MERGED MSX 0xd9ec9db7+0xdaec9af0" },
	{ 0xb3cbf2cd , 0x8000, "MSX casema? differences to 0x94ee12f3 in the first 16k" },
	{ 0xee229390 , 0x8000, "MSXJ" },
	{ 0xe9ccd789 , 0x8000, "MSXUK" },
	{ 0x3ab0cd3b , 0x8000, "MSXKR" },
	{ 0xa781f7ca , 0x8000, "MSXKR 0x3ab0cd3b hacked to boot like jap/eu msx for increased compatiblity" },

	{ 0x97478efb , 0x4000, "BAD DUMP? MSXKR han" },

	{ 0x2949cb19 , 0x4000, "MSX ru disk" },
	{ 0xaf445c3d , 0x4000, "MSX shrpdisk" },
	{ 0x6704ef81 , 0x4000, "MSX gradisk" },
	{ 0xeb8e1d5b , 0x4000, "MSX fmsxdisk" },
	{ 0x71162b96 , 0x4000, "MSX disk" },

	{ 0x07610d77, 0x8000, "EXPERT 1.0" },
	{ 0xefb4b972, 0x8000, "EXPERT 1.1" },
	{ 0xb6942694, 0x8000, "HOTBIT 1.1" },
	{ 0xf59a4a0c, 0x8000, "HOTBIT 1.2" },

	{ 0x77b94ae0,0x8000, "MSXTR" },
	{ 0x937c8dbb,0x8000, "MSXTR" },
	{ 0x70aea0fe,0x4000, "MSXTR ext" },
	{ 0xf5f93437,0x4000, "MSXTR mus" },
	{ 0xa068cba9,0x8000, "MSXTR kanji" },
	{ 0x7016dfd0,0x40000, "MSXTR kanji 256k" },

	{ 0x6cdaf3a5,0x8000, "MSX2" },
	{ 0x66237ecf,0x4000, "MSX2 ext" },
	{ 0x9b3e7b97,0x8000, "MSX2 japan" },
	{ 0x43e7a7fc,0x4000, "MSX2 japan X" },
	{ 0x0531dea4,0x8000, "MSX2 casema" },
	{ 0x53850907,0x8000, "MSX2 k" },

	{ 0x00870134,0x8000, "MSX2+" },
	{ 0xb8ba44d3,0x4000, "MSX2+ ext" },
	{ 0xc9651b32,0x20000, "MSX2+ kanji 128k" },

	{ 0x98d48655,0x8000, "SVI 1.0" },
	{ 0x709904e9,0x8000, "SVI 1.1" },
	{ 0xbc433df6,0x8000, "SVI 1.11" },

/* sharp ***************************************************************************/
	{ 0x4c6c6b7b , 0x1000, "MZ700" },
	{ 0x42b9e8fb , 0x1000, "MZ700 font" },
	{ 0x425eedf5 , 0x1000, "MZ700 font japan" },
	{ 0x0c281675 , 0x2000, "MZ800" },

	{ 0xdca8f879 , 0x4000, "PC1500A rom" },

	{ 0x44bee438 , 0x2000, "SC61860A08 5H 13LD PC1401 cpu rom" },
	{ 0x69b9d587 , 0x8000, "5S1 SC613256 D30 PC1401" },
	{ 0xf7287aca , 0x2000, "PC1251 cpu rom" },
	{ 0x93ecb629 , 0x4000, "PC1251 basic rom" },
	{ 0x79a924bc , 0x2000, "PC1350 cpu rom" },
	{ 0x158b28e2 , 0x8000, "PC1350 basic rom" },

	{ 0x9f3195f1 ,0xc0000, "X68000 charset" },
	{ 0x72bdf532 ,0x20000, "X68000 1.00 1987/05/07" },

/* texas instruments ****************************************************************/
	{ 0xdb8f33e5 , 0x2000, "TI99_4A arom" },
	{ 0x8f7df93f , 0x2000, "TI99_4A disk" },
	{ 0xaf5c2449 , 0x6000, "TI99_4A agrom" },
	{ 0x58b155f7 , 0x8000, "TI99_4A speech" },
	{ 0x0a0b0c42 , 0x100, "94519209 TI990_4" },
	{ 0xd078af61 , 0x100, "94519210 TI990_4" },
	{ 0x6cf7d4a0 , 0x100, "94519211 TI990_4" },
	{ 0xd9522458 , 0x100, "94519212 TI990_4" },
	{ 0x8719b04e , 0x100, "94519113 TI990_4" },
	{ 0x72a040e0 , 0x100, "94519114 TI990_4" },
	{ 0x9ccf8cca , 0x100, "94519115 TI990_4" },
	{ 0xfa387bf3 , 0x100, "94519116 TI990_4" },

	{ 0x160ee4a6 , 0x150000, "AVIGO english 1.004" },

	{ 0xe2f5721c , 0x20000, "TI82 16" },
	{ 0x0fc956d4 , 0x20000, "TI82 17" },
	{ 0x6a320f03 , 0x20000, "TI82 18" },
	{ 0xed4cf9ff , 0x20000, "TI82 19" },
	{ 0x7ee5d27b , 0x40000, "TI83 102" },
	{ 0x926f72a4 , 0x40000, "TI83 103" },
	{ 0xdccb73d3 , 0x40000, "TI83 104" },
	{ 0x2eae1cf0 , 0x40000, "TI83 106" },
	{ 0x4bf05697 , 0x40000, "TI83 1.07" },
	{ 0x0c6aafcc , 0x40000, "TI83 108" },
	{ 0x7faee2d2 , 0x40000, "TI83 110" },
	{ 0xda466be0 , 0x80000, "TI83+ 103" },
	{ 0xad770061 , 0x80000, "TI83+ 112" },
	{ 0x6a0a94d0 , 0x20000, "TI85 ?" },
	{ 0x053325b0 , 0x20000, "TI85 100" },
	{ 0xde4c0b1a , 0x20000, "TI85 30a" },
	{ 0x889dadc7 , 0x20000, "TI85 40" },
	{ 0xd723e107 , 0x20000, "TI85 50" },
	{ 0xcd13d4f1 , 0x20000, "TI85 60" },
	{ 0x32ad5c28 , 0x20000, "TI85 80" },
	{ 0xceed0ef5 , 0x20000, "TI85 90" },
	{ 0xbdf16105 , 0x40000, "TI86 1.2" },
	{ 0x073ef70f , 0x40000, "TI86 1.3" },
	{ 0xfe6e2986 , 0x40000, "TI86 1.4" },
	{ 0xe6e10546 , 0x40000, "TI86 1.5" },
	{ 0x37e02acc , 0x40000, "TI86 1.6" },
	{ 0x264b34ad , 0x200000, "TI89 1.00" },
	{ 0x3bc0b474 , 0x200000, "TI89 1.05" },
	{ 0x316c8196 , 0x100000, "TI92 1.3" },
	{ 0x239e9405 , 0x100000, "TI92 1.4" },
	{ 0x83e27cc5 , 0x100000, "TI92 1.7" },
	{ 0x4a343833 , 0x100000, "TI92 1.11" },
	{ 0x9a6947a0 , 0x100000, "TI92 1.12" },
	{ 0x5afb5863 , 0x200000, "TI92 2.1" },
	{ 0xc651a586 , 0x200000, "TI92+ 1.00" },
	{ 0x826b1539 , 0x200000, "TI92+ 1.01" },
	{ 0xcd945824 , 0x200000, "TI92+ 1.05" },

	{ 0xd359ead7 , 0x4000, "CGENIE bios" },
	{ 0x2a96cf74 , 0x2000, "CGENIE dos" },
	{ 0x4fed774a , 0x800, "CGENIE font" },

	{ 0xa2d15bcf , 0x2000, "AQUARIUS" },
	{ 0xf4c12112 , 0x800, "AQUARIUS character" },

	{ 0x9ca858cc , 0x2000, "MTX ???" },
	{ 0x87b4e59c , 0x2000, "MTX ???" },
	{ 0x9d7538c3 , 0x2000, "MTX ???" },

	{ 0x9954cf1a , 0x4000, "COUPE ???" },
	{ 0xf031aed4 , 0x4000, "COUPE ???" },

	{ 0xe371b58a , 0x400, "NASCOM 1 nasbugt2" },
	{ 0xb6300716 , 0x800, "NASCOM 2 nassys1" },
	{ 0x5cb5197b , 0x2000, "NASCOM 2 basic" },
	{ 0x33e92a04 , 0x800, "NOT BAD DUMP! NASCOM 1 nascom1.chr" },
	{ 0x2bc09d32 , 0x800, "NASCOM 2 nasgra.chr" },

	{ 0xdc7cf06a , 0x1000, "MERGED NASCOM nascom1.chr 0x33e92a04+?" },
	{ 0xacaa3a31 , 0x1000, "MERGED NASCOM nasgra.chr 0x33e92a04+0x2bc09d32" },
	{ 0x3da17373 , 0x800, "NASCOM nassys3" },
	{ 0xf391df68 , 0x800, "NASCOM nasbugt4" },
	{ 0x6c144399 , 0x800, "NASCOM sysex" },
	{ 0xac4d33b0 , 0x0500, "BAD DUMP NASCOM nascom1.chr" },

	{ 0x99412d43 , 0x2000, "LASER110" },
	{ 0xe4c24e8b , 0x2000, "LASER110" },
	{ 0xead006a1 , 0xc00, "LASER110 characters" },
	{ 0xcc854fe9 , 0x2000, "LASER210" },
	{ 0x7060f91a , 0x2000, "LASER210" },
	{ 0x613de12c , 0x4000, "LASER310" },
	{ 0x9bed01f7 , 0x8000, "LASER350" },
	{ 0xed6bfb2a , 0x800, "LASER350 chars" },

	{ 0xdfe34b08 , 0x2000, "KC85_4 basic" },
	{ 0x57d9ab02 , 0x1000, "KC85_4 os c000" },
	{ 0xd64cd50b , 0x2000, "KC85_4 os e000" },
	{ 0x37cc2080 , 0x2000, "KC85_4 disk" },
	{ 0xee273933 , 0x2000, "KC85_4 tape" },
	{ 0xfe2932e3 , 0x2000, "KC85_3? basic (1 byte different to 0xdfe34b08)" },
	{ 0xbd30cd2d , 0x2000, "KC85_3? bios" },
	{ 0x4a6c9a47 , 0x2000, "KC85_3 disk" },
	{ 0x639e4864 , 0x2000, "KC85_3 tape" },

	{ 0x7896a696 , 0x2000, "MBEE basic 8000" },
	{ 0xb21d9679 , 0x2000, "MBEE basic a000" },
	{ 0x0fc21cb5 , 0x2000, "MBEE" },
	{ 0x47a56a9a , 0x1000, "BAD DUMP? MBEE char" },
	{ 0x28211224 , 0x1000, "MBEE 56k" },
	{ 0x1f9fcee4 , 0x1000, "MBEE 128k char" },
	{ 0x995c53db , 0x2000, "MBEE 128k" },

	{ 0x5f72da5b , 0x1000, "KAYPRO char" },
	{ 0xd10cd036 , 5632, "REPROGRAMMED? KAYPRO" },

	{ 0xd421795f , 0x8000, "ENTERPRISE128 os" },
	{ 0x683cf455 , 0x4000, "ENTERPRISE128 basic" },
	{ 0xd1d7e157 , 0x8000, "ENTERPRISE128 dos" },
	{ 0x982a3b44 , 0x8000, "ENTERPRIES128 os 21" },

	{ 0xdc8438a5 , 0x1000, "JUPITER " },
	{ 0x4009f636 , 0x1000, "JUPITER" },
	{ 0xe5b1f5f6 , 0x2000, "MERGED! JUPITER 0xdc8438a5+0x4009f636" },

	{ 0x650784a3 , 0x1000, "P2000 bios" },
	{ 0x9d9d38f9 , 0x4000, "P2000 basic" },
	{ 0x873e81c1 , 2240, "BAD DUMP P2000 character" },

	{ 0x3e09d384 , 0x1000, "MICROTAN" },
	{ 0x75105113 , 0x1000, "MICROTAN" },
	{ 0xee6e8412 , 0x800, "MICROTAN" },
	{ 0xbd87fd34 , 0x800, "MICROTAN" },
	{ 0x9fd233ee , 0x800, "MICROTAN" },
	{ 0x7e215313 , 0x400, "MICROTAN" },
	{ 0xc8221d9e , 0x400, "MICROTAN" },
	{ 0x3b3c5360 , 0x800, "MICROTAN character" },

	{ 0xf18710b4 , 0x4000, "ORIC1 basic 10" },
	{ 0xc3a92bef , 0x4000, "ORICA basic 11b" },
	{ 0xa9664a9c , 0x2000, "ORIC microdisk" },
	{ 0x58079502 , 0x4000, "PRAVETZ8D" },
	{ 0xb48973ef , 0x4000, "PRAVETZ8Dd" },
	{ 0xf8d23821 , 0x4000, "PRAVETZ8Dda" },

	{ 0x32f0d1ef , 0x4000, "MODIFIED? Einstein" },

	{ 0x5c3b5bb5, 0x800, "BAD DUMP? Galaxy char" },
	{ 0x365f3e24, 0x1000, "Galaxy" },
	{ 0x5dc5a100, 0x1000, "Galaxy" },

	{ 0xe6ea96dc ,0x1000, "ZRT80" },
	{ 0x4dbdc60f ,0x800, "ZRT80 char" },

	{ 0xa0b059f9 , 0x119000, "BAD Dump PalmOs" },

	{ 0xd4f1390b , 0x40000, "HP48S E" },
	{ 0x5619ccaf , 0x40000, "BAD DUMP HP48S E" },
	{ 0xd6bb68c5 , 0x80000, "BAD DUMP HP48G R" },

	{ 0xa2a56502 , 0x400, "6530-003 KIM1 1800" },
	{ 0x2b08e923 , 0x400, "6530-002 KIM1 1c00" },

	{ 0x075b0bbd , 0x2000, "SYM1 basic ???" },
	{ 0x7a4b1e12 , 0x1000, "SYM1 ???" },

	{ 0x0878b399 , 0x1000, "AIM65" },
	{ 0xd7b42d2a , 0x1000, "AIM65" },
	{ 0x36a61f39 , 0x1000, "AIM65" },
	{ 0xd01914b0 , 0x1000, "AIM65" },
	{ 0x90e44afe , 0x1000, "AIM65" },

	{ 0xa2a56502 , 0x400, "MEKD" },

	{ 0x9d3caa92 , 0x800, "UK101" },
	{ 0x0d011242 , 0x800, "UK101" },
	{ 0x667223e8 , 0x800, "UK101" },
	{ 0x04ac5822 , 0x800, "UK101" },
	{ 0xfce2c84a , 0x800, "UK101" },
	{ 0xf4f5dec0 , 0x800, "SUPERBRD" },
	{ 0x0039ef6a , 0x800, "SUPERBRD/UK101" },
	{ 0xca25f8c1 , 0x800, "SUPERBRD" },
	{ 0x8ee6030e , 0x800, "SUPERBRD" },
	{ 0xe5b7028d , 0x800, "SUPERBRD" },
	{ 0xec94afe7 , 0x800, "SUPERBRD" },

	{ 0x278f7bf3 , 0x800, "7916E C48091 82c210-1 Chess Champion MK1 (2716 compatible)" },
	{ 0x4f28c443 , 0x400, "MOS6530 024 1879 Chess Champion MK2" },
	{ 0x6f10991b , 0x1000, "MOS6332 005 2179 Chess Champion MK2 (not full 2732 compatible)" },
	{ 0x9ea46ed3 , 0x1000, "Signetics c19081e Chess Champion MK3 (not full 2732 compatible)" },
	{ 0x52741e0b , 0x1000, "Signetics c19082 Chess Champion MK3 (not full 2732 compatible)" },

	{ 0x2bf4b1a8 , 0x80000, "Epoxy DIL32 Comquest Plus German (dumped as 278001, gave 2 identical halfes" },

	/* centronics based devices */
	{ 0x62ba054e, 0x10000, "Printer Star LC10 nx1p 2.1" },
	{ 0x191384a6, 0x10000, "Printer Star LC10 Color nx1p 1.6 c l" },

#if 0
	{ 0x , 0x000, "" },
#endif

};
