/* xcanvas.h -- X interface to the Xlife canvas */

#define SCALEDOWN(n)	((scale >= 0) ? ((n) >> scale) : ((n) << -scale))
#define SCALEUP(n)	((scale >= 0) ? ((n) << scale) : ((n) >> -scale))

/* mouse coordinates to life-universe coordinates */
#define MOUSE2LIFE(x,xpos) (SCALEDOWN(x) + xpos) 

/* life-universe coordinates to mouse coordinates */
#define LIFE2MOUSE(x,xpos) SCALEUP((x) - xpos)

/* selection box types (used to pick color) */
#define ERASE_BOX	0		/* same as background color */
#define SELECT_BOX	(MAXSTATES+0)
#define LOAD_BOX	(MAXSTATES+1)
#define TRANSITION_BOX	(MAXSTATES+2)
#define MESH_SMALL	(MAXSTATES+3)
#define MESH_BIG	(MAXSTATES+4)
#define MAXCOLORS	(MAXSTATES+5)

GLOBAL coord_t view_x, view_y;	/* coords of upper left corner of viewport */
GLOBAL int scale, grid_interval;
GLOBAL GC cellgc[MAXCOLORS];
GLOBAL bool dispmesh, wireframe;
GLOBAL Display *disp;
GLOBAL Window lifew;

/* xcanvas.h ends here */
