#!/usr/bin/perl
#
# lsmgen.sh -- generate current LSM for fetchmail
#
$version = $ARGV[0];
$size = substr($ARGV[1], 0, 3);

@months
  = ('JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC');

my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$month = $months[$mon];

print <<EOF;
Begin3
Title:		xlife
Version:	$version
Entered-date:	${mday}${month}${year}
Description:	Super laboratory for experimenting with cellular automata.
		Now features support for loadable rulesets and up to 8-state
		cellular automata.  Rules and patterns for Life, Wireworld,
		E.F. Codd's 1975 UCC automaton, and some Prisoner's Dilemma
		games are included.
Keywords:	life, solitaire, game, cellular automata, artificial life
Author: 	jcrb\@cs.cmu.edu (Jon Bennet)
		callahan\@inf.ethz.ch (Paul Callahan)
		achim\@mathematik.uni-bielefeld.de (Achim Flammenkampf)
		esr\@snark.thyrsus.com (Eric S. Raymond)
		cs4n\@andrew.cmu.edu (Chuck Silvers)
Maintained-by:	esr\@snark.thyrsus.com (Eric S. Raymond)
Primary-site:	locke.ccil.org /pub/esr
		${size}K xlife-$version.tar.gz
Platforms:	Unix with X
Copying-policy:	BSD-like
End
EOF


