/*
 * XLife Copyright 1989 Jon Bennett jb7m+@andrew.cmu.edu, jcrb@cs.cmu.edu
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <pwd.h>
#include <time.h>
#include "defs.h"

void fatal(const char *s)
{
    fprintf(stderr, s);
    exit(1);
}

void stamp(char *leader, FILE *ofp)
/* generate \n-terminated time and user info string */
{
    struct passwd *pw;
    char machine[80];
    time_t timeval;

    timeval = time(0);
    gethostname(machine, sizeof(machine));
    if ((pw = getpwuid(getuid())) != NULL)
    {
	fprintf(ofp,"#O %s@%s (%s) ",pw->pw_name,machine,pw->pw_gecos);
	strftime(machine,sizeof(machine)-1,
		 "%Y-%m-%d %H:%M:%S %Z\n",gmtime(&timeval));
	fprintf(ofp,"%s",machine);
    }
}

void heapsort(coord_t *data, int n, int size)
{
    /**  !! There must be size(coord_t) free for usage in front of data !!  **/
   register unsigned long  h, i, j, k;
   data -= size;
#define  copy(x,y)    for (h=0;h<size;h++)  data[(x)+h]=data[(y)+h];
#define  if_is_first_greater(x,y)  for (h=0;h<size;h++)   \
                                      if (data[(x)+h] != data[(y)+h])  break; \
                                   if (h!=size && data[(x)+h] > data[(y)+h])
   for (i=2*size;i<=n*size;i+=size)
   {
       while ((j=(i/size/2)*size) >= 1*size)
      {
	  if_is_first_greater(i,j)
	  {
	      copy(0,i); copy(i,j); copy(j,0); 
	  }
          else  break;
          i = j;
      }
   }
   for (k=n*size;k>size;k-=size)
   {
       copy(0,1*size);
       for (i=2*size,j=size;i<k;i+=i)
       {
	   if_is_first_greater(i+1*size,i)  i+=size;
	   copy(j,i);
	   j = i;
       }
       if (i==k)
       {
	   copy(j,i);
	   j = i;
       }
       copy(j,k);
       copy(k,0);
       if (j < k)
       {
	   while ((i=(j/size/2)*size) >= 1*size)
	   {
	       if_is_first_greater(j,i)
	       {
		   copy(0,i); copy(i,j); copy(j,0);
	       }
               else
		   break;
               j = i;
	   }
       }
   }
#undef  copy
#undef  if_is_first_greater
   data += size;
}

/* unsigned long  must be 32 bits */
#define  B31  0x80000000
static u32bits  p_2 = 656623456, p_1 = 747247571;

void randomseed(u32bits x2, u32bits x1)
{
    if (!((x2&~B31) | x1)) 
	x1 = 1;
    p_1 = x1; p_2 = x2;
}

u32bits random32()
{
    /* Randomgenerator nach R. C. Tausworthe           */
    /* f(x) = 1 + x^52 + x^63 irreduzibel ueber GF(2)  */
    /* Certificat: Angewandte Informatik 9/83 p404-409 */
    u32bits register p1=p_1, p2=p_2, b31=B31;
    /* shift um 63 bit  */
    p2 ^= (p2<<11) ^ (p1>>21);
    p1 ^= p1<<11;
    p2 <<= 1;
    p1 ^= p2 >> 21;
    /* shift um ein bit */
    p2 |= !!(p1&b31);
    p_2 = p2;
    p1 <<= 1;
    p2 ^= p2<<11;
    p1 |= !!(p2&b31);
    p_1 = p1;
    return p1;   /*** p2 contains 31 bits, 31. bit undefined ***/
}

/* utils.c ends here */
