/* guidata.h -- I/O functions and GUI state information */

/* main.c */
GLOBAL int breakreq(void);
GLOBAL int patch_transition(coord_t x, coord_t y, cell_t s, 
			    cell_t n1, cell_t n2, cell_t n3, cell_t n4);
GLOBAL void announce(const char *s);
GLOBAL void error(const char *s);

/* xcanvas.c */
GLOBAL void paintcell(coord_t x, coord_t y, cell_t c);
GLOBAL void pan(int xoff, int yoff);
GLOBAL void drawbox(coord_t x1, coord_t y1, coord_t x2, coord_t y2, int color);
GLOBAL void erasebox(void);
GLOBAL void boxpattern(pattern *context, const int color);
GLOBAL void post(cell_t ns, coord_t x, coord_t y, int mode);
GLOBAL void redraw(const pattern *actp, const pattern *tentp, bool force);
GLOBAL void setscale(const int sc);

#define POST_ACTIVE	0
#define POST_TENTATIVE	1

/* guidata.h ends here */
