/*
 * XLife Copyright 1989 Jon Bennett jb7m+@andrew.cmu.edu, jcrb@cs.cmu.edu
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifdef __GNUCC__
; /* bogus semi-colon to appease the GNU god */
#endif /* __GNUCC__ */

#define SAVE_VERSION	"##Life5"

#define PATCH_LOG	"new.transitions"

#define LOADEXT		".l"
#define LOADEXTLEN	2

typedef int	bool;
#define TRUE	1
#define FALSE	0

/*
 * If you don't want n-state capability, define this to 1 in the Makefile
 * to save some storage and reduce the program size.
 */
#ifndef STATEBITS
#define STATEBITS	3
#endif /* STATEBITS */

#define MAXSTATES	(1<<STATEBITS)
#define BADSTATE	0xff	/* out-of-band cell-state value */

#define is_state(c)	isdigit(c)	/* is char a valid state indicator? */
#define stoi(c)		((c) - '0')	/* state character to int */
#define itos(n)		('0' + (n))	/* int to state character */

#if STATEBITS <= 8
typedef unsigned char	cell_t;		/* allows 256 states per cell */
#elif STATEBITS <= 16
typedef short	cell_t;			/* allows 65536 states per cell */
#else
typedef int	cell_t;			/* are you serious? */
#endif

/* someday, on a 64-bit machine, this might be unsigned int rather than long */
typedef unsigned long	u32bits;

/*
 * These typedefs might change on 64-bit machines like the DEC Alpha to
 * support *really large* universes.  Ideally, cellcount_t should be
 * twice the length of coord_t, since it might hold coord_t's max squared.
 * It's hardly likely it will ever go that high, though...
 */
typedef signed long	coord_t;	/* hold world coordinates */
typedef unsigned long	cellcount_t;	/* hold a cell count */
typedef unsigned long	lifetime_t;	/* hold a generation count */

#define COORD_MAX	LONG_MAX
#define COORD_MIN	LONG_MIN

#define PATNAMESIZ 100 /* It's an arbitrary limit, but probably enough */

typedef struct
{
    coord_t x, y;
}
point;

typedef struct
{
    point	min, max;
}
rect;

typedef struct
{
    coord_t xtrans,ytrans;
    int rxx,rxy,ryx,ryy;
}
motion;

typedef struct 
{
    int xtrans, ytrans;	/* translation point */
    int	flip;		/* 1 or -1 */
    int	rotation;	/* 0..3, 90-degree increments clockwise */
}
dihedral;

/* geometry.c */
extern dihedral motion2dihedral(motion map);
extern motion apply_rotation(motion transform, int flip, int rotation);
extern point point_dihedral(point location, dihedral transform);
extern const motion motion_unity;

typedef struct lq
{
    lifetime_t loadtime;
    char patname[PATNAMESIZ];
    int relpath;
    motion at;
    struct lq  *next;
}
LoadReq;

/* definitions for geometric transformations */ 

/* Get around "%" bogosity, and compute mod *correctly*. */
#define mod(m,n) (((m)>=0)?((m)%(n)):((n)-1-(-(m)+(n)-1)%(n)))
#define divis(x,y) (((long)((x)/(y)))*(y)==(x)) 

#define max(x, y)	(((x) > (y)) ? (x) : (y))
#define min(x, y)	(((x) > (y)) ? (y) : (x))
#define abs(x)	  	(((x) > (y)) ? ((x) - (y)) : ((y) - (x)))

/* compute coordinate transform for rotations */
/* yes, macros are equivalent, but this makes the meaning clearer (maybe) */
#define tx(x,y,rxx,rxy) ((rxx)*(x)+(rxy)*(y))
#define ty(x,y,ryx,ryy) ((ryx)*(x)+(ryy)*(y))
#define	TX(at, x, y)	(at.xtrans + tx(x,y,at.rxx,at.rxy))
#define TY(at, x, y)	(at.ytrans + ty(x,y,at.ryx,at.ryy))

#ifdef SVR4
#define srandom(n)	srand48(n);
#define random()	lrand48()
#endif

#ifndef GLOBAL
#define GLOBAL extern
#endif /* GLOBAL */
